/*
 * Decompiled with CFR 0.152.
 */
package tpamod.data;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class WarpData {
    private Map<String, WarpPoint> warpPoints = new HashMap<String, WarpPoint>();
    private File warpFile = new File("config/tpamod/warplist.dat");

    public WarpData() {
        this.loadWarpPoints();
    }

    public boolean addWarpPoint(String name, String levelIdentifier, String biomeIdentifier, float x, float y) {
        if (this.warpPoints.containsKey(name.toLowerCase())) {
            return false;
        }
        this.warpPoints.put(name.toLowerCase(), new WarpPoint(name, levelIdentifier, biomeIdentifier, x, y));
        this.saveWarpPoints();
        return true;
    }

    public boolean removeWarpPoint(String name) {
        if (!this.warpPoints.containsKey(name.toLowerCase())) {
            return false;
        }
        this.warpPoints.remove(name.toLowerCase());
        this.saveWarpPoints();
        return true;
    }

    public WarpPoint getWarpPoint(String name) {
        return this.warpPoints.get(name.toLowerCase());
    }

    public Set<String> getWarpPointNames() {
        return this.warpPoints.keySet();
    }

    public boolean hasWarpPoint(String name) {
        return this.warpPoints.containsKey(name.toLowerCase());
    }

    private void saveWarpPoints() {
        try {
            this.warpFile.getParentFile().mkdirs();
            try (PrintWriter writer = new PrintWriter(new FileWriter(this.warpFile));){
                for (Map.Entry<String, WarpPoint> entry : this.warpPoints.entrySet()) {
                    WarpPoint point = entry.getValue();
                    writer.println(point.name + "," + point.levelIdentifier + "," + point.biomeIdentifier + "," + point.x + "," + point.y);
                }
            }
        }
        catch (Exception e) {
            System.out.println("Warp System: Failed to save warp points: " + e.getMessage());
        }
    }

    private void loadWarpPoints() {
        block10: {
            try {
                if (!this.warpFile.exists()) break block10;
                try (BufferedReader reader = new BufferedReader(new FileReader(this.warpFile));){
                    String line;
                    while ((line = reader.readLine()) != null) {
                        float x;
                        String levelIdentifier;
                        String name;
                        String[] parts = line.split(",");
                        if (parts.length == 5) {
                            name = parts[0];
                            levelIdentifier = parts[1];
                            String biomeIdentifier = parts[2];
                            x = Float.parseFloat(parts[3]);
                            float y = Float.parseFloat(parts[4]);
                            this.warpPoints.put(name.toLowerCase(), new WarpPoint(name, levelIdentifier, biomeIdentifier, x, y));
                            continue;
                        }
                        if (parts.length == 7) {
                            name = parts[0];
                            levelIdentifier = parts[3];
                            String biomeIdentifier = parts[4];
                            x = Float.parseFloat(parts[5]);
                            float y = Float.parseFloat(parts[6]);
                            this.warpPoints.put(name.toLowerCase(), new WarpPoint(name, levelIdentifier, biomeIdentifier, x, y));
                            continue;
                        }
                        if (parts.length != 6) continue;
                        name = parts[0];
                        levelIdentifier = parts[3];
                        float x2 = Float.parseFloat(parts[4]);
                        float y = Float.parseFloat(parts[5]);
                        String biomeIdentifier = "default";
                        this.warpPoints.put(name.toLowerCase(), new WarpPoint(name, levelIdentifier, biomeIdentifier, x2, y));
                    }
                }
                System.out.println("Warp System: Loaded " + this.warpPoints.size() + " warp points");
            }
            catch (Exception e) {
                System.out.println("Warp System: Failed to load warp points: " + e.getMessage());
            }
        }
    }

    public static class WarpPoint {
        public final String name;
        public final String levelIdentifier;
        public final String biomeIdentifier;
        public final float x;
        public final float y;

        public WarpPoint(String name, String levelIdentifier, String biomeIdentifier, float x, float y) {
            this.name = name;
            this.levelIdentifier = levelIdentifier;
            this.biomeIdentifier = biomeIdentifier;
            this.x = x;
            this.y = y;
        }
    }
}

