/*
 * Decompiled with CFR 0.152.
 */
package tpamod.data;

import java.io.File;
import necesse.engine.save.LoadData;
import necesse.engine.save.SaveData;

public class RTPLimitConfig {
    private int limitRange = 1000;
    private File configFile = new File("config/tpamod/rtplimit.dat");

    public RTPLimitConfig() {
        this.loadConfig();
    }

    public int getLimitRange() {
        return this.limitRange;
    }

    public void setLimitRange(int range) {
        if (range >= 100) {
            this.limitRange = range;
            this.saveConfig();
        }
    }

    private void saveConfig() {
        try {
            SaveData saveData = new SaveData("RTPLimitConfig");
            saveData.addInt("limitRange", this.limitRange);
            this.configFile.getParentFile().mkdirs();
            saveData.saveScript(this.configFile);
        }
        catch (Exception e) {
            System.out.println("RTP Limit System: Failed to save config: " + e.getMessage());
        }
    }

    private void loadConfig() {
        try {
            LoadData loadData;
            int savedRange;
            if (this.configFile.exists() && (savedRange = (loadData = new LoadData(this.configFile)).getInt("limitRange", 1000)) >= 100) {
                this.limitRange = savedRange;
                System.out.println("RTP Limit System: Loaded limit range: " + savedRange);
            }
        }
        catch (Exception e) {
            System.out.println("RTP Limit System: Using default limit range (1000)");
        }
    }
}

