/*
 * Decompiled with CFR 0.152.
 */
package tpamod.data;

import java.io.File;
import necesse.engine.save.LoadData;
import necesse.engine.save.SaveData;

public class RTPConfig {
    private int cooldownSeconds = 15;
    private File configFile = new File("config/tpamod/rtpconfig.dat");

    public RTPConfig() {
        this.loadConfig();
    }

    public int getCooldownSeconds() {
        return this.cooldownSeconds;
    }

    public void setCooldownSeconds(int seconds) {
        if (seconds >= 1 && seconds <= 3600) {
            this.cooldownSeconds = seconds;
            this.saveConfig();
        }
    }

    private void saveConfig() {
        try {
            SaveData saveData = new SaveData("RTPConfig");
            saveData.addInt("cooldownSeconds", this.cooldownSeconds);
            this.configFile.getParentFile().mkdirs();
            saveData.saveScript(this.configFile);
        }
        catch (Exception e) {
            System.out.println("RTP System: Failed to save config: " + e.getMessage());
        }
    }

    private void loadConfig() {
        try {
            LoadData loadData;
            int savedCooldown;
            if (this.configFile.exists() && (savedCooldown = (loadData = new LoadData(this.configFile)).getInt("cooldownSeconds", 15)) >= 1 && savedCooldown <= 3600) {
                this.cooldownSeconds = savedCooldown;
                System.out.println("RTP System: Loaded cooldown time: " + savedCooldown + " seconds");
            }
        }
        catch (Exception e) {
            System.out.println("RTP System: Using default cooldown time (15 seconds)");
        }
    }
}

