/*
 * Decompiled with CFR 0.152.
 */
package tpamod.data;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import necesse.engine.save.LoadData;
import necesse.engine.save.SaveData;

public class BackData {
    private Map<String, PlayerBackData> playerBackDataMap = new HashMap<String, PlayerBackData>();
    private File backFile = new File("config/tpamod/backlist.dat");

    public BackData() {
        this.loadBackData();
    }

    public PlayerBackData getPlayerBackData(String playerAuth) {
        return this.playerBackDataMap.computeIfAbsent(playerAuth, k -> new PlayerBackData());
    }

    public void recordTeleportPosition(String playerAuth, int dimension, int x, int y) {
        this.recordTeleportPosition(playerAuth, dimension, x, y, "default");
    }

    public void recordTeleportPosition(String playerAuth, int dimension, int x, int y, String biome) {
        PlayerBackData data = this.getPlayerBackData(playerAuth);
        data.lastTeleportDimension = dimension;
        data.lastTeleportX = x;
        data.lastTeleportY = y;
        data.lastTeleportBiome = biome;
        data.hasTeleportRecord = true;
        this.saveBackData();
    }

    public void recordDeathPosition(String playerAuth, int dimension, int x, int y) {
        this.recordDeathPosition(playerAuth, dimension, x, y, "default");
    }

    public void recordDeathPosition(String playerAuth, int dimension, int x, int y, String biome) {
        PlayerBackData data = this.getPlayerBackData(playerAuth);
        data.lastDeathDimension = dimension;
        data.lastDeathX = x;
        data.lastDeathY = y;
        data.lastDeathBiome = biome;
        data.hasDeathRecord = true;
        this.saveBackData();
    }

    public void clearDeathRecord(String playerAuth) {
        PlayerBackData data = this.getPlayerBackData(playerAuth);
        data.hasDeathRecord = false;
        this.saveBackData();
    }

    public void clearTeleportRecord(String playerAuth) {
        PlayerBackData data = this.getPlayerBackData(playerAuth);
        data.hasTeleportRecord = false;
        this.saveBackData();
    }

    private void saveBackData() {
        try {
            SaveData saveData = new SaveData("BackData");
            for (Map.Entry<String, PlayerBackData> entry : this.playerBackDataMap.entrySet()) {
                String playerAuth = entry.getKey();
                PlayerBackData data = entry.getValue();
                SaveData playerData = new SaveData("PlayerBack");
                playerData.addUnsafeString("auth", playerAuth);
                playerData.addInt("teleportDimension", data.lastTeleportDimension);
                playerData.addInt("teleportX", data.lastTeleportX);
                playerData.addInt("teleportY", data.lastTeleportY);
                playerData.addUnsafeString("teleportBiome", data.lastTeleportBiome);
                playerData.addInt("deathDimension", data.lastDeathDimension);
                playerData.addInt("deathX", data.lastDeathX);
                playerData.addInt("deathY", data.lastDeathY);
                playerData.addUnsafeString("deathBiome", data.lastDeathBiome);
                playerData.addBoolean("hasDeathRecord", data.hasDeathRecord);
                playerData.addBoolean("hasTeleportRecord", data.hasTeleportRecord);
                saveData.addSaveData(playerData);
            }
            this.backFile.getParentFile().mkdirs();
            saveData.saveScript(this.backFile);
        }
        catch (Exception e) {
            System.out.println("Back System: Failed to save back data: " + e.getMessage());
        }
    }

    private void loadBackData() {
        try {
            if (this.backFile.exists()) {
                LoadData loadData = new LoadData(this.backFile);
                this.playerBackDataMap.clear();
                for (LoadData playerData : loadData.getLoadData()) {
                    String playerAuth;
                    if (!"PlayerBack".equals(playerData.getName()) || (playerAuth = playerData.getUnsafeString("auth", "")).isEmpty()) continue;
                    PlayerBackData data = new PlayerBackData();
                    data.lastTeleportDimension = playerData.getInt("teleportDimension", 0);
                    data.lastTeleportX = playerData.getInt("teleportX", 0);
                    data.lastTeleportY = playerData.getInt("teleportY", 0);
                    data.lastTeleportBiome = playerData.getUnsafeString("teleportBiome", "default");
                    data.lastDeathDimension = playerData.getInt("deathDimension", 0);
                    data.lastDeathX = playerData.getInt("deathX", 0);
                    data.lastDeathY = playerData.getInt("deathY", 0);
                    data.lastDeathBiome = playerData.getUnsafeString("deathBiome", "default");
                    data.hasDeathRecord = playerData.getBoolean("hasDeathRecord", false);
                    data.hasTeleportRecord = playerData.getBoolean("hasTeleportRecord", false);
                    this.playerBackDataMap.put(playerAuth, data);
                }
                System.out.println("Back System: Loaded back data for " + this.playerBackDataMap.size() + " players");
            }
        }
        catch (Exception e) {
            System.out.println("Back System: Failed to load back data: " + e.getMessage());
        }
    }

    public static class PlayerBackData {
        public int lastTeleportDimension = 0;
        public int lastTeleportX = 0;
        public int lastTeleportY = 0;
        public String lastTeleportBiome = "default";
        public int lastDeathDimension = 0;
        public int lastDeathX = 0;
        public int lastDeathY = 0;
        public String lastDeathBiome = "default";
        public boolean hasDeathRecord = false;
        public boolean hasTeleportRecord = false;
    }
}

