/*
 * Decompiled with CFR 0.152.
 */
package tpamod.commands;

import java.util.Set;
import necesse.engine.commands.CmdParameter;
import necesse.engine.commands.CommandLog;
import necesse.engine.commands.ModularChatCommand;
import necesse.engine.commands.PermissionLevel;
import necesse.engine.network.client.Client;
import necesse.engine.network.server.Server;
import necesse.engine.network.server.ServerClient;
import tpamod.data.WarpData;

public class WarpListCommand
extends ModularChatCommand {
    private final WarpData warpData;

    public WarpListCommand(String name, WarpData warpData) {
        super(name, "View warp point list", PermissionLevel.USER, false, new CmdParameter[0]);
        this.warpData = warpData;
    }

    public void runModular(Client client, Server server, ServerClient serverClient, Object[] args, String[] errors, CommandLog logs) {
        Set<String> warpNames = this.warpData.getWarpPointNames();
        if (warpNames.isEmpty()) {
            logs.add("There are currently no available warp points");
            return;
        }
        logs.add("Available warp points (" + warpNames.size() + "):");
        int count = 0;
        StringBuilder warpList = new StringBuilder();
        for (String warpName : warpNames) {
            if (count > 0) {
                warpList.append(", ");
            }
            warpList.append(warpName);
            if (++count % 5 != 0) continue;
            logs.add(warpList.toString());
            warpList = new StringBuilder();
        }
        if (warpList.length() > 0) {
            logs.add(warpList.toString());
        }
        logs.add("Use /warp [warp point name] to teleport");
    }

    public boolean shouldBeListed() {
        return true;
    }
}

