/*
 * Decompiled with CFR 0.152.
 */
package tpamod.commands;

import java.awt.Point;
import necesse.engine.commands.CmdParameter;
import necesse.engine.commands.CommandLog;
import necesse.engine.commands.ModularChatCommand;
import necesse.engine.commands.PermissionLevel;
import necesse.engine.commands.parameterHandlers.ParameterHandler;
import necesse.engine.commands.parameterHandlers.PresetStringParameterHandler;
import necesse.engine.network.client.Client;
import necesse.engine.network.server.Server;
import necesse.engine.network.server.ServerClient;
import necesse.engine.util.LevelIdentifier;
import necesse.entity.mobs.PlayerMob;
import necesse.level.maps.Level;
import necesse.level.maps.biomes.Biome;
import tpamod.data.BackData;
import tpamod.data.WarpConfig;
import tpamod.data.WarpData;
import tpamod.listener.WarpListener;
import tpamod.util.PermissionUtil;

public class WarpCommand
extends ModularChatCommand {
    private final WarpData warpData;
    private final WarpConfig warpConfig;
    private final WarpListener warpListener;
    private final BackData backData;

    public WarpCommand(String name, WarpData warpData, WarpConfig warpConfig, WarpListener warpListener, BackData backData) {
        super(name, "Teleport to specified warp point", PermissionLevel.USER, false, new CmdParameter[]{new CmdParameter("warpName", (ParameterHandler)new PresetStringParameterHandler(false, new String[]{"home", "spawn", "town", "base", "hole1", "hole2", "hole3", "hole4", "hole5", "boss1", "boss2", "boss3", "boss4", "boss5", "boss6", "boss7", "boss8", "boss9", "boss10"}))});
        this.warpData = warpData;
        this.warpConfig = warpConfig;
        this.warpListener = warpListener;
        this.backData = backData;
    }

    public void runModular(Client client, Server server, ServerClient serverClient, Object[] args, String[] errors, CommandLog logs) {
        long remainingCooldown;
        String warpName = (String)args[0];
        if (!this.warpData.hasWarpPoint(warpName)) {
            logs.add("Warp point '" + warpName + "' does not exist");
            return;
        }
        if (!PermissionUtil.isAdminOrOwner(serverClient) && (remainingCooldown = this.warpListener.getRemainingCooldown(serverClient.authentication)) > 0L) {
            logs.add("Teleport on cooldown, remaining time: " + remainingCooldown / 1000L + " seconds");
            return;
        }
        WarpData.WarpPoint warpPoint = this.warpData.getWarpPoint(warpName);
        if (warpPoint == null) {
            logs.add("Warp point data read failed");
            return;
        }
        PlayerMob playerMob = serverClient.playerMob;
        if (playerMob != null) {
            String currentLevelIdentifierString;
            float currentX = playerMob.getX();
            float currentY = playerMob.getY();
            String currentLevelIdentifier = playerMob.getLevel().getIdentifier().toString();
            int levelType = Math.abs(currentLevelIdentifier.hashCode() % 1000);
            String currentBiomeIdentifier = this.getCurrentBiomeIdentifier(playerMob.getLevel(), currentX, currentY);
            this.backData.recordTeleportPosition(String.valueOf(serverClient.authentication), levelType, (int)currentX, (int)currentY, currentBiomeIdentifier);
            if (!PermissionUtil.isAdminOrOwner(serverClient)) {
                this.warpListener.setCooldown(serverClient.authentication, this.warpConfig.getCooldownSeconds());
            }
            if (!(currentLevelIdentifierString = playerMob.getLevel().getIdentifier().toString()).equals(warpPoint.levelIdentifier)) {
                logs.add("Switching level...");
                logs.add("Target level: " + warpPoint.levelIdentifier + " (Current level: " + currentLevelIdentifierString + ")");
                try {
                    LevelIdentifier targetLevelIdentifier = new LevelIdentifier(warpPoint.levelIdentifier);
                    serverClient.changeLevel(targetLevelIdentifier, level -> new Point((int)warpPoint.x, (int)warpPoint.y), true);
                    logs.add("Level switch successful");
                    logs.add("Switched to level: " + warpPoint.levelIdentifier);
                    logs.add("Teleported to warp point: " + warpName);
                    logs.add("Coordinates: (" + String.format("%.2f", Float.valueOf(warpPoint.x)) + ", " + String.format("%.2f", Float.valueOf(warpPoint.y)) + ")");
                    logs.add("Biome: " + warpPoint.biomeIdentifier);
                }
                catch (Exception e) {
                    logs.add("Level switch failed: " + e.getMessage());
                    logs.add("Please try again later");
                }
            } else {
                playerMob.setPos(warpPoint.x, warpPoint.y, true);
                logs.add("Teleported to warp point: " + warpName);
                logs.add("Coordinates: (" + String.format("%.2f", Float.valueOf(warpPoint.x)) + ", " + String.format("%.2f", Float.valueOf(warpPoint.y)) + ") Level: " + warpPoint.levelIdentifier);
                logs.add("Biome: " + warpPoint.biomeIdentifier);
            }
        } else {
            logs.add("Player data error, teleport failed");
        }
    }

    public boolean shouldBeListed() {
        return true;
    }

    private String getCurrentBiomeIdentifier(Level level, float x, float y) {
        try {
            int tileX = (int)(x / 32.0f);
            int tileY = (int)(y / 32.0f);
            Biome biome = level.getBiome(tileX, tileY);
            if (biome != null) {
                return biome.getStringID();
            }
        }
        catch (Exception e) {
            System.out.println("Warp Command: Failed to get biome identifier: " + e.getMessage());
        }
        return "unknown";
    }
}

