/*
 * Decompiled with CFR 0.152.
 */
package tpamod.commands;

import java.awt.Point;
import necesse.engine.commands.CmdParameter;
import necesse.engine.commands.CommandLog;
import necesse.engine.commands.ModularChatCommand;
import necesse.engine.commands.PermissionLevel;
import necesse.engine.commands.parameterHandlers.IntParameterHandler;
import necesse.engine.commands.parameterHandlers.LevelIdentifierParameterHandler;
import necesse.engine.commands.parameterHandlers.ParameterHandler;
import necesse.engine.commands.parameterHandlers.ServerClientParameterHandler;
import necesse.engine.network.client.Client;
import necesse.engine.network.server.Server;
import necesse.engine.network.server.ServerClient;
import necesse.engine.util.LevelIdentifier;
import necesse.level.maps.Level;
import necesse.level.maps.biomes.Biome;
import tpamod.data.BackData;

public class TPPosCommand
extends ModularChatCommand {
    private final BackData backData;

    public TPPosCommand(String name) {
        super(name, "Teleport to specified coordinates", PermissionLevel.ADMIN, false, new CmdParameter[]{new CmdParameter("x", (ParameterHandler)new IntParameterHandler()), new CmdParameter("y", (ParameterHandler)new IntParameterHandler()), new CmdParameter("level", (ParameterHandler)new LevelIdentifierParameterHandler(null), true, new CmdParameter[0]), new CmdParameter("player", (ParameterHandler)new ServerClientParameterHandler(true, true), true, new CmdParameter[0])});
        this.backData = null;
    }

    public TPPosCommand(String name, BackData backData) {
        super(name, "Teleport to specified coordinates", PermissionLevel.ADMIN, false, new CmdParameter[]{new CmdParameter("x", (ParameterHandler)new IntParameterHandler()), new CmdParameter("y", (ParameterHandler)new IntParameterHandler()), new CmdParameter("level", (ParameterHandler)new LevelIdentifierParameterHandler(null), true, new CmdParameter[0]), new CmdParameter("player", (ParameterHandler)new ServerClientParameterHandler(true, true), true, new CmdParameter[0])});
        this.backData = backData;
    }

    public void runModular(Client client, Server server, ServerClient serverClient, Object[] args, String[] errors, CommandLog logs) {
        int x = (Integer)args[0];
        int y = (Integer)args[1];
        LevelIdentifier levelIdentifier = (LevelIdentifier)args[2];
        ServerClient target = (ServerClient)args[3];
        if (target == null) {
            target = serverClient;
        }
        if (target != null) {
            if (this.backData != null && target.playerMob != null) {
                float currentX = target.playerMob.getX();
                float currentY = target.playerMob.getY();
                String currentLevelIdentifier = target.playerMob.getLevel().getIdentifier().toString();
                int levelType = Math.abs(currentLevelIdentifier.hashCode() % 1000);
                String currentBiomeIdentifier = this.getCurrentBiomeIdentifier(target.playerMob.getLevel(), currentX, currentY);
                this.backData.recordTeleportPosition(String.valueOf(target.authentication), levelType, (int)currentX, (int)currentY, currentBiomeIdentifier);
            }
            if (levelIdentifier != null) {
                this.handleLevelTeleport(target, levelIdentifier, x, y, logs);
            } else {
                target.playerMob.setPos((float)x, (float)y, true);
                if (target == serverClient) {
                    logs.add("Teleported to coordinates (" + x + ", " + y + ")");
                } else {
                    logs.add("Teleported player " + target.getName() + " to coordinates (" + x + ", " + y + ")");
                }
            }
        } else {
            logs.add("Unable to get player information");
        }
    }

    public boolean shouldBeListed() {
        return true;
    }

    private void handleLevelTeleport(ServerClient target, LevelIdentifier targetLevelIdentifier, int x, int y, CommandLog logs) {
        try {
            LevelIdentifier currentLevelIdentifier = target.playerMob.getLevel().getIdentifier();
            String levelName = targetLevelIdentifier.toString();
            if (!currentLevelIdentifier.equals(targetLevelIdentifier)) {
                logs.add("Switching level...");
                logs.add("Target level: " + levelName + " (Current level: " + currentLevelIdentifier.toString() + ")");
                try {
                    target.changeLevel(targetLevelIdentifier, level -> new Point(x, y), true);
                    logs.add("Level switch successful");
                    logs.add("Switched to level: " + levelName);
                    logs.add("Teleported to coordinates (" + x + ", " + y + ")");
                }
                catch (Exception e) {
                    logs.add("Level switch failed: " + e.getMessage());
                    logs.add("Please try again later");
                }
            } else {
                target.playerMob.setPos((float)x, (float)y, true);
                logs.add("Teleported to coordinates (" + x + ", " + y + ") Level: " + levelName);
            }
        }
        catch (Exception e) {
            logs.add("Teleport failed: " + e.getMessage());
        }
    }

    private String getCurrentBiomeIdentifier(Level level, float x, float y) {
        try {
            int tileX = (int)(x / 32.0f);
            int tileY = (int)(y / 32.0f);
            Biome biome = level.getBiome(tileX, tileY);
            if (biome != null) {
                return biome.getStringID();
            }
        }
        catch (Exception e) {
            System.out.println("TPPos Command: Failed to get biome identifier: " + e.getMessage());
        }
        return "unknown";
    }
}

