/*
 * Decompiled with CFR 0.152.
 */
package tpamod.commands;

import java.util.concurrent.atomic.AtomicBoolean;
import necesse.engine.GameEvents;
import necesse.engine.commands.CmdParameter;
import necesse.engine.commands.CommandLog;
import necesse.engine.commands.ModularChatCommand;
import necesse.engine.commands.PermissionLevel;
import necesse.engine.commands.parameterHandlers.ParameterHandler;
import necesse.engine.commands.parameterHandlers.ServerClientParameterHandler;
import necesse.engine.events.PreventableGameEvent;
import necesse.engine.network.client.Client;
import necesse.engine.network.server.Server;
import necesse.engine.network.server.ServerClient;
import tpamod.data.BackData;
import tpamod.events.TPARequestEvent;
import tpamod.listener.TPAListener;

public class TPACommand
extends ModularChatCommand {
    private final TPAListener listener;
    private final BackData backData;

    public TPACommand(String name) {
        super(name, "Request to teleport to another player", PermissionLevel.USER, false, new CmdParameter[]{new CmdParameter("player", (ParameterHandler)new ServerClientParameterHandler())});
        this.listener = null;
        this.backData = null;
    }

    public TPACommand(String name, TPAListener listener) {
        super(name, "Request to teleport to another player", PermissionLevel.USER, false, new CmdParameter[]{new CmdParameter("player", (ParameterHandler)new ServerClientParameterHandler())});
        this.listener = listener;
        this.backData = null;
    }

    public TPACommand(String name, TPAListener listener, BackData backData) {
        super(name, "Request to teleport to another player", PermissionLevel.USER, false, new CmdParameter[]{new CmdParameter("player", (ParameterHandler)new ServerClientParameterHandler())});
        this.listener = listener;
        this.backData = backData;
    }

    public void runModular(Client client, Server server, ServerClient serverClient, Object[] args, String[] errors, CommandLog logs) {
        ServerClient target = (ServerClient)args[0];
        if (target != null && target != serverClient) {
            String clientName = serverClient == null ? "Server" : serverClient.getName();
            logs.add("Teleport to " + target.getName());
            logs.addClient("Teleport request from " + clientName, target);
            logs.addClient("Use /tpac " + clientName + " to accept or /tpad " + clientName + " to reject", target);
            AtomicBoolean accepted = new AtomicBoolean(false);
            GameEvents.triggerEvent((PreventableGameEvent)new TPARequestEvent(serverClient, target, logs, this.backData), e -> accepted.set(true));
            if (!accepted.get()) {
                int cooldown = this.getCooldownSeconds();
                logs.addClient(clientName + " already has a pending teleport request, please wait " + cooldown + " seconds and try again", serverClient);
            }
        } else {
            logs.add("Cannot use on yourself");
        }
    }

    private int getCooldownSeconds() {
        if (this.listener != null) {
            return this.listener.getCooldownSeconds();
        }
        return 30;
    }

    public boolean shouldBeListed() {
        return true;
    }
}

