/*
 * Decompiled with CFR 0.152.
 */
package tpamod.commands;

import necesse.engine.commands.CmdParameter;
import necesse.engine.commands.CommandLog;
import necesse.engine.commands.ModularChatCommand;
import necesse.engine.commands.PermissionLevel;
import necesse.engine.commands.parameterHandlers.IntParameterHandler;
import necesse.engine.commands.parameterHandlers.ParameterHandler;
import necesse.engine.network.client.Client;
import necesse.engine.network.server.Server;
import necesse.engine.network.server.ServerClient;
import tpamod.listener.RTPListener;

public class RTPLimitCommand
extends ModularChatCommand {
    private final RTPListener rtpListener;

    public RTPLimitCommand(String name, RTPListener rtpListener) {
        super(name, "Set random teleport range limit", PermissionLevel.ADMIN, false, new CmdParameter[]{new CmdParameter("range", (ParameterHandler)new IntParameterHandler(), true, new CmdParameter[0])});
        this.rtpListener = rtpListener;
    }

    public void runModular(Client client, Server server, ServerClient serverClient, Object[] args, String[] errors, CommandLog logs) {
        if (args.length > 0) {
            int newRange = (Integer)args[0];
            this.rtpListener.setLimitRange(newRange);
            logs.add("Random teleport range limit has been set to: " + newRange);
            logs.add("New random teleports will generate coordinates within " + newRange + " pixels from the border");
        } else {
            int currentRange = this.rtpListener.getLimitRange();
            logs.add("Current random teleport range limit: " + currentRange);
            logs.add("Random teleports generate coordinates within " + currentRange + " pixels from the border");
            logs.add("Use /rtplimit <range> to modify the limit (minimum range: 100, no upper limit)");
        }
    }

    public boolean shouldBeListed() {
        return true;
    }
}

