/*
 * Decompiled with CFR 0.152.
 */
package tpamod.commands;

import necesse.engine.commands.CmdParameter;
import necesse.engine.commands.CommandLog;
import necesse.engine.commands.ModularChatCommand;
import necesse.engine.commands.PermissionLevel;
import necesse.engine.network.client.Client;
import necesse.engine.network.server.Server;
import necesse.engine.network.server.ServerClient;
import necesse.engine.util.GameRandom;
import necesse.level.maps.Level;
import necesse.level.maps.biomes.Biome;
import tpamod.data.BackData;
import tpamod.listener.RTPListener;

public class RTPCommand
extends ModularChatCommand {
    private final RTPListener rtpListener;
    private final BackData backData;

    public RTPCommand(String name, RTPListener rtpListener, BackData backData) {
        super(name, "Randomly teleport to a random position in the current level", PermissionLevel.USER, false, new CmdParameter[0]);
        this.rtpListener = rtpListener;
        this.backData = backData;
    }

    public void runModular(Client client, Server server, ServerClient serverClient, Object[] args, String[] errors, CommandLog logs) {
        try {
            long remainingCooldown;
            if (!this.rtpListener.isCooldownExempt(serverClient) && (remainingCooldown = this.rtpListener.getRemainingCooldown(serverClient.authentication)) > 0L) {
                long remainingSeconds = (remainingCooldown + 999L) / 1000L;
                logs.add("Random teleport on cooldown, remaining time: " + remainingSeconds + " seconds");
                return;
            }
            Level currentLevel = serverClient.getLevel();
            if (currentLevel == null) {
                logs.add("Unable to get current level information");
                return;
            }
            float originalX = serverClient.playerMob.x;
            float originalY = serverClient.playerMob.y;
            String originalBiome = this.getCurrentBiomeIdentifier(currentLevel, originalX, originalY);
            int limitRange = this.rtpListener.getLimitRange();
            float randomX = GameRandom.globalRandom.getFloatBetween((float)limitRange, (float)(currentLevel.tileWidth * 32 - limitRange));
            float randomY = GameRandom.globalRandom.getFloatBetween((float)limitRange, (float)(currentLevel.tileHeight * 32 - limitRange));
            serverClient.playerMob.setPos(randomX, randomY, true);
            this.backData.recordTeleportPosition(String.valueOf(serverClient.authentication), 0, (int)originalX, (int)originalY, originalBiome);
            if (!this.rtpListener.isCooldownExempt(serverClient)) {
                this.rtpListener.setCooldown(serverClient.authentication, this.rtpListener.getCooldownSeconds());
            }
            logs.add("Random teleport successful! New position: (" + (int)randomX + ", " + (int)randomY + ")");
        }
        catch (Exception e) {
            logs.add("Random teleport failed: " + e.getMessage());
            System.out.println("RTP Command Error: " + e.getMessage());
            e.printStackTrace();
        }
    }

    private String getCurrentBiomeIdentifier(Level level, float x, float y) {
        try {
            int tileX = (int)(x / 32.0f);
            int tileY = (int)(y / 32.0f);
            Biome biome = level.getBiome(tileX, tileY);
            if (biome != null) {
                return biome.getStringID();
            }
        }
        catch (Exception e) {
            System.out.println("Failed to get biome identifier: " + e.getMessage());
        }
        return "unknown";
    }
}

