/*
 * Decompiled with CFR 0.152.
 */
package tpamod.commands;

import necesse.engine.commands.CmdParameter;
import necesse.engine.commands.CommandLog;
import necesse.engine.commands.ModularChatCommand;
import necesse.engine.commands.PermissionLevel;
import necesse.engine.commands.parameterHandlers.IntParameterHandler;
import necesse.engine.commands.parameterHandlers.ParameterHandler;
import necesse.engine.network.client.Client;
import necesse.engine.network.server.Server;
import necesse.engine.network.server.ServerClient;
import tpamod.listener.RTPListener;

public class RTPCDCommand
extends ModularChatCommand {
    private final RTPListener rtpListener;

    public RTPCDCommand(String name, RTPListener rtpListener) {
        super(name, "Set random teleport cooldown time (seconds)", PermissionLevel.ADMIN, false, new CmdParameter[]{new CmdParameter("seconds", (ParameterHandler)new IntParameterHandler())});
        this.rtpListener = rtpListener;
    }

    public void runModular(Client client, Server server, ServerClient serverClient, Object[] args, String[] errors, CommandLog logs) {
        int seconds = (Integer)args[0];
        if (seconds < 1) {
            logs.add("Cooldown time cannot be less than 1 second");
            return;
        }
        if (seconds > 3600) {
            logs.add("Cooldown time cannot exceed 3600 seconds (1 hour)");
            return;
        }
        this.rtpListener.setCooldownSeconds(seconds);
        logs.add("Random teleport cooldown time has been set to " + seconds + " seconds");
    }

    public boolean shouldBeListed() {
        return true;
    }
}

