/*
 * Decompiled with CFR 0.152.
 */
package tpamod.commands;

import necesse.engine.commands.CmdParameter;
import necesse.engine.commands.CommandLog;
import necesse.engine.commands.ModularChatCommand;
import necesse.engine.commands.PermissionLevel;
import necesse.engine.commands.parameterHandlers.ParameterHandler;
import necesse.engine.commands.parameterHandlers.PresetStringParameterHandler;
import necesse.engine.network.client.Client;
import necesse.engine.network.server.Server;
import necesse.engine.network.server.ServerClient;
import necesse.level.maps.Level;
import necesse.level.maps.biomes.Biome;
import tpamod.data.WarpData;

public class NewWarpCommand
extends ModularChatCommand {
    private final WarpData warpData;

    public NewWarpCommand(String name, WarpData warpData) {
        super(name, "Create warp point", PermissionLevel.ADMIN, false, new CmdParameter[]{new CmdParameter("warpName", (ParameterHandler)new PresetStringParameterHandler(false, new String[]{"home", "spawn", "town", "base"}))});
        this.warpData = warpData;
    }

    public void runModular(Client client, Server server, ServerClient serverClient, Object[] args, String[] errors, CommandLog logs) {
        String warpName = (String)args[0];
        if (serverClient != null) {
            String currentBiomeIdentifier;
            float playerX = serverClient.playerMob.getX();
            float playerY = serverClient.playerMob.getY();
            String currentLevelIdentifier = serverClient.playerMob.getLevel().getIdentifier().toString();
            if (this.warpData.addWarpPoint(warpName, currentLevelIdentifier, currentBiomeIdentifier = this.getCurrentBiomeIdentifier(serverClient.playerMob.getLevel(), playerX, playerY), playerX, playerY)) {
                logs.add("Warp point '" + warpName + "' has been created");
                logs.add("Position: Level(" + currentLevelIdentifier + ") Biome(" + currentBiomeIdentifier + ") Coordinates(" + String.format("%.2f", Float.valueOf(playerX)) + ", " + String.format("%.2f", Float.valueOf(playerY)) + ")");
            } else {
                logs.add("Warp point '" + warpName + "' already exists");
            }
        } else {
            logs.add("Unable to get player information");
        }
    }

    private String getCurrentBiomeIdentifier(Level level, float x, float y) {
        try {
            int tileX = (int)(x / 32.0f);
            int tileY = (int)(y / 32.0f);
            Biome biome = level.getBiome(tileX, tileY);
            if (biome != null) {
                return biome.getStringID();
            }
        }
        catch (Exception e) {
            System.out.println("Failed to get biome identifier: " + e.getMessage());
        }
        return "unknown";
    }

    public boolean shouldBeListed() {
        return true;
    }
}

