/*
 * Decompiled with CFR 0.152.
 */
package tpamod.commands;

import necesse.engine.commands.CmdParameter;
import necesse.engine.commands.CommandLog;
import necesse.engine.commands.ModularChatCommand;
import necesse.engine.commands.PermissionLevel;
import necesse.engine.commands.parameterHandlers.ParameterHandler;
import necesse.engine.commands.parameterHandlers.ServerClientParameterHandler;
import necesse.engine.network.client.Client;
import necesse.engine.network.server.Server;
import necesse.engine.network.server.ServerClient;
import necesse.engine.util.LevelIdentifier;
import necesse.entity.mobs.PlayerMob;
import necesse.level.maps.Level;
import necesse.level.maps.biomes.Biome;
import tpamod.util.PermissionUtil;

public class GetPosCommand
extends ModularChatCommand {
    public GetPosCommand(String name) {
        super(name, "Get player position", PermissionLevel.USER, false, new CmdParameter[]{new CmdParameter("player", (ParameterHandler)new ServerClientParameterHandler(true, true), true, new CmdParameter[0])});
    }

    public void runModular(Client client, Server server, ServerClient serverClient, Object[] args, String[] errors, CommandLog logs) {
        ServerClient target = (ServerClient)args[0];
        if (target == null) {
            target = serverClient;
        }
        if (target != serverClient && !PermissionUtil.isAdminOrOwner(serverClient)) {
            logs.add("You do not have permission to query other players' coordinates");
            return;
        }
        if (target != null && target.playerMob != null) {
            PlayerMob playerMob = target.playerMob;
            float playerX = playerMob.getX();
            float playerY = playerMob.getY();
            String levelIdentifier = this.getLevelIdentifierString(playerMob);
            String biomeIdentifier = this.getCurrentBiomeIdentifier(playerMob.getLevel(), playerX, playerY);
            if (target == serverClient) {
                logs.add("Your current position information:");
            } else {
                logs.add("Player " + target.getName() + "'s current position information:");
            }
            logs.add("Level: " + levelIdentifier);
            logs.add("Biome: " + biomeIdentifier);
            logs.add("Coordinates: (" + String.format("%.2f", Float.valueOf(playerX)) + ", " + String.format("%.2f", Float.valueOf(playerY)) + ")");
        } else {
            logs.add("Unable to get player information");
        }
    }

    private String getLevelIdentifierString(PlayerMob playerMob) {
        try {
            LevelIdentifier levelIdentifier = playerMob.getLevel().getIdentifier();
            return levelIdentifier.toString();
        }
        catch (Exception e) {
            return "Unknown";
        }
    }

    private String getCurrentBiomeIdentifier(Level level, float x, float y) {
        try {
            int tileX = (int)(x / 32.0f);
            int tileY = (int)(y / 32.0f);
            Biome biome = level.getBiome(tileX, tileY);
            if (biome != null) {
                return biome.getStringID();
            }
        }
        catch (Exception e) {
            System.out.println("GetPos Command: Failed to get biome identifier: " + e.getMessage());
        }
        return "Unknown";
    }
}

