/*
 * Decompiled with CFR 0.152.
 */
package tpamod.commands;

import java.awt.Point;
import necesse.engine.commands.CmdParameter;
import necesse.engine.commands.CommandLog;
import necesse.engine.commands.ModularChatCommand;
import necesse.engine.commands.PermissionLevel;
import necesse.engine.network.client.Client;
import necesse.engine.network.server.Server;
import necesse.engine.network.server.ServerClient;
import necesse.engine.util.LevelIdentifier;
import necesse.entity.mobs.PlayerMob;
import tpamod.data.BackConfig;
import tpamod.data.BackData;
import tpamod.listener.BackListener;
import tpamod.util.PermissionUtil;

public class BackCommand
extends ModularChatCommand {
    private final BackData backData;
    private final BackConfig backConfig;
    private final BackListener backListener;

    public BackCommand(String name, BackData backData, BackConfig backConfig, BackListener backListener) {
        super(name, "Return to the previous coordinate point", PermissionLevel.USER, false, new CmdParameter[0]);
        this.backData = backData;
        this.backConfig = backConfig;
        this.backListener = backListener;
    }

    public void runModular(Client client, Server server, ServerClient serverClient, Object[] args, String[] errors, CommandLog logs) {
        long remainingCooldown;
        String playerAuth = String.valueOf(serverClient.authentication);
        if (!PermissionUtil.isAdminOrOwner(serverClient) && (remainingCooldown = this.backListener.getRemainingCooldown(playerAuth)) > 0L) {
            logs.add("Return on cooldown, remaining time: " + remainingCooldown / 1000L + " seconds");
            return;
        }
        BackData.PlayerBackData playerData = this.backData.getPlayerBackData(playerAuth);
        if (playerData.hasDeathRecord) {
            this.teleportPlayer(serverClient, 0, 0, playerData.lastDeathDimension, playerData.lastDeathX, playerData.lastDeathY, logs);
            this.backData.clearDeathRecord(playerAuth);
            logs.add("Returned to the last death position");
            logs.add("Biome: " + playerData.lastDeathBiome);
        } else if (playerData.hasTeleportRecord) {
            this.teleportPlayer(serverClient, 0, 0, playerData.lastTeleportDimension, playerData.lastTeleportX, playerData.lastTeleportY, logs);
            this.backData.clearTeleportRecord(playerAuth);
            logs.add("Returned to the position before the last teleport");
            logs.add("Biome: " + playerData.lastTeleportBiome);
        } else {
            logs.add("No coordinate records to return to");
            return;
        }
        if (!PermissionUtil.isAdminOrOwner(serverClient)) {
            this.backListener.setCooldown(playerAuth, this.backConfig.getCooldownSeconds());
        }
    }

    private void teleportPlayer(ServerClient serverClient, int islandX, int islandY, int levelType, int x, int y, CommandLog logs) {
        PlayerMob playerMob = serverClient.playerMob;
        if (playerMob != null) {
            int currentLevelType = this.getCurrentLevelType(playerMob);
            if (currentLevelType != levelType) {
                logs.add("Switching level...");
                logs.add("Target level: " + this.getLevelName(levelType) + " (Current level: " + this.getLevelName(currentLevelType) + ")");
                LevelIdentifier targetLevelIdentifier = this.getLevelIdentifierFromType(levelType);
                if (targetLevelIdentifier != null) {
                    try {
                        serverClient.changeLevel(targetLevelIdentifier, level -> new Point(x, y), true);
                        logs.add("Level switch successful");
                        logs.add("Switched to level: " + this.getLevelName(levelType));
                        logs.add("Teleported to coordinates: (" + x + ", " + y + ")");
                    }
                    catch (Exception e) {
                        logs.add("Level switch failed: " + e.getMessage());
                        logs.add("Please try again later");
                    }
                } else {
                    logs.add("Unrecognized target level: " + levelType);
                    logs.add("Please use /setlevel command to switch levels manually");
                }
            } else {
                playerMob.setPos((float)x, (float)y, true);
                logs.add("Coordinates: (" + x + ", " + y + ") Level: " + this.getLevelName(levelType));
            }
        } else {
            logs.add("Player data error, teleport failed");
        }
    }

    public boolean shouldBeListed() {
        return true;
    }

    private int getCurrentLevelType(PlayerMob playerMob) {
        try {
            LevelIdentifier levelIdentifier = playerMob.getLevel().getIdentifier();
            String levelIdentifierString = levelIdentifier.toString();
            if (levelIdentifierString.contains("flat")) {
                return 2;
            }
            if (levelIdentifierString.contains("surface")) {
                return 0;
            }
            if (levelIdentifierString.contains("cave")) {
                return 1;
            }
            if (levelIdentifierString.contains("deepcave")) {
                return 2;
            }
            System.out.println("Back System: Unknown level identifier: " + levelIdentifierString + ", using default (0)");
            return 0;
        }
        catch (Exception e) {
            System.out.println("Back System: Failed to get level type, using default (0)");
            return 0;
        }
    }

    private String getLevelName(int levelType) {
        switch (levelType) {
            case 0: {
                return "Surface (0)";
            }
            case 1: {
                return "Underground Cave (1)";
            }
            case 2: {
                return "Deep Cave (2)";
            }
        }
        return "Unknown (" + levelType + ")";
    }

    private LevelIdentifier getLevelIdentifierFromType(int levelType) {
        try {
            switch (levelType) {
                case 0: {
                    return new LevelIdentifier("surface");
                }
                case 1: {
                    return new LevelIdentifier("cave");
                }
                case 2: {
                    return new LevelIdentifier("deepcave");
                }
            }
            return new LevelIdentifier("surface");
        }
        catch (Exception e) {
            System.out.println("Back System: Failed to create LevelIdentifier for level type " + levelType);
            return new LevelIdentifier("surface");
        }
    }
}

