/*
 * Decompiled with CFR 0.152.
 */
package mod;

import java.io.File;
import java.lang.reflect.Field;
import java.util.Random;
import java.util.function.Supplier;
import necesse.engine.GlobalData;
import necesse.engine.modLoader.annotations.ModEntry;
import necesse.engine.registries.MobRegistry;
import necesse.engine.registries.SettlerRegistry;
import necesse.engine.save.LoadData;
import necesse.engine.save.SaveData;
import necesse.engine.util.GameRandom;
import necesse.engine.util.TicketSystemList;
import necesse.entity.mobs.friendly.human.HumanMob;
import necesse.level.maps.Level;
import necesse.level.maps.levelData.settlementData.AnimalMerchantSettlementVisitorSpawner;
import necesse.level.maps.levelData.settlementData.ServerSettlementData;
import necesse.level.maps.levelData.settlementData.SettlementVisitorOdds;
import necesse.level.maps.levelData.settlementData.SettlementVisitorSpawner;
import necesse.level.maps.levelData.settlementData.settler.Settler;

@ModEntry
public class VisitorFrequencyMod {
    public static int MIN_SECONDS_VISITOR_TIMER = 1;
    public static int MAX_SECONDS_VISITOR_TIMER = 25;
    public static int VISITOR_STAY_TIME = 115;
    public static int VISITOR_TRAVEL_OUT_TIME = 5;
    public static int EXOTIC_MERCHANT_TICKETS = 75;
    public static int PAWNBROKER_TICKETS = 50;
    public static int ANIMAL_MERCHANT_TICKETS = 100;
    public static int RECRUIT_TICKETS = 250;

    public void init() {
        this.loadConfig();
        this.modifyVisitorInterval();
        this.modifyVisitorStayTime();
        ServerSettlementData.visitorOdds.clear();
        this.addAllVisitorsWithNewTickets();
    }

    private File getConfigFile() {
        String userDataPath = GlobalData.appDataPath();
        return new File(userDataPath + "cfg/mods/VisitorFrequencyMod/config.txt");
    }

    private void loadConfig() {
        try {
            File configFile = this.getConfigFile();
            if (configFile.exists()) {
                LoadData loadData = new LoadData(configFile);
                MIN_SECONDS_VISITOR_TIMER = loadData.getInt("visitorintervalmin", 1);
                MAX_SECONDS_VISITOR_TIMER = loadData.getInt("visitorintervalmax", 25);
                VISITOR_STAY_TIME = loadData.getInt("visitorstaytime", 115);
                VISITOR_TRAVEL_OUT_TIME = loadData.getInt("visitortravelouttime", 5);
                EXOTIC_MERCHANT_TICKETS = loadData.getInt("exoticmerchant_tickets", 75);
                PAWNBROKER_TICKETS = loadData.getInt("pawnbroker_tickets", 50);
                ANIMAL_MERCHANT_TICKETS = loadData.getInt("animalmerchant_tickets", 100);
                RECRUIT_TICKETS = loadData.getInt("recruit_tickets", 250);
            } else {
                this.saveConfig();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void saveConfig() {
        try {
            File configDir = this.getConfigFile().getParentFile();
            if (!configDir.exists()) {
                configDir.mkdirs();
            }
            SaveData saveData = new SaveData("VisitorFrequencyConfig");
            saveData.addInt("visitorintervalmin", MIN_SECONDS_VISITOR_TIMER);
            saveData.addInt("visitorintervalmax", MAX_SECONDS_VISITOR_TIMER);
            saveData.addInt("visitorstaytime", VISITOR_STAY_TIME);
            saveData.addInt("visitortravelouttime", VISITOR_TRAVEL_OUT_TIME);
            saveData.addInt("exoticmerchant_tickets", EXOTIC_MERCHANT_TICKETS);
            saveData.addInt("pawnbroker_tickets", PAWNBROKER_TICKETS);
            saveData.addInt("animalmerchant_tickets", ANIMAL_MERCHANT_TICKETS);
            saveData.addInt("recruit_tickets", RECRUIT_TICKETS);
            saveData.saveScript(this.getConfigFile());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void modifyVisitorInterval() {
        try {
            Field minField = ServerSettlementData.class.getDeclaredField("MIN_SECONDS_VISITOR_TIMER");
            Field maxField = ServerSettlementData.class.getDeclaredField("MAX_SECONDS_VISITOR_TIMER");
            minField.setAccessible(true);
            maxField.setAccessible(true);
            minField.set(null, MIN_SECONDS_VISITOR_TIMER);
            maxField.set(null, MAX_SECONDS_VISITOR_TIMER);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void modifyVisitorStayTime() {
        try {
            Field stayTimeField = HumanMob.class.getDeclaredField("visitorStayTimeSeconds");
            Field travelOutField = HumanMob.class.getDeclaredField("timeToTravelOut");
            stayTimeField.setAccessible(true);
            travelOutField.setAccessible(true);
            stayTimeField.set(null, VISITOR_STAY_TIME);
            travelOutField.set(null, VISITOR_TRAVEL_OUT_TIME);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void addAllVisitorsWithNewTickets() {
        ServerSettlementData.visitorOdds.add(new SettlementVisitorOdds("exoticmerchant"){

            public boolean canSpawn(ServerSettlementData data) {
                return true;
            }

            public int getTickets(ServerSettlementData data) {
                return EXOTIC_MERCHANT_TICKETS;
            }

            public SettlementVisitorSpawner getNewVisitorSpawner(ServerSettlementData data) {
                return new SettlementVisitorSpawner((SettlementVisitorOdds)this, (HumanMob)MobRegistry.getMob((String)"exoticmerchanthuman", (Level)data.getLevel()));
            }
        });
        ServerSettlementData.visitorOdds.add(new SettlementVisitorOdds("pawnbroker"){

            public boolean canSpawn(ServerSettlementData data) {
                return true;
            }

            public int getTickets(ServerSettlementData data) {
                return PAWNBROKER_TICKETS;
            }

            public SettlementVisitorSpawner getNewVisitorSpawner(ServerSettlementData data) {
                return new SettlementVisitorSpawner((SettlementVisitorOdds)this, (HumanMob)MobRegistry.getMob((String)"pawnbrokerhuman", (Level)data.getLevel()));
            }
        });
        ServerSettlementData.visitorOdds.add(new SettlementVisitorOdds("animalmerchant"){

            public boolean canSpawn(ServerSettlementData data) {
                return true;
            }

            public int getTickets(ServerSettlementData data) {
                return ANIMAL_MERCHANT_TICKETS;
            }

            public SettlementVisitorSpawner getNewVisitorSpawner(ServerSettlementData data) {
                if (GameRandom.globalRandom.nextBoolean()) {
                    int animalCount = GameRandom.globalRandom.getIntBetween(4, 5);
                    return new AnimalMerchantSettlementVisitorSpawner((SettlementVisitorOdds)this, data, "animalkeeperhuman", animalCount);
                }
                int animalCount = GameRandom.globalRandom.getIntBetween(1, 2);
                return new AnimalMerchantSettlementVisitorSpawner((SettlementVisitorOdds)this, data, "farmerhuman", animalCount);
            }
        });
        ServerSettlementData.visitorOdds.add(new SettlementVisitorOdds("recruit"){

            public boolean canSpawn(ServerSettlementData data) {
                return true;
            }

            public int getTickets(ServerSettlementData data) {
                return RECRUIT_TICKETS;
            }

            public SettlementVisitorSpawner getNewVisitorSpawner(ServerSettlementData data) {
                TicketSystemList ticketSystem = new TicketSystemList();
                for (Settler settler : SettlerRegistry.getSettlers()) {
                    settler.addNewRecruitSettler(data, true, ticketSystem);
                }
                while (!ticketSystem.isEmpty()) {
                    Supplier supplier = (Supplier)ticketSystem.getAndRemoveRandomObject((Random)GameRandom.globalRandom);
                    HumanMob humanMob = (HumanMob)supplier.get();
                    if (humanMob == null) continue;
                    return new SettlementVisitorSpawner((SettlementVisitorOdds)this, humanMob);
                }
                return null;
            }
        });
    }
}

