/*
 * Decompiled with CFR 0.152.
 */
package gatekeeper.core.events;

import gatekeeper.core.WhitelistManager;
import necesse.engine.GameEventInterface;
import necesse.engine.commands.PermissionLevel;
import necesse.engine.events.ServerClientConnectedEvent;
import necesse.engine.network.Packet;
import necesse.engine.network.packet.PacketChatMessage;
import necesse.engine.network.packet.PacketDisconnect;
import necesse.engine.network.server.Server;
import necesse.engine.network.server.ServerClient;

public class WhitelistConnectionListener
implements GameEventInterface<ServerClientConnectedEvent> {
    private volatile boolean disposed = false;
    private final WhitelistManager manager;
    private static final long NOTIFY_COOLDOWN_MS = 60000L;

    public WhitelistConnectionListener(WhitelistManager manager) {
        this.manager = manager;
    }

    public void init(Runnable removeCallback) {
    }

    public void onEvent(ServerClientConnectedEvent event) {
        String who;
        boolean isPrivileged;
        if (this.disposed || event == null || event.client == null) {
            return;
        }
        ServerClient c = event.client;
        Server server = c.getServer();
        long auth = c.authentication;
        String name = c.getName();
        boolean bl = isPrivileged = c.getPermissionLevel().getLevel() >= PermissionLevel.ADMIN.getLevel();
        if (isPrivileged) {
            boolean added;
            if (!this.manager.isWhitelisted(server, auth, name) && (added = this.manager.addAuth(server, auth))) {
                this.manager.logAdminAction(server, "auto_add_privileged_on_join," + auth + "," + (name == null ? "" : name));
            }
            this.manager.rememberName(auth, name);
            String status = this.manager.isEnabled() ? "ENABLED" : "DISABLED";
            c.sendPacket((Packet)new PacketChatMessage("[GateKeeper] Whitelist is " + status + ". Use /whitelist help"));
            return;
        }
        if (!this.manager.isEnabled()) {
            return;
        }
        if (this.manager.isWhitelisted(server, auth, name)) {
            return;
        }
        String address = c.networkInfo == null ? null : c.networkInfo.getDisplayName();
        this.manager.recordDeniedAttempt(server, auth, name, address);
        if (!this.manager.isLockdown() && this.manager.shouldNotify(auth, 60000L)) {
            who = name == null || name.isEmpty() ? "<unknown>" : name;
            String msg = "[GateKeeper] Connection blocked for non-whitelisted user: " + who + " \u2014 approve with /whitelist approve " + who + " or /whitelist approve-last";
            for (int i = 0; i < server.getSlots(); ++i) {
                ServerClient admin = server.getClient(i);
                if (admin == null || admin.getPermissionLevel().getLevel() < PermissionLevel.ADMIN.getLevel()) continue;
                admin.sendPacket((Packet)new PacketChatMessage(msg));
            }
            this.manager.rememberNotify(auth);
        }
        who = name == null || name.isEmpty() ? "you" : name;
        Object reason = this.manager.isLockdown() ? "Server is in lockdown. Please contact an admin." : "Not whitelisted. Ask an admin to run /whitelist approve " + who;
        server.disconnectClient(c, PacketDisconnect.kickPacket((int)c.slot, (String)reason));
    }

    public boolean isDisposed() {
        return this.disposed;
    }

    public void dispose() {
        this.disposed = true;
    }
}

