/*
 * Decompiled with CFR 0.152.
 */
package gatekeeper.core;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import gatekeeper.core.NameCache;
import gatekeeper.core.WhitelistConfig;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import necesse.engine.network.server.Server;
import necesse.engine.network.server.ServerClient;
import necesse.engine.world.World;

public class WhitelistManager {
    private File configDir;
    private File configFile;
    private File nameCacheFile;
    private long currentWorldId = Long.MIN_VALUE;
    private final Set<Long> authIds = new HashSet<Long>();
    private boolean enabled = false;
    private boolean lockdown = false;
    private final Map<Long, Long> lastNotify = new HashMap<Long, Long>();
    private long lastGlobalNotify = 0L;
    private static final long NOTIFY_GLOBAL_MIN_INTERVAL_MS = 3000L;
    private final LinkedList<Attempt> recent = new LinkedList();
    private static final int RECENT_MAX = 50;
    private final Map<Long, String> authToName = new HashMap<Long, String>();
    private final Map<String, Long> nameToAuth = new HashMap<String, Long>();

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(Server server, boolean value) {
        this.ensureWorld(server);
        this.enabled = value;
        this.saveInternal();
    }

    private void ensureWorld(Server server) {
        if (server == null || server.world == null) {
            return;
        }
        long wid = server.world.getUniqueID();
        if (wid == this.currentWorldId && this.configFile != null) {
            return;
        }
        File worldPath = server.world.filePath;
        if (World.isWorldADirectory((File)worldPath)) {
            this.configDir = new File(worldPath, "GateKeeper");
        } else {
            String baseName = World.getWorldDisplayName((String)worldPath.getName());
            this.configDir = new File(worldPath.getParentFile(), baseName + ".GateKeeper");
        }
        this.configFile = new File(this.configDir, "whitelist.json");
        this.nameCacheFile = new File(this.configDir, "name_cache.json");
        this.currentWorldId = wid;
        this.loadInternal();
    }

    private synchronized void loadInternal() {
        if (this.configDir == null || this.configFile == null) {
            return;
        }
        if (!this.configDir.exists()) {
            this.configDir.mkdirs();
        }
        if (!this.configFile.exists()) {
            this.loadNameCache();
            return;
        }
        try {
            WhitelistConfig cfg = this.readConfig(this.configFile);
            this.applyConfig(cfg);
            this.loadNameCache();
        }
        catch (JsonSyntaxException | IOException e) {
            String renamed = this.renameBrokenConfig();
            System.err.println("GateKeeper: Failed to parse whitelist.json; kept defaults. Renamed broken file to: " + renamed);
        }
    }

    private synchronized void saveInternal() {
        if (this.configDir == null || this.configFile == null) {
            return;
        }
        if (!this.configDir.exists()) {
            this.configDir.mkdirs();
        }
        try (BufferedWriter bw = new BufferedWriter(new FileWriter(this.configFile));){
            ArrayList<Long> ids = new ArrayList<Long>(this.authIds);
            Collections.sort(ids);
            WhitelistConfig cfg = new WhitelistConfig();
            cfg.enabled = this.enabled;
            cfg.lockdown = this.lockdown;
            cfg.auth = ids;
            Gson gson = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
            bw.write(gson.toJson(cfg));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public synchronized boolean isWhitelisted(Server server, long auth, String name) {
        this.ensureWorld(server);
        if (!this.enabled) {
            return true;
        }
        return this.authIds.contains(auth);
    }

    public synchronized boolean isLockdown() {
        return this.lockdown;
    }

    public synchronized void setLockdown(Server server, boolean on) {
        this.ensureWorld(server);
        this.lockdown = on;
        this.saveInternal();
    }

    public synchronized boolean addAuth(Server server, long auth) {
        this.ensureWorld(server);
        boolean added = this.authIds.add(auth);
        if (added) {
            this.saveInternal();
        }
        return added;
    }

    public synchronized boolean removeAuth(Server server, long auth) {
        this.ensureWorld(server);
        boolean rem = this.authIds.remove(auth);
        if (rem) {
            this.saveInternal();
        }
        return rem;
    }

    public synchronized List<Long> listAuths(Server server) {
        this.ensureWorld(server);
        return new ArrayList<Long>(this.authIds);
    }

    public synchronized Long findAuthByName(Server server, String name) {
        if (server == null || name == null) {
            return null;
        }
        this.ensureWorld(server);
        String nlow = name.toLowerCase(Locale.ENGLISH);
        for (int i = 0; i < server.getSlots(); ++i) {
            ServerClient c = server.getClient(i);
            if (c == null || c.getName() == null || !c.getName().equalsIgnoreCase(name)) continue;
            return c.authentication;
        }
        HashMap used = server.world.getUsedPlayerNames();
        for (Map.Entry entry : used.entrySet()) {
            if (entry.getValue() == null || !((String)entry.getValue()).toLowerCase(Locale.ENGLISH).equals(nlow)) continue;
            return (Long)entry.getKey();
        }
        Long cached = this.nameToAuth.get(nlow);
        return cached;
    }

    public synchronized String getNameByAuth(Server server, long auth) {
        if (server == null) {
            return null;
        }
        this.ensureWorld(server);
        for (int i = 0; i < server.getSlots(); ++i) {
            ServerClient c = server.getClient(i);
            if (c == null || c.authentication != auth) continue;
            return c.getName();
        }
        String cached = this.authToName.get(auth);
        if (cached != null) {
            return cached;
        }
        HashMap used = server.world.getUsedPlayerNames();
        return (String)used.get(auth);
    }

    public synchronized boolean reload(Server server, StringBuilder messageOut) {
        this.ensureWorld(server);
        if (this.configFile == null) {
            if (messageOut != null) {
                messageOut.append("No config file to reload.");
            }
            return false;
        }
        try {
            WhitelistConfig cfg = this.readConfig(this.configFile);
            this.applyConfig(cfg);
            if (messageOut != null) {
                messageOut.append("Reloaded whitelist from ").append(this.configFile.getName());
            }
            return true;
        }
        catch (JsonSyntaxException | IOException e) {
            String renamed = this.renameBrokenConfig();
            if (messageOut != null) {
                messageOut.append("Error parsing whitelist; kept existing config. Renamed broken file to ").append(renamed);
            }
            return false;
        }
    }

    private WhitelistConfig readConfig(File file) throws IOException, JsonSyntaxException {
        try (BufferedReader br = new BufferedReader(new FileReader(file));){
            Gson gson = new Gson();
            WhitelistConfig cfg = gson.fromJson((Reader)br, WhitelistConfig.class);
            if (cfg == null) {
                cfg = new WhitelistConfig();
            }
            WhitelistConfig whitelistConfig = cfg;
            return whitelistConfig;
        }
    }

    private void applyConfig(WhitelistConfig cfg) {
        this.enabled = cfg.enabled;
        this.lockdown = cfg.lockdown;
        this.authIds.clear();
        if (cfg.auth != null) {
            this.authIds.addAll(cfg.auth);
        }
    }

    private String renameBrokenConfig() {
        if (this.configFile == null) {
            return null;
        }
        String ts = new SimpleDateFormat("yyyyMMddHHmmss").format(new Date());
        File renamed = new File(this.configDir, this.configFile.getName() + ".broken-" + ts);
        boolean ok = this.configFile.renameTo(renamed);
        return ok ? renamed.getName() : this.configFile.getName();
    }

    public synchronized void rememberNotify(long auth) {
        this.lastNotify.put(auth, System.currentTimeMillis());
        this.lastGlobalNotify = System.currentTimeMillis();
    }

    public synchronized boolean shouldNotify(long auth, long cooldownMs) {
        long now = System.currentTimeMillis();
        if (now - this.lastGlobalNotify < 3000L) {
            return false;
        }
        Long last = this.lastNotify.get(auth);
        if (last == null) {
            return true;
        }
        return now - last > cooldownMs;
    }

    public synchronized void recordDeniedAttempt(Server server, long auth, String name, String address) {
        this.ensureWorld(server);
        Attempt a = new Attempt(System.currentTimeMillis(), auth, name, address);
        this.recent.addLast(a);
        while (this.recent.size() > 50) {
            this.recent.removeFirst();
        }
        this.rememberName(auth, name);
        if (this.configDir != null) {
            File log = new File(this.configDir, "denied_log.txt");
            try (BufferedWriter bw = new BufferedWriter(new FileWriter(log, true));){
                String n = name == null ? "" : name;
                String addr = address == null ? "" : address;
                bw.write(a.timeMs + "," + auth + "," + n + "," + addr + "\n");
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public synchronized List<Attempt> getRecentAttempts() {
        return new ArrayList<Attempt>(this.recent);
    }

    public synchronized Long getLastDeniedAuth() {
        return this.recent.isEmpty() ? null : Long.valueOf(this.recent.getLast().auth);
    }

    public synchronized File getConfigDir(Server server) {
        this.ensureWorld(server);
        return this.configDir;
    }

    public synchronized int exportKnownPlayers(Server server) {
        this.ensureWorld(server);
        if (this.configDir == null) {
            return 0;
        }
        if (!this.configDir.exists()) {
            this.configDir.mkdirs();
        }
        File out = new File(this.configDir, "known_players.txt");
        HashMap used = server.world.getUsedPlayerNames();
        int count = 0;
        try (BufferedWriter bw = new BufferedWriter(new FileWriter(out));){
            bw.write("# auth,name\n");
            for (Map.Entry e : used.entrySet()) {
                if (e.getValue() == null) continue;
                bw.write(e.getKey() + "," + (String)e.getValue() + "\n");
                ++count;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return count;
    }

    public synchronized void logAdminAction(Server server, String line) {
        this.ensureWorld(server);
        if (this.configDir == null) {
            return;
        }
        if (!this.configDir.exists()) {
            this.configDir.mkdirs();
        }
        File out = new File(this.configDir, "admin_log.txt");
        try (BufferedWriter bw = new BufferedWriter(new FileWriter(out, true));){
            bw.write(System.currentTimeMillis() + "," + line + "\n");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public synchronized void rememberName(long auth, String name) {
        if (name == null || name.isEmpty()) {
            return;
        }
        this.authToName.put(auth, name);
        this.nameToAuth.put(name.toLowerCase(Locale.ENGLISH), auth);
        this.saveNameCache();
    }

    private void loadNameCache() {
        if (this.nameCacheFile == null) {
            return;
        }
        if (!this.nameCacheFile.exists()) {
            return;
        }
        try (BufferedReader br = new BufferedReader(new FileReader(this.nameCacheFile));){
            Gson gson = new Gson();
            NameCache nc = gson.fromJson((Reader)br, NameCache.class);
            if (nc != null) {
                this.authToName.clear();
                this.nameToAuth.clear();
                if (nc.authNames != null) {
                    this.authToName.putAll(nc.authNames);
                }
                if (nc.names != null) {
                    for (Map.Entry<String, Long> e : nc.names.entrySet()) {
                        if (e.getKey() == null || e.getValue() == null) continue;
                        this.nameToAuth.put(e.getKey().toLowerCase(Locale.ENGLISH), e.getValue());
                    }
                }
            }
        }
        catch (JsonSyntaxException | IOException exception) {
            // empty catch block
        }
    }

    private void saveNameCache() {
        if (this.configDir == null || this.nameCacheFile == null) {
            return;
        }
        if (!this.configDir.exists()) {
            this.configDir.mkdirs();
        }
        try (BufferedWriter bw = new BufferedWriter(new FileWriter(this.nameCacheFile));){
            NameCache nc = new NameCache();
            nc.authNames = new HashMap<Long, String>(this.authToName);
            HashMap<String, Long> namesOut = new HashMap<String, Long>();
            for (Map.Entry<String, Long> e : this.nameToAuth.entrySet()) {
                if (e.getKey() == null || e.getValue() == null) continue;
                namesOut.put(e.getKey().toLowerCase(Locale.ENGLISH), e.getValue());
            }
            nc.names = namesOut;
            Gson gson = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
            bw.write(gson.toJson(nc));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static class Attempt {
        public final long timeMs;
        public final long auth;
        public final String name;
        public final String address;

        public Attempt(long timeMs, long auth, String name, String address) {
            this.timeMs = timeMs;
            this.auth = auth;
            this.name = name;
            this.address = address;
        }
    }
}

