/*
 * Decompiled with CFR 0.152.
 */
package gatekeeper.core;

import gatekeeper.core.WhitelistManager;
import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import necesse.engine.commands.CmdParameter;
import necesse.engine.commands.CommandLog;
import necesse.engine.commands.ModularChatCommand;
import necesse.engine.commands.PermissionLevel;
import necesse.engine.commands.parameterHandlers.ParameterHandler;
import necesse.engine.commands.parameterHandlers.RestStringParameterHandler;
import necesse.engine.network.client.Client;
import necesse.engine.network.packet.PacketDisconnect;
import necesse.engine.network.server.Server;
import necesse.engine.network.server.ServerClient;

public class WhitelistCommand
extends ModularChatCommand {
    private final WhitelistManager manager;

    public WhitelistCommand(WhitelistManager manager) {
        super("whitelist", "Manage the GateKeeper whitelist", PermissionLevel.ADMIN, false, new CmdParameter[]{new CmdParameter("args", (ParameterHandler)new RestStringParameterHandler())});
        this.manager = manager;
    }

    public void runModular(Client client, Server server, ServerClient serverClient, Object[] args, String[] errors, CommandLog logs) {
        String sub;
        String rest = ((String)args[0]).trim();
        if (rest.isEmpty()) {
            this.printHelp(logs);
            return;
        }
        String[] parts = rest.split("\\s+");
        switch (sub = parts[0].toLowerCase(Locale.ENGLISH)) {
            case "help": {
                this.printHelp(logs);
                break;
            }
            case "enable": {
                this.manager.setEnabled(server, true);
                logs.add("GateKeeper whitelist enabled");
                break;
            }
            case "disable": {
                this.manager.setEnabled(server, false);
                logs.add("GateKeeper whitelist disabled");
                break;
            }
            case "status": {
                logs.add("Whitelist is " + (this.manager.isEnabled() ? "ENABLED" : "DISABLED"));
                logs.add("Entries: " + this.manager.listAuths(server).size());
                break;
            }
            case "reload": {
                StringBuilder sb = new StringBuilder();
                boolean ok = this.manager.reload(server, sb);
                logs.add((ok ? "OK: " : "ERROR: ") + sb.toString());
                break;
            }
            case "list": {
                List<Long> auths = this.manager.listAuths(server);
                Collections.sort(auths);
                logs.add("Whitelisted users (" + auths.size() + "):");
                for (Long a : auths) {
                    String nm = this.manager.getNameByAuth(server, a);
                    if (nm != null && !nm.isEmpty()) {
                        logs.add(" - " + nm);
                        continue;
                    }
                    logs.add(" - <unknown> (" + a + ")");
                }
                break;
            }
            case "lockdown": {
                if (parts.length == 1 || parts[1].equalsIgnoreCase("status")) {
                    logs.add("Lockdown is " + (this.manager.isLockdown() ? "ON" : "OFF"));
                    break;
                }
                if (parts[1].equalsIgnoreCase("on")) {
                    this.manager.setLockdown(server, true);
                    logs.add("Lockdown enabled: only whitelisted players can join; notifications suppressed.");
                    break;
                }
                if (parts[1].equalsIgnoreCase("off")) {
                    this.manager.setLockdown(server, false);
                    logs.add("Lockdown disabled.");
                    break;
                }
                logs.add("Usage: /whitelist lockdown [on|off|status]");
                break;
            }
            case "online": {
                for (int i = 0; i < server.getSlots(); ++i) {
                    ServerClient c = server.getClient(i);
                    if (c == null) continue;
                    String nm = c.getName();
                    logs.add("#" + (i + 1) + ": " + (nm == null || nm.isEmpty() ? "<unknown>" : nm) + " perm=" + c.getPermissionLevel());
                }
                break;
            }
            case "recent": {
                int start;
                if (parts.length >= 3 && parts[1].equalsIgnoreCase("approve")) {
                    try {
                        int idx = Integer.parseInt(parts[2]);
                        List<WhitelistManager.Attempt> list = this.manager.getRecentAttempts();
                        if (idx < 1 || idx > list.size()) {
                            logs.add("Index out of range");
                            break;
                        }
                        WhitelistManager.Attempt at = list.get(idx - 1);
                        long authIdx = at.auth;
                        boolean addedIdx = this.manager.addAuth(server, authIdx);
                        String who = at.name == null || at.name.isEmpty() ? "<unknown> (" + authIdx + ")" : at.name;
                        logs.add((addedIdx ? "Approved" : "Already whitelisted") + ": " + who);
                    }
                    catch (NumberFormatException ex) {
                        logs.add("Usage: /whitelist recent approve <index>");
                    }
                    break;
                }
                List<WhitelistManager.Attempt> list = this.manager.getRecentAttempts();
                if (list.isEmpty()) {
                    logs.add("No recent denied attempts.");
                    break;
                }
                int shown = 0;
                for (int i = start = Math.max(0, list.size() - 10); i < list.size(); ++i) {
                    WhitelistManager.Attempt a = list.get(i);
                    long ageSec = (System.currentTimeMillis() - a.timeMs) / 1000L;
                    String who = a.name == null || a.name.isEmpty() ? "<unknown>" : a.name;
                    logs.add(i + 1 + ". " + who + " " + ageSec + "s ago " + (String)(a.address == null ? "" : "[" + a.address + "]"));
                    ++shown;
                }
                logs.add("Shown " + shown + "/" + list.size() + ". Use '/whitelist recent approve <index>' to approve.");
                break;
            }
            case "approve-last": {
                Long last = this.manager.getLastDeniedAuth();
                if (last == null) {
                    logs.add("No recent denied attempts.");
                    break;
                }
                boolean addedLast = this.manager.addAuth(server, last);
                String whoLast = this.manager.getNameByAuth(server, last);
                Object whoText = whoLast == null || whoLast.isEmpty() ? "<unknown> (" + last + ")" : whoLast;
                logs.add((addedLast ? "Approved" : "Already whitelisted") + ": " + (String)whoText);
                break;
            }
            case "export": {
                int count = this.manager.exportKnownPlayers(server);
                File dir = this.manager.getConfigDir(server);
                logs.add("Exported " + count + " known players to " + new File(dir, "known_players.txt").getPath());
                break;
            }
            case "add": 
            case "approve": {
                if (parts.length < 2) {
                    logs.add("Usage: /whitelist add <auth|name>");
                    break;
                }
                this.handleAdd(server, logs, parts[1]);
                break;
            }
            case "remove": 
            case "deny": {
                if (parts.length < 2) {
                    logs.add("Usage: /whitelist remove <auth|name>");
                    break;
                }
                this.handleRemove(server, logs, parts[1]);
                break;
            }
            default: {
                this.printHelp(logs);
            }
        }
    }

    private void handleAdd(Server server, CommandLog logs, String token) {
        try {
            long auth = Long.parseLong(token);
            boolean added = this.manager.addAuth(server, auth);
            String who = this.manager.getNameByAuth(server, auth);
            Object out = who == null || who.isEmpty() ? "(" + auth + ")" : who;
            logs.add((added ? "Added" : "Already present") + ": " + (String)out);
        }
        catch (NumberFormatException nfe) {
            Long auth = this.manager.findAuthByName(server, token);
            if (auth != null) {
                boolean added = this.manager.addAuth(server, auth);
                this.manager.rememberName(auth, token);
                logs.add((added ? "Added" : "Already present") + ": " + token);
            }
            logs.add("Could not resolve name '" + token + "' to a SteamID. Ask them to connect once or provide their SteamID.");
        }
    }

    private void handleRemove(Server server, CommandLog logs, String token) {
        Long authToRemove = null;
        try {
            authToRemove = Long.parseLong(token);
        }
        catch (NumberFormatException ignore) {
            authToRemove = this.manager.findAuthByName(server, token);
        }
        if (authToRemove == null) {
            logs.add("Could not resolve '" + token + "' to a SteamID");
            return;
        }
        boolean removed = this.manager.removeAuth(server, authToRemove);
        String who = this.manager.getNameByAuth(server, authToRemove);
        Object out = who == null || who.isEmpty() ? "(" + authToRemove + ")" : who;
        logs.add((removed ? "Removed" : "Not present") + ": " + (String)out);
        if (removed) {
            for (int i = 0; i < server.getSlots(); ++i) {
                ServerClient c = server.getClient(i);
                if (c == null || c.authentication != authToRemove) continue;
                String nm = c.getName();
                server.disconnectClient(c, PacketDisconnect.kickPacket((int)c.slot, (String)"Removed from whitelist"));
                this.manager.logAdminAction(server, "kick_on_remove," + authToRemove + "," + (nm == null ? "" : nm));
            }
        }
    }

    private void printHelp(CommandLog logs) {
        logs.add("/whitelist enable|disable|status|reload|lockdown [on|off|status]");
        logs.add("/whitelist list|online|recent|approve-last|export");
        logs.add("/whitelist add <auth|name> (prefer name; we resolve to SteamID)");
        logs.add("/whitelist remove <auth|name> (deny alias; prefer name)");
        logs.add("/whitelist recent approve <index>");
    }
}

