/*
 * Decompiled with CFR 0.152.
 */
package instahouse;

import instahouse.InstaHouseMod;
import instahouse.presets.InstaHousePreset;
import necesse.engine.network.NetworkPacket;
import necesse.engine.network.Packet;
import necesse.engine.network.PacketReader;
import necesse.engine.network.PacketWriter;
import necesse.engine.network.client.Client;
import necesse.engine.network.server.Server;
import necesse.engine.network.server.ServerClient;
import necesse.level.maps.Level;
import necesse.level.maps.presets.Preset;
import necesse.level.maps.presets.PresetUtils;

public class PresetPacket
extends Packet {
    public final int playerSlot;
    public final int tileX;
    public final int tileY;
    public final String presetScript;

    public PresetPacket(byte[] data) {
        super(data);
        PacketReader reader = new PacketReader((Packet)this);
        this.playerSlot = reader.getNextByteUnsigned();
        this.tileX = reader.getNextInt();
        this.tileY = reader.getNextInt();
        this.presetScript = reader.getNextString();
    }

    public PresetPacket(Client client, int tileX, int tileY, String presetScript) {
        this.playerSlot = client.getSlot();
        this.tileX = tileX;
        this.tileY = tileY;
        this.presetScript = presetScript;
        PacketWriter writer = new PacketWriter((Packet)this);
        writer.putNextByteUnsigned(this.playerSlot);
        writer.putNextInt(tileX);
        writer.putNextInt(tileY);
        writer.putNextString(presetScript);
    }

    public void processServer(NetworkPacket packet, Server server, ServerClient client) {
        if (this.presetScript != null && !this.presetScript.isEmpty()) {
            String script = this.presetScript;
            boolean useClientPreset = InstaHousePreset.IsAllowedPreset(client.getPermissionLevel());
            if (!useClientPreset) {
                script = InstaHouseMod.SettingsGetter.getString("server_preset");
            }
            PresetUtils.placeAndSendPresetToClients((Server)client.getServer(), (Preset)new InstaHousePreset(script), (Level)client.getLevel(), (int)this.tileX, (int)this.tileY);
        }
    }
}

