/*
 * Decompiled with CFR 0.152.
 */
package autotrash.ui;

import autotrash.data.PlayerData;
import autotrash.data.PlayerDataList;
import autotrash.ui.FormAutoTrashItemList;
import java.awt.Color;
import java.awt.Rectangle;
import java.util.function.Supplier;
import necesse.engine.gameLoop.tickManager.TickManager;
import necesse.engine.input.Control;
import necesse.engine.localization.Localization;
import necesse.engine.localization.message.GameMessage;
import necesse.engine.localization.message.LocalMessage;
import necesse.entity.mobs.PlayerMob;
import necesse.gfx.forms.Form;
import necesse.gfx.forms.MainGameFormManager;
import necesse.gfx.forms.components.FormComponent;
import necesse.gfx.forms.components.FormContentIconButton;
import necesse.gfx.forms.components.FormInputSize;
import necesse.gfx.forms.components.FormTextInput;
import necesse.gfx.forms.components.localComponents.FormLocalCheckBox;
import necesse.gfx.forms.components.localComponents.FormLocalLabel;
import necesse.gfx.gameFont.FontOptions;
import necesse.gfx.gameTexture.GameTexture;
import necesse.gfx.gameTooltips.GameTooltipManager;
import necesse.gfx.gameTooltips.GameTooltips;
import necesse.gfx.gameTooltips.InputTooltip;
import necesse.gfx.gameTooltips.ListGameTooltips;
import necesse.gfx.gameTooltips.TooltipLocation;
import necesse.gfx.ui.ButtonColor;
import necesse.gfx.ui.ButtonTexture;

public class ItemListForm
extends Form {
    public final MainGameFormManager mainFormManager;
    public final FormLocalLabel label;
    public final FormLocalCheckBox enabledCheckbox;
    public static GameTexture clearListButtonTexture;
    public final FormContentIconButton clearListButton;
    public final FormTextInput searchFilter;
    public FormAutoTrashItemList itemList;
    public final Supplier<Boolean> isNotHiddenSupplier = () -> !this.isHidden();

    public ItemListForm(MainGameFormManager mainFormManager, String name, int width, int height, PlayerMob player) {
        super(name, width, height);
        this.mainFormManager = mainFormManager;
        this.label = (FormLocalLabel)this.addComponent((FormComponent)new FormLocalLabel("autotrash", "itemlistlabel", new FontOptions(16), 0, this.getWidth() / 2, 5));
        this.searchFilter = (FormTextInput)this.addComponent((FormComponent)new FormTextInput(5, this.label.getY() + this.label.getHeight() + 3, FormInputSize.SIZE_20, this.getWidth() - 10, Integer.MAX_VALUE));
        this.searchFilter.placeHolder = new LocalMessage("ui", "searchtip");
        this.searchFilter.rightClickToClear = true;
        this.searchFilter.onChange(e -> this.itemList.setFilter(this.searchFilter.getText()));
        this.enabledCheckbox = (FormLocalCheckBox)this.addComponent((FormComponent)new FormLocalCheckBox("autotrash", "enabledcheckboxlabel", 5, this.getHeight() - 18, true));
        this.enabledCheckbox.onClicked(e -> {
            PlayerData playerData = PlayerDataList.getPlayerData(player);
            if (playerData != null) {
                playerData.setEnabledAndSend(this.enabledCheckbox.checked);
            }
        });
        this.clearListButton = (FormContentIconButton)this.addComponent((FormComponent)new FormContentIconButton(this.getWidth() - 16 - 5, this.getHeight() - 16 - 4, FormInputSize.SIZE_16, ButtonColor.BASE, new ButtonTexture(clearListButtonTexture, state -> (Color)state.textColorGetter.apply(this.getInterfaceStyle())), new GameMessage[0]){

            protected void addTooltips(PlayerMob perspective) {
                super.addTooltips(perspective);
                if (perspective != null) {
                    ListGameTooltips tooltips = new ListGameTooltips();
                    tooltips.add((Object)new InputTooltip(Control.INV_QUICK_TRASH.getKeyName(), Control.MOUSE1, Localization.translate((String)"autotrash", (String)"clearlisttooltip")));
                    GameTooltipManager.addTooltip((GameTooltips)tooltips, null, (TooltipLocation)TooltipLocation.FORM_FOCUS);
                }
            }
        });
        this.clearListButton.onClicked(e -> {
            if (Control.INV_QUICK_TRASH.isDown()) {
                PlayerData playerData = PlayerDataList.getPlayerData(player);
                if (playerData != null) {
                    playerData.clearItemsAndSend();
                }
                this.clearListButton.setCooldown(500);
            }
        });
        int itemListY = this.searchFilter.getY() + this.searchFilter.size.height + 3;
        this.itemList = (FormAutoTrashItemList)this.addComponent((FormComponent)new FormAutoTrashItemList(3, itemListY, this.getWidth() - 6, this.getHeight() - itemListY - 24, player));
    }

    public void draw(TickManager tickManager, PlayerMob perspective, Rectangle renderBox) {
        super.draw(tickManager, perspective, renderBox);
    }
}

