/*
 * Decompiled with CFR 0.152.
 */
package autotrash.ui;

import autotrash.data.PlayerData;
import autotrash.data.PlayerDataList;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import necesse.engine.gameLoop.tickManager.TickManager;
import necesse.engine.input.InputEvent;
import necesse.engine.input.controller.ControllerEvent;
import necesse.engine.input.controller.ControllerInput;
import necesse.engine.localization.message.GameMessage;
import necesse.engine.registries.ItemRegistry;
import necesse.engine.util.GameBlackboard;
import necesse.engine.util.GameMath;
import necesse.engine.util.GameUtils;
import necesse.entity.mobs.PlayerMob;
import necesse.gfx.GameResources;
import necesse.gfx.Renderer;
import necesse.gfx.forms.FormManager;
import necesse.gfx.forms.components.lists.FormGeneralGridList;
import necesse.gfx.forms.components.lists.FormGeneralList;
import necesse.gfx.forms.components.lists.FormItemList;
import necesse.gfx.forms.components.lists.FormListElement;
import necesse.gfx.forms.controller.ControllerFocus;
import necesse.gfx.forms.controller.ControllerFocusHandler;
import necesse.gfx.forms.controller.ControllerNavigationHandler;
import necesse.gfx.gameFont.FontManager;
import necesse.gfx.gameFont.FontOptions;
import necesse.gfx.shader.FormShader;
import necesse.inventory.InventoryItem;
import necesse.inventory.item.Item;
import necesse.inventory.item.ItemSearchTester;

public class FormAutoTrashItemList
extends FormItemList {
    private String nameFilter = "";
    private Thread filterUpdater;
    public final PlayerMob player;

    public FormAutoTrashItemList(int x, int y, int width, int height, PlayerMob player) {
        super(x, y, width, height, FormItemList.UpdateMode.CONCURRENT_CONTINUOUS);
        this.setFilter(this.nameFilter);
        this.player = player;
    }

    public void addAllItemIds(List<Integer> list) {
        ArrayList<InventoryItem> items = new ArrayList<InventoryItem>();
        PlayerData playerData = PlayerDataList.getPlayerData(this.player);
        if (playerData != null) {
            for (int itemId : playerData.getItems()) {
                items.add(new InventoryItem(ItemRegistry.getItem((int)itemId), 1, false));
            }
        }
        this.addAllItems(items);
    }

    public void addAllItems(List<InventoryItem> list) {
        PlayerData playerData = PlayerDataList.getPlayerData(this.player);
        if (playerData == null) {
            return;
        }
        for (int itemId : playerData.getItems()) {
            Item item = ItemRegistry.getItem((int)itemId);
            if (item == null) continue;
            item.addDefaultItems(list, null);
        }
    }

    public void addItemIds(List<Integer> list) {
        for (Integer itemId : list) {
            this.addItemId(itemId, false);
        }
        this.updateList(true);
    }

    public void addItemId(int itemId, boolean updateList) {
        Item item = ItemRegistry.getItem((int)itemId);
        if (item != null) {
            item.addDefaultItems((List)this.allItems, null);
            if (updateList) {
                this.updateList(true);
            }
        }
    }

    public void removeItemId(int itemId) {
        Item item = ItemRegistry.getItem((int)itemId);
        if (item != null) {
            this.allItems.remove(item.getDefaultItem(null, 1));
            this.updateList(true);
        }
    }

    public void clearItems() {
        this.allItems.clear();
        this.updateList(true);
    }

    public void onItemClicked(InventoryItem item, InputEvent event) {
        PlayerData playerData = PlayerDataList.getPlayerData(this.player);
        if (playerData != null) {
            playerData.removeItemAndSend(item.item.getID());
        }
        this.allItems.remove(item);
    }

    public void setFilter(String filter) {
        this.nameFilter = filter.toLowerCase();
        ItemSearchTester tester = ItemSearchTester.constructSearchTester((String)this.nameFilter);
        this.setFilter(invItem -> {
            if (!invItem.item.shouldShowInItemList()) {
                return false;
            }
            return tester.matches(invItem, null, new GameBlackboard());
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateList(final boolean limitScroll) {
        if (this.filterUpdater != null) {
            this.filterUpdater.interrupt();
            this.filterUpdater = null;
        }
        final Predicate finalFilter = this.filter;
        if (this.updateMode == FormItemList.UpdateMode.CONCURRENT_CONTINUOUS) {
            this.elements = new ArrayList();
            final int lastScroll = this.scroll;
            this.filterUpdater = new Thread("item-list-filter-continuous"){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    super.run();
                    for (InventoryItem invItem : FormAutoTrashItemList.this.allItems) {
                        if (this.isInterrupted()) {
                            return;
                        }
                        if (finalFilter == null || finalFilter.test(invItem)) {
                            FormAutoTrashItemList formAutoTrashItemList;
                            if (FormAutoTrashItemList.this.sorted) {
                                formAutoTrashItemList = FormAutoTrashItemList.this;
                                synchronized (formAutoTrashItemList) {
                                    List list = FormAutoTrashItemList.this.elements;
                                    FormAutoTrashItemList formAutoTrashItemList2 = FormAutoTrashItemList.this;
                                    Objects.requireNonNull(formAutoTrashItemList2);
                                    GameUtils.insertSortedList((List)list, (Object)((Object)formAutoTrashItemList2.new AutoTrashItemElement(invItem)), Comparator.comparing(i -> i.item));
                                }
                            }
                            formAutoTrashItemList = FormAutoTrashItemList.this;
                            synchronized (formAutoTrashItemList) {
                                List list = FormAutoTrashItemList.this.elements;
                                FormAutoTrashItemList formAutoTrashItemList3 = FormAutoTrashItemList.this;
                                Objects.requireNonNull(formAutoTrashItemList3);
                                list.add(formAutoTrashItemList3.new AutoTrashItemElement(invItem));
                            }
                        }
                        if (!limitScroll) continue;
                        FormAutoTrashItemList.this.scroll = lastScroll;
                        FormAutoTrashItemList.this.limitMaxScroll();
                    }
                }
            };
            this.filterUpdater.start();
        } else if (this.updateMode == FormItemList.UpdateMode.CONCURRENT_FULL) {
            this.filterUpdater = new Thread("item-list-filter-wait"){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    super.run();
                    ArrayList<AutoTrashItemElement> list = new ArrayList<AutoTrashItemElement>(FormAutoTrashItemList.this.allItems.size());
                    for (InventoryItem invItem : FormAutoTrashItemList.this.allItems) {
                        if (this.isInterrupted()) {
                            return;
                        }
                        if (finalFilter != null && !finalFilter.test(invItem)) continue;
                        FormAutoTrashItemList formAutoTrashItemList = FormAutoTrashItemList.this;
                        Objects.requireNonNull(formAutoTrashItemList);
                        list.add(formAutoTrashItemList.new AutoTrashItemElement(invItem));
                    }
                    Object object = FormAutoTrashItemList.this;
                    synchronized (object) {
                        if (!this.isInterrupted()) {
                            if (FormAutoTrashItemList.this.sorted) {
                                list.sort(Comparator.comparing(i -> i.item));
                            }
                            FormAutoTrashItemList.this.elements = new ArrayList();
                            FormAutoTrashItemList.this.elements.addAll(list);
                            if (limitScroll) {
                                FormAutoTrashItemList.this.limitMaxScroll();
                            }
                        }
                    }
                }
            };
            this.filterUpdater.start();
        } else {
            FormAutoTrashItemList formAutoTrashItemList = this;
            synchronized (formAutoTrashItemList) {
                this.elements = new ArrayList();
                for (InventoryItem invItem : this.allItems) {
                    if (finalFilter != null && !finalFilter.test(invItem)) continue;
                    if (this.sorted) {
                        GameUtils.insertSortedList((List)this.elements, (Object)((Object)new AutoTrashItemElement(invItem)), Comparator.comparing(i -> i.item));
                        continue;
                    }
                    this.elements.add(new AutoTrashItemElement(invItem));
                }
                if (this.sorted) {
                    this.elements.sort(Comparator.comparing(i -> i.item));
                }
                if (limitScroll) {
                    this.limitMaxScroll();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addNextControllerFocus(List<ControllerFocus> list, int currentXOffset, int currentYOffset, ControllerNavigationHandler customNavigationHandler, Rectangle area, boolean draw) {
        area = area.intersection(new Rectangle(currentXOffset + this.getX(), currentYOffset + this.getY(), this.width, this.height));
        if (draw) {
            Renderer.drawShape((Shape)area, (boolean)false, (float)0.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
        FormAutoTrashItemList formAutoTrashItemList = this;
        synchronized (formAutoTrashItemList) {
            int elementsPerRow = Math.max(1, this.width / this.elementWidth);
            int startRow = Math.max(0, (int)Math.ceil((float)this.scroll / (float)this.elementHeight));
            int startIndex = startRow * elementsPerRow;
            int endRow = (int)Math.floor((float)(this.scroll + this.height) / (float)this.elementHeight);
            int endIndex = Math.min(this.elements.size(), endRow * elementsPerRow);
            int centerRow = this.width % this.elementWidth / 2;
            for (int i = startIndex; i < endIndex; ++i) {
                AutoTrashItemElement element = (AutoTrashItemElement)((Object)this.elements.get(i));
                int row = i / elementsPerRow;
                int elementY = row * this.elementHeight - this.scroll;
                int elementX = (i - row * elementsPerRow) * this.elementWidth + centerRow;
                ControllerFocus.add(list, (Rectangle)area, (ControllerFocusHandler)element, (Rectangle)new Rectangle(this.elementWidth, this.elementHeight), (int)(currentXOffset + this.getX() + elementX), (int)(currentYOffset + this.getY() + elementY), (int)0, (ControllerNavigationHandler)this.getControllerNavigationHandler(currentXOffset, currentYOffset));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleControllerEvent(ControllerEvent event, TickManager tickManager, PlayerMob perspective) {
        ControllerFocus currentFocus;
        if ((event.isButton && event.buttonState || this.acceptMouseRepeatEvents && event.getState() == ControllerInput.REPEAT_EVENT) && (currentFocus = this.getManager().getCurrentFocus()) != null && currentFocus.handler instanceof FormListElement) {
            FormAutoTrashItemList formAutoTrashItemList = this;
            synchronized (formAutoTrashItemList) {
                int elementsPerRow = Math.max(1, this.width / this.elementWidth);
                int startRow = Math.max(0, (int)Math.ceil((float)this.scroll / (float)this.elementHeight) - 1);
                int startIndex = startRow * elementsPerRow;
                int endRow = (int)Math.floor((float)(this.scroll + this.height) / (float)this.elementHeight) + 1;
                int endIndex = Math.min(this.elements.size(), endRow * elementsPerRow);
                for (int i = startIndex; i < endIndex; ++i) {
                    AutoTrashItemElement element = (AutoTrashItemElement)((Object)this.elements.get(i));
                    if (element != currentFocus.handler) continue;
                    element.onControllerEvent(this, i, event, tickManager, perspective);
                }
            }
        }
    }

    protected ControllerNavigationHandler getControllerNavigationHandler(int currentXOffset, int currentYOffset) {
        return (dir, event, tickManager, perspective) -> {
            LinkedList list = new LinkedList();
            Rectangle area = new Rectangle(currentXOffset + this.getX(), currentYOffset + this.getY() - this.elementHeight, this.width, this.height + this.elementHeight * 2);
            FormAutoTrashItemList formAutoTrashItemList = this;
            synchronized (formAutoTrashItemList) {
                int elementsPerRow = Math.max(1, this.width / this.elementWidth);
                int startRow = Math.max(0, (int)Math.ceil((float)this.scroll / (float)this.elementHeight) - 1);
                int startIndex = startRow * elementsPerRow;
                int endRow = (int)Math.floor((float)(this.scroll + this.height) / (float)this.elementHeight) + 1;
                int endIndex = Math.min(this.elements.size(), endRow * elementsPerRow);
                int centerRow = this.width % this.elementWidth / 2;
                for (int i = startIndex; i < endIndex; ++i) {
                    AutoTrashItemElement element = (AutoTrashItemElement)((Object)((Object)this.elements.get(i)));
                    int row = i / elementsPerRow;
                    int elementY = row * this.elementHeight - this.scroll;
                    int elementX = (i - row * elementsPerRow) * this.elementWidth + centerRow;
                    ControllerFocus.add(list, (Rectangle)area, (ControllerFocusHandler)element, (Rectangle)new Rectangle(this.elementWidth, this.elementHeight), (int)(currentXOffset + this.getX() + elementX), (int)(currentYOffset + this.getY() + elementY), (int)0, (ControllerNavigationHandler)this.getControllerNavigationHandler(currentXOffset, currentYOffset));
                }
                ControllerFocus next = ControllerFocus.getNext((int)dir, (FormManager)this.getManager(), list);
                if (next != null) {
                    int currentScroll = this.scroll;
                    Rectangle box = new Rectangle(next.boundingBox.x - (currentXOffset + this.getX()), next.boundingBox.y - (currentYOffset + this.getY() - this.scroll), next.boundingBox.width, next.boundingBox.height);
                    int scrollPadding = this.elementHeight;
                    int minY = box.y - scrollPadding;
                    int maxY = box.y + box.height + scrollPadding - this.height;
                    this.scroll = Math.max(0, GameMath.limit((int)this.scroll, (int)maxY, (int)minY));
                    this.limitMaxScroll();
                    int deltaScroll = this.scroll - currentScroll;
                    this.getManager().setControllerFocus(new ControllerFocus(next, 0, -deltaScroll));
                    return true;
                }
                return false;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void draw(TickManager tickManager, PlayerMob perspective, Rectangle renderBox) {
        this.handleDrawScroll(tickManager);
        if (this.elements.isEmpty()) {
            this.drawEmptyMessage(tickManager);
        } else {
            FormAutoTrashItemList formAutoTrashItemList = this;
            synchronized (formAutoTrashItemList) {
                int elementsPerRow = Math.max(1, this.width / this.elementWidth);
                int startRow = Math.max(0, this.scroll / this.elementHeight);
                int startIndex = startRow * elementsPerRow;
                int rowsPerSpace = this.height / this.elementHeight + (this.height % this.elementHeight == 0 ? 0 : 1);
                int endIndex = Math.min(this.elements.size(), startIndex + (rowsPerSpace + (this.scroll % this.elementHeight == 0 ? 0 : 1)) * elementsPerRow);
                int centerRow = this.width % this.elementWidth / 2;
                for (int i = startIndex; i < endIndex; ++i) {
                    int row = i / elementsPerRow;
                    int elementY = row * this.elementHeight - this.scroll;
                    int elementX = (i - row * elementsPerRow) * this.elementWidth + centerRow;
                    int drawX = this.getX() + elementX;
                    int drawY = this.getY() + elementY;
                    int minDrawY = Math.max(0, -elementY);
                    int maxDrawY = Math.min(this.elementHeight, this.height - elementY) - minDrawY;
                    int maxDrawX = Math.min(this.elementWidth, this.width - elementX);
                    FormShader.FormShaderState shaderState = GameResources.formShader.startState(new Point(drawX, drawY), new Rectangle(0, minDrawY, maxDrawX, maxDrawY));
                    try {
                        ((AutoTrashItemElement)((Object)this.elements.get(i))).draw(this, tickManager, perspective, i);
                        continue;
                    }
                    finally {
                        shaderState.end();
                    }
                }
            }
        }
    }

    protected synchronized FormGeneralList.MouseOverObject getMouseOverObj(InputEvent event) {
        if (!this.isMouseOverElementSpace(event)) {
            return null;
        }
        int elementsPerRow = Math.max(1, this.width / this.elementWidth);
        int startRow = Math.max(0, this.scroll / this.elementHeight);
        int startIndex = startRow * elementsPerRow;
        int rowsPerSpace = this.height / this.elementHeight + (this.height % this.elementHeight == 0 ? 0 : 1);
        int endIndex = Math.min(this.elements.size(), startIndex + (rowsPerSpace + (this.scroll % this.elementHeight == 0 ? 0 : 1)) * elementsPerRow);
        for (int i = startIndex; i < endIndex; ++i) {
            FormGeneralList.MouseOverObject out = this.getMouseOffset(i, event);
            if (out.xOffset == -1 || out.yOffset == -1) continue;
            return out;
        }
        return null;
    }

    protected FormGeneralList.MouseOverObject getMouseOffset(int index, InputEvent event) {
        int elementsPerRow = Math.max(1, this.width / this.elementWidth);
        int centerRow = this.width % this.elementWidth / 2;
        int row = index / elementsPerRow;
        int elementY = row * this.elementHeight - this.scroll;
        int elementX = (index - row * elementsPerRow) * this.elementWidth + centerRow;
        int drawX = this.getX() + elementX;
        int drawY = this.getY() + elementY;
        return this.getMouseOffset(index, event, drawX, drawY);
    }

    private FormGeneralList.MouseOverObject getMouseOffset(int index, InputEvent event, int drawX, int drawY) {
        int offsetX = event.pos.hudX - drawX;
        int offsetY = event.pos.hudY - drawY;
        if (offsetX < 0 || offsetX >= this.elementWidth) {
            drawX = -1;
        }
        if (offsetY < 0 || offsetY >= this.elementHeight) {
            drawY = -1;
        }
        return new FormGeneralList.MouseOverObject((FormGeneralList)this, index, drawX, drawY);
    }

    public void limitMaxScroll() {
        int elementsPerRow = Math.max(1, this.width / this.elementWidth);
        int lastRow = (this.elements.size() - 1) / elementsPerRow;
        int maxScroll = Math.max(0, lastRow * this.elementHeight - (this.height - this.elementHeight));
        if (this.scroll > maxScroll) {
            this.scroll = maxScroll;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void drawEmptyMessage(TickManager tickManager) {
        GameMessage message = this.getEmptyMessage();
        if (message != null) {
            FormShader.FormShaderState shaderState = GameResources.formShader.startState(null, new Rectangle(0, 0, this.width, this.height));
            try {
                FontOptions options = new FontOptions(this.getEmptyMessageFontOptions()).color(this.getInterfaceStyle().activeTextColor);
                String s = message.translate();
                ArrayList lines = GameUtils.breakString((String)s, (FontOptions)options, (int)(this.width - 20));
                for (int i = 0; i < lines.size(); ++i) {
                    String line = (String)lines.get(i);
                    int lineWidth = FontManager.bit.getWidthCeil(line, options);
                    FontManager.bit.drawString((float)(this.getX() + this.width / 2 - lineWidth / 2), (float)(this.getY() + i * options.getSize() + 4), line, options);
                }
            }
            finally {
                shaderState.end();
            }
        }
    }

    public boolean isMouseOverElementSpace(InputEvent event) {
        return !event.isMoveUsed() && new Rectangle(this.getX(), this.getY(), this.width, this.height).contains(event.pos.hudX, event.pos.hudY);
    }

    public boolean isMouseOverTop(InputEvent event) {
        return false;
    }

    public boolean isMouseOverBot(InputEvent event) {
        return false;
    }

    public class AutoTrashItemElement
    extends FormItemList.ItemElement {
        public AutoTrashItemElement(InventoryItem item) {
            super((FormItemList)FormAutoTrashItemList.this, item);
        }

        protected void draw(FormItemList parent, TickManager tickManager, PlayerMob perspective, int elementIndex) {
            if (this.isMouseOver((FormGeneralGridList)parent)) {
                FormAutoTrashItemList.this.getInterfaceStyle().inventoryslot_small.highlighted.initDraw().color(FormAutoTrashItemList.this.getInterfaceStyle().highlightElementColor).draw(2, 2);
                FormAutoTrashItemList.this.addTooltips(this.item, perspective);
            } else {
                FormAutoTrashItemList.this.getInterfaceStyle().inventoryslot_small.active.initDraw().color(FormAutoTrashItemList.this.getInterfaceStyle().activeElementColor).draw(2, 2);
            }
            this.item.draw(perspective, 2, 2);
        }

        protected void onControllerEvent(FormItemList parent, int elementIndex, ControllerEvent event, TickManager tickManager, PlayerMob perspective) {
            if (event.getState() == ControllerInput.MENU_SELECT) {
                FormAutoTrashItemList.this.onItemClicked(this.item, InputEvent.ControllerButtonEvent((ControllerEvent)event, (TickManager)tickManager));
                event.use();
            }
        }
    }
}

