/*
 * Decompiled with CFR 0.152.
 */
package autotrash.patches;

import autotrash.data.PlayerData;
import autotrash.data.PlayerDataList;
import necesse.engine.modLoader.annotations.ModMethodPatch;
import necesse.engine.network.PacketReader;
import necesse.engine.network.PacketWriter;
import necesse.engine.save.LoadData;
import necesse.engine.save.SaveData;
import necesse.entity.mobs.PlayerMob;
import net.bytebuddy.asm.Advice;

public class PlayerMobPatches {

    @ModMethodPatch(target=PlayerMob.class, name="applySpawnPacket", arguments={PacketReader.class})
    public static class applySpawnPacket {
        @Advice.OnMethodExit
        static void onExit(@Advice.This PlayerMob This2, @Advice.Argument(value=0) PacketReader reader) {
            if (reader.hasNext()) {
                PlayerData playerData = PlayerData.applyPacket(reader);
                PlayerDataList.setPlayerData(playerData.playerUniqueID, playerData);
            }
        }
    }

    @ModMethodPatch(target=PlayerMob.class, name="setupSpawnPacket", arguments={PacketWriter.class})
    public static class setupSpawnPacket {
        @Advice.OnMethodExit
        static void onExit(@Advice.This PlayerMob This2, @Advice.Argument(value=0) PacketWriter writer) {
            PlayerData playerData = PlayerDataList.getPlayerData(This2);
            if (playerData != null) {
                playerData.setupPacket(writer);
            }
        }
    }

    @ModMethodPatch(target=PlayerMob.class, name="addSaveData", arguments={SaveData.class})
    public static class addSaveData {
        @Advice.OnMethodExit
        static void onExit(@Advice.This PlayerMob This2, @Advice.Argument(value=0) SaveData save) {
            PlayerData playerData = PlayerDataList.getPlayerData(This2.getServerClient().getCharacterUniqueID());
            if (playerData != null) {
                playerData.saveData(save);
            }
        }
    }

    @ModMethodPatch(target=PlayerMob.class, name="applyLoadData", arguments={LoadData.class})
    public static class applyLoadData {
        @Advice.OnMethodExit
        static void onExit(@Advice.This PlayerMob This2, @Advice.Argument(value=0) LoadData save) {
            PlayerData playerData = PlayerDataList.initPlayerData(This2.getServerClient().getCharacterUniqueID());
            playerData.loadData(save);
        }
    }
}

