/*
 * Decompiled with CFR 0.152.
 */
package autotrash.patches;

import autotrash.data.PlayerDataList;
import autotrash.ui.AutoTrashContainerSlot;
import necesse.engine.modLoader.annotations.ModMethodPatch;
import necesse.engine.network.client.Client;
import necesse.entity.mobs.PlayerMob;
import necesse.inventory.ItemCombineResult;
import necesse.inventory.container.slots.ContainerSlot;
import necesse.level.maps.Level;
import net.bytebuddy.asm.Advice;

public class ContainerSlotPatches {
    public static int itemIdBefore = -1;

    @ModMethodPatch(target=ContainerSlot.class, name="combineSlots", arguments={Level.class, PlayerMob.class, ContainerSlot.class, int.class, boolean.class, boolean.class, String.class})
    public static class combineSlots {
        @Advice.OnMethodEnter
        static boolean onEnter(@Advice.This ContainerSlot This2, @Advice.Argument(value=2) ContainerSlot slot) {
            if (slot instanceof AutoTrashContainerSlot && This2.getContainer().getClient().isClient()) {
                itemIdBefore = slot.getItem() == null ? -1 : slot.getItem().item.getID();
            }
            return false;
        }

        @Advice.OnMethodExit
        static void onExit(@Advice.This ContainerSlot This2, @Advice.Return ItemCombineResult result) {
            if (itemIdBefore != -1 && result.success) {
                Client client = This2.getContainer().getClient().getClientClient().getClient();
                PlayerDataList.getPlayerData(client).removeItemAndSend(itemIdBefore);
                itemIdBefore = -1;
            }
        }
    }
}

