/*
 * Decompiled with CFR 0.152.
 */
package autotrash.packets;

import autotrash.data.PlayerData;
import autotrash.data.PlayerDataList;
import necesse.engine.network.NetworkPacket;
import necesse.engine.network.Packet;
import necesse.engine.network.PacketReader;
import necesse.engine.network.PacketWriter;
import necesse.engine.network.client.Client;
import necesse.engine.network.server.Server;
import necesse.engine.network.server.ServerClient;

public class AutoTrashLoadPlayerDataPacket
extends Packet {
    public final int slot;
    public final int playerUniqueID;
    public final PlayerData playerData;

    public AutoTrashLoadPlayerDataPacket(byte[] data) {
        super(data);
        PacketReader reader = new PacketReader((Packet)this);
        this.slot = reader.getNextInt();
        this.playerUniqueID = reader.getNextInt();
        this.playerData = reader.hasNext() ? PlayerData.applyPacket(reader) : null;
    }

    public AutoTrashLoadPlayerDataPacket(int slot, int playerUniqueID, PlayerData playerData) {
        this.slot = slot;
        this.playerUniqueID = playerUniqueID;
        this.playerData = playerData;
        PacketWriter writer = new PacketWriter((Packet)this);
        writer.putNextInt(slot);
        writer.putNextInt(playerUniqueID);
        if (playerData != null) {
            playerData.setupPacket(writer);
        }
    }

    public void processClient(NetworkPacket packet, Client client) {
        PlayerDataList.setPlayerData(this.playerUniqueID, this.playerData);
    }

    public void processServer(NetworkPacket packet, Server server, ServerClient client) {
        PlayerData playerData = PlayerDataList.getPlayerData(this.playerUniqueID);
        if (playerData == null) {
            PlayerDataList.initPlayerData(this.playerUniqueID);
        }
    }
}

