/*
 * Decompiled with CFR 0.152.
 */
package autotrash.data;

import autotrash.data.PlayerData;
import java.util.HashMap;
import java.util.Map;
import necesse.engine.network.client.Client;
import necesse.engine.network.server.ServerClient;
import necesse.entity.mobs.PlayerMob;

public class PlayerDataList {
    public static final Map<Integer, PlayerData> playerDataList = new HashMap<Integer, PlayerData>();

    public static PlayerData getPlayerData(PlayerMob player) {
        if (player.isServer()) {
            if (player.getServerClient() != null) {
                return PlayerDataList.getPlayerData(player.getServerClient());
            }
        } else if (player.getClient() != null) {
            return PlayerDataList.getPlayerData(player.getClient());
        }
        return null;
    }

    public static PlayerData getPlayerData(ServerClient serverClient) {
        return PlayerDataList.getPlayerData(serverClient.getCharacterUniqueID());
    }

    public static PlayerData getPlayerData(Client client) {
        return PlayerDataList.getPlayerData(client.getCharacterUniqueID());
    }

    public static PlayerData getPlayerData(int playerUniqueId) {
        return playerDataList.get(playerUniqueId);
    }

    public static void setPlayerData(int playerUniqueId, PlayerData playerData) {
        playerDataList.put(playerUniqueId, playerData);
    }

    public static PlayerData initPlayerData(PlayerMob player) {
        return PlayerDataList.initPlayerData(player.isServer() ? player.getServerClient().getCharacterUniqueID() : player.getClient().getCharacterUniqueID());
    }

    public static PlayerData initPlayerData(int playerUniqueId) {
        PlayerData playerData = new PlayerData(playerUniqueId);
        playerDataList.put(playerUniqueId, playerData);
        return playerData;
    }
}

