/*
 * Decompiled with CFR 0.152.
 */
package autotrash.data;

import autotrash.AutoTrashMod;
import autotrash.packets.AutoTrashClientListAddPacket;
import autotrash.packets.AutoTrashClientListClearPacket;
import autotrash.packets.AutoTrashClientListRemovePacket;
import autotrash.packets.AutoTrashClientSetEnabledPacket;
import java.util.ArrayList;
import java.util.List;
import necesse.engine.network.Packet;
import necesse.engine.network.PacketReader;
import necesse.engine.network.PacketWriter;
import necesse.engine.save.LoadData;
import necesse.engine.save.SaveData;

public class PlayerData {
    private static final String ITEMS_DATA_NAME = "autotrash_items";
    private static final String ENABLED_DATA_NAME = "autotrash_enabled";
    private final List<Integer> items = new ArrayList<Integer>();
    private boolean enabled;
    public final int playerUniqueID;

    public PlayerData(int playerUniqueID) {
        this.playerUniqueID = playerUniqueID;
    }

    public void loadData(LoadData loadData) {
        this.enabled = loadData.getBoolean(ENABLED_DATA_NAME, true, false);
        int[] itemArray = loadData.getIntArray(ITEMS_DATA_NAME, new int[0], false);
        this.items.clear();
        for (int itemId : itemArray) {
            this.items.add(itemId);
        }
    }

    public void saveData(SaveData saveData) {
        saveData.addBoolean(ENABLED_DATA_NAME, this.enabled);
        int[] itemArray = this.items.stream().mapToInt(Integer::intValue).toArray();
        saveData.addIntArray(ITEMS_DATA_NAME, itemArray);
    }

    public boolean getEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setEnabledAndSend(boolean enabled) {
        this.enabled = enabled;
        if (AutoTrashMod.itemListForm != null && AutoTrashMod.itemListForm.itemList.player.getClient().getCharacterUniqueID() == this.playerUniqueID) {
            AutoTrashMod.itemListForm.itemList.player.getClient().network.sendPacket((Packet)new AutoTrashClientSetEnabledPacket(this.playerUniqueID, enabled));
        }
    }

    public List<Integer> getItems() {
        return this.items;
    }

    public void addItem(int itemId) {
        if (!this.items.contains(itemId)) {
            this.items.add(itemId);
            if (AutoTrashMod.itemListForm != null && AutoTrashMod.itemListForm.itemList.player.getClient().getCharacterUniqueID() == this.playerUniqueID) {
                AutoTrashMod.itemListForm.itemList.addItemId(itemId, true);
            }
        }
    }

    public void addItemAndSend(int itemId) {
        if (!this.items.contains(itemId)) {
            this.items.add(itemId);
            if (AutoTrashMod.itemListForm != null && AutoTrashMod.itemListForm.itemList.player.getClient().getCharacterUniqueID() == this.playerUniqueID) {
                AutoTrashMod.itemListForm.itemList.addItemId(itemId, true);
                AutoTrashMod.itemListForm.itemList.player.getClient().network.sendPacket((Packet)new AutoTrashClientListAddPacket(this.playerUniqueID, itemId));
            }
        }
    }

    public void removeItem(int itemId) {
        this.items.remove((Object)itemId);
        if (AutoTrashMod.itemListForm != null && AutoTrashMod.itemListForm.itemList.player.getClient().getCharacterUniqueID() == this.playerUniqueID) {
            AutoTrashMod.itemListForm.itemList.removeItemId(itemId);
        }
    }

    public void removeItemAndSend(int itemId) {
        this.items.remove((Object)itemId);
        if (AutoTrashMod.itemListForm != null && AutoTrashMod.itemListForm.itemList.player.getClient().getCharacterUniqueID() == this.playerUniqueID) {
            AutoTrashMod.itemListForm.itemList.removeItemId(itemId);
            AutoTrashMod.itemListForm.itemList.player.getClient().network.sendPacket((Packet)new AutoTrashClientListRemovePacket(this.playerUniqueID, itemId));
        }
    }

    public void clearItems() {
        this.items.clear();
        if (AutoTrashMod.itemListForm != null && AutoTrashMod.itemListForm.itemList.player.getClient().getCharacterUniqueID() == this.playerUniqueID) {
            AutoTrashMod.itemListForm.itemList.clearItems();
        }
    }

    public void clearItemsAndSend() {
        this.items.clear();
        if (AutoTrashMod.itemListForm != null && AutoTrashMod.itemListForm.itemList.player.getClient().getCharacterUniqueID() == this.playerUniqueID) {
            AutoTrashMod.itemListForm.itemList.clearItems();
            AutoTrashMod.itemListForm.itemList.player.getClient().network.sendPacket((Packet)new AutoTrashClientListClearPacket(this.playerUniqueID));
        }
    }

    public boolean containsItem(int itemId) {
        return this.items.contains(itemId);
    }

    public void setupPacket(PacketWriter writer) {
        writer.putNextInt(this.playerUniqueID);
        writer.putNextBoolean(this.enabled);
        writer.putNextInt(this.items.size());
        writer.putNextInts(this.items.stream().mapToInt(Integer::intValue).toArray());
    }

    public static PlayerData applyPacket(PacketReader reader) {
        PlayerData playerData = new PlayerData(reader.getNextInt());
        playerData.enabled = reader.getNextBoolean();
        int[] itemArray = reader.getNextInts(reader.getNextInt());
        playerData.items.clear();
        for (int itemId : itemArray) {
            playerData.items.add(itemId);
        }
        return playerData;
    }
}

