/*
 * Decompiled with CFR 0.152.
 */
package aeyos.wims.forms;

import aeyos.wims.ModMain;
import aeyos.wims.SearchEngine;
import necesse.engine.gameLoop.tickManager.TickManager;
import necesse.engine.input.InputEvent;
import necesse.engine.localization.message.GameMessage;
import necesse.engine.localization.message.LocalMessage;
import necesse.engine.registries.ItemRegistry;
import necesse.engine.state.MainGame;
import necesse.engine.window.GameWindow;
import necesse.entity.mobs.PlayerMob;
import necesse.gfx.forms.Form;
import necesse.gfx.forms.MainGameFormManager;
import necesse.gfx.forms.components.FormButton;
import necesse.gfx.forms.components.FormComponent;
import necesse.gfx.forms.components.FormFlow;
import necesse.gfx.forms.components.FormInputSize;
import necesse.gfx.forms.components.FormTextInput;
import necesse.gfx.forms.components.localComponents.FormLocalLabel;
import necesse.gfx.forms.components.localComponents.FormLocalTextButton;
import necesse.gfx.forms.events.FormEventListener;
import necesse.gfx.forms.events.FormInputEvent;
import necesse.gfx.forms.position.FormFixedPosition;
import necesse.gfx.forms.position.FormPosition;
import necesse.gfx.forms.position.FormPositionContainer;
import necesse.gfx.gameFont.FontOptions;
import necesse.inventory.item.Item;

public class SearchForm
extends Form {
    private static SearchForm instance;
    private FormTextInput textInput;
    private FormLocalTextButton submitButton;
    private FormLocalTextButton cancelButton;
    private MainGame mainGame;
    private static final int FORM_PADDING = 5;
    private static final int FORM_FONT_SIZE = 20;
    private static final int FORM_TEXT_MAX_LENGTH = 50;
    private static final int FORM_BUTTON_WIDTH = 100;
    private FormEventListener<FormInputEvent<FormTextInput>> handleSubmit = e -> this.onSubmit();
    private FormEventListener<FormInputEvent<FormButton>> handleClickSubmit = e -> this.onSubmit();
    private FormEventListener<FormInputEvent<FormButton>> handleCancel = e -> this.onCancel();

    public static void frameTick(MainGame mainGame, TickManager tickManager, GameWindow gameWindow) {
        if (mainGame.getClient() == null || mainGame.getClient().getPlayer() == null) {
            return;
        }
        if (!mainGame.formManager.pauseMenu.isHidden()) {
            if (instance != null) {
                instance.onCancel();
            }
            return;
        }
        if (ModMain.wimsOpenSearchControl.isPressed() && instance == null) {
            MainGameFormManager formManager = mainGame.formManager;
            instance = new SearchForm(mainGame);
            formManager.addComponent((FormComponent)instance);
        }
    }

    public void init() {
        super.init();
        this.textInput.setTyping(true);
        this.positionAboveInventory();
    }

    public void handleInputEvent(InputEvent event, TickManager tickManager, PlayerMob perspective) {
        if (event.state && event.getID() == 256) {
            this.onCancel();
            event.use();
            return;
        }
        super.handleInputEvent(event, tickManager, perspective);
    }

    public void onWindowResized(GameWindow window) {
        super.onWindowResized(window);
        this.resizeX();
        this.positionAboveInventory();
    }

    public SearchForm(MainGame mainGame) {
        super("mySimpleTextForm", 400, 120);
        this.mainGame = mainGame;
        this.resizeX();
        int formHeight = this.addFormElements();
        this.setHeight(formHeight);
        this.positionAboveInventory();
    }

    private int addFormElements() {
        int midPoint = this.getWidth() / 2;
        FormFlow flow = new FormFlow(5);
        FormLocalLabel label = (FormLocalLabel)this.addComponent((FormComponent)new FormLocalLabel((GameMessage)new LocalMessage("ui", "itemsearchtip"), new FontOptions(20), 0, midPoint, 5));
        flow.nextY((FormPositionContainer)label, 5);
        this.textInput = (FormTextInput)this.addComponent((FormComponent)new FormTextInput(5, 0, FormInputSize.SIZE_32, this.getWidth() - 10, 50));
        flow.nextY((FormPositionContainer)this.textInput, 5);
        this.submitButton = (FormLocalTextButton)this.addComponent((FormComponent)new FormLocalTextButton((GameMessage)new LocalMessage("ui", "searchtip"), this.getWidth() - 100 - 5, flow.next(), 100));
        this.cancelButton = (FormLocalTextButton)this.addComponent((FormComponent)new FormLocalTextButton((GameMessage)new LocalMessage("ui", "cancelbutton"), 5, flow.next(), 100));
        flow.nextY((FormPositionContainer)this.cancelButton, 5);
        this.submitButton.onClicked(this.handleClickSubmit);
        this.cancelButton.onClicked(this.handleCancel);
        this.textInput.onSubmit(this.handleSubmit);
        return flow.next() + 5;
    }

    private void resizeX() {
        MainGameFormManager formManager = this.mainGame.formManager;
        if (formManager != null) {
            int width = formManager.inventory.getWidth();
            this.setWidth(width);
        }
    }

    private void positionAboveInventory() {
        MainGameFormManager formManager = this.mainGame.formManager;
        if (formManager != null) {
            int x = formManager.inventory.getX();
            int y = formManager.inventory.getY() - this.getHeight() - 10;
            this.setPosition((FormPosition)new FormFixedPosition(x, y));
        }
    }

    protected void onSubmit() {
        String text = this.getText();
        if (text.isEmpty()) {
            return;
        }
        Item item = ItemRegistry.getItem((String)text);
        if (item != null) {
            SearchEngine.searchItemByDefinition(this.mainGame.getClient(), item, 16);
        } else {
            SearchEngine.searchItemByName(this.mainGame.getClient(), text, 16);
        }
        this.onCancel();
    }

    protected void onCancel() {
        instance = null;
        this.mainGame.formManager.removeComponent((FormComponent)this);
        this.dispose();
    }

    public String getText() {
        return this.textInput.getText();
    }
}

