/*
 * Decompiled with CFR 0.152.
 */
package aeyos.wims;

import aeyos.wims.ItemMatcher;
import aeyos.wims.ParticleSpawner;
import java.util.List;
import java.util.stream.Collectors;
import necesse.engine.network.client.Client;
import necesse.entity.DrawOnMapEntity;
import necesse.entity.manager.TileEntityList;
import necesse.entity.mobs.PlayerMob;
import necesse.entity.objectEntity.InventoryObjectEntity;
import necesse.entity.objectEntity.ObjectEntity;
import necesse.inventory.Inventory;
import necesse.inventory.InventoryItem;
import necesse.inventory.InventorySlot;
import necesse.inventory.item.Item;
import necesse.level.maps.Level;

public class SearchEngine {
    public static void queryItem(Client client, ItemMatcher itemMatcher, int radius) {
        PlayerMob player = client.getPlayer();
        int originX = player.getTileX();
        int originY = player.getTileY();
        Level level = client.getLevel();
        boolean found = false;
        System.out.println("Searching for items in radius " + radius);
        TileEntityList objectEntities = level.entityManager.objectEntities;
        for (ObjectEntity objectEntity : objectEntities) {
            if (objectEntity == null || objectEntity.tileX < originX - radius || objectEntity.tileX > originX + radius || objectEntity.tileY < originY - radius || objectEntity.tileY > originY + radius) continue;
            System.out.println("Object entity: " + objectEntity.tileX + ", " + objectEntity.tileY);
            if (!(objectEntity instanceof InventoryObjectEntity)) continue;
            InventoryObjectEntity inventoryObjectEntity = (InventoryObjectEntity)objectEntity;
            System.out.println("Inventory object entity: " + objectEntity.tileX + ", " + objectEntity.tileY);
            Inventory inventory = inventoryObjectEntity.getInventory();
            List slots = inventory.streamSlots().collect(Collectors.toList());
            System.out.println("Slots: " + slots.size());
            for (InventorySlot slot : slots) {
                InventoryItem inventoryItem = slot.isSlotClear() ? null : slot.getItem();
                System.out.println("Inventory item: " + inventoryItem);
                if (inventoryItem == null || !itemMatcher.matches(inventoryItem)) continue;
                ParticleSpawner.success((DrawOnMapEntity)inventoryObjectEntity);
                found = true;
            }
        }
        if (!found) {
            ParticleSpawner.fail(player);
        }
    }

    public static void searchItemByDefinition(Client client, Item item, int radius) {
        SearchEngine.queryItem(client, inventoryItem -> inventoryItem.item.equals(item), radius);
    }

    public static void searchItemByName(Client client, String name, int radius) {
        SearchEngine.queryItem(client, inventoryItem -> inventoryItem.getItemDisplayName().toLowerCase().contains(name.toLowerCase()), radius);
    }
}

