/*
 * Decompiled with CFR 0.152.
 */
package extratooltips;

import extratooltips.Settings;
import necesse.engine.modLoader.LoadedMod;
import necesse.engine.modLoader.annotations.ModMethodPatch;
import necesse.engine.registries.ItemRegistry;
import necesse.engine.util.GameBlackboard;
import necesse.engine.util.GameUtils;
import necesse.entity.mobs.PlayerMob;
import necesse.gfx.gameTooltips.GameTooltips;
import necesse.gfx.gameTooltips.ListGameTooltips;
import necesse.inventory.InventoryItem;
import necesse.inventory.item.Item;
import necesse.inventory.item.ItemCategory;
import net.bytebuddy.asm.Advice;
import net.bytebuddy.implementation.bytecode.assign.Assigner;

@ModMethodPatch(target=Item.class, name="getTooltips", arguments={InventoryItem.class, PlayerMob.class, GameBlackboard.class})
public class ItemGetTooltipsMethodPatch {
    @Advice.OnMethodExit
    static void onExit(@Advice.This Item self, @Advice.Argument(value=0) InventoryItem item, @Advice.Return(readOnly=false, typing=Assigner.Typing.DYNAMIC) ListGameTooltips originalValue) {
        try {
            LoadedMod mod;
            if (!Settings.enabled) {
                return;
            }
            ListGameTooltips gameTooltips = new ListGameTooltips((GameTooltips)originalValue);
            if (Settings.showCategory) {
                gameTooltips.add("\u00a73Category: " + GameUtils.join((Object[])ItemCategory.masterManager.getItemsCategory(self).getStringIDTree(false), (String)", "));
            }
            if (Settings.showValue) {
                gameTooltips.add("\u00a7#26d2e1Value: " + (float)Math.round(item.getBrokerValue() * 10.0f) / 10.0f);
            }
            if (Settings.showMod && (mod = ItemRegistry.getItemMod((int)self.getID())) != null) {
                gameTooltips.add("\u00a7bMod: " + mod.name);
            }
            originalValue = gameTooltips;
        }
        catch (Exception e) {
            System.err.println("[Extra Tooltips] Error while loading extra tooltips");
        }
    }
}

