/*
 * Decompiled with CFR 0.152.
 */
package extratooltips;

import extratooltips.Settings;
import necesse.engine.commands.CmdParameter;
import necesse.engine.commands.CommandLog;
import necesse.engine.commands.ModularChatCommand;
import necesse.engine.commands.PermissionLevel;
import necesse.engine.commands.parameterHandlers.BoolParameterHandler;
import necesse.engine.commands.parameterHandlers.ParameterHandler;
import necesse.engine.commands.parameterHandlers.StringParameterHandler;
import necesse.engine.network.client.Client;
import necesse.engine.network.server.Server;
import necesse.engine.network.server.ServerClient;

public class ExtraTooltipsCommand
extends ModularChatCommand {
    private static final String[] options = new String[]{"list", "enabled", "showCategory", "showValue", "showMod"};
    private final String list = "\u00a73Current settings:\nMod: " + (Settings.enabled ? "enabled" : "disabled") + "\nCategory: " + (Settings.showCategory ? "shown" : "hidden") + "\nValue: " + (Settings.showValue ? "shown" : "hidden") + "\nMod: " + (Settings.showMod ? "shown" : "hidden");

    public ExtraTooltipsCommand() {
        super("extraTooltips", "command for configuring the Extra tooltips mod", PermissionLevel.USER, false, new CmdParameter[]{new CmdParameter("operation", (ParameterHandler)new StringParameterHandler(options[0], options), false, new CmdParameter[0]), new CmdParameter("enabled", (ParameterHandler)new BoolParameterHandler(Boolean.valueOf(true)), true, new CmdParameter[0])});
    }

    public void runModular(Client client, Server server, ServerClient serverClient, Object[] args, String[] errors, CommandLog commandLog) {
        try {
            String operation = (String)args[0];
            boolean enabled = (Boolean)args[1];
            switch (operation) {
                case "list": {
                    commandLog.add(this.list);
                    break;
                }
                case "enabled": {
                    Settings.enabled = enabled;
                    commandLog.add("\u00a73[Extra tooltips] The mod is now " + (enabled ? "enabled" : "disabled"));
                    break;
                }
                case "showCategory": {
                    Settings.showCategory = enabled;
                    commandLog.add("\u00a73[Extra tooltips] Category tooltips is now " + (enabled ? "shown" : "hidden"));
                    break;
                }
                case "showValue": {
                    Settings.showValue = enabled;
                    commandLog.add("\u00a73[Extra tooltips] Value tooltip is now " + (enabled ? "shown" : "hidden"));
                    break;
                }
                case "showMod": {
                    Settings.showMod = enabled;
                    commandLog.add("\u00a73[Extra tooltips] Mod tooltip is now " + (enabled ? "shown" : "hidden"));
                }
            }
        }
        catch (Exception e) {
            System.err.println("[Extra tooltips] An error has occurred while running the extraTooltips command.\nError:\n" + e);
        }
    }
}

