/*
 * Decompiled with CFR 0.152.
 */
package rpgmodadmintools.commands;

import java.lang.reflect.Method;
import necesse.engine.commands.CmdParameter;
import necesse.engine.commands.CommandLog;
import necesse.engine.commands.ModularChatCommand;
import necesse.engine.commands.PermissionLevel;
import necesse.engine.commands.parameterHandlers.IntParameterHandler;
import necesse.engine.commands.parameterHandlers.ParameterHandler;
import necesse.engine.commands.parameterHandlers.PresetStringParameterHandler;
import necesse.engine.commands.parameterHandlers.ServerClientParameterHandler;
import necesse.engine.network.client.Client;
import necesse.engine.network.server.Server;
import necesse.engine.network.server.ServerClient;
import necesse.entity.mobs.PlayerMob;

public class RPGSetPointCN
extends ModularChatCommand {
    public RPGSetPointCN() {
        super("RPG\u8bbe\u7f6e\u70b9\u6570", "\u4e3a\u73a9\u5bb6\u8bbe\u7f6e\u6280\u80fd\u70b9", PermissionLevel.ADMIN, true, new CmdParameter[]{new CmdParameter("player", (ParameterHandler)new ServerClientParameterHandler(true, false), true, new CmdParameter[0]), new CmdParameter("pointType", (ParameterHandler)new PresetStringParameterHandler(new String[]{"attribute", "\u5c5e\u6027\u70b9", "reset", "\u91cd\u7f6e\u70b9", "mastery", "\u7cbe\u901a\u70b9", "class", "\u804c\u4e1a\u70b9"}), false, new CmdParameter[0]), new CmdParameter("amount", (ParameterHandler)new IntParameterHandler(), false, new CmdParameter[0])});
    }

    public void runModular(Client client, Server server, ServerClient serverClient, Object[] args, String[] errors, CommandLog commandLog) {
        if (!this.isRPGModLoaded()) {
            commandLog.add("\u9519\u8bef: RPG\u6a21\u7ec4\u672a\u52a0\u8f7d\uff0c\u65e0\u6cd5\u6267\u884c\u547d\u4ee4\u3002\u8bf7\u786e\u4fddRPG\u6a21\u7ec4\u5df2\u6b63\u786e\u5b89\u88c5\u5e76\u542f\u7528\u3002");
            return;
        }
        ServerClient target = (ServerClient)args[0];
        if (target == null) {
            if (serverClient == null) {
                commandLog.add("\u9519\u8bef: \u672a\u6307\u5b9a\u73a9\u5bb6\u4e14\u65e0\u5ba2\u6237\u7aef\u4e0a\u4e0b\u6587\u53ef\u7528\u3002");
                return;
            }
            target = serverClient;
        }
        String pointType = (String)args[1];
        int amount = (Integer)args[2];
        PlayerMob player = target.playerMob;
        try {
            Class<?> playerDataListClass = Class.forName("rpgclasses.data.PlayerDataList");
            Class<?> playerDataClass = Class.forName("rpgclasses.data.PlayerData");
            Method getPlayerDataMethod = playerDataListClass.getMethod("getPlayerData", PlayerMob.class);
            Object playerData = getPlayerDataMethod.invoke(null, player);
            if (playerData == null) {
                commandLog.add("\u9519\u8bef: \u65e0\u6cd5\u83b7\u53d6\u73a9\u5bb6\u6570\u636e\uff0c\u8bf7\u786e\u4fddRPG\u6a21\u7ec4\u5df2\u52a0\u8f7d");
                return;
            }
            String resultMessage = "";
            switch (pointType) {
                case "attribute": 
                case "\u5c5e\u6027\u70b9": {
                    Method getLevelMethod = playerDataClass.getMethod("getLevel", new Class[0]);
                    Method getExpMethod = playerDataClass.getMethod("getExp", new Class[0]);
                    Method getExpRequiredForLevelMethod = playerDataClass.getMethod("getExpRequiredForLevel", Integer.TYPE);
                    Method modExpSendPacketMethod = playerDataClass.getMethod("modExpSendPacket", ServerClient.class, Integer.TYPE);
                    int currentLevel = (Integer)getLevelMethod.invoke(playerData, new Object[0]);
                    int currentExp = (Integer)getExpMethod.invoke(playerData, new Object[0]);
                    int expNeeded = (Integer)getExpRequiredForLevelMethod.invoke(playerData, currentLevel + amount) - currentExp;
                    modExpSendPacketMethod.invoke(playerData, target, expNeeded);
                    resultMessage = String.format("%s \u7684\u7b49\u7ea7\u589e\u52a0\u4e86 %d \u7ea7\uff0c\u4ece\u800c\u589e\u52a0\u4e86\u5c5e\u6027\u70b9", player.getDisplayName(), amount);
                    break;
                }
                case "reset": 
                case "\u91cd\u7f6e\u70b9": {
                    Method modResetsSendPacketMethod = playerDataClass.getMethod("modResetsSendPacket", ServerClient.class, Integer.TYPE);
                    modResetsSendPacketMethod.invoke(playerData, target, amount);
                    resultMessage = String.format("%s \u7684\u91cd\u7f6e\u70b9\u589e\u52a0\u4e86 %d \u70b9", player.getDisplayName(), amount);
                    break;
                }
                case "mastery": 
                case "\u7cbe\u901a\u70b9": {
                    Method getLevelMethod2 = playerDataClass.getMethod("getLevel", new Class[0]);
                    Method getExpMethod2 = playerDataClass.getMethod("getExp", new Class[0]);
                    Method getExpRequiredForLevelMethod2 = playerDataClass.getMethod("getExpRequiredForLevel", Integer.TYPE);
                    Method modExpSendPacketMethod2 = playerDataClass.getMethod("modExpSendPacket", ServerClient.class, Integer.TYPE);
                    int currentLevel2 = (Integer)getLevelMethod2.invoke(playerData, new Object[0]);
                    int currentExp2 = (Integer)getExpMethod2.invoke(playerData, new Object[0]);
                    int expNeeded2 = (Integer)getExpRequiredForLevelMethod2.invoke(playerData, currentLevel2 + amount * 20) - currentExp2;
                    modExpSendPacketMethod2.invoke(playerData, target, expNeeded2);
                    resultMessage = String.format("%s \u7684\u7b49\u7ea7\u589e\u52a0\u4e86 %d \u7ea7\uff0c\u4ece\u800c\u589e\u52a0\u4e86\u7cbe\u901a\u70b9", player.getDisplayName(), amount * 20);
                    break;
                }
                case "class": 
                case "\u804c\u4e1a\u70b9": {
                    Method getLevelMethod3 = playerDataClass.getMethod("getLevel", new Class[0]);
                    Method getExpMethod3 = playerDataClass.getMethod("getExp", new Class[0]);
                    Method getExpRequiredForLevelMethod3 = playerDataClass.getMethod("getExpRequiredForLevel", Integer.TYPE);
                    Method modExpSendPacketMethod3 = playerDataClass.getMethod("modExpSendPacket", ServerClient.class, Integer.TYPE);
                    int currentLevel3 = (Integer)getLevelMethod3.invoke(playerData, new Object[0]);
                    int currentExp3 = (Integer)getExpMethod3.invoke(playerData, new Object[0]);
                    int expNeeded3 = (Integer)getExpRequiredForLevelMethod3.invoke(playerData, currentLevel3 + amount) - currentExp3;
                    modExpSendPacketMethod3.invoke(playerData, target, expNeeded3);
                    resultMessage = String.format("%s \u7684\u7b49\u7ea7\u589e\u52a0\u4e86 %d \u7ea7\uff0c\u4ece\u800c\u589e\u52a0\u4e86\u804c\u4e1a\u70b9", player.getDisplayName(), amount);
                    break;
                }
                default: {
                    commandLog.add("\u9519\u8bef: \u65e0\u6548\u7684\u6280\u80fd\u70b9\u7c7b\u578b\u3002\u53ef\u7528\u7c7b\u578b: attribute/\u5c5e\u6027\u70b9, reset/\u91cd\u7f6e\u70b9, mastery/\u7cbe\u901a\u70b9, class/\u804c\u4e1a\u70b9");
                    return;
                }
            }
            commandLog.add(resultMessage);
        }
        catch (ClassNotFoundException e) {
            commandLog.add("\u9519\u8bef: RPG\u6a21\u7ec4\u672a\u52a0\u8f7d\uff0c\u65e0\u6cd5\u6267\u884c\u547d\u4ee4");
        }
        catch (Exception e) {
            commandLog.add("\u9519\u8bef: \u6267\u884c\u547d\u4ee4\u65f6\u53d1\u751f\u5f02\u5e38: " + e.getMessage());
            e.printStackTrace();
        }
    }

    private boolean isRPGModLoaded() {
        try {
            Class.forName("rpgclasses.data.PlayerDataList");
            Class.forName("rpgclasses.data.PlayerData");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }
}

