/*
 * Decompiled with CFR 0.152.
 */
package com.tia.autominer.ObjectsScripts;

import com.tia.autominer.AutoMinerCraftingStationObject;
import com.tia.autominer.ObjectEntities.AutoMinerBasaltObjectEntity;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import necesse.engine.gameLoop.tickManager.TickManager;
import necesse.engine.localization.Localization;
import necesse.engine.network.server.ServerClient;
import necesse.engine.registries.ContainerRegistry;
import necesse.engine.util.GameRandom;
import necesse.entity.mobs.PlayerMob;
import necesse.entity.objectEntity.FueledInventoryObjectEntity;
import necesse.entity.objectEntity.ObjectEntity;
import necesse.entity.particle.Particle;
import necesse.gfx.camera.GameCamera;
import necesse.gfx.drawOptions.texture.TextureDrawOptionsEnd;
import necesse.gfx.drawables.LevelSortedDrawable;
import necesse.gfx.drawables.OrderableDrawables;
import necesse.gfx.gameTexture.GameTexture;
import necesse.inventory.Inventory;
import necesse.inventory.InventoryItem;
import necesse.inventory.InventoryRange;
import necesse.inventory.container.object.CraftingStationContainer;
import necesse.inventory.item.toolItem.ToolType;
import necesse.inventory.itemFilter.ItemCategoriesFilter;
import necesse.inventory.recipe.Recipe;
import necesse.inventory.recipe.Recipes;
import necesse.inventory.recipe.Tech;
import necesse.level.gameObject.GameObject;
import necesse.level.gameObject.ObjectHoverHitbox;
import necesse.level.maps.Level;
import necesse.level.maps.levelData.settlementData.SettlementWorkstationObject;
import necesse.level.maps.light.GameLight;

public class AutoMinerBasalt
extends AutoMinerCraftingStationObject
implements SettlementWorkstationObject {
    public GameTexture texture;

    public AutoMinerBasalt() {
        super(new Rectangle(32, 32));
        this.toolType = ToolType.PICKAXE;
        this.isLightTransparent = false;
    }

    public void loadTextures() {
        super.loadTextures();
        this.texture = GameTexture.fromFile((String)"objects/autominerbasalt");
    }

    public Rectangle getCollision(Level level, int x, int y, int rotation) {
        if (rotation % 2 == 0) {
            return new Rectangle(x * 32 + 2, y * 32 + 6, 28, 20);
        }
        return new Rectangle(x * 32 + 6, y * 32 + 2, 20, 28);
    }

    public List<ObjectHoverHitbox> getHoverHitboxes(Level level, int layerID, int tileX, int tileY) {
        List list = super.getHoverHitboxes(level, layerID, tileX, tileY);
        list.add(this.getHoverHitbox(level, layerID, tileX, tileY));
        return list;
    }

    public void addDrawables(List<LevelSortedDrawable> list, OrderableDrawables tileList, Level level, int tileX, int tileY, TickManager tickManager, GameCamera camera, PlayerMob perspective) {
        GameLight light = level.getLightLevel(tileX, tileY);
        int drawX = camera.getTileDrawX(tileX);
        int drawY = camera.getTileDrawY(tileY);
        final TextureDrawOptionsEnd options = this.texture.initDraw().light(light).pos(drawX, drawY - this.texture.getHeight() + 32);
        list.add(new LevelSortedDrawable((GameObject)this, tileX, tileY){

            public int getSortY() {
                return 16;
            }

            public void draw(TickManager tickManager) {
                options.draw();
            }
        });
    }

    public void tickEffect(Level level, int layerID, int x, int y) {
        ObjectEntity objectEntity;
        super.tickEffect(level, layerID, x, y);
        if (GameRandom.globalRandom.nextInt(10) == 0 && (objectEntity = level.entityManager.getObjectEntity(x, y)) instanceof FueledInventoryObjectEntity && ((FueledInventoryObjectEntity)objectEntity).isFueled()) {
            int startHeight = 16 + GameRandom.globalRandom.nextInt(16);
            level.entityManager.addParticle((float)(x * 32 + GameRandom.globalRandom.getIntBetween(8, 24)), (float)(y * 32 + 32), Particle.GType.COSMETIC).smokeColor().heightMoves((float)startHeight, (float)(startHeight + 20)).lifeTime(1000);
        }
    }

    public void drawPreview(Level level, int tileX, int tileY, int rotation, float alpha, PlayerMob player, GameCamera camera) {
        int drawX = camera.getTileDrawX(tileX);
        int drawY = camera.getTileDrawY(tileY);
        this.texture.initDraw().alpha(alpha).draw(drawX, drawY - this.texture.getHeight() + 32);
    }

    @Override
    public ObjectEntity getNewObjectEntity(Level level, int x, int y) {
        return new AutoMinerBasaltObjectEntity(level, x, y);
    }

    public String getInteractTip(Level level, int x, int y, PlayerMob perspective, boolean debug) {
        return Localization.translate((String)"controls", (String)"opentip");
    }

    public boolean canInteract(Level level, int x, int y, PlayerMob player) {
        return true;
    }

    @Override
    public void interact(Level level, int x, int y, PlayerMob player) {
        if (level.isServer()) {
            CraftingStationContainer.openAndSendContainer((int)ContainerRegistry.FUELED_PROCESSING_STATION_CONTAINER, (ServerClient)player.getServerClient(), (Level)level, (int)x, (int)y);
        }
    }

    public AutoMinerBasaltObjectEntity getBasaltObjectEntity(Level level, int tileX, int tileY) {
        ObjectEntity objectEntity = level.entityManager.getObjectEntity(tileX, tileY);
        if (objectEntity instanceof AutoMinerBasaltObjectEntity) {
            return (AutoMinerBasaltObjectEntity)objectEntity;
        }
        return null;
    }

    public Stream<Recipe> streamSettlementRecipes(Level level, int tileX, int tileY) {
        AutoMinerBasaltObjectEntity basaltObjectEntity = this.getBasaltObjectEntity(level, tileX, tileY);
        if (basaltObjectEntity != null) {
            return Recipes.streamRecipes((Tech[])basaltObjectEntity.techs);
        }
        return Stream.empty();
    }

    public boolean isProcessingInventory(Level level, int tileX, int tileY) {
        return true;
    }

    @Override
    public boolean canCurrentlyCraft(Level level, int tileX, int tileY, Recipe recipe) {
        AutoMinerBasaltObjectEntity basaltObjectEntity = this.getBasaltObjectEntity(level, tileX, tileY);
        if (basaltObjectEntity != null) {
            return basaltObjectEntity.getExpectedResults().crafts < 10 && (basaltObjectEntity.isFuelRunning() || basaltObjectEntity.canUseFuel());
        }
        return false;
    }

    public int getMaxCraftsAtOnce(Level level, int tileX, int tileY, Recipe recipe) {
        return 5;
    }

    public InventoryRange getProcessingInputRange(Level level, int tileX, int tileY) {
        AutoMinerBasaltObjectEntity basaltObjectEntity = this.getBasaltObjectEntity(level, tileX, tileY);
        if (basaltObjectEntity != null) {
            return basaltObjectEntity.getInputInventoryRange();
        }
        return null;
    }

    public InventoryRange getProcessingOutputRange(Level level, int tileX, int tileY) {
        AutoMinerBasaltObjectEntity basaltObjectEntity = this.getBasaltObjectEntity(level, tileX, tileY);
        if (basaltObjectEntity != null) {
            return basaltObjectEntity.getOutputInventoryRange();
        }
        return null;
    }

    public ArrayList<InventoryItem> getCurrentAndFutureProcessingOutputs(Level level, int tileX, int tileY) {
        AutoMinerBasaltObjectEntity basaltObjectEntity = this.getBasaltObjectEntity(level, tileX, tileY);
        if (basaltObjectEntity != null) {
            return basaltObjectEntity.getCurrentAndExpectedResults().items;
        }
        return new ArrayList<InventoryItem>();
    }

    public ItemCategoriesFilter getDefaultFuelFilters(Level level, int tileX, int tileY) {
        return new ItemCategoriesFilter(5, 75, true);
    }

    @Override
    public InventoryRange getFuelInventoryRange(Level level, int tileX, int tileY) {
        Inventory inventory;
        AutoMinerBasaltObjectEntity basaltObjectEntity = this.getBasaltObjectEntity(level, tileX, tileY);
        if (basaltObjectEntity != null && (inventory = basaltObjectEntity.getInventory()) != null && basaltObjectEntity.fuelSlots > 0) {
            return new InventoryRange(inventory, 0, basaltObjectEntity.fuelSlots - 1);
        }
        return null;
    }
}

