/*
 * Decompiled with CFR 0.152.
 */
package gunsmith.scripts;

import gunsmith.items.tools.ModularGun;
import java.awt.geom.Point2D;
import necesse.engine.network.Packet;
import necesse.engine.network.gameNetworkData.GNDItemMap;
import necesse.engine.network.packet.PacketFireDeathRipper;
import necesse.engine.sound.PrimitiveSoundEmitter;
import necesse.engine.sound.SoundEffect;
import necesse.engine.sound.SoundManager;
import necesse.engine.sound.gameSound.GameSound;
import necesse.engine.util.GameMath;
import necesse.engine.util.GameRandom;
import necesse.entity.mobs.Mob;
import necesse.entity.mobs.ai.behaviourTree.leaves.ChaserAINode;
import necesse.entity.mobs.attackHandler.MouseAngleAttackHandler;
import necesse.entity.mobs.itemAttacker.ItemAttackSlot;
import necesse.entity.mobs.itemAttacker.ItemAttackerMob;
import necesse.gfx.GameResources;
import necesse.inventory.InventoryItem;
import necesse.inventory.item.Item;
import necesse.level.maps.regionSystem.RegionPositionGetter;

public class RipperAttackHandler
extends MouseAngleAttackHandler {
    private final InventoryItem item;
    private final ModularGun toolItem;
    private long lastTime;
    private long timeBuffer;
    private final int attackSeed;
    private int shots;
    private final GameRandom random = new GameRandom();

    public RipperAttackHandler(ItemAttackerMob attackerMob, ItemAttackSlot slot, InventoryItem item, ModularGun toolItem, int seed, int startTargetX, int startTargetY) {
        super(attackerMob, slot, 50, 1000.0f, startTargetX, startTargetY);
        this.item = item;
        this.toolItem = toolItem;
        this.attackSeed = seed;
        this.lastTime = attackerMob.getLocalTime();
    }

    public void onUpdate() {
        super.onUpdate();
        if (!this.attackerMob.isPlayer && this.lastItemAttackerTarget != null && !ChaserAINode.hasLineOfSightToTarget((Mob)this.attackerMob, (Mob)this.lastItemAttackerTarget, (float)5.0f)) {
            this.attackerMob.endAttackHandler(true);
        } else {
            Point2D.Float dir = GameMath.getAngleDir((float)this.currentAngle);
            int attackX = this.attackerMob.getX() + (int)(dir.x * 100.0f);
            int attackY = this.attackerMob.getY() + (int)(dir.y * 100.0f);
            long currentTime = this.attackerMob.getLevel().getLocalTime();
            if (this.toolItem.canAttack(this.attackerMob.getLevel(), attackX, attackY, this.attackerMob, this.item) == null) {
                int cooldown;
                this.timeBuffer += currentTime - this.lastTime;
                int seed = Item.getRandomAttackSeed((GameRandom)this.random.seeded((long)GameRandom.prime((int)(this.attackSeed * this.shots))));
                GNDItemMap attackMap = this.attackerMob.showAttackAndSendAttacker(this.item, attackX, attackY, 0, seed);
                while (this.timeBuffer >= (long)(cooldown = this.getShootCooldown())) {
                    this.timeBuffer -= (long)cooldown;
                    seed = Item.getRandomAttackSeed((GameRandom)this.random.nextSeeded(GameRandom.prime((int)(this.attackSeed * this.shots))));
                    ++this.shots;
                    this.toolItem.superOnAttack(this.attackerMob.getLevel(), attackX, attackY, this.attackerMob, this.attackerMob.getCurrentAttackHeight(), this.item, this.slot, 0, seed, attackMap);
                    if (this.attackerMob.isClient()) {
                        RipperAttackHandler.playFireSound((Mob)this.attackerMob);
                        continue;
                    }
                    if (!this.attackerMob.isServer()) continue;
                    this.attackerMob.sendAttackerPacket((RegionPositionGetter)this.attackerMob, (Packet)new PacketFireDeathRipper((Mob)this.attackerMob));
                }
            } else {
                this.onEndAttack(true);
            }
            this.lastTime = currentTime;
        }
    }

    public static void playFireSound(Mob target) {
        SoundManager.playSound((GameSound)GameResources.handgun, (SoundEffect)SoundEffect.effect((PrimitiveSoundEmitter)target));
    }

    private int getShootCooldown() {
        float multiplier = 1.0f / this.toolItem.getAttackSpeedModifier(this.item, this.attackerMob);
        if (this.shots > 9) {
            return (int)(multiplier * 150.0f);
        }
        if (this.shots > 6) {
            return (int)(multiplier * 200.0f);
        }
        return this.shots > 3 ? (int)(multiplier * 275.0f) : (int)(multiplier * 350.0f);
    }

    public void onEndAttack(boolean bySelf) {
        this.attackerMob.doAndSendStopAttackAttacker(false);
        this.shots = 0;
    }
}

