/*
 * Decompiled with CFR 0.152.
 */
package gunsmith.scripts;

import gunsmith.items.tools.ModularGun;
import java.awt.geom.Point2D;
import necesse.engine.registries.ItemRegistry;
import necesse.engine.sound.PrimitiveSoundEmitter;
import necesse.engine.sound.SoundEffect;
import necesse.engine.sound.SoundManager;
import necesse.engine.sound.gameSound.GameSound;
import necesse.engine.util.GameMath;
import necesse.engine.util.GameRandom;
import necesse.entity.mobs.Mob;
import necesse.entity.mobs.ai.behaviourTree.leaves.ChaserAINode;
import necesse.entity.mobs.attackHandler.MouseAngleAttackHandler;
import necesse.entity.mobs.itemAttacker.ItemAttackSlot;
import necesse.entity.mobs.itemAttacker.ItemAttackerMob;
import necesse.gfx.GameResources;
import necesse.inventory.InventoryItem;

public class BuildupFireAttackHandler
extends MouseAngleAttackHandler {
    private final InventoryItem item;
    private final ModularGun toolItem;
    private long lastTime;
    private long timeBuffer;
    private final int attackSeed;
    private int shots;
    private final GameRandom random = new GameRandom();

    public BuildupFireAttackHandler(ItemAttackerMob attackerMob, ItemAttackSlot slot, InventoryItem item, ModularGun toolItem, int seed, int startTargetX, int startTargetY) {
        super(attackerMob, slot, 50, 1000.0f, startTargetX, startTargetY);
        this.item = item;
        this.toolItem = toolItem;
        this.attackSeed = seed;
        this.lastTime = attackerMob.getLocalTime();
        this.shots = item.getGndData().getInt("ChargedShots");
    }

    public void onUpdate() {
        super.onUpdate();
        if (!this.attackerMob.isPlayer && this.lastItemAttackerTarget != null && !ChaserAINode.hasLineOfSightToTarget((Mob)this.attackerMob, (Mob)this.lastItemAttackerTarget, (float)5.0f)) {
            this.attackerMob.endAttackHandler(true);
        } else {
            Point2D.Float dir = GameMath.getAngleDir((float)this.currentAngle);
            int attackX = this.attackerMob.getX() + (int)(dir.x * 100.0f);
            int attackY = this.attackerMob.getY() + (int)(dir.y * 100.0f);
            long currentTime = this.attackerMob.getLevel().getLocalTime();
            if (this.toolItem.canAttack(this.attackerMob.getLevel(), attackX, attackY, this.attackerMob, this.item) == null) {
                int cooldown;
                this.timeBuffer += currentTime - this.lastTime;
                while (this.timeBuffer >= (long)(cooldown = this.getShootCooldown())) {
                    this.timeBuffer -= (long)cooldown;
                    ++this.shots;
                    this.item.getGndData().setInt("ChargedShots", this.shots);
                    float pitch = 0.75f * (float)(1 + this.shots / 10);
                    SoundManager.playSound((GameSound)GameResources.pop, (SoundEffect)SoundEffect.effect((PrimitiveSoundEmitter)this.attackerMob).volume(1.62f).pitch(pitch));
                }
            } else {
                this.onEndAttack(true);
            }
            this.lastTime = currentTime;
        }
    }

    public static void playFireSound(Mob target) {
    }

    private int getShootCooldown() {
        InventoryItem barrelItem = ItemRegistry.getItem((String)this.item.getGndData().getString("BarrelItem", "BarrelMachinegunIron")).getDefaultItem(null, 1);
        InventoryItem bodyItem = ItemRegistry.getItem((String)this.item.getGndData().getString("BodyItem", "BodyMachinegunBasic")).getDefaultItem(null, 1);
        InventoryItem stockItem = ItemRegistry.getItem((String)this.item.getGndData().getString("StockItem", "StockMachinegunIron")).getDefaultItem(null, 1);
        float multiplier = 1.0f / (stockItem.getGndData().getFloat("AttackSpeed", 1.0f) * barrelItem.getGndData().getFloat("AttackSpeed", 1.0f) * bodyItem.getGndData().getFloat("AttackSpeed", 1.0f));
        return Math.round(300.0f * multiplier);
    }

    public void onEndAttack(boolean bySelf) {
        this.attackerMob.doAndSendStopAttackAttacker(false);
    }
}

