/*
 * Decompiled with CFR 0.152.
 */
package gunsmith.projectiles.modifiers;

import necesse.engine.network.PacketReader;
import necesse.engine.network.PacketWriter;
import necesse.engine.registries.BuffRegistry;
import necesse.engine.util.GameMath;
import necesse.entity.levelEvent.LevelEvent;
import necesse.entity.levelEvent.mobAbilityLevelEvent.CrystallizeShatterEvent;
import necesse.entity.mobs.Attacker;
import necesse.entity.mobs.GameDamage;
import necesse.entity.mobs.Mob;
import necesse.entity.mobs.buffs.ActiveBuff;
import necesse.entity.mobs.buffs.BuffManager;
import necesse.entity.mobs.buffs.BuffModifiers;
import necesse.entity.mobs.buffs.staticBuffs.Buff;
import necesse.entity.projectile.Projectile;
import necesse.entity.projectile.modifiers.ProjectileModifier;
import necesse.level.maps.LevelObjectHit;

public class CrystalizeModifier
extends ProjectileModifier {
    private float resilienceGain;
    private boolean hasGained = false;

    public CrystalizeModifier() {
    }

    public CrystalizeModifier(float resilienceGain) {
        this.resilienceGain = resilienceGain;
    }

    public void setupSpawnPacket(PacketWriter writer) {
        super.setupSpawnPacket(writer);
        writer.putNextFloat(this.resilienceGain);
        writer.putNextBoolean(this.hasGained);
    }

    public void applySpawnPacket(PacketReader reader) {
        super.applySpawnPacket(reader);
        this.resilienceGain = reader.getNextFloat();
        this.hasGained = reader.getNextBoolean();
    }

    public void initChildProjectile(Projectile projectile, float childStrength, int childCount) {
        super.initChildProjectile(projectile, childStrength, childCount);
        projectile.setModifier((ProjectileModifier)new CrystalizeModifier(this.resilienceGain / (float)childCount));
    }

    public void doHitLogic(Mob mob, LevelObjectHit object, float x, float y) {
        BuffManager attackerBM;
        super.doHitLogic(mob, object, x, y);
        if (this.projectile.isServer() && mob != null && (attackerBM = this.projectile.getAttackOwner().buffManager) != null) {
            float thresholdMod = ((Float)attackerBM.getModifier(BuffModifiers.CRIT_CHANCE)).floatValue() + ((Float)attackerBM.getModifier(BuffModifiers.MELEE_CRIT_CHANCE)).floatValue();
            float crystallizeMod = ((Float)attackerBM.getModifier(BuffModifiers.CRIT_DAMAGE)).floatValue() + ((Float)attackerBM.getModifier(BuffModifiers.MELEE_CRIT_CHANCE)).floatValue();
            int stackThreshold = (int)GameMath.limit((float)(10.0f - 7.0f * thresholdMod), (float)3.0f, (float)10.0f);
            float crystallizeDamageMultiplier = GameMath.limit((float)crystallizeMod, (float)2.0f, (float)stackThreshold);
            Buff crystallizeBuff = BuffRegistry.Debuffs.CRYSTALLIZE_BUFF;
            ActiveBuff ab = new ActiveBuff(crystallizeBuff, mob, 10000, (Attacker)this.projectile.getAttackOwner());
            mob.buffManager.addBuff(ab, true);
            if (mob.buffManager.getBuff(crystallizeBuff).getStacks() >= stackThreshold) {
                this.getLevel().entityManager.addLevelEvent((LevelEvent)new CrystallizeShatterEvent(mob, CrystallizeShatterEvent.ParticleType.SAPPHIRE));
                mob.buffManager.removeBuff(crystallizeBuff, true);
                GameDamage finalDamage = this.projectile.getDamage().modDamage(crystallizeDamageMultiplier);
                mob.isServerHit(finalDamage, 0.0f, 0.0f, 0.0f, (Attacker)this.projectile);
            }
        }
        if (!this.hasGained) {
            Mob owner = this.projectile.getOwner();
            if (mob != null && owner != null && mob.canGiveResilience((Attacker)owner)) {
                owner.addResilience(this.resilienceGain);
                this.hasGained = true;
            }
        }
    }
}

