/*
 * Decompiled with CFR 0.152.
 */
package gunsmith.packets;

import java.util.Iterator;
import necesse.engine.network.NetworkPacket;
import necesse.engine.network.Packet;
import necesse.engine.network.PacketReader;
import necesse.engine.network.PacketWriter;
import necesse.engine.network.client.Client;
import necesse.engine.network.gameNetworkData.GNDItemMap;
import necesse.engine.network.server.Server;
import necesse.engine.network.server.ServerClient;
import necesse.engine.registries.ItemRegistry;
import necesse.gfx.fairType.FairType;
import necesse.gfx.forms.components.chat.ChatMessage;
import necesse.inventory.InventoryItem;

public class RequestItemPacket
extends Packet {
    public final int requestSlot;
    public final String baseItem;
    public final Packet baseItemGND;

    public RequestItemPacket(byte[] data) {
        super(data);
        PacketReader reader = new PacketReader((Packet)this);
        this.requestSlot = reader.getNextInt();
        this.baseItem = reader.getNextString();
        this.baseItemGND = reader.getNextContentPacket();
    }

    public RequestItemPacket(int requestSlot, InventoryItem baseItem) {
        this.requestSlot = requestSlot;
        this.baseItem = baseItem.item.getStringID();
        this.baseItemGND = baseItem.getGndData().getContentPacket();
        PacketWriter writer = new PacketWriter((Packet)this);
        writer.putNextInt(this.requestSlot);
        writer.putNextString(this.baseItem);
        writer.putNextContentPacket(this.baseItemGND);
    }

    public void processServer(NetworkPacket packet, Server server, ServerClient client) {
        server.network.sendToClientsAtEntireLevel((Packet)this, server.getPlayer(this.requestSlot).getLevel());
    }

    public void processClient(NetworkPacket packet, Client client) {
        InventoryItem item = new InventoryItem(ItemRegistry.getItem((String)this.baseItem), 1);
        GNDItemMap gndData = new GNDItemMap(this.baseItemGND);
        item.setGndData(gndData);
        StringBuilder displayString = new StringBuilder("[item=" + item.item.getStringID() + "]{");
        StringBuilder displayStringComp = new StringBuilder("[item=" + item.item.getStringID() + "]{");
        Iterator GNDKeys = item.getGndData().getDirtyKeys().iterator();
        while (GNDKeys.hasNext()) {
            Integer keyValue = (Integer)GNDKeys.next();
            displayString.append(keyValue).append("={");
            displayStringComp.append(keyValue).append("={");
            displayString.append("gndType=").append(item.getGndData().getItem(keyValue.intValue()).getStringID()).append(",");
            displayStringComp.append("gndType=").append(item.getGndData().getItem(keyValue.intValue()).getStringID()).append(",");
            if (item.getGndData().getItem(keyValue.intValue()).getStringID().equalsIgnoreCase("float")) {
                displayString.append("value=").append(item.getGndData().getItem(keyValue.intValue())).append("}");
                displayStringComp.append("value=").append(item.getGndData().getItem(keyValue.intValue())).deleteCharAt(displayStringComp.lastIndexOf("f")).append("}");
            } else {
                displayString.append("value=").append(item.getGndData().getItem(keyValue.intValue())).append("}");
                displayStringComp.append("value=").append(item.getGndData().getItem(keyValue.intValue())).append("}");
            }
            if (!GNDKeys.hasNext()) continue;
            displayString.append(",");
            displayStringComp.append(",");
        }
        displayString.append("}");
        displayStringComp.append("}");
        String display = displayString.toString();
        boolean found = false;
        FairType type = new FairType();
        type.append(ChatMessage.fontOptions, "\u00a7#f7b345ToolForge MP Beta Sync\u00a7#FFFFFF: " + display);
        ChatMessage message2 = new ChatMessage(type);
        for (ChatMessage message2 : client.chat) {
            if (!message2.type.getParseString().equalsIgnoreCase(displayStringComp.toString())) continue;
            found = true;
            client.chat.removeMessage(message2);
            break;
        }
        for (int i = 0; i < 11; ++i) {
            if (client.getPlayer().getInv().main.getItem(i) != item) continue;
            found = true;
            break;
        }
        if (!found) {
            client.chat.addMessage(type);
            client.chat.removeMessage(message2);
        }
        client.chat.removeMessage(message2);
    }
}

