/*
 * Decompiled with CFR 0.152.
 */
package gunsmith.packets;

import gunsmith.projectiles.ReflectedProjectile;
import necesse.engine.network.NetworkPacket;
import necesse.engine.network.Packet;
import necesse.engine.network.PacketReader;
import necesse.engine.network.PacketWriter;
import necesse.engine.network.client.Client;
import necesse.engine.network.server.Server;
import necesse.engine.network.server.ServerClient;
import necesse.engine.util.GameRandom;
import necesse.engine.util.LevelIdentifier;
import necesse.entity.Entity;
import necesse.entity.mobs.Mob;
import necesse.entity.projectile.Projectile;

public class ReflectedProjectilePacket
extends Packet {
    public final int uniqueID;
    public final LevelIdentifier levelID;
    public final int playerID;

    public ReflectedProjectilePacket(byte[] data) {
        super(data);
        PacketReader reader = new PacketReader((Packet)this);
        this.uniqueID = reader.getNextInt();
        this.levelID = new LevelIdentifier(reader.getNextString());
        this.playerID = reader.getNextInt();
    }

    public ReflectedProjectilePacket(int uniqueID, LevelIdentifier levelID, int playerID) {
        this.uniqueID = uniqueID;
        this.levelID = levelID;
        this.playerID = playerID;
        PacketWriter writer = new PacketWriter((Packet)this);
        writer.putNextInt(uniqueID);
        writer.putNextString(levelID.stringID);
        writer.putNextInt(playerID);
    }

    public void processServer(NetworkPacket packet, Server server, ServerClient client) {
        Projectile old = (Projectile)server.world.getLevel((LevelIdentifier)this.levelID).entityManager.projectiles.get(this.uniqueID, true);
        ReflectedProjectile reflect = null;
        reflect = old.getOwner() != null ? new ReflectedProjectile(old.getX(), old.getY(), old.getOwner().x, old.getOwner().y, old.speed, old.distance, old.getDamage(), old.knockback, (Mob)server.getPlayer(this.playerID)) : (server.getPlayer(this.playerID).getDir() == 0 ? new ReflectedProjectile(old.getX(), old.getY(), old.getX() + GameRandom.globalRandom.getIntBetween(-100, 100), old.getY() - GameRandom.globalRandom.getIntBetween(10, 100), old.speed, old.distance, old.getDamage(), old.knockback, (Mob)server.getPlayer(this.playerID)) : (server.getPlayer(this.playerID).getDir() == 1 ? new ReflectedProjectile(old.getX(), old.getY(), old.getX() + GameRandom.globalRandom.getIntBetween(10, 100), old.getY() + GameRandom.globalRandom.getIntBetween(-100, 100), old.speed, old.distance, old.getDamage(), old.knockback, (Mob)server.getPlayer(this.playerID)) : (server.getPlayer(this.playerID).getDir() == 2 ? new ReflectedProjectile(old.getX(), old.getY(), old.getX() + GameRandom.globalRandom.getIntBetween(-100, 100), old.getY() + GameRandom.globalRandom.getIntBetween(10, 100), old.speed, old.distance, old.getDamage(), old.knockback, (Mob)server.getPlayer(this.playerID)) : new ReflectedProjectile(old.getX(), old.getY(), old.getX() - GameRandom.globalRandom.getIntBetween(10, 100), old.getY() + GameRandom.globalRandom.getIntBetween(-100, 100), old.speed, old.distance, old.getDamage(), old.knockback, (Mob)server.getPlayer(this.playerID)))));
        if (((Projectile)reflect).speed * 2.0f > 10.0f) {
            server.world.getLevel((LevelIdentifier)this.levelID).entityManager.projectiles.add((Entity)reflect);
        }
        old.remove();
    }

    public void processClient(NetworkPacket packet, Client client) {
        if (client.getLevel().getIdentifier() == this.levelID && client.getLevel().entityManager.projectiles.get(this.uniqueID, true) != null) {
            ((Projectile)client.getLevel().entityManager.projectiles.get(this.uniqueID, true)).remove();
        }
    }
}

