/*
 * Decompiled with CFR 0.152.
 */
package gunsmith.items.tools.special.jenWand;

import gunsmith.events.JenWandBlastEvent;
import gunsmith.gunsmith;
import gunsmith.projectiles.special.JenWandPushProjectile;
import java.awt.Point;
import necesse.engine.localization.Localization;
import necesse.engine.network.Packet;
import necesse.engine.network.gameNetworkData.GNDItemMap;
import necesse.engine.network.packet.PacketLevelEvent;
import necesse.engine.sound.PrimitiveSoundEmitter;
import necesse.engine.sound.SoundEffect;
import necesse.engine.sound.SoundManager;
import necesse.engine.sound.gameSound.GameSound;
import necesse.engine.util.GameBlackboard;
import necesse.engine.util.GameRandom;
import necesse.entity.levelEvent.LevelEvent;
import necesse.entity.mobs.Attacker;
import necesse.entity.mobs.Mob;
import necesse.entity.mobs.PlayerMob;
import necesse.entity.mobs.itemAttacker.ItemAttackSlot;
import necesse.entity.mobs.itemAttacker.ItemAttackerMob;
import necesse.entity.projectile.Projectile;
import necesse.gfx.gameTooltips.ListGameTooltips;
import necesse.inventory.InventoryItem;
import necesse.inventory.item.Item;
import necesse.inventory.item.toolItem.projectileToolItem.magicProjectileToolItem.MagicProjectileToolItem;
import necesse.level.maps.Level;
import necesse.level.maps.regionSystem.RegionPositionGetter;

public class JenWand
extends MagicProjectileToolItem {
    public int moveDist;

    public JenWand() {
        super(700, null);
        this.rarity = Item.Rarity.LEGENDARY;
        this.attackAnimTime.setBaseValue(200);
        this.attackDamage.setBaseValue(0.0f).setUpgradedValue(1.0f, 0.0f);
        this.knockback.setBaseValue(300);
        this.attackXOffset = 20;
        this.attackYOffset = 20;
        this.moveDist = 20;
        this.attackCooldownTime.setBaseValue(400);
        this.velocity.setBaseValue(700);
        this.attackRange.setBaseValue(70);
        this.manaCost.setBaseValue(2.0f).setUpgradedValue(1.0f, 3.5f);
        this.itemAttackerProjectileCanHitWidth = 5.0f;
        this.canBeUsedForRaids = false;
        this.raidTicketsModifier = 0.5f;
        this.useForRaidsOnlyIfObtained = false;
    }

    public ListGameTooltips getPreEnchantmentTooltips(InventoryItem item, PlayerMob perspective, GameBlackboard blackboard) {
        ListGameTooltips tooltips = super.getPreEnchantmentTooltips(item, perspective, blackboard);
        tooltips.add(Localization.translate((String)"itemtooltip", (String)"voidstafftip"));
        return tooltips;
    }

    public void showAttack(Level level, int x, int y, ItemAttackerMob attackerMob, int attackHeight, InventoryItem item, int animAttack, int seed, GNDItemMap mapContent) {
        if (level.isClient()) {
            SoundManager.playSound((GameSound)gunsmith.JenWandBlast, (SoundEffect)SoundEffect.effect((PrimitiveSoundEmitter)attackerMob).volume(0.5f).pitch(1.15f));
        }
    }

    public Point getItemAttackerAttackPosition(Level level, ItemAttackerMob attackerMob, Mob target, int seed, InventoryItem item) {
        return this.applyInaccuracy(attackerMob, item, new Point(target.getX(), target.getY()));
    }

    public InventoryItem onAttack(Level level, int x, int y, ItemAttackerMob attackerMob, int attackHeight, InventoryItem item, ItemAttackSlot slot, int animAttack, int seed, GNDItemMap mapContent) {
        JenWandBlastEvent event = new JenWandBlastEvent((Mob)attackerMob, this.knockback.getValue(this.getUpgradeTier(item)), 0.2f, attackerMob.getX(), attackerMob.getY(), x += GameRandom.globalRandom.getIntBetween(-2, 2), y += GameRandom.globalRandom.getIntBetween(-2, 2), GameRandom.globalRandom.getIntBetween(-5, 5), (Mob)attackerMob);
        attackerMob.getLevel().entityManager.addLevelEventHidden((LevelEvent)event);
        if (level.isServer()) {
            level.getServer().network.sendToClientsWithEntityExcept((Packet)new PacketLevelEvent((LevelEvent)event), (RegionPositionGetter)event, attackerMob.getFirstPlayerOwner().getServerClient());
        }
        JenWandPushProjectile projectile = new JenWandPushProjectile(level, (Mob)attackerMob, attackerMob.x, attackerMob.y, x, y, this.getProjectileVelocity(item, (Mob)attackerMob), this.attackRange.getValue(this.getUpgradeTier(item)), this.getAttackDamage(item), this.getKnockback(item, (Attacker)attackerMob));
        projectile.getUniqueID(new GameRandom((long)seed));
        attackerMob.addAndSendAttackerProjectile((Projectile)projectile, this.moveDist);
        this.consumeMana(attackerMob, item);
        return item;
    }
}

