/*
 * Decompiled with CFR 0.152.
 */
package gunsmith.items.tools;

import gunsmith.events.DeflectingToolItemMobAbilityEvent;
import gunsmith.gunsmith;
import gunsmith.items.tools.ModularBase;
import gunsmith.packets.RequestItemPacket;
import gunsmith.scripts.RGBToHex;
import java.awt.Color;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import necesse.engine.GameState;
import necesse.engine.GlobalData;
import necesse.engine.input.Control;
import necesse.engine.localization.Localization;
import necesse.engine.localization.message.GameMessage;
import necesse.engine.localization.message.StaticMessage;
import necesse.engine.network.Packet;
import necesse.engine.network.gameNetworkData.GNDItemMap;
import necesse.engine.network.packet.PacketOpenContainer;
import necesse.engine.network.server.ServerClient;
import necesse.engine.registries.BuffRegistry;
import necesse.engine.registries.ContainerRegistry;
import necesse.engine.registries.DamageTypeRegistry;
import necesse.engine.registries.ItemRegistry;
import necesse.engine.sound.PrimitiveSoundEmitter;
import necesse.engine.sound.SoundEffect;
import necesse.engine.sound.SoundManager;
import necesse.engine.sound.gameSound.GameSound;
import necesse.engine.util.ComparableSequence;
import necesse.engine.util.GameBlackboard;
import necesse.engine.util.GameMath;
import necesse.engine.util.LineHitbox;
import necesse.engine.world.GameClock;
import necesse.engine.world.WorldSettings;
import necesse.entity.Entity;
import necesse.entity.TileEntity;
import necesse.entity.levelEvent.LevelEvent;
import necesse.entity.levelEvent.mobAbilityLevelEvent.ToolItemMobAbilityEvent;
import necesse.entity.mobs.AttackAnimMob;
import necesse.entity.mobs.Attacker;
import necesse.entity.mobs.GameDamage;
import necesse.entity.mobs.Mob;
import necesse.entity.mobs.PlayerMob;
import necesse.entity.mobs.buffs.ActiveBuff;
import necesse.entity.mobs.buffs.BuffModifiers;
import necesse.entity.mobs.itemAttacker.ItemAttackSlot;
import necesse.entity.mobs.itemAttacker.ItemAttackerMob;
import necesse.gfx.GameResources;
import necesse.gfx.camera.GameCamera;
import necesse.gfx.drawOptions.DrawOptions;
import necesse.gfx.drawOptions.itemAttack.ItemAttackDrawOptions;
import necesse.gfx.gameTexture.GameSprite;
import necesse.gfx.gameTexture.GameTexture;
import necesse.gfx.gameTexture.MergeFunction;
import necesse.gfx.gameTooltips.ListGameTooltips;
import necesse.inventory.Inventory;
import necesse.inventory.InventoryAddConsumer;
import necesse.inventory.InventoryItem;
import necesse.inventory.InventoryItemsRemoved;
import necesse.inventory.PlayerInventorySlot;
import necesse.inventory.SlotPriority;
import necesse.inventory.container.Container;
import necesse.inventory.container.ContainerActionResult;
import necesse.inventory.container.item.ItemInventoryContainer;
import necesse.inventory.container.slots.ContainerSlot;
import necesse.inventory.enchants.ToolItemModifiers;
import necesse.inventory.item.Item;
import necesse.inventory.item.ItemControllerInteract;
import necesse.inventory.item.ItemStatTip;
import necesse.inventory.item.ItemStatTipList;
import necesse.inventory.item.LocalMessageDoubleItemStatTip;
import necesse.inventory.item.StringItemStatTip;
import necesse.inventory.item.TickItem;
import necesse.inventory.item.miscItem.InternalInventoryItemInterface;
import necesse.inventory.item.toolItem.ToolItem;
import necesse.inventory.item.toolItem.shovelToolItem.CustomShovelToolItem;
import necesse.inventory.recipe.Ingredient;
import necesse.inventory.recipe.IngredientCounter;
import necesse.inventory.recipe.IngredientUser;
import necesse.level.maps.Level;

public class ModularShovel
extends CustomShovelToolItem
implements InternalInventoryItemInterface,
TickItem {
    public HashSet<String> insertPurposes = new HashSet();
    public boolean isInsertPurposesBlacklist = false;
    public HashSet<String> requestPurposes = new HashSet();
    public boolean isRequestPurposeBlacklist = true;
    public HashSet<String> pickupDisabledPurposeIgnores = new HashSet();
    public boolean allowRestockFrom = true;

    protected boolean isValidPurpose(HashSet<String> purposes, boolean isBlacklist, String purpose, boolean isPickupDisabled) {
        if (isPickupDisabled && this.pickupDisabledPurposeIgnores.contains(purpose)) {
            return isBlacklist;
        }
        return isBlacklist != purposes.contains(purpose);
    }

    public ModularShovel() {
        super(0, 0, 0.0f, 0, 50, 80, 500);
        this.damageType = DamageTypeRegistry.MELEE;
        this.showAttackAllDirections = true;
        this.attackXOffset = -4;
        this.attackYOffset = 3;
        this.setItemCategory(new String[]{"TF", "shovel"});
    }

    public boolean animDrawBehindHand(InventoryItem item) {
        return true;
    }

    public InventoryItem defaultBarrel(InventoryItem item) {
        InventoryItem defaultItem = ItemRegistry.getItem((String)item.getGndData().getString("BarrelItem", "HeadShovelWood")).getDefaultItem(null, 1);
        if (item.getGndData().hasKey("BarrelBonus")) {
            item.getGndData().copyKeysToTarget(defaultItem.getGndData(), new String[]{"BarrelBonus", "BarrelBonusValue"});
        }
        return defaultItem;
    }

    public InventoryItem defaultBody(InventoryItem item) {
        InventoryItem defaultItem = ItemRegistry.getItem((String)item.getGndData().getString("BodyItem", "BodyShovelBasic")).getDefaultItem(null, 1);
        if (item.getGndData().hasKey("BodyBonus")) {
            item.getGndData().copyKeysToTarget(defaultItem.getGndData(), new String[]{"BodyBonus", "BodyBonusValue"});
        }
        return defaultItem;
    }

    public InventoryItem defaultStock(InventoryItem item) {
        InventoryItem defaultItem = ItemRegistry.getItem((String)item.getGndData().getString("StockItem", "ShaftPickaxeWood")).getDefaultItem(null, 1);
        if (item.getGndData().hasKey("StockBonus")) {
            item.getGndData().copyKeysToTarget(defaultItem.getGndData(), new String[]{"StockBonus", "StockBonusValue"});
        }
        return defaultItem;
    }

    public boolean isValidPouchItem(InventoryItem item) {
        return this.isValidRequestItem(item.item);
    }

    public boolean isValidRequestItem(Item item) {
        return item != null ? item.getStringID().equalsIgnoreCase("bucket") || item.getStringID().equalsIgnoreCase("landfill") : !this.isValidRequestType(null);
    }

    public boolean isValidAddItem(InventoryItem item) {
        return this.isValidPouchItem(item);
    }

    public boolean isValidRequestType(Item.Type type) {
        return false;
    }

    public int getInternalInventorySize() {
        return 1;
    }

    public Supplier<ContainerActionResult> getInventoryRightClickAction(Container container, InventoryItem item, int slotIndex, ContainerSlot slot) {
        return () -> {
            PlayerInventorySlot playerSlot = null;
            if (slot.getInventory() == container.getClient().playerMob.getInv().main) {
                playerSlot = new PlayerInventorySlot(container.getClient().playerMob.getInv().main, slot.getInventorySlot());
            }
            if (slot.getInventory() == container.getClient().playerMob.getInv().cloud) {
                playerSlot = new PlayerInventorySlot(container.getClient().playerMob.getInv().cloud, slot.getInventorySlot());
            }
            if (playerSlot != null) {
                if (container.getClient().isServer()) {
                    ServerClient client = container.getClient().getServerClient();
                    this.openContainer(client, playerSlot);
                }
                return new ContainerActionResult(-1002911334);
            }
            return new ContainerActionResult(208675834, Localization.translate((String)"itemtooltip", (String)"rclickinvopenerror"));
        };
    }

    protected void openContainer(ServerClient client, PlayerInventorySlot inventorySlot) {
        PacketOpenContainer p = new PacketOpenContainer(ContainerRegistry.ITEM_INVENTORY_CONTAINER, ItemInventoryContainer.getContainerContent((InternalInventoryItemInterface)this, (PlayerInventorySlot)inventorySlot));
        ContainerRegistry.openAndSendContainer((ServerClient)client, (PacketOpenContainer)p);
    }

    public ComparableSequence<Integer> getInventoryAddPriority(Level level, PlayerMob player, Inventory inventory, int inventorySlot, InventoryItem item, InventoryItem input, String purpose) {
        ComparableSequence last = super.getInventoryAddPriority(level, player, inventory, inventorySlot, item, input, purpose);
        if (this.isValidAddItem(input) && (this.isValidPurpose(this.insertPurposes, this.isInsertPurposesBlacklist, purpose, this.isPickupDisabled(item)) || this.allowRestockFrom && purpose.equals("restockfrom"))) {
            last = last.beforeBy((Comparable)Integer.valueOf(-10000));
            Inventory internalInventory = this.getInternalInventory(item);
            ArrayList addList = internalInventory.getPriorityAddList(level, player, input, 0, internalInventory.getSize() - 1, purpose);
            for (SlotPriority slotPriority : addList) {
                boolean isValid = internalInventory.isItemValid(slotPriority.slot, input);
                int stackLimit = internalInventory.getItemStackLimit(slotPriority.slot, input);
                InventoryItem invItem = internalInventory.getItem(slotPriority.slot);
                if (invItem.item.inventoryCanAddItem(level, player, invItem, input, purpose, isValid, stackLimit) <= 0) continue;
                return last.thenBy((Comparable)Integer.valueOf(inventorySlot)).thenBy(((SlotPriority)addList.get((int)0)).comparable);
            }
            return last.thenBy((Comparable)Integer.valueOf(10000));
        }
        return last;
    }

    public ComparableSequence<Integer> getInventoryPriority(Level level, PlayerMob player, Inventory inventory, int inventorySlot, InventoryItem item, String purpose) {
        return super.getInventoryPriority(level, player, inventory, inventorySlot, item, purpose).beforeBy((Comparable)Integer.valueOf(-10000));
    }

    public int getInventoryAmount(Level level, PlayerMob player, InventoryItem item, Item requestItem, String purpose) {
        int amount = super.getInventoryAmount(level, player, item, requestItem, purpose);
        if (this.isValidPurpose(this.requestPurposes, this.isRequestPurposeBlacklist, purpose, this.isPickupDisabled(item)) && this.isValidRequestItem(requestItem)) {
            Inventory internalInventory = this.getInternalInventory(item);
            amount += internalInventory.getAmount(level, player, requestItem, purpose);
        }
        return amount;
    }

    public int getInventoryAmount(Level level, PlayerMob player, InventoryItem item, Item.Type requestType, String purpose) {
        int amount = super.getInventoryAmount(level, player, item, requestType, purpose);
        if (this.isValidRequestType(requestType)) {
            Inventory internalInventory = this.getInternalInventory(item);
            amount += internalInventory.getAmount(level, player, requestType, purpose);
        }
        return amount;
    }

    public void countIngredientAmount(Level level, PlayerMob player, Inventory inventory, int inventorySlot, InventoryItem item, String purpose, IngredientCounter handler) {
        if (purpose.equals("buy") || purpose.equals("crafting")) {
            this.getInternalInventory(item).countIngredientAmount(level, player, purpose, handler);
        }
        super.countIngredientAmount(level, player, inventory, inventorySlot, item, purpose, handler);
    }

    public void useIngredientAmount(Level level, PlayerMob player, Inventory inventory, int inventorySlot, InventoryItem item, String purpose, IngredientUser handler) {
        if (purpose.equals("buy") || purpose.equals("crafting")) {
            this.getInternalInventory(item).useIngredientAmount(level, player, purpose, handler);
        }
        super.useIngredientAmount(level, player, inventory, inventorySlot, item, purpose, handler);
    }

    public Item getInventoryFirstItem(Level level, PlayerMob player, InventoryItem item, Item[] requestItems, String purpose) {
        Inventory internalInventory;
        Item firstItem;
        if (this.isValidPurpose(this.requestPurposes, this.isRequestPurposeBlacklist, purpose, this.isPickupDisabled(item)) && Arrays.stream(requestItems).anyMatch(this::isValidRequestItem) && (firstItem = (internalInventory = this.getInternalInventory(item)).getFirstItem(level, player, requestItems, purpose)) != null) {
            return firstItem;
        }
        return super.getInventoryFirstItem(level, player, item, requestItems, purpose);
    }

    public Item getInventoryFirstItem(Level level, PlayerMob player, InventoryItem item, Item.Type requestType, String purpose) {
        Inventory internalInventory;
        Item firstItem;
        if (this.isValidRequestType(requestType) && (firstItem = (internalInventory = this.getInternalInventory(item)).getFirstItem(level, player, requestType, purpose)) != null) {
            return firstItem;
        }
        return super.getInventoryFirstItem(level, player, item, requestType, purpose);
    }

    public boolean inventoryAddItem(Level level, PlayerMob player, Inventory myInventory, int mySlot, InventoryItem me, InventoryItem input, String purpose, boolean isValid, int stackLimit, boolean combineIsValid, InventoryAddConsumer addConsumer) {
        Inventory internalInventory;
        boolean success;
        if (this.isValidAddItem(input) && this.isValidPurpose(this.insertPurposes, this.isInsertPurposesBlacklist, purpose, this.isPickupDisabled(me)) && (success = (internalInventory = this.getInternalInventory(me)).addItem(level, player, input, purpose, addConsumer))) {
            if (input.isNew()) {
                me.setNew(true);
            }
            this.saveInternalInventory(me, internalInventory);
            return true;
        }
        return super.inventoryAddItem(level, player, myInventory, mySlot, me, input, purpose, isValid, stackLimit, combineIsValid, addConsumer);
    }

    public int inventoryCanAddItem(Level level, PlayerMob player, InventoryItem item, InventoryItem input, String purpose, boolean isValid, int stackLimit) {
        if (this.isValidAddItem(input)) {
            Inventory internalInventory = this.getInternalInventory(item);
            return internalInventory.canAddItem(level, player, input, purpose);
        }
        return super.inventoryCanAddItem(level, player, item, input, purpose, isValid, stackLimit);
    }

    public int removeInventoryAmount(Level level, PlayerMob player, InventoryItem item, Item requestItem, int amount, String purpose) {
        Inventory internalInventory;
        int removed = 0;
        if (this.isValidPurpose(this.requestPurposes, this.isRequestPurposeBlacklist, purpose, this.isPickupDisabled(item)) && this.isValidRequestItem(requestItem) && (removed = (internalInventory = this.getInternalInventory(item)).removeItems(level, player, requestItem, amount, purpose)) > 0) {
            this.saveInternalInventory(item, internalInventory);
        }
        return removed < amount ? removed + super.removeInventoryAmount(level, player, item, requestItem, amount, purpose) : removed;
    }

    public int removeInventoryAmount(Level level, PlayerMob player, InventoryItem item, Item.Type requestType, int amount, String purpose) {
        Inventory internalInventory;
        int removed = 0;
        if (this.isValidRequestType(requestType) && (removed = (internalInventory = this.getInternalInventory(item)).removeItems(level, player, requestType, amount, purpose)) > 0) {
            this.saveInternalInventory(item, internalInventory);
        }
        return removed < amount ? removed + super.removeInventoryAmount(level, player, item, requestType, amount, purpose) : removed;
    }

    public int removeInventoryAmount(Level level, PlayerMob player, InventoryItem item, Inventory inventory, int inventorySlot, Ingredient ingredient, int amount, Collection<InventoryItemsRemoved> collect) {
        Inventory internalInventory = this.getInternalInventory(item);
        int removed = internalInventory.removeItems(level, player, ingredient, amount, collect);
        if (removed > 0) {
            this.saveInternalInventory(item, internalInventory);
        }
        return removed < amount ? removed + super.removeInventoryAmount(level, player, item, inventory, inventorySlot, ingredient, amount, collect) : removed;
    }

    public boolean isValidItem(InventoryItem item) {
        return item == null ? true : this.isValidPouchItem(item);
    }

    protected ListGameTooltips getDisplayNameTooltips(InventoryItem item, PlayerMob perspective, GameBlackboard blackboard) {
        return ModularBase.getDisplayNameTooltips(item, perspective, blackboard, this.defaultBarrel(item), this.defaultBody(item), this.defaultStock(item));
    }

    public ListGameTooltips getPreEnchantmentTooltips(InventoryItem item, PlayerMob perspective, GameBlackboard blackboard) {
        ListGameTooltips tooltips = new ListGameTooltips();
        Control statsKey = Control.getControl((String)gunsmith.settingsGetter.getSelection("viewStats").toString());
        Control partsKey = Control.getControl((String)gunsmith.settingsGetter.getSelection("viewParts").toString());
        if (!partsKey.isDown() && !statsKey.isDown()) {
            tooltips = super.getPreEnchantmentTooltips(item, perspective, blackboard);
        }
        if (!item.getGndData().hasKey("StockItem")) {
            return tooltips;
        }
        if (partsKey.isDown() && partsKey != statsKey) {
            tooltips.add(Localization.translate((String)"itemtooltip", (String)"Head") + " " + Localization.translate((String)"item", (String)(item.getGndData().getString("BarrelItem", "HeadShovelWood") + "Name")));
            tooltips.add(Localization.translate((String)"itemtooltip", (String)"Brace") + " " + Localization.translate((String)"item", (String)(item.getGndData().getString("BodyItem", "BodyShovelBasic") + "Name")));
            tooltips.add(Localization.translate((String)"itemtooltip", (String)"Shaft") + " " + Localization.translate((String)"item", (String)(item.getGndData().getString("StockItem", "ShaftPickaxeWood") + "Name")));
        } else if (statsKey.isDown() || statsKey.isDown() && statsKey == partsKey || partsKey.isDown() && statsKey == partsKey) {
            String color;
            if (statsKey == partsKey) {
                tooltips.add(Localization.translate((String)"itemtooltip", (String)"Head") + " " + Localization.translate((String)"item", (String)(item.getGndData().getString("BarrelItem", "HeadShovelWood") + "Name")));
                tooltips.add(Localization.translate((String)"itemtooltip", (String)"Brace") + " " + Localization.translate((String)"item", (String)(item.getGndData().getString("BodyItem", "BodyShovelBasic") + "Name")));
                tooltips.add(Localization.translate((String)"itemtooltip", (String)"Shaft") + " " + Localization.translate((String)"item", (String)(item.getGndData().getString("StockItem", "ShaftPickaxeWood") + "Name")));
            }
            tooltips.add(Localization.translate((String)"barreltooltip", (String)"HeadTip"));
            if (item.getGndData().hasKey("BarrelBonus")) {
                color = RGBToHex.RGBToHex(gunsmith.settingsGetter.getColor("bonusColor"));
                StringBuilder stringBuilder = new StringBuilder();
                if (item.getGndData().getFloat("BarrelBonusValue") >= this.defaultStock(item).getGndData().getFloat(stringBuilder.append("High").append(item.getGndData().getString("BarrelBonus")).toString())) {
                    color = RGBToHex.RGBToHex(gunsmith.settingsGetter.getColor("bonusMaxColor"));
                }
                if (item.getGndData().getString("BarrelBonus").equalsIgnoreCase("BonusAttackSpeed")) {
                    if (item.getGndData().getFloat("BarrelBonusValue") > 0.0f) {
                        tooltips.add(Localization.translate((String)"bonusmodtip", (String)item.getGndData().getString("BarrelBonus"), (Object[])new Object[]{"value", Float.valueOf(item.getGndData().getFloat("BarrelBonusValue") / 10.0f), "unit", "+", "color", color}));
                    } else {
                        tooltips.add(Localization.translate((String)"bonusmodtip", (String)item.getGndData().getString("BarrelBonus"), (Object[])new Object[]{"value", Float.valueOf(item.getGndData().getFloat("BarrelBonusValue") / 10.0f), "unit", "", "color", color}));
                    }
                } else if (item.getGndData().getFloat("BarrelBonusValue") > 0.0f) {
                    tooltips.add(Localization.translate((String)"bonusmodtip", (String)item.getGndData().getString("BarrelBonus"), (Object[])new Object[]{"value", Float.valueOf(item.getGndData().getFloat("BarrelBonusValue")), "unit", "+", "color", color}));
                } else {
                    tooltips.add(Localization.translate((String)"bonusmodtip", (String)item.getGndData().getString("BarrelBonus"), (Object[])new Object[]{"value", Float.valueOf(item.getGndData().getFloat("BarrelBonusValue")), "unit", "", "color", color}));
                }
            }
            tooltips.add(Localization.translate((String)"barreltooltip", (String)(item.getGndData().getString("BarrelItem", "HeadShovelWood") + "Tip")));
            tooltips.add(Localization.translate((String)"bodytooltip", (String)"BraceTip"));
            if (item.getGndData().hasKey("BodyBonus")) {
                color = RGBToHex.RGBToHex(gunsmith.settingsGetter.getColor("bonusColor"));
                StringBuilder stringBuilder = new StringBuilder();
                if (item.getGndData().getFloat("BodyBonusValue") >= this.defaultStock(item).getGndData().getFloat(stringBuilder.append("High").append(item.getGndData().getString("BodyBonus")).toString())) {
                    color = RGBToHex.RGBToHex(gunsmith.settingsGetter.getColor("bonusMaxColor"));
                }
                if (item.getGndData().getString("BodyBonus").equalsIgnoreCase("BonusAttackSpeed")) {
                    if (item.getGndData().getFloat("BodyBonusValue") > 0.0f) {
                        tooltips.add(Localization.translate((String)"bonusmodtip", (String)item.getGndData().getString("BodyBonus"), (Object[])new Object[]{"value", Float.valueOf(item.getGndData().getFloat("BodyBonusValue") / 10.0f), "unit", "+", "color", color}));
                    } else {
                        tooltips.add(Localization.translate((String)"bonusmodtip", (String)item.getGndData().getString("BodyBonus"), (Object[])new Object[]{"value", Float.valueOf(item.getGndData().getFloat("BodyBonusValue") / 10.0f), "unit", "", "color", color}));
                    }
                } else if (item.getGndData().getFloat("BodyBonusValue") > 0.0f) {
                    tooltips.add(Localization.translate((String)"bonusmodtip", (String)item.getGndData().getString("BodyBonus"), (Object[])new Object[]{"value", Float.valueOf(item.getGndData().getFloat("BodyBonusValue")), "unit", "+", "color", color}));
                } else {
                    tooltips.add(Localization.translate((String)"bonusmodtip", (String)item.getGndData().getString("BodyBonus"), (Object[])new Object[]{"value", Float.valueOf(item.getGndData().getFloat("BodyBonusValue")), "unit", "", "color", color}));
                }
            }
            tooltips.add(Localization.translate((String)"bodytooltip", (String)(item.getGndData().getString("BodyItem", "BodyShovelBasic") + "Tip")), 400);
            tooltips.add(Localization.translate((String)"stocktooltip", (String)"ShaftTip"));
            if (item.getGndData().hasKey("StockBonus")) {
                color = RGBToHex.RGBToHex(gunsmith.settingsGetter.getColor("bonusColor"));
                StringBuilder stringBuilder = new StringBuilder();
                if (item.getGndData().getFloat("StockBonusValue") >= this.defaultStock(item).getGndData().getFloat(stringBuilder.append("High").append(item.getGndData().getString("StockBonus")).toString())) {
                    color = RGBToHex.RGBToHex(gunsmith.settingsGetter.getColor("bonusMaxColor"));
                }
                if (item.getGndData().getString("StockBonus").equalsIgnoreCase("BonusAttackSpeed")) {
                    if (item.getGndData().getFloat("StockBonusValue") > 0.0f) {
                        tooltips.add(Localization.translate((String)"bonusmodtip", (String)item.getGndData().getString("StockBonus"), (Object[])new Object[]{"value", Float.valueOf(item.getGndData().getFloat("StockBonusValue") / 10.0f), "unit", "+", "color", color}));
                    } else {
                        tooltips.add(Localization.translate((String)"bonusmodtip", (String)item.getGndData().getString("StockBonus"), (Object[])new Object[]{"value", Float.valueOf(item.getGndData().getFloat("StockBonusValue") / 10.0f), "unit", "", "color", color}));
                    }
                } else if (item.getGndData().getFloat("StockBonusValue") > 0.0f) {
                    tooltips.add(Localization.translate((String)"bonusmodtip", (String)item.getGndData().getString("StockBonus"), (Object[])new Object[]{"value", Float.valueOf(item.getGndData().getFloat("StockBonusValue")), "unit", "+", "color", color}));
                } else {
                    tooltips.add(Localization.translate((String)"bonusmodtip", (String)item.getGndData().getString("StockBonus"), (Object[])new Object[]{"value", Float.valueOf(item.getGndData().getFloat("StockBonusValue")), "unit", "", "color", color}));
                }
            }
            tooltips.add(Localization.translate((String)"stocktooltip", (String)(item.getGndData().getString("StockItem", "ShaftPickaxeWood") + "Tip")));
        } else {
            if (item.getGndData().getString("BodyItem", "BodyShovelBasic").equalsIgnoreCase("BodyShovelGrass")) {
                tooltips.add(Localization.translate((String)"itemtooltip", (String)"rclickinvopentip"));
            }
            if (partsKey == statsKey) {
                tooltips.add(Localization.translate((String)"itemtooltip", (String)"holdparts", (String)"shift", (String)statsKey.id));
            } else {
                tooltips.add(Localization.translate((String)"itemtooltip", (String)"holdShift", (String)"shift", (String)statsKey.id));
                tooltips.add(Localization.translate((String)"itemtooltip", (String)"holdCtrl", (String)"ctrl", (String)partsKey.id));
            }
        }
        return tooltips;
    }

    public void addStatTooltips(ItemStatTipList list, InventoryItem currentItem, InventoryItem lastItem, ItemAttackerMob perspective, boolean forceAdd) {
        this.addToolTierTip(list, currentItem, lastItem, (Mob)perspective, true);
        this.addToolDPSTip(list, currentItem, lastItem, perspective, true);
        this.addMobDamageTip(list, currentItem, lastItem, (Mob)perspective);
        this.addAttackSpeedTip(list, currentItem, lastItem, perspective);
        this.addAddedRangeTip(list, currentItem, lastItem, (Mob)perspective, forceAdd);
    }

    public void addToolTierTip(ItemStatTipList list, InventoryItem currentItem, InventoryItem lastItem, Mob perspective, boolean forceAdd) {
        float lastTier;
        float tier = this.getToolTier(currentItem, perspective);
        float f = lastTier = lastItem == null ? tier : this.getToolTier(lastItem, perspective);
        if (tier != lastTier || forceAdd) {
            LocalMessageDoubleItemStatTip tip = new LocalMessageDoubleItemStatTip("itemtooltip", "toolDamageTier", "value", (double)tier, 1);
            if (lastItem != null) {
                tip.setCompareValue((double)lastTier);
            }
            list.add(30, (ItemStatTip)tip);
        }
    }

    public int getToolDps(InventoryItem item, Mob persepctive) {
        int toolDps = this.getFlatToolDps(item);
        int buffModifierFlat = persepctive == null ? 0 : (Integer)persepctive.buffManager.getModifier(BuffModifiers.TOOL_DAMAGE_FLAT);
        float buffModifier = persepctive == null ? 1.0f : ((Float)persepctive.buffManager.getModifier(BuffModifiers.TOOL_DAMAGE)).floatValue();
        return Math.round((float)(toolDps + buffModifierFlat) * buffModifier * ((Float)this.getEnchantment(item).applyModifierLimited(ToolItemModifiers.TOOL_DAMAGE, (Object)((Float)ToolItemModifiers.TOOL_DAMAGE.defaultBuffManagerValue))).floatValue());
    }

    public void addToolDPSTip(ItemStatTipList list, InventoryItem currentItem, InventoryItem lastItem, ItemAttackerMob perspective, boolean forceAdd) {
        int lastDps;
        int dps = this.getToolDps(currentItem, (Mob)perspective);
        int n = lastDps = lastItem == null ? -1 : this.getToolDps(lastItem, (Mob)perspective);
        if (dps > 0 || lastDps > 0 || forceAdd) {
            LocalMessageDoubleItemStatTip tip = new LocalMessageDoubleItemStatTip("itemtooltip", "tooldmg", "value", (double)dps, 0);
            if (lastItem != null) {
                tip.setCompareValue((double)lastDps);
            }
            list.add(50, (ItemStatTip)tip);
        }
        if (GlobalData.debugActive()) {
            String debugToolString = this.getToolHitDamageString(currentItem, perspective);
            StringItemStatTip debugToolTip = new StringItemStatTip(debugToolString){

                public GameMessage toMessage(Color betterColor, Color worseColor, Color neutralColor, boolean showDifference) {
                    return new StaticMessage("Tool hit damage: " + this.getReplaceValue(betterColor, worseColor, neutralColor, showDifference));
                }
            };
            if (lastItem != null) {
                String lastDebugToolString = this.getToolHitDamageString(lastItem, perspective);
                debugToolTip.setCompareValue(lastDebugToolString, dps == lastDps ? null : Boolean.valueOf(dps > lastDps));
            }
            list.add(40, (ItemStatTip)debugToolTip);
        }
    }

    public void addMobDamageTip(ItemStatTipList list, InventoryItem currentItem, InventoryItem lastItem, Mob perspective) {
        float lastMobDamage;
        float mobDamage = this.getFlatAttackDamage((InventoryItem)currentItem).damage;
        float f = lastMobDamage = lastItem == null ? 0.0f : this.getFlatAttackDamage((InventoryItem)lastItem).damage;
        if (mobDamage != 0.0f || lastMobDamage != 0.0f) {
            LocalMessageDoubleItemStatTip tip = new LocalMessageDoubleItemStatTip("itemtooltip", "toolMobDamage", "value", (double)Math.round(mobDamage), 0);
            tip.setValueToString(GameMath::removeDecimalIfZero);
            if (lastItem != null) {
                tip.setCompareValue((double)Math.round(lastMobDamage));
            }
            list.add(51, (ItemStatTip)tip);
        }
    }

    public void addAddedRangeTip(ItemStatTipList list, InventoryItem currentItem, InventoryItem lastItem, Mob perspective, boolean forceAdd) {
        int lastAddedRange;
        int addedRange = this.getAddedRange(currentItem);
        float bonusMod = 1.0f;
        if (this.defaultBarrel(currentItem).getGndData().getString("BarrelBonus", "null").equalsIgnoreCase("BonusRangeMod")) {
            bonusMod += this.defaultBarrel(currentItem).getGndData().getFloat("BarrelBonusValue", 0.0f) / 100.0f;
        }
        if (this.defaultBody(currentItem).getGndData().getString("BodyBonus", "null").equalsIgnoreCase("BonusRangeMod")) {
            bonusMod += this.defaultBody(currentItem).getGndData().getFloat("BodyBonusValue", 0.0f) / 100.0f;
        }
        if (this.defaultStock(currentItem).getGndData().getString("StockBonus", "null").equalsIgnoreCase("BonusRangeMod")) {
            bonusMod += this.defaultStock(currentItem).getGndData().getFloat("StockBonusValue", 0.0f) / 100.0f;
        }
        float rangeMod = bonusMod + this.defaultBarrel(currentItem).getGndData().getFloat("extraRangeMod", 0.0f) + this.defaultBody(currentItem).getGndData().getFloat("extraRangeMod", 0.0f) + this.defaultStock(currentItem).getGndData().getFloat("extraRangeMod", 0.0f);
        int n = lastAddedRange = lastItem == null ? 0 : this.getAddedRange(lastItem);
        if (addedRange != 0 || lastAddedRange != 0 || bonusMod > 1.0f || forceAdd) {
            LocalMessageDoubleItemStatTip tip = addedRange != 0 ? (rangeMod == 1.0f ? new LocalMessageDoubleItemStatTip("itemtooltip", "tooladdrange", "value", (double)addedRange, 0) : new LocalMessageDoubleItemStatTip("itemtooltip", "tooladdrange", "value", (double)addedRange * (3.5 * (double)rangeMod), 0)) : new LocalMessageDoubleItemStatTip("itemtooltip", "tooladdrange", "value", 3.5 * (double)rangeMod, 0);
            tip.setValueToString(value -> value >= 0.0 ? "+" + GameMath.removeDecimalIfZero((double)value) : GameMath.removeDecimalIfZero((double)value));
            if (lastItem != null) {
                tip.setCompareValue((double)lastAddedRange);
            }
            list.add(250, (ItemStatTip)tip);
        }
    }

    public void draw(InventoryItem item, PlayerMob perspective, int x, int y, boolean inInventory) {
        super.draw(item, perspective, x, y, inInventory);
    }

    public void drawIcon(InventoryItem item, PlayerMob perspective, int x, int y, int size, Color color) {
        File texture;
        color = color != null ? MergeFunction.MULTIPLY.merge(color, this.getDrawColor(item, perspective)) : this.getDrawColor(item, perspective);
        new GameSprite(GameTexture.fromFile((String)("items/" + item.getGndData().getString("BarrelItem", "HeadShovelWood")))).initDraw().color(color).size(size).draw(x, y);
        new GameSprite(GameTexture.fromFile((String)("items/" + item.getGndData().getString("StockItem", "ShaftPickaxeWood")))).initDraw().color(color).size(size).draw(x, y);
        new GameSprite(GameTexture.fromFile((String)("items/" + item.getGndData().getString("BodyItem", "BodyShovelBasic")))).initDraw().color(color).size(size).depth(-1.0f).draw(x, y);
        float bonusSize = 0.0f;
        if (ModularBase.getFlatAttackRangeOnlyBonusMod(item, this.defaultBarrel(item), this.defaultBody(item), this.defaultStock(item), this.attackRange.getValue(this.getUpgradeTier(item))) != 1.0f) {
            bonusSize = ModularBase.getFlatAttackRangeOnlyBonusMod(item, this.defaultBarrel(item), this.defaultBody(item), this.defaultStock(item), this.attackRange.getValue(this.getUpgradeTier(item))) - 1.0f;
        }
        if (bonusSize != 0.0f) {
            int bonusSizeText = Math.round((bonusSize + 1.0f) * 100.0f);
            texture = new File(gunsmith.modDirectory + "/attackTextures/" + item.getGndData().getString("BarrelItem", "HeadShovelWood") + item.getGndData().getString("BodyItem", "BodyShovelBasic") + item.getGndData().getString("StockItem", "ShaftPickaxeWood") + bonusSizeText + ".png");
        } else {
            texture = new File(gunsmith.modDirectory + "/attackTextures/" + item.getGndData().getString("BarrelItem", "HeadShovelWood") + item.getGndData().getString("BodyItem", "BodyShovelBasic") + item.getGndData().getString("StockItem", "ShaftPickaxeWood") + ".png");
        }
        if (!texture.exists()) {
            GameTexture baseWorld = GameTexture.fromFile((String)"player/weapons/shovel/ModularShovelBase.png", (boolean)true);
            GameTexture barrelMatTex = GameTexture.fromFile((String)("player/weapons/shovel/" + item.getGndData().getString("BarrelItem", "HeadShovelWood") + ".png"), (boolean)true);
            GameTexture bodyMatTex = GameTexture.fromFile((String)("player/weapons/shovel/" + item.getGndData().getString("BodyItem", "BodyShovelBasic") + ".png"), (boolean)true);
            GameTexture stockMatTex = GameTexture.fromFile((String)("player/weapons/pickaxe/" + item.getGndData().getString("StockItem", "ShaftPickaxeWood") + ".png"), (boolean)true);
            GameTexture attackTex = new GameTexture("debug", baseWorld.getWidth(), baseWorld.getHeight());
            attackTex.merge(barrelMatTex, 0, 0, MergeFunction.NORMAL);
            attackTex.merge(stockMatTex, 6, 6, MergeFunction.NORMAL);
            attackTex.merge(bodyMatTex, 0, 0, MergeFunction.NORMAL);
            int sizeBonusFlat = this.defaultBarrel(item).getGndData().getInt("RangeAdd", 0) + this.defaultBody(item).getGndData().getInt("RangeAdd", 0) + this.defaultStock(item).getGndData().getInt("RangeAdd", 0);
            float sizeBonusMod = 1.0f + this.defaultBarrel(item).getGndData().getFloat("RangeMod", 0.0f) + this.defaultBody(item).getGndData().getFloat("RangeMod", 0.0f) + this.defaultStock(item).getGndData().getFloat("RangeMod", 0.0f);
            if (ModularBase.getFlatAttackRangeOnlyBonusMod(item, this.defaultBarrel(item), this.defaultBody(item), this.defaultStock(item), this.attackRange.getValue(this.getUpgradeTier(item))) != 1.0f) {
                bonusSize = ModularBase.getFlatAttackRangeOnlyBonusMod(item, this.defaultBarrel(item), this.defaultBody(item), this.defaultStock(item), this.attackRange.getValue(this.getUpgradeTier(item))) - 1.0f;
            }
            float sizeMod = (float)(this.attackRange.defaultValue + sizeBonusFlat) * sizeBonusMod / (float)this.attackRange.defaultValue;
            float sizeModBonus = (float)(this.attackRange.defaultValue + sizeBonusFlat) * (sizeBonusMod + bonusSize) / (float)this.attackRange.defaultValue;
            GameTexture finalized = attackTex.resize(Math.round((float)baseWorld.getWidth() * sizeMod), Math.round((float)baseWorld.getHeight() * sizeMod), 1, 1);
            GameTexture finalizedBonus = attackTex.resize(Math.round((float)baseWorld.getWidth() * sizeModBonus), Math.round((float)baseWorld.getHeight() * sizeModBonus), 1, 1);
            attackTex.delete();
            finalized.makeFinal();
            finalizedBonus.makeFinal();
            finalized.saveTextureImage(gunsmith.modDirectory + "/attackTextures/" + item.getGndData().getString("BarrelItem", "HeadShovelWood") + item.getGndData().getString("BodyItem", "BodyShovelBasic") + item.getGndData().getString("StockItem", "ShaftPickaxeWood"));
            if (bonusSize != 0.0f) {
                int bonusSizeText = Math.round((bonusSize + 1.0f) * 100.0f);
                finalizedBonus.saveTextureImage(gunsmith.modDirectory + "/attackTextures/" + item.getGndData().getString("BarrelItem", "HeadShovelWood") + item.getGndData().getString("BodyItem", "BodyShovelBasic") + item.getGndData().getString("StockItem", "ShaftPickaxeWood") + bonusSizeText);
            }
        }
    }

    public GameSprite getAttackSprite(InventoryItem item, PlayerMob player) {
        File texture;
        float bonusSize = 0.0f;
        if (ModularBase.getFlatAttackRangeOnlyBonusMod(item, this.defaultBarrel(item), this.defaultBody(item), this.defaultStock(item), this.attackRange.getValue(this.getUpgradeTier(item))) != 1.0f) {
            bonusSize = ModularBase.getFlatAttackRangeOnlyBonusMod(item, this.defaultBarrel(item), this.defaultBody(item), this.defaultStock(item), this.attackRange.getValue(this.getUpgradeTier(item))) - 1.0f;
        }
        if (bonusSize != 0.0f) {
            int bonusSizeText = Math.round((bonusSize + 1.0f) * 100.0f);
            texture = new File(gunsmith.modDirectory + "/attackTextures/" + item.getGndData().getString("BarrelItem", "HeadShovelWood") + item.getGndData().getString("BodyItem", "BodyShovelBasic") + item.getGndData().getString("StockItem", "ShaftPickaxeWood") + bonusSizeText + ".png");
        } else {
            texture = new File(gunsmith.modDirectory + "/attackTextures/" + item.getGndData().getString("BarrelItem", "HeadShovelWood") + item.getGndData().getString("BodyItem", "BodyShovelBasic") + item.getGndData().getString("StockItem", "ShaftPickaxeWood") + ".png");
        }
        GameTexture attTex = null;
        try {
            attTex = GameTexture.fromFileRawOutside((String)texture.getPath(), (boolean)true);
        }
        catch (FileNotFoundException e) {
            if (!texture.exists()) {
                player.getClient().network.sendPacket((Packet)new RequestItemPacket(player.getPlayerSlot(), item));
            }
            return new GameSprite(GameTexture.fromFile((String)"player/weapons/demonicshovel.png"));
        }
        if (!texture.exists()) {
            player.getClient().network.sendPacket((Packet)new RequestItemPacket(player.getPlayerSlot(), item));
            return new GameSprite(GameTexture.fromFile((String)"player/weapons/demonicshovel.png"));
        }
        return new GameSprite(attTex);
    }

    public GameSprite getWorldItemSprite(InventoryItem item, PlayerMob perspective) {
        return this.getAttackSprite(item, perspective);
    }

    public float getToolTier(InventoryItem item, Mob perspective) {
        return ModularBase.getToolTier(item, perspective, this.defaultBarrel(item), this.defaultBody(item), this.defaultStock(item));
    }

    public int getFlatToolDps(InventoryItem item) {
        return ModularBase.getFlatToolDps(item, this.defaultBarrel(item), this.defaultBody(item), this.defaultStock(item));
    }

    public int getAddedRange(InventoryItem item) {
        return ModularBase.getAddedRange(item, this.defaultBarrel(item), this.defaultBody(item), this.defaultStock(item), (ToolItem)this);
    }

    public int getMiningRange(InventoryItem item, ItemAttackerMob attackerMob) {
        return ModularBase.getMiningRange(item, this.defaultBarrel(item), this.defaultBody(item), this.defaultStock(item), attackerMob, this.getAddedRange(item));
    }

    public float getAttackMovementMod(InventoryItem item) {
        return ModularBase.getAttackMovementMod(item, this.defaultBarrel(item), this.defaultBody(item), this.defaultStock(item));
    }

    public int getFlatAttackAnimTime(InventoryItem item) {
        return ModularBase.getFlatAttackAnimTime(item, this.defaultBarrel(item), this.defaultBody(item), this.defaultStock(item));
    }

    public float getAttackSpeedModifier(InventoryItem item, ItemAttackerMob attackerMob) {
        return ModularBase.getAttackSpeedModifier(item, attackerMob, this.defaultBarrel(item), this.defaultBody(item), this.defaultStock(item), this.damageType, this.getEnchantment(item));
    }

    public GameDamage getFlatAttackDamage(InventoryItem item) {
        return ModularBase.getFlatAttackDamage(item, this.defaultBarrel(item), this.defaultBody(item), this.defaultStock(item), this.getDamageType(item));
    }

    public int getFlatAttackRange(InventoryItem item) {
        return ModularBase.getFlatAttackRange(item, this.defaultBarrel(item), this.defaultBody(item), this.defaultStock(item), this.attackRange.getValue(this.getUpgradeTier(item)));
    }

    public int getKnockback(InventoryItem item, Attacker attacker) {
        return ModularBase.getKnockback(item, this.defaultBarrel(item), this.defaultBody(item), this.defaultStock(item), this.knockback, attacker, this.getEnchantment(item));
    }

    public float getFlatManaCost(InventoryItem item) {
        return ModularBase.getFlatManaCost(item, this.defaultBarrel(item), this.defaultBody(item), this.defaultStock(item), (ToolItem)this);
    }

    public float getResilienceGain(InventoryItem item) {
        return ModularBase.getResilienceGain(item, this.defaultBarrel(item), this.defaultBody(item), this.defaultStock(item), (ToolItem)this, this.resilienceGain);
    }

    public int getFlatLifeCost(InventoryItem item) {
        return ModularBase.getFlatLifeCost(item, this.defaultBarrel(item), this.defaultBody(item), this.defaultStock(item), (ToolItem)this, this.lifeCost.getValue(this.getUpgradeTier(item)));
    }

    public int getLifeSteal(InventoryItem item) {
        return ModularBase.getLifeSteal(item, this.defaultBarrel(item), this.defaultBody(item), this.defaultStock(item), (ToolItem)this, this.lifeSteal.getValue(this.getUpgradeTier(item)));
    }

    public void showAttack(Level level, int x, int y, ItemAttackerMob attackerMob, int attackHeight, InventoryItem item, int animAttack, int seed, GNDItemMap mapContent) {
        if (level.isClient()) {
            SoundManager.playSound((GameSound)GameResources.swing2, (SoundEffect)SoundEffect.effect((PrimitiveSoundEmitter)attackerMob));
        }
        if (this.getFlatLifeCost(item) != 0) {
            attackerMob.setHealth(attackerMob.getHealth() - this.getFlatLifeCost(item), (Attacker)attackerMob);
            attackerMob.sendHealthPacket(false);
        }
        this.consumeMana(attackerMob, item);
    }

    public InventoryItem onAttack(Level level, int x, int y, ItemAttackerMob attackerMob, int attackHeight, InventoryItem item, ItemAttackSlot slot, int animAttack, int seed, GNDItemMap mapContent) {
        super.onAttack(level, x, y, attackerMob, attackHeight, item, slot, animAttack, seed, mapContent);
        return item;
    }

    public InventoryItem startToolItemEventAbilityEvent(Level level, int x, int y, ItemAttackerMob attackerMob, int attackHeight, InventoryItem item, int seed) {
        int animTime = this.getAttackAnimTime(item, attackerMob);
        if (this.defaultBody(item).getGndData().getString("BodyName", "Basic").equalsIgnoreCase("Block")) {
            Ellipse2D.Float circle = new Ellipse2D.Float(attackerMob.x - (float)(this.getFlatAttackRange(item) * 3 / 2), attackerMob.y - (float)(this.getFlatAttackRange(item) * 3 / 2), this.getFlatAttackRange(item) * 3, this.getFlatAttackRange(item) * 3);
            DeflectingToolItemMobAbilityEvent event = new DeflectingToolItemMobAbilityEvent((AttackAnimMob)attackerMob, seed, item, x - attackerMob.getX(), y - attackerMob.getY() + attackHeight, animTime, animTime / 2, circle);
            attackerMob.addAndSendAttackerLevelEvent((LevelEvent)event);
        } else {
            ToolItemMobAbilityEvent event = new ToolItemMobAbilityEvent((AttackAnimMob)attackerMob, seed, item, x - attackerMob.getX(), y - attackerMob.getY() + attackHeight, animTime, animTime);
            attackerMob.addAndSendAttackerLevelEvent((LevelEvent)event);
        }
        return item;
    }

    public void hitMob(InventoryItem item, ToolItemMobAbilityEvent event, Level level, Mob target, Mob attacker) {
        if (this.getLifeSteal(item) > 0) {
            attacker.setHealth(attacker.getHealth() + this.getLifeSteal(item));
            attacker.sendHealthPacket(false);
        }
        if (event.totalHits == 0 && target.canGiveResilience((Attacker)attacker)) {
            attacker.addResilience(this.getResilienceGain(item));
        }
        target.isServerHit(this.getAttackDamage(item), target.x - attacker.x, target.y - attacker.y, (float)this.getKnockback(item, (Attacker)attacker), (Attacker)attacker);
        InventoryItem barrelItem = ItemRegistry.getItem((String)item.getGndData().getString("BarrelItem", "HeadShovelWood")).getDefaultItem(null, 1);
        if (barrelItem.getGndData().getString("BarrelName", "Wood").equalsIgnoreCase("Magma") && level.isServer() && target != null) {
            ActiveBuff ab = new ActiveBuff(BuffRegistry.getBuff((String)"MagmaPickDebuff"), target, 10.0f, (Attacker)attacker);
            target.addBuff(ab, true);
        }
    }

    public boolean canLevelInteract(Level level, int x, int y, ItemAttackerMob attackerMob, InventoryItem item) {
        InventoryItem bodyItem = this.defaultBody(item);
        if (attackerMob.isPlayer) {
            return bodyItem.getGndData().getString("BodyName", "Basic").equalsIgnoreCase("Bucket");
        }
        return false;
    }

    public float getItemCooldownPercent(InventoryItem item, PlayerMob perspective) {
        return 0.0f;
    }

    public ItemControllerInteract getControllerInteract(Level level, PlayerMob player, InventoryItem item, boolean beforeObjectInteract, int interactDir, LinkedList<Rectangle> mobInteractBoxes, LinkedList<Rectangle> tileInteractBoxes) {
        Point2D.Float controllerAimDir = player.getControllerAimDir();
        Point levelPos = this.getControllerAttackLevelPos(level, controllerAimDir.x, controllerAimDir.y, player, item);
        return new ItemControllerInteract(levelPos.x, levelPos.y){

            public DrawOptions getDrawOptions(GameCamera camera) {
                return null;
            }

            public void onCurrentlyFocused(GameCamera camera) {
            }
        };
    }

    public InventoryItem onLevelInteract(Level level, int x, int y, ItemAttackerMob attackerMob, int attackHeight, InventoryItem item, ItemAttackSlot slot, int seed, GNDItemMap mapContent) {
        InventoryItem bodyItem = this.defaultBody(item);
        if (!attackerMob.isPlayer || !level.isClient() || bodyItem.getGndData().getString("BodyName", "Basic").equalsIgnoreCase("Bucket")) {
            // empty if block
        }
        return item;
    }

    public ItemAttackDrawOptions setupItemSpriteAttackDrawOptions(ItemAttackDrawOptions options, InventoryItem item, PlayerMob player, int mobDir, float attackDirX, float attackDirY, float attackProgress, Color itemColor) {
        ItemAttackDrawOptions.AttackItemSprite itemSprite = options.itemSprite(this.getAttackSprite(item, player));
        itemSprite.itemRotatePoint(this.attackXOffset, this.attackYOffset);
        itemSprite.itemRawCoords();
        if (itemColor != null) {
            itemSprite.itemColor(itemColor);
        }
        return itemSprite.itemEnd();
    }

    public float getHitboxSwingAngle(InventoryItem item, int dir) {
        return 150.0f;
    }

    public float getHitboxSwingAngleOffset(InventoryItem item, int dir, float swingAngle) {
        return 50.0f;
    }

    public Function<Float, Float> getSwingDirection(InventoryItem item, AttackAnimMob mob) {
        int attackDir = mob.getDir();
        float animSwingAngle = this.getHitboxSwingAngle(item, attackDir);
        float animSwingAngleOffset = this.getHitboxSwingAngleOffset(item, attackDir, animSwingAngle);
        Function<Float, Float> angleGetter = attackDir == 0 ? (this.getAnimInverted(item) ? progress -> Float.valueOf(-progress.floatValue() * animSwingAngle - animSwingAngleOffset) : progress -> Float.valueOf(180.0f + progress.floatValue() * 2.0f * animSwingAngle + animSwingAngleOffset)) : (attackDir == 1 ? (this.getAnimInverted(item) ? progress -> Float.valueOf(90.0f - progress.floatValue() * animSwingAngle - animSwingAngleOffset) : progress -> Float.valueOf(270.0f + progress.floatValue() * animSwingAngle + animSwingAngleOffset)) : (attackDir == 2 ? (this.getAnimInverted(item) ? progress -> Float.valueOf(180.0f - progress.floatValue() * animSwingAngle - animSwingAngleOffset) : progress -> Float.valueOf(progress.floatValue() * 2.0f * animSwingAngle + animSwingAngleOffset)) : (this.getAnimInverted(item) ? progress -> Float.valueOf(90.0f + progress.floatValue() * animSwingAngle + animSwingAngleOffset) : progress -> Float.valueOf(270.0f - progress.floatValue() * animSwingAngle - animSwingAngleOffset))));
        return angleGetter;
    }

    public ArrayList<Shape> getHitboxes(InventoryItem item, AttackAnimMob mob, int aimX, int aimY, ToolItemMobAbilityEvent event, boolean forDebug) {
        ArrayList<Shape> out = new ArrayList<Shape>();
        int attackRange = Math.round((float)this.getFlatAttackRange(item) * 0.85f);
        float lastProgress = event.lastHitboxProgress;
        float nextProgress = mob.getAttackAnimProgress();
        float circumference = (float)(Math.PI * (double)attackRange);
        float percPerWidth = Math.max(10.0f, this.width) / circumference;
        Point2D.Float base = new Point2D.Float(mob.x, mob.y);
        int attackDir = mob.getDir();
        if (attackDir == 0) {
            base.x += 8.0f;
        } else if (attackDir == 2) {
            base.x -= 8.0f;
        }
        for (float progress = lastProgress; progress <= nextProgress; progress += percPerWidth) {
            float angle = this.getSwingDirection(item, mob).apply(Float.valueOf(progress)).floatValue();
            Point2D.Float dir = GameMath.getAngleDir((float)angle);
            Line2D.Float attackLine = new Line2D.Float(base.x, base.y, dir.x * (float)attackRange + mob.x, dir.y * (float)attackRange + mob.y);
            if (this.width > 0.0f) {
                out.add((Shape)new LineHitbox((Line2D)attackLine, this.width));
            } else {
                out.add(attackLine);
            }
            if (forDebug) continue;
            event.lastHitboxProgress = progress;
        }
        return out;
    }

    public void tick(Inventory inventory, int i, InventoryItem inventoryItem, GameClock gameClock, GameState gameState, Entity entity, TileEntity tileEntity, WorldSettings worldSettings, Consumer<InventoryItem> consumer) {
    }
}

