/*
 * Decompiled with CFR 0.152.
 */
package gunsmith.items.tools;

import gunsmith.gunsmith;
import gunsmith.items.tools.ModularBase;
import gunsmith.items.tools.ModularGun;
import gunsmith.packets.RequestItemPacket;
import gunsmith.projectiles.modifiers.TriDotModifier;
import gunsmith.projectiles.special.LivingShottyLeafBuffed;
import gunsmith.scripts.BurstFireAttackHandler;
import gunsmith.scripts.RGBToHex;
import java.awt.Color;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.LinkedList;
import necesse.engine.input.Control;
import necesse.engine.localization.Localization;
import necesse.engine.network.Packet;
import necesse.engine.network.gameNetworkData.GNDItemMap;
import necesse.engine.registries.ItemRegistry;
import necesse.engine.sound.PrimitiveSoundEmitter;
import necesse.engine.sound.SoundEffect;
import necesse.engine.sound.SoundManager;
import necesse.engine.sound.gameSound.GameSound;
import necesse.engine.util.GameBlackboard;
import necesse.engine.util.GameRandom;
import necesse.entity.mobs.AttackAnimMob;
import necesse.entity.mobs.Attacker;
import necesse.entity.mobs.GameDamage;
import necesse.entity.mobs.Mob;
import necesse.entity.mobs.PlayerMob;
import necesse.entity.mobs.attackHandler.AttackHandler;
import necesse.entity.mobs.buffs.ActiveBuff;
import necesse.entity.mobs.itemAttacker.ItemAttackSlot;
import necesse.entity.mobs.itemAttacker.ItemAttackerMob;
import necesse.entity.projectile.Projectile;
import necesse.entity.projectile.modifiers.ProjectileModifier;
import necesse.entity.projectile.modifiers.ResilienceOnHitProjectileModifier;
import necesse.gfx.GameResources;
import necesse.gfx.camera.GameCamera;
import necesse.gfx.drawOptions.DrawOptions;
import necesse.gfx.gameTexture.GameSprite;
import necesse.gfx.gameTexture.GameTexture;
import necesse.gfx.gameTexture.MergeFunction;
import necesse.gfx.gameTooltips.ListGameTooltips;
import necesse.inventory.InventoryItem;
import necesse.inventory.item.Item;
import necesse.inventory.item.ItemControllerInteract;
import necesse.inventory.item.ItemInteractAction;
import necesse.inventory.item.bulletItem.BulletItem;
import necesse.inventory.item.toolItem.ToolItem;
import necesse.level.maps.Level;

public class ModularShotgun
extends ModularGun
implements ItemInteractAction {
    public ModularShotgun() {
        this.rarity = Item.Rarity.COMMON;
        this.attackAnimTime.setBaseValue(0);
        this.attackXOffset = 10;
        this.attackYOffset = 12;
        this.attackDamage.setBaseValue(0.0f).setUpgradedValue(5.0f, 0.0f);
        this.attackRange.setBaseValue(640);
        this.velocity.setBaseValue(350);
        this.knockback.setBaseValue(50);
        this.resilienceGain.setBaseValue(0.1f);
        this.setItemCategory(new String[]{"TF", "shotgun"});
    }

    public InventoryItem defaultBarrel(InventoryItem item) {
        InventoryItem defaultItem = ItemRegistry.getItem((String)item.getGndData().getString("BarrelItem", "BarrelShotgunIron")).getDefaultItem(null, 1);
        if (item.getGndData().hasKey("BarrelBonus")) {
            item.getGndData().copyKeysToTarget(defaultItem.getGndData(), new String[]{"BarrelBonus", "BarrelBonusValue"});
        }
        return defaultItem;
    }

    public InventoryItem defaultBody(InventoryItem item) {
        InventoryItem defaultItem = ItemRegistry.getItem((String)item.getGndData().getString("BodyItem", "BodyShotgunBasic")).getDefaultItem(null, 1);
        if (item.getGndData().hasKey("BodyBonus")) {
            item.getGndData().copyKeysToTarget(defaultItem.getGndData(), new String[]{"BodyBonus", "BodyBonusValue"});
        }
        return defaultItem;
    }

    public InventoryItem defaultStock(InventoryItem item) {
        InventoryItem defaultItem = ItemRegistry.getItem((String)item.getGndData().getString("StockItem", "StockShotgunIron")).getDefaultItem(null, 1);
        if (item.getGndData().hasKey("StockBonus")) {
            item.getGndData().copyKeysToTarget(defaultItem.getGndData(), new String[]{"StockBonus", "StockBonusValue"});
        }
        return defaultItem;
    }

    protected ListGameTooltips getDisplayNameTooltips(InventoryItem item, PlayerMob perspective, GameBlackboard blackboard) {
        return ModularBase.getDisplayNameTooltips(item, perspective, blackboard, this.defaultBarrel(item), this.defaultBody(item), this.defaultStock(item));
    }

    protected void addExtraGunTooltips(ListGameTooltips tooltips, InventoryItem item, PlayerMob perspective, GameBlackboard blackboard) {
        Control statsKey = Control.getControl((String)gunsmith.settingsGetter.getSelection("viewStats").toString());
        Control partsKey = Control.getControl((String)gunsmith.settingsGetter.getSelection("viewParts").toString());
        if (!partsKey.isDown() && !statsKey.isDown()) {
            super.addExtraGunTooltips(tooltips, item, perspective, blackboard);
        }
    }

    public ListGameTooltips getPreEnchantmentTooltips(InventoryItem item, PlayerMob perspective, GameBlackboard blackboard) {
        Control statsKey = Control.getControl((String)gunsmith.settingsGetter.getSelection("viewStats").toString());
        Control partsKey = Control.getControl((String)gunsmith.settingsGetter.getSelection("viewParts").toString());
        ListGameTooltips tooltips = new ListGameTooltips();
        if (!partsKey.isDown() && !statsKey.isDown()) {
            tooltips = super.getPreEnchantmentTooltips(item, perspective, blackboard);
        }
        if (!item.getGndData().hasKey("StockItem")) {
            return tooltips;
        }
        if (!partsKey.isDown() && !statsKey.isDown()) {
            this.addExtraGunTooltips(tooltips, item, perspective, blackboard);
        }
        if (partsKey.isDown() && partsKey != statsKey) {
            tooltips.add(Localization.translate((String)"itemtooltip", (String)"Barrel") + " " + Localization.translate((String)"item", (String)(item.getGndData().getString("BarrelItem", "BarrelShotgunIron") + "Name")));
            tooltips.add(Localization.translate((String)"itemtooltip", (String)"Body") + " " + Localization.translate((String)"item", (String)(item.getGndData().getString("BodyItem", "BodyShotgunBasic") + "Name")));
            tooltips.add(Localization.translate((String)"itemtooltip", (String)"Stock") + " " + Localization.translate((String)"item", (String)(item.getGndData().getString("StockItem", "StockShotgunIron") + "Name")));
        } else if (statsKey.isDown() || statsKey.isDown() && statsKey == partsKey || partsKey.isDown() && statsKey == partsKey) {
            String color;
            if (statsKey == partsKey) {
                tooltips.add(Localization.translate((String)"itemtooltip", (String)"Barrel") + " " + Localization.translate((String)"item", (String)(item.getGndData().getString("BarrelItem", "BarrelShotgunIron") + "Name")));
                tooltips.add(Localization.translate((String)"itemtooltip", (String)"Body") + " " + Localization.translate((String)"item", (String)(item.getGndData().getString("BodyItem", "BodyShotgunBasic") + "Name")));
                tooltips.add(Localization.translate((String)"itemtooltip", (String)"Stock") + " " + Localization.translate((String)"item", (String)(item.getGndData().getString("StockItem", "StockShotgunIron") + "Name")));
            }
            tooltips.add(Localization.translate((String)"barreltooltip", (String)"BarrelTip"));
            if (item.getGndData().hasKey("BarrelBonus")) {
                color = RGBToHex.RGBToHex(gunsmith.settingsGetter.getColor("bonusColor"));
                StringBuilder stringBuilder = new StringBuilder();
                if (item.getGndData().getFloat("BarrelBonusValue") >= this.defaultStock(item).getGndData().getFloat(stringBuilder.append("High").append(item.getGndData().getString("BarrelBonus")).toString())) {
                    color = RGBToHex.RGBToHex(gunsmith.settingsGetter.getColor("bonusMaxColor"));
                }
                if (item.getGndData().getString("BarrelBonus").equalsIgnoreCase("BonusAttackSpeed")) {
                    if (item.getGndData().getFloat("BarrelBonusValue") > 0.0f) {
                        tooltips.add(Localization.translate((String)"bonusmodtip", (String)item.getGndData().getString("BarrelBonus"), (Object[])new Object[]{"value", Float.valueOf(item.getGndData().getFloat("BarrelBonusValue") / 10.0f), "unit", "+", "color", color}));
                    } else {
                        tooltips.add(Localization.translate((String)"bonusmodtip", (String)item.getGndData().getString("BarrelBonus"), (Object[])new Object[]{"value", Float.valueOf(item.getGndData().getFloat("BarrelBonusValue") / 10.0f), "unit", "", "color", color}));
                    }
                } else if (item.getGndData().getFloat("BarrelBonusValue") > 0.0f) {
                    tooltips.add(Localization.translate((String)"bonusmodtip", (String)item.getGndData().getString("BarrelBonus"), (Object[])new Object[]{"value", Float.valueOf(item.getGndData().getFloat("BarrelBonusValue")), "unit", "+", "color", color}));
                } else {
                    tooltips.add(Localization.translate((String)"bonusmodtip", (String)item.getGndData().getString("BarrelBonus"), (Object[])new Object[]{"value", Float.valueOf(item.getGndData().getFloat("BarrelBonusValue")), "unit", "", "color", color}));
                }
            }
            tooltips.add(Localization.translate((String)"barreltooltip", (String)(item.getGndData().getString("BarrelItem", "BarrelShotgunIron") + "Tip")));
            tooltips.add(Localization.translate((String)"bodytooltip", (String)"BodyTip"));
            if (item.getGndData().hasKey("BodyBonus")) {
                color = RGBToHex.RGBToHex(gunsmith.settingsGetter.getColor("bonusColor"));
                StringBuilder stringBuilder = new StringBuilder();
                if (item.getGndData().getFloat("BodyBonusValue") >= this.defaultStock(item).getGndData().getFloat(stringBuilder.append("High").append(item.getGndData().getString("BodyBonus")).toString())) {
                    color = RGBToHex.RGBToHex(gunsmith.settingsGetter.getColor("bonusMaxColor"));
                }
                if (item.getGndData().getString("BodyBonus").equalsIgnoreCase("BonusAttackSpeed")) {
                    if (item.getGndData().getFloat("BodyBonusValue") > 0.0f) {
                        tooltips.add(Localization.translate((String)"bonusmodtip", (String)item.getGndData().getString("BodyBonus"), (Object[])new Object[]{"value", Float.valueOf(item.getGndData().getFloat("BodyBonusValue") / 10.0f), "unit", "+", "color", color}));
                    } else {
                        tooltips.add(Localization.translate((String)"bonusmodtip", (String)item.getGndData().getString("BodyBonus"), (Object[])new Object[]{"value", Float.valueOf(item.getGndData().getFloat("BodyBonusValue") / 10.0f), "unit", "", "color", color}));
                    }
                } else if (item.getGndData().getFloat("BodyBonusValue") > 0.0f) {
                    tooltips.add(Localization.translate((String)"bonusmodtip", (String)item.getGndData().getString("BodyBonus"), (Object[])new Object[]{"value", Float.valueOf(item.getGndData().getFloat("BodyBonusValue")), "unit", "+", "color", color}));
                } else {
                    tooltips.add(Localization.translate((String)"bonusmodtip", (String)item.getGndData().getString("BodyBonus"), (Object[])new Object[]{"value", Float.valueOf(item.getGndData().getFloat("BodyBonusValue")), "unit", "", "color", color}));
                }
            }
            tooltips.add(Localization.translate((String)"bodytooltip", (String)(item.getGndData().getString("BodyItem", "BodyShotgunBasic") + "Tip")));
            tooltips.add(Localization.translate((String)"stocktooltip", (String)"StockTip"));
            if (item.getGndData().hasKey("StockBonus")) {
                color = RGBToHex.RGBToHex(gunsmith.settingsGetter.getColor("bonusColor"));
                StringBuilder stringBuilder = new StringBuilder();
                if (item.getGndData().getFloat("StockBonusValue") >= item.item.getDefaultItem(null, 1).getGndData().getFloat(stringBuilder.append("High").append(item.getGndData().getString("StockBonus")).toString())) {
                    color = RGBToHex.RGBToHex(gunsmith.settingsGetter.getColor("bonusMaxColor"));
                }
                if (item.getGndData().getString("StockBonus").equalsIgnoreCase("BonusAttackSpeed")) {
                    if (item.getGndData().getFloat("StockBonusValue") > 0.0f) {
                        tooltips.add(Localization.translate((String)"bonusmodtip", (String)item.getGndData().getString("StockBonus"), (Object[])new Object[]{"value", Float.valueOf(item.getGndData().getFloat("StockBonusValue") / 10.0f), "unit", "+", "color", color}));
                    } else {
                        tooltips.add(Localization.translate((String)"bonusmodtip", (String)item.getGndData().getString("StockBonus"), (Object[])new Object[]{"value", Float.valueOf(item.getGndData().getFloat("StockBonusValue") / 10.0f), "unit", "", "color", color}));
                    }
                } else if (item.getGndData().getFloat("StockBonusValue") > 0.0f) {
                    tooltips.add(Localization.translate((String)"bonusmodtip", (String)item.getGndData().getString("StockBonus"), (Object[])new Object[]{"value", Float.valueOf(item.getGndData().getFloat("StockBonusValue")), "unit", "+", "color", color}));
                } else {
                    tooltips.add(Localization.translate((String)"bonusmodtip", (String)item.getGndData().getString("StockBonus"), (Object[])new Object[]{"value", Float.valueOf(item.getGndData().getFloat("StockBonusValue")), "unit", "", "color", color}));
                }
            }
            tooltips.add(Localization.translate((String)"stocktooltip", (String)(item.getGndData().getString("StockItem", "StockShotgunIron") + "Tip")));
        } else {
            if (item.getGndData().getString("BodyItem", "").equalsIgnoreCase("BodyShotgunDoubleBarrel")) {
                tooltips.add(Localization.translate((String)"toolabilitytip", (String)"ShotgunDoubleBarrelTip"), 400);
            }
            if (this.getAmmoConsumeChance(null, item) < 1.0f) {
                tooltips.add(Localization.translate((String)"itemtooltip", (String)"AmmoConsumeTip", (String)"useage", (Object)Math.round((1.0f - this.getAmmoConsumeChance(null, item)) * 100.0f)));
            }
            if (partsKey == statsKey) {
                tooltips.add(Localization.translate((String)"itemtooltip", (String)"holdparts", (String)"shift", (String)statsKey.id));
            } else {
                tooltips.add(Localization.translate((String)"itemtooltip", (String)"holdShift", (String)"shift", (String)statsKey.id));
                tooltips.add(Localization.translate((String)"itemtooltip", (String)"holdCtrl", (String)"ctrl", (String)partsKey.id));
            }
        }
        return tooltips;
    }

    protected void addAmmoTooltips(ListGameTooltips tooltips, InventoryItem item) {
        Control statsKey = Control.getControl((String)gunsmith.settingsGetter.getSelection("viewStats").toString());
        Control partsKey = Control.getControl((String)gunsmith.settingsGetter.getSelection("viewParts").toString());
        if (!partsKey.isDown() && !statsKey.isDown()) {
            super.addAmmoTooltips(tooltips, item);
        }
    }

    public void showAttack(Level level, int x, int y, ItemAttackerMob attackerMob, int attackHeight, InventoryItem item, int animAttack, int seed, GNDItemMap mapContent) {
        InventoryItem bodyItem = ItemRegistry.getItem((String)item.getGndData().getString("BodyItem", "BodyShotgunBasic")).getDefaultItem(null, 1);
        if (level.isClient() && !bodyItem.getGndData().getString("BodyName").equalsIgnoreCase("Burst")) {
            this.playFireSound((AttackAnimMob)attackerMob);
        }
    }

    public void playFireSound(AttackAnimMob mob) {
        SoundManager.playSound((GameSound)GameResources.shotgun, (SoundEffect)SoundEffect.effect((PrimitiveSoundEmitter)mob).volume(0.7f).pitch(GameRandom.globalRandom.getFloatBetween(0.9f, 1.0f)));
    }

    public void draw(InventoryItem item, PlayerMob perspective, int x, int y, boolean inInventory) {
        super.draw(item, perspective, x, y, inInventory);
    }

    public void drawIcon(InventoryItem item, PlayerMob perspective, int x, int y, int size, Color color) {
        color = color != null ? MergeFunction.MULTIPLY.merge(color, this.getDrawColor(item, perspective)) : this.getDrawColor(item, perspective);
        new GameSprite(GameTexture.fromFile((String)("items/" + item.getGndData().getString("BarrelItem", "BarrelShotgunIron")))).initDraw().color(color).size(size).draw(x, y);
        new GameSprite(GameTexture.fromFile((String)("items/" + item.getGndData().getString("StockItem", "StockShotgunIron")))).initDraw().color(color).size(size).draw(x, y);
        new GameSprite(GameTexture.fromFile((String)("items/" + item.getGndData().getString("BodyItem", "BodyShotgunBasic")))).initDraw().color(color).size(size).depth(-1.0f).draw(x, y);
        File texture = new File(gunsmith.modDirectory + "/attackTextures/" + item.getGndData().getString("BarrelItem", "BarrelShotgunIron") + item.getGndData().getString("BodyItem", "BodyShotgunBasic") + item.getGndData().getString("StockItem", "StockShotgunIron") + ".png");
        if (!texture.exists()) {
            GameTexture baseWorld = GameTexture.fromFile((String)"player/weapons/shotgun/ModularShotgunBase.png", (boolean)true);
            GameTexture barrelMatTex = GameTexture.fromFile((String)("player/weapons/shotgun/" + item.getGndData().getString("BarrelItem", "BarrelShotgunIron") + ".png"), (boolean)true);
            GameTexture bodyMatTex = GameTexture.fromFile((String)("player/weapons/shotgun/" + item.getGndData().getString("BodyItem", "BodyShotgunBasic") + ".png"), (boolean)true);
            GameTexture stockMatTex = GameTexture.fromFile((String)("player/weapons/shotgun/" + item.getGndData().getString("StockItem", "StockShotgunIron") + ".png"), (boolean)true);
            GameTexture attackTex = new GameTexture("debug", baseWorld.getWidth(), baseWorld.getHeight());
            attackTex.merge(barrelMatTex, 0, 0, MergeFunction.NORMAL);
            attackTex.merge(stockMatTex, 0, 0, MergeFunction.NORMAL);
            attackTex.merge(bodyMatTex, 0, 0, MergeFunction.NORMAL);
            attackTex.makeFinal();
            attackTex.saveTextureImage(gunsmith.modDirectory + "/attackTextures/" + item.getGndData().getString("BarrelItem", "BarrelShotgunIron") + item.getGndData().getString("BodyItem", "BodyShotgunBasic") + item.getGndData().getString("StockItem", "StockShotgunIron"));
        }
    }

    public GameSprite getAttackSprite(InventoryItem item, PlayerMob player) {
        File texture = new File(gunsmith.modDirectory + "/attackTextures/" + item.getGndData().getString("BarrelItem", "BarrelShotgunIron") + item.getGndData().getString("BodyItem", "BodyShotgunBasic") + item.getGndData().getString("StockItem", "StockShotgunIron") + ".png");
        GameTexture attTex = null;
        try {
            attTex = GameTexture.fromFileRawOutside((String)texture.getPath(), (boolean)true);
        }
        catch (FileNotFoundException e) {
            if (!texture.exists()) {
                player.getClient().network.sendPacket((Packet)new RequestItemPacket(player.getPlayerSlot(), item));
            }
            return new GameSprite(GameTexture.fromFile((String)"player/weapons/shotgun.png"));
        }
        if (!texture.exists()) {
            player.getClient().network.sendPacket((Packet)new RequestItemPacket(player.getPlayerSlot(), item));
            return new GameSprite(GameTexture.fromFile((String)"player/weapons/shotgun.png"));
        }
        return new GameSprite(attTex);
    }

    public GameSprite getWorldItemSprite(InventoryItem item, PlayerMob perspective) {
        return this.getAttackSprite(item, perspective);
    }

    public float getAttackMovementMod(InventoryItem item) {
        return ModularBase.getAttackMovementMod(item, this.defaultBarrel(item), this.defaultBody(item), this.defaultStock(item));
    }

    public int getFlatAttackAnimTime(InventoryItem item) {
        return ModularBase.getFlatAttackAnimTime(item, this.defaultBarrel(item), this.defaultBody(item), this.defaultStock(item));
    }

    public float getAttackSpeedModifier(InventoryItem item, ItemAttackerMob attackerMob) {
        return ModularBase.getAttackSpeedModifier(item, attackerMob, this.defaultBarrel(item), this.defaultBody(item), this.defaultStock(item), this.damageType, this.getEnchantment(item));
    }

    public GameDamage getFlatAttackDamage(InventoryItem item) {
        return ModularBase.getFlatAttackDamage(item, this.defaultBarrel(item), this.defaultBody(item), this.defaultStock(item), this.getDamageType(item));
    }

    public int getFlatAttackRange(InventoryItem item) {
        return ModularBase.getFlatAttackRange(item, this.defaultBarrel(item), this.defaultBody(item), this.defaultStock(item), this.attackRange.getValue(this.getUpgradeTier(item)));
    }

    public int getKnockback(InventoryItem item, Attacker attacker) {
        return ModularBase.getKnockback(item, this.defaultBarrel(item), this.defaultBody(item), this.defaultStock(item), this.knockback, attacker, this.getEnchantment(item));
    }

    public float getFlatManaCost(InventoryItem item) {
        return ModularBase.getFlatManaCost(item, this.defaultBarrel(item), this.defaultBody(item), this.defaultStock(item), (ToolItem)this);
    }

    public float getResilienceGain(InventoryItem item) {
        return ModularBase.getResilienceGain(item, this.defaultBarrel(item), this.defaultBody(item), this.defaultStock(item), (ToolItem)this, this.resilienceGain);
    }

    public int getFlatLifeCost(InventoryItem item) {
        return ModularBase.getFlatLifeCost(item, this.defaultBarrel(item), this.defaultBody(item), this.defaultStock(item), (ToolItem)this, this.lifeCost.getValue(this.getUpgradeTier(item)));
    }

    public int getLifeSteal(InventoryItem item) {
        return ModularBase.getLifeSteal(item, this.defaultBarrel(item), this.defaultBody(item), this.defaultStock(item), (ToolItem)this, this.lifeSteal.getValue(this.getUpgradeTier(item)));
    }

    public float getAmmoConsumeChance(ItemAttackerMob attackerMob, InventoryItem item) {
        return ModularBase.getAmmoConsumeChance(attackerMob, item, this.defaultBarrel(item), this.defaultBody(item), this.defaultStock(item), this.ammoConsumeChance);
    }

    public int getFlatVelocity(InventoryItem item) {
        return ModularBase.getFlatVelocity(item, this.defaultBarrel(item), this.defaultBody(item), this.defaultStock(item), this.velocity, (ToolItem)this);
    }

    public InventoryItem onAttack(Level level, int x, int y, ItemAttackerMob attackerMob, int attackHeight, InventoryItem item, ItemAttackSlot slot, int animAttack, int seed, GNDItemMap mapContent) {
        if (this.defaultBody(item).getGndData().getString("BodyName").equalsIgnoreCase("Burst")) {
            attackerMob.startAttackHandler((AttackHandler)new BurstFireAttackHandler(attackerMob, slot, item, this, seed, x, y, this.defaultBody(item).getGndData().getInt("ReloadTime", 1700), this.defaultBody(item).getGndData().getInt("ShotTime", 170), this.defaultBody(item).getGndData().getInt("ShotAmount", 3)));
        } else {
            super.onAttack(level, x, y, attackerMob, attackHeight, item, slot, animAttack, seed, mapContent);
        }
        return item;
    }

    public Projectile getProjectile(InventoryItem item, BulletItem bulletItem, float x, float y, float targetX, float targetY, int range, ItemAttackerMob attackerMob) {
        return super.getProjectile(item, bulletItem, x, y + 12.0f, targetX, targetY + 12.0f, range, attackerMob);
    }

    protected void fireProjectiles(Level level, int x, int y, ItemAttackerMob attackerMob, InventoryItem item, int seed, BulletItem bullet, boolean dropItem, GNDItemMap mapContent) {
        int range;
        GameRandom random = new GameRandom((long)seed);
        GameRandom spreadRandom = new GameRandom((long)(seed + 10));
        if (this.controlledRange) {
            Point newTarget = this.controlledRangePosition(new GameRandom((long)(seed + 10)), (Mob)attackerMob, x, y, item, this.controlledMinRange, this.controlledInaccuracy);
            x = newTarget.x;
            y = newTarget.y;
            range = (int)attackerMob.getDistance((float)x, (float)y);
        } else {
            range = this.getAttackRange(item);
        }
        if (this.defaultBody(item).getGndData().getString("BodyName").equalsIgnoreCase("Living")) {
            LivingShottyLeafBuffed projectile = new LivingShottyLeafBuffed(level, (Mob)attackerMob, attackerMob.x, attackerMob.y, x, y, this.getProjectileVelocity(item, (Mob)attackerMob), range, this.getAttackDamage(item), this.getKnockback(item, (Attacker)attackerMob));
            this.setModifier((Projectile)projectile, item);
            projectile.setDamage(this.getAttackDamage(item).modFinalMultiplier(1.75f));
            projectile.getUniqueID(new GameRandom((long)seed));
            attackerMob.addAndSendAttackerProjectile((Projectile)projectile, this.moveDist);
            projectile.setAngle(projectile.getAngle() + (spreadRandom.nextFloat() - 0.5f) * ModularBase.getSpread(item, this.defaultBarrel(item), this.defaultBody(item), this.defaultStock(item), 22.0f));
        }
        for (int i = 1; i <= ModularBase.getPellets(item, this.defaultBarrel(item), this.defaultBody(item), this.defaultStock(item)); ++i) {
            Projectile projectile = this.getProjectile(item, bullet, attackerMob.x, attackerMob.y, x, y, range, attackerMob);
            if (projectile.getClass().getSuperclass().getName().substring(projectile.getClass().getSuperclass().getName().length() - 19).equalsIgnoreCase("FollowingProjectile") && !item.getGndData().getString("BarrelName", "Iron").equalsIgnoreCase("Void")) {
                int pellets = ModularBase.getPellets(item, this.defaultBarrel(item), this.defaultBody(item), this.defaultStock(item));
                projectile.setDamage(this.getAttackDamage(item).modFinalMultiplier(1.0f - (float)pellets / 2.0f * 0.1f));
            }
            this.setModifier(projectile, item);
            projectile.dropItem = dropItem;
            projectile.getUniqueID(new GameRandom((long)seed));
            attackerMob.addAndSendAttackerProjectile(projectile, this.moveDist);
            projectile.setAngle(projectile.getAngle() + (spreadRandom.nextFloat() - 0.5f) * ModularBase.getSpread(item, this.defaultBarrel(item), this.defaultBody(item), this.defaultStock(item), 22.0f));
        }
    }

    public boolean canLevelInteract(Level level, int x, int y, ItemAttackerMob attackerMob, InventoryItem item) {
        InventoryItem bodyItem = ItemRegistry.getItem((String)item.getGndData().getString("BodyItem", "BodyShotgunBasic")).getDefaultItem(null, 1);
        Item bulletcheck = attackerMob.getFirstPlayerOwner().getInv().main.getFirstItem(level, attackerMob.getFirstPlayerOwner(), this.ammoItems(), "bulletammo");
        if (bulletcheck != null) {
            return !attackerMob.buffManager.hasBuff("DoubleBarrelCooldownDebuff") && bodyItem.getGndData().getString("BodyName").equalsIgnoreCase("Burst");
        }
        return false;
    }

    public InventoryItem onLevelInteract(Level level, int x, int y, ItemAttackerMob attackerMob, int attackHeight, InventoryItem item, ItemAttackSlot slot, int seed, GNDItemMap mapContent) {
        InventoryItem barrelItem = ItemRegistry.getItem((String)item.getGndData().getString("BarrelItem", "BarrelShotgunIron")).getDefaultItem(null, 1);
        InventoryItem bodyItem = ItemRegistry.getItem((String)item.getGndData().getString("BodyItem", "BodyShotgunBasic")).getDefaultItem(null, 1);
        InventoryItem stockItem = ItemRegistry.getItem((String)item.getGndData().getString("StockItem", "StockShotgunIron")).getDefaultItem(null, 1);
        ActiveBuff ab = new ActiveBuff("DoubleBarrelCooldownDebuff", (Mob)attackerMob, 2.0f, (Attacker)attackerMob);
        attackerMob.buffManager.addBuff(ab, true);
        Item bullet = attackerMob.isPlayer ? attackerMob.getFirstPlayerOwner().getInv().main.getFirstItem(level, attackerMob.getFirstPlayerOwner(), this.ammoItems(), "bulletammo") : ItemRegistry.getItem((String)"simplebullet");
        int range = this.getAttackRange(item);
        GameRandom random = new GameRandom((long)seed);
        GameRandom spreadRandom = new GameRandom((long)(seed + 10));
        for (int i = 1; i <= ModularBase.getPellets(item, barrelItem, bodyItem, stockItem) * 2; ++i) {
            Projectile projectile = this.getProjectile(item, (BulletItem)bullet, attackerMob.x, attackerMob.y, x, y, range, attackerMob);
            projectile.setAngle(projectile.getAngle() + (spreadRandom.nextFloat() - 0.5f) * ModularBase.getSpread(item, barrelItem, bodyItem, stockItem, 28.0f));
            this.setModifier(projectile, item);
            projectile.dropItem = true;
            projectile.getUniqueID(new GameRandom((long)seed));
            attackerMob.addAndSendAttackerProjectile(projectile, this.moveDist);
        }
        if (attackerMob.isPlayer) {
            attackerMob.getFirstPlayerOwner().getInv().removeItems(attackerMob.getFirstPlayerOwner().getInv().main.getFirstItem(level, attackerMob.getFirstPlayerOwner(), this.ammoItems(), "bulletammo"), 1, true, true, true, true, "bulletammo");
        }
        SoundManager.playSound((GameSound)GameResources.shotgun, (SoundEffect)SoundEffect.effect((PrimitiveSoundEmitter)attackerMob).volume(1.1f).pitch(GameRandom.globalRandom.getFloatBetween(0.8f, 0.85f)));
        SoundManager.playSound((GameSound)GameResources.explosionLight, (SoundEffect)SoundEffect.effect((PrimitiveSoundEmitter)attackerMob).volume(0.75f).pitch(1.0f));
        return item;
    }

    public void setModifier(Projectile projectile, InventoryItem item) {
        projectile.setModifier((ProjectileModifier)new ResilienceOnHitProjectileModifier(this.getResilienceGain(item)));
        if (item.getGndData().getString("BodyItem", "BodyShotgunBasic").equalsIgnoreCase("BodyShotgunNaturesWrath")) {
            projectile.setModifier((ProjectileModifier)new TriDotModifier(30.0f, this.getResilienceGain(item)));
        }
    }

    public float getItemCooldownPercent(InventoryItem item, PlayerMob perspective) {
        InventoryItem bodyItem = ItemRegistry.getItem((String)item.getGndData().getString("BodyItem", "BodyShotgunBasic")).getDefaultItem(null, 1);
        if (bodyItem.getGndData().getString("BodyName").equalsIgnoreCase("Burst")) {
            return perspective.buffManager.getBuffDurationLeftSeconds("DoubleBarrelCooldownDebuff") / 2.0f;
        }
        return 0.0f;
    }

    public ItemControllerInteract getControllerInteract(Level level, PlayerMob player, InventoryItem item, boolean beforeObjectInteract, int interactDir, LinkedList<Rectangle> mobInteractBoxes, LinkedList<Rectangle> tileInteractBoxes) {
        Point2D.Float controllerAimDir = player.getControllerAimDir();
        Point levelPos = this.getControllerAttackLevelPos(level, controllerAimDir.x, controllerAimDir.y, player, item);
        return new ItemControllerInteract(levelPos.x, levelPos.y){

            public DrawOptions getDrawOptions(GameCamera camera) {
                return null;
            }

            public void onCurrentlyFocused(GameCamera camera) {
            }
        };
    }
}

