/*
 * Decompiled with CFR 0.152.
 */
package gunsmith.items.tools;

import gunsmith.gunsmith;
import gunsmith.items.tools.ModularBase;
import gunsmith.items.tools.ModularGun;
import gunsmith.packets.RequestItemPacket;
import gunsmith.projectiles.modifiers.CrystalizeModifier;
import gunsmith.scripts.BuildupFireAttackHandler;
import gunsmith.scripts.BurstFireAttackHandler;
import gunsmith.scripts.MisfireAttackHandler;
import gunsmith.scripts.RGBToHex;
import gunsmith.scripts.RipperAttackHandler;
import java.awt.Color;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.LinkedList;
import necesse.engine.input.Control;
import necesse.engine.localization.Localization;
import necesse.engine.network.Packet;
import necesse.engine.network.gameNetworkData.GNDItemMap;
import necesse.engine.registries.ItemRegistry;
import necesse.engine.sound.PrimitiveSoundEmitter;
import necesse.engine.sound.SoundEffect;
import necesse.engine.sound.SoundManager;
import necesse.engine.sound.gameSound.GameSound;
import necesse.engine.util.GameBlackboard;
import necesse.engine.util.GameRandom;
import necesse.entity.mobs.AttackAnimMob;
import necesse.entity.mobs.Attacker;
import necesse.entity.mobs.GameDamage;
import necesse.entity.mobs.Mob;
import necesse.entity.mobs.PlayerMob;
import necesse.entity.mobs.attackHandler.AttackHandler;
import necesse.entity.mobs.itemAttacker.ItemAttackSlot;
import necesse.entity.mobs.itemAttacker.ItemAttackerMob;
import necesse.entity.projectile.Projectile;
import necesse.entity.projectile.modifiers.ProjectileModifier;
import necesse.entity.projectile.modifiers.ResilienceOnHitProjectileModifier;
import necesse.gfx.GameResources;
import necesse.gfx.camera.GameCamera;
import necesse.gfx.drawOptions.DrawOptions;
import necesse.gfx.drawOptions.itemAttack.ItemAttackDrawOptions;
import necesse.gfx.gameTexture.GameSprite;
import necesse.gfx.gameTexture.GameTexture;
import necesse.gfx.gameTexture.MergeFunction;
import necesse.gfx.gameTooltips.ListGameTooltips;
import necesse.inventory.InventoryItem;
import necesse.inventory.item.Item;
import necesse.inventory.item.ItemControllerInteract;
import necesse.inventory.item.ItemInteractAction;
import necesse.inventory.item.bulletItem.BulletItem;
import necesse.inventory.item.toolItem.ToolItem;
import necesse.level.maps.Level;

public class ModularSMG
extends ModularGun
implements ItemInteractAction {
    public ModularSMG() {
        this.rarity = Item.Rarity.COMMON;
        this.attackAnimTime.setBaseValue(200);
        this.attackXOffset = 20;
        this.attackYOffset = 20;
        this.moveDist = 50;
        this.attackDamage.setBaseValue(0.0f).setUpgradedValue(5.0f, 0.0f);
        this.attackRange.setBaseValue(720);
        this.ammoConsumeChance = 0.5f;
        this.velocity.setBaseValue(400);
        this.knockback.setBaseValue(20);
        this.setItemCategory(new String[]{"TF", "machinegun"});
    }

    public InventoryItem defaultBarrel(InventoryItem item) {
        return ItemRegistry.getItem((String)item.getGndData().getString("BarrelItem", "BarrelMachinegunIron")).getDefaultItem(null, 1);
    }

    public InventoryItem defaultBody(InventoryItem item) {
        return ItemRegistry.getItem((String)item.getGndData().getString("BodyItem", "BodyMachinegunBasic")).getDefaultItem(null, 1);
    }

    public InventoryItem defaultStock(InventoryItem item) {
        return ItemRegistry.getItem((String)item.getGndData().getString("StockItem", "StockMachinegunIron")).getDefaultItem(null, 1);
    }

    protected ListGameTooltips getDisplayNameTooltips(InventoryItem item, PlayerMob perspective, GameBlackboard blackboard) {
        return ModularBase.getDisplayNameTooltips(item, perspective, blackboard, this.defaultBarrel(item), this.defaultBody(item), this.defaultStock(item));
    }

    protected void addExtraGunTooltips(ListGameTooltips tooltips, InventoryItem item, PlayerMob perspective, GameBlackboard blackboard) {
        Control statsKey = Control.getControl((String)gunsmith.settingsGetter.getSelection("viewStats").toString());
        Control partsKey = Control.getControl((String)gunsmith.settingsGetter.getSelection("viewParts").toString());
        if (!partsKey.isDown() && !statsKey.isDown()) {
            super.addExtraGunTooltips(tooltips, item, perspective, blackboard);
        }
    }

    public ListGameTooltips getPreEnchantmentTooltips(InventoryItem item, PlayerMob perspective, GameBlackboard blackboard) {
        Control statsKey = Control.getControl((String)gunsmith.settingsGetter.getSelection("viewStats").toString());
        Control partsKey = Control.getControl((String)gunsmith.settingsGetter.getSelection("viewParts").toString());
        ListGameTooltips tooltips = new ListGameTooltips();
        if (!partsKey.isDown() && !statsKey.isDown()) {
            tooltips = super.getPreEnchantmentTooltips(item, perspective, blackboard);
        }
        if (!item.getGndData().hasKey("StockItem")) {
            return tooltips;
        }
        if (!partsKey.isDown() && !statsKey.isDown()) {
            this.addExtraGunTooltips(tooltips, item, perspective, blackboard);
        }
        if (partsKey.isDown() && partsKey != statsKey) {
            tooltips.add(Localization.translate((String)"itemtooltip", (String)"Barrel") + " " + Localization.translate((String)"item", (String)(item.getGndData().getString("BarrelItem", "BarrelMachinegunIron") + "Name")));
            tooltips.add(Localization.translate((String)"itemtooltip", (String)"Body") + " " + Localization.translate((String)"item", (String)(item.getGndData().getString("BodyItem", "BodyMachinegunBasic") + "Name")));
            tooltips.add(Localization.translate((String)"itemtooltip", (String)"Stock") + " " + Localization.translate((String)"item", (String)(item.getGndData().getString("StockItem", "StockMachinegunIron") + "Name")));
        } else if (statsKey.isDown() || statsKey.isDown() && statsKey == partsKey || partsKey.isDown() && statsKey == partsKey) {
            String color;
            if (statsKey == partsKey) {
                tooltips.add(Localization.translate((String)"itemtooltip", (String)"Barrel") + " " + Localization.translate((String)"item", (String)(item.getGndData().getString("BarrelItem", "BarrelMachinegunIron") + "Name")));
                tooltips.add(Localization.translate((String)"itemtooltip", (String)"Body") + " " + Localization.translate((String)"item", (String)(item.getGndData().getString("BodyItem", "BodyMachinegunBasic") + "Name")));
                tooltips.add(Localization.translate((String)"itemtooltip", (String)"Stock") + " " + Localization.translate((String)"item", (String)(item.getGndData().getString("StockItem", "StockMachinegunIron") + "Name")));
            }
            tooltips.add(Localization.translate((String)"barreltooltip", (String)"BarrelTip"));
            if (item.getGndData().hasKey("BarrelBonus")) {
                color = RGBToHex.RGBToHex(gunsmith.settingsGetter.getColor("bonusColor"));
                StringBuilder stringBuilder = new StringBuilder();
                if (item.getGndData().getFloat("BarrelBonusValue") >= this.defaultStock(item).getGndData().getFloat(stringBuilder.append("High").append(item.getGndData().getString("BarrelBonus")).toString())) {
                    color = RGBToHex.RGBToHex(gunsmith.settingsGetter.getColor("bonusMaxColor"));
                }
                if (item.getGndData().getString("BarrelBonus").equalsIgnoreCase("BonusAttackSpeed")) {
                    if (item.getGndData().getFloat("BarrelBonusValue") > 0.0f) {
                        tooltips.add(Localization.translate((String)"bonusmodtip", (String)item.getGndData().getString("BarrelBonus"), (Object[])new Object[]{"value", Float.valueOf(item.getGndData().getFloat("BarrelBonusValue") / 10.0f), "unit", "+", "color", color}));
                    } else {
                        tooltips.add(Localization.translate((String)"bonusmodtip", (String)item.getGndData().getString("BarrelBonus"), (Object[])new Object[]{"value", Float.valueOf(item.getGndData().getFloat("BarrelBonusValue") / 10.0f), "unit", "", "color", color}));
                    }
                } else if (item.getGndData().getFloat("BarrelBonusValue") > 0.0f) {
                    tooltips.add(Localization.translate((String)"bonusmodtip", (String)item.getGndData().getString("BarrelBonus"), (Object[])new Object[]{"value", Float.valueOf(item.getGndData().getFloat("BarrelBonusValue")), "unit", "+", "color", color}));
                } else {
                    tooltips.add(Localization.translate((String)"bonusmodtip", (String)item.getGndData().getString("BarrelBonus"), (Object[])new Object[]{"value", Float.valueOf(item.getGndData().getFloat("BarrelBonusValue")), "unit", "", "color", color}));
                }
            }
            tooltips.add(Localization.translate((String)"barreltooltip", (String)(item.getGndData().getString("BarrelItem", "BarrelMachinegunIron") + "Tip")));
            tooltips.add(Localization.translate((String)"bodytooltip", (String)"BodyTip"));
            if (item.getGndData().hasKey("BodyBonus")) {
                color = RGBToHex.RGBToHex(gunsmith.settingsGetter.getColor("bonusColor"));
                StringBuilder stringBuilder = new StringBuilder();
                if (item.getGndData().getFloat("BodyBonusValue") >= this.defaultStock(item).getGndData().getFloat(stringBuilder.append("High").append(item.getGndData().getString("BodyBonus")).toString())) {
                    color = RGBToHex.RGBToHex(gunsmith.settingsGetter.getColor("bonusMaxColor"));
                }
                if (item.getGndData().getString("BodyBonus").equalsIgnoreCase("BonusAttackSpeed")) {
                    if (item.getGndData().getFloat("BodyBonusValue") > 0.0f) {
                        tooltips.add(Localization.translate((String)"bonusmodtip", (String)item.getGndData().getString("BodyBonus"), (Object[])new Object[]{"value", Float.valueOf(item.getGndData().getFloat("BodyBonusValue") / 10.0f), "unit", "+", "color", color}));
                    } else {
                        tooltips.add(Localization.translate((String)"bonusmodtip", (String)item.getGndData().getString("BodyBonus"), (Object[])new Object[]{"value", Float.valueOf(item.getGndData().getFloat("BodyBonusValue") / 10.0f), "unit", "", "color", color}));
                    }
                } else if (item.getGndData().getFloat("BodyBonusValue") > 0.0f) {
                    tooltips.add(Localization.translate((String)"bonusmodtip", (String)item.getGndData().getString("BodyBonus"), (Object[])new Object[]{"value", Float.valueOf(item.getGndData().getFloat("BodyBonusValue")), "unit", "+", "color", color}));
                } else {
                    tooltips.add(Localization.translate((String)"bonusmodtip", (String)item.getGndData().getString("BodyBonus"), (Object[])new Object[]{"value", Float.valueOf(item.getGndData().getFloat("BodyBonusValue")), "unit", "", "color", color}));
                }
            }
            tooltips.add(Localization.translate((String)"bodytooltip", (String)(item.getGndData().getString("BodyItem", "BodyMachinegunBasic") + "Tip")));
            tooltips.add(Localization.translate((String)"stocktooltip", (String)"StockTip"));
            if (item.getGndData().hasKey("StockBonus")) {
                color = RGBToHex.RGBToHex(gunsmith.settingsGetter.getColor("bonusColor"));
                StringBuilder stringBuilder = new StringBuilder();
                if (item.getGndData().getFloat("StockBonusValue") >= item.item.getDefaultItem(null, 1).getGndData().getFloat(stringBuilder.append("High").append(item.getGndData().getString("StockBonus")).toString())) {
                    color = RGBToHex.RGBToHex(gunsmith.settingsGetter.getColor("bonusMaxColor"));
                }
                if (item.getGndData().getString("StockBonus").equalsIgnoreCase("BonusAttackSpeed")) {
                    if (item.getGndData().getFloat("StockBonusValue") > 0.0f) {
                        tooltips.add(Localization.translate((String)"bonusmodtip", (String)item.getGndData().getString("StockBonus"), (Object[])new Object[]{"value", Float.valueOf(item.getGndData().getFloat("StockBonusValue") / 10.0f), "unit", "+", "color", color}));
                    } else {
                        tooltips.add(Localization.translate((String)"bonusmodtip", (String)item.getGndData().getString("StockBonus"), (Object[])new Object[]{"value", Float.valueOf(item.getGndData().getFloat("StockBonusValue") / 10.0f), "unit", "", "color", color}));
                    }
                } else if (item.getGndData().getFloat("StockBonusValue") > 0.0f) {
                    tooltips.add(Localization.translate((String)"bonusmodtip", (String)item.getGndData().getString("StockBonus"), (Object[])new Object[]{"value", Float.valueOf(item.getGndData().getFloat("StockBonusValue")), "unit", "+", "color", color}));
                } else {
                    tooltips.add(Localization.translate((String)"bonusmodtip", (String)item.getGndData().getString("StockBonus"), (Object[])new Object[]{"value", Float.valueOf(item.getGndData().getFloat("StockBonusValue")), "unit", "", "color", color}));
                }
            }
            tooltips.add(Localization.translate((String)"stocktooltip", (String)(item.getGndData().getString("StockItem", "StockMachinegunIron") + "Tip")));
        } else {
            if (this.getAmmoConsumeChance(null, item) < 1.0f) {
                tooltips.add(Localization.translate((String)"itemtooltip", (String)"AmmoConsumeTip", (String)"useage", (Object)Math.round((1.0f - this.getAmmoConsumeChance(null, item)) * 100.0f)));
            }
            if (partsKey == statsKey) {
                tooltips.add(Localization.translate((String)"itemtooltip", (String)"holdparts", (String)"shift", (String)statsKey.id));
            } else {
                tooltips.add(Localization.translate((String)"itemtooltip", (String)"holdShift", (String)"shift", (String)statsKey.id));
                tooltips.add(Localization.translate((String)"itemtooltip", (String)"holdCtrl", (String)"ctrl", (String)partsKey.id));
            }
        }
        return tooltips;
    }

    protected void addAmmoTooltips(ListGameTooltips tooltips, InventoryItem item) {
        Control statsKey = Control.getControl((String)gunsmith.settingsGetter.getSelection("viewStats").toString());
        Control partsKey = Control.getControl((String)gunsmith.settingsGetter.getSelection("viewParts").toString());
        if (!partsKey.isDown() && !statsKey.isDown()) {
            super.addAmmoTooltips(tooltips, item);
        }
    }

    public void showAttack(Level level, int x, int y, ItemAttackerMob attackerMob, int attackHeight, InventoryItem item, int animAttack, int seed, GNDItemMap mapContent) {
        InventoryItem bodyItem = ItemRegistry.getItem((String)item.getGndData().getString("BodyItem", "BodyMachinegunBasic")).getDefaultItem(null, 1);
        if (level.isClient() && !bodyItem.getGndData().getString("BodyName").equalsIgnoreCase("Burst") && !bodyItem.getGndData().getString("BodyName").equalsIgnoreCase("Ripper") && !bodyItem.getGndData().getString("BodyName").equalsIgnoreCase("Economic")) {
            this.playFireSound((AttackAnimMob)attackerMob);
        }
    }

    public void playFireSound(AttackAnimMob mob) {
        SoundManager.playSound((GameSound)GameResources.handgun, (SoundEffect)SoundEffect.effect((PrimitiveSoundEmitter)mob).volume(0.7f).pitch(GameRandom.globalRandom.getFloatBetween(1.15f, 1.2f)));
    }

    public void draw(InventoryItem item, PlayerMob perspective, int x, int y, boolean inInventory) {
        super.draw(item, perspective, x, y, inInventory);
    }

    public void drawIcon(InventoryItem item, PlayerMob perspective, int x, int y, int size, Color color) {
        color = color != null ? MergeFunction.MULTIPLY.merge(color, this.getDrawColor(item, perspective)) : this.getDrawColor(item, perspective);
        new GameSprite(GameTexture.fromFile((String)("items/" + item.getGndData().getString("BarrelItem", "BarrelMachinegunIron")))).initDraw().color(color).size(size).draw(x, y);
        new GameSprite(GameTexture.fromFile((String)("items/" + item.getGndData().getString("StockItem", "StockMachinegunIron")))).initDraw().color(color).size(size).draw(x, y);
        new GameSprite(GameTexture.fromFile((String)("items/" + item.getGndData().getString("BodyItem", "BodyMachinegunBasic")))).initDraw().color(color).size(size).depth(-1.0f).draw(x, y);
        File texture = new File(gunsmith.modDirectory + "/attackTextures/" + item.getGndData().getString("BarrelItem", "BarrelMachinegunIron") + item.getGndData().getString("BodyItem", "BodyMachinegunBasic") + item.getGndData().getString("StockItem", "StockMachinegunIron") + ".png");
        if (!texture.exists()) {
            GameTexture baseWorld = GameTexture.fromFile((String)"player/weapons/Machinegun/ModularMachinegunBase.png", (boolean)true);
            GameTexture barrelMatTex = GameTexture.fromFile((String)("player/weapons/Machinegun/" + item.getGndData().getString("BarrelItem", "BarrelMachinegunIron") + ".png"), (boolean)true);
            GameTexture bodyMatTex = GameTexture.fromFile((String)("player/weapons/Machinegun/" + item.getGndData().getString("BodyItem", "BodyMachinegunBasic") + ".png"), (boolean)true);
            GameTexture stockMatTex = GameTexture.fromFile((String)("player/weapons/Machinegun/" + item.getGndData().getString("StockItem", "StockMachinegunIron") + ".png"), (boolean)true);
            GameTexture attackTex = new GameTexture("debug", baseWorld.getWidth(), baseWorld.getHeight());
            attackTex.merge(barrelMatTex, 0, 0, MergeFunction.NORMAL);
            attackTex.merge(stockMatTex, 0, 0, MergeFunction.NORMAL);
            attackTex.merge(bodyMatTex, 0, 0, MergeFunction.NORMAL);
            attackTex.makeFinal();
            attackTex.saveTextureImage(gunsmith.modDirectory + "/attackTextures/" + item.getGndData().getString("BarrelItem", "BarrelMachinegunIron") + item.getGndData().getString("BodyItem", "BodyMachinegunBasic") + item.getGndData().getString("StockItem", "StockMachinegunIron"));
        }
    }

    public GameSprite getAttackSprite(InventoryItem item, PlayerMob player) {
        File texture = new File(gunsmith.modDirectory + "/attackTextures/" + item.getGndData().getString("BarrelItem", "BarrelShotgunIron") + item.getGndData().getString("BodyItem", "BodyShotgunBasic") + item.getGndData().getString("StockItem", "StockShotgunIron") + ".png");
        GameTexture attTex = null;
        try {
            attTex = GameTexture.fromFileRawOutside((String)texture.getPath(), (boolean)true);
        }
        catch (FileNotFoundException e) {
            if (!texture.exists()) {
                player.getClient().network.sendPacket((Packet)new RequestItemPacket(player.getPlayerSlot(), item));
            }
            return new GameSprite(GameTexture.fromFile((String)"player/weapons/shotgun.png"));
        }
        if (!texture.exists()) {
            player.getClient().network.sendPacket((Packet)new RequestItemPacket(player.getPlayerSlot(), item));
            return new GameSprite(GameTexture.fromFile((String)"player/weapons/shotgun.png"));
        }
        return new GameSprite(attTex);
    }

    public GameSprite getWorldItemSprite(InventoryItem item, PlayerMob perspective) {
        return this.getAttackSprite(item, perspective);
    }

    public void setDrawAttackRotation(InventoryItem item, ItemAttackDrawOptions drawOptions, float attackDirX, float attackDirY, float attackProgress) {
        super.setDrawAttackRotation(item, drawOptions, attackDirX, attackDirY, attackProgress);
        drawOptions.addedArmPosOffset(-3, 5);
    }

    public float getAttackMovementMod(InventoryItem item) {
        return ModularBase.getAttackMovementMod(item, this.defaultBarrel(item), this.defaultBody(item), this.defaultStock(item));
    }

    public int getFlatAttackAnimTime(InventoryItem item) {
        return ModularBase.getFlatAttackAnimTime(item, this.defaultBarrel(item), this.defaultBody(item), this.defaultStock(item));
    }

    public float getAttackSpeedModifier(InventoryItem item, ItemAttackerMob attackerMob) {
        return ModularBase.getAttackSpeedModifier(item, attackerMob, this.defaultBarrel(item), this.defaultBody(item), this.defaultStock(item), this.damageType, this.getEnchantment(item));
    }

    public GameDamage getFlatAttackDamage(InventoryItem item) {
        return ModularBase.getFlatAttackDamage(item, this.defaultBarrel(item), this.defaultBody(item), this.defaultStock(item), this.getDamageType(item));
    }

    public int getFlatAttackRange(InventoryItem item) {
        return ModularBase.getFlatAttackRange(item, this.defaultBarrel(item), this.defaultBody(item), this.defaultStock(item), this.attackRange.getValue(this.getUpgradeTier(item)));
    }

    public int getKnockback(InventoryItem item, Attacker attacker) {
        return ModularBase.getKnockback(item, this.defaultBarrel(item), this.defaultBody(item), this.defaultStock(item), this.knockback, attacker, this.getEnchantment(item));
    }

    public float getFlatManaCost(InventoryItem item) {
        return ModularBase.getFlatManaCost(item, this.defaultBarrel(item), this.defaultBody(item), this.defaultStock(item), (ToolItem)this);
    }

    public float getResilienceGain(InventoryItem item) {
        return ModularBase.getResilienceGain(item, this.defaultBarrel(item), this.defaultBody(item), this.defaultStock(item), (ToolItem)this, this.resilienceGain);
    }

    public int getFlatLifeCost(InventoryItem item) {
        return ModularBase.getFlatLifeCost(item, this.defaultBarrel(item), this.defaultBody(item), this.defaultStock(item), (ToolItem)this, this.lifeCost.getValue(this.getUpgradeTier(item)));
    }

    public int getLifeSteal(InventoryItem item) {
        return ModularBase.getLifeSteal(item, this.defaultBarrel(item), this.defaultBody(item), this.defaultStock(item), (ToolItem)this, this.lifeSteal.getValue(this.getUpgradeTier(item)));
    }

    public float getAmmoConsumeChance(ItemAttackerMob attackerMob, InventoryItem item) {
        return ModularBase.getAmmoConsumeChance(attackerMob, item, this.defaultBarrel(item), this.defaultBody(item), this.defaultStock(item), this.ammoConsumeChance);
    }

    public int getFlatVelocity(InventoryItem item) {
        return ModularBase.getFlatVelocity(item, this.defaultBarrel(item), this.defaultBody(item), this.defaultStock(item), this.velocity, (ToolItem)this);
    }

    public InventoryItem onAttack(Level level, int x, int y, ItemAttackerMob attackerMob, int attackHeight, InventoryItem item, ItemAttackSlot slot, int animAttack, int seed, GNDItemMap mapContent) {
        InventoryItem bodyItem = ItemRegistry.getItem((String)item.getGndData().getString("BodyItem", "BodyMachinegunBasic")).getDefaultItem(null, 1);
        if (bodyItem.getGndData().getString("BodyName").equalsIgnoreCase("Burst")) {
            attackerMob.startAttackHandler((AttackHandler)new BurstFireAttackHandler(attackerMob, slot, item, this, seed, x, y, bodyItem.getGndData().getInt("ReloadTime", 1700), bodyItem.getGndData().getInt("ShotTime", 170), bodyItem.getGndData().getInt("ShotAmount", 3)));
        } else if (bodyItem.getGndData().getString("BodyName").equalsIgnoreCase("Ripper")) {
            attackerMob.startAttackHandler((AttackHandler)new RipperAttackHandler(attackerMob, slot, item, this, seed, x, y));
        } else if (bodyItem.getGndData().getString("BodyName").equalsIgnoreCase("Economic")) {
            attackerMob.startAttackHandler((AttackHandler)new MisfireAttackHandler(attackerMob, slot, item, this, seed, x, y, bodyItem.getGndData().getFloat("MisfireChance", 0.12f)));
        } else if (bodyItem.getGndData().getString("BodyName").equalsIgnoreCase("Chaingun")) {
            attackerMob.startAttackHandler((AttackHandler)new BuildupFireAttackHandler(attackerMob, slot, item, this, seed, x, y));
        } else {
            super.onAttack(level, x, y, attackerMob, attackHeight, item, slot, animAttack, seed, mapContent);
        }
        return item;
    }

    public Projectile getProjectile(InventoryItem item, BulletItem bulletItem, float x, float y, float targetX, float targetY, int range, ItemAttackerMob attackerMob) {
        InventoryItem barrelItem = ItemRegistry.getItem((String)item.getGndData().getString("BarrelItem", "BarrelMachinegunIron")).getDefaultItem(null, 1);
        InventoryItem bodyItem = ItemRegistry.getItem((String)item.getGndData().getString("BodyItem", "BodyMachinegunBasic")).getDefaultItem(null, 1);
        InventoryItem stockItem = ItemRegistry.getItem((String)item.getGndData().getString("StockItem", "StockMachinegunIron")).getDefaultItem(null, 1);
        return super.getProjectile(item, bulletItem, x, y + 12.0f, targetX, targetY + 12.0f, range + barrelItem.getGndData().getInt("RangeAdd", 0) + bodyItem.getGndData().getInt("RangeAdd", 0) + stockItem.getGndData().getInt("RangeAdd", 0), attackerMob);
    }

    protected void fireProjectiles(Level level, int x, int y, ItemAttackerMob attackerMob, InventoryItem item, int seed, BulletItem bullet, boolean dropItem, GNDItemMap mapContent) {
        int range;
        InventoryItem barrelItem = ItemRegistry.getItem((String)item.getGndData().getString("BarrelItem", "BarrelMachinegunIron")).getDefaultItem(null, 1);
        InventoryItem bodyItem = ItemRegistry.getItem((String)item.getGndData().getString("BodyItem", "BodyMachinegunBasic")).getDefaultItem(null, 1);
        InventoryItem stockItem = ItemRegistry.getItem((String)item.getGndData().getString("StockItem", "StockMachinegunIron")).getDefaultItem(null, 1);
        GameRandom random = new GameRandom((long)seed);
        GameRandom spreadRandom = new GameRandom((long)(seed + 10));
        if (this.controlledRange) {
            Point newTarget = this.controlledRangePosition(new GameRandom((long)(seed + 10)), (Mob)attackerMob, x, y, item, this.controlledMinRange, this.controlledInaccuracy);
            x = newTarget.x;
            y = newTarget.y;
            range = (int)attackerMob.getDistance((float)x, (float)y);
        } else {
            range = this.getAttackRange(item);
        }
        Projectile projectile = this.getProjectile(item, bullet, attackerMob.x, attackerMob.y, x, y, range, attackerMob);
        this.setModifier(projectile, item);
        projectile.dropItem = dropItem;
        projectile.getUniqueID(new GameRandom((long)seed));
        attackerMob.addAndSendAttackerProjectile(projectile, this.moveDist);
        projectile.setAngle(projectile.getAngle() + (spreadRandom.nextFloat() - 0.5f) * (4.0f * barrelItem.getGndData().getFloat("SpreadMod", 1.0f) * bodyItem.getGndData().getFloat("SpreadMod", 1.0f) * stockItem.getGndData().getFloat("SpreadMod", 1.0f)));
    }

    public boolean canLevelInteract(Level level, int x, int y, ItemAttackerMob attackerMob, InventoryItem item) {
        Item bulletcheck = attackerMob.getFirstPlayerOwner().getInv().main.getFirstItem(level, attackerMob.getFirstPlayerOwner(), this.ammoItems(), "bulletammo");
        return bulletcheck != null && this.defaultBody(item).getGndData().getString("BodyName", "Basic").equalsIgnoreCase("Chaingun") && item.getGndData().getInt("ChargedShots") > 0;
    }

    public void setModifier(Projectile projectile, InventoryItem item) {
        if (this.defaultBody(item).getGndData().getString("BodyName").equalsIgnoreCase("Crystal")) {
            projectile.setModifier((ProjectileModifier)new CrystalizeModifier(this.getResilienceGain(item)));
        } else {
            projectile.setModifier((ProjectileModifier)new ResilienceOnHitProjectileModifier(this.getResilienceGain(item)));
        }
    }

    public float getItemCooldownPercent(InventoryItem item, PlayerMob perspective) {
        return 0.0f;
    }

    public ItemControllerInteract getControllerInteract(Level level, PlayerMob player, InventoryItem item, boolean beforeObjectInteract, int interactDir, LinkedList<Rectangle> mobInteractBoxes, LinkedList<Rectangle> tileInteractBoxes) {
        Point2D.Float controllerAimDir = player.getControllerAimDir();
        Point levelPos = this.getControllerAttackLevelPos(level, controllerAimDir.x, controllerAimDir.y, player, item);
        return new ItemControllerInteract(levelPos.x, levelPos.y){

            public DrawOptions getDrawOptions(GameCamera camera) {
                return null;
            }

            public void onCurrentlyFocused(GameCamera camera) {
            }
        };
    }
}

