/*
 * Decompiled with CFR 0.152.
 */
package gunsmith.items.tools;

import gunsmith.items.tools.ModularBase;
import gunsmith.items.tools.ModularGun;
import gunsmith.projectiles.modifiers.CrystalizeModifier;
import gunsmith.scripts.BuildupFireAttackHandler;
import gunsmith.scripts.BurstFireAttackHandler;
import gunsmith.scripts.MisfireAttackHandler;
import gunsmith.scripts.RipperAttackHandler;
import java.awt.Color;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.util.LinkedList;
import necesse.engine.input.Control;
import necesse.engine.localization.Localization;
import necesse.engine.network.gameNetworkData.GNDItem;
import necesse.engine.network.gameNetworkData.GNDItemGameDamage;
import necesse.engine.network.gameNetworkData.GNDItemMap;
import necesse.engine.registries.DamageTypeRegistry;
import necesse.engine.registries.ItemRegistry;
import necesse.engine.sound.PrimitiveSoundEmitter;
import necesse.engine.sound.SoundEffect;
import necesse.engine.sound.SoundManager;
import necesse.engine.sound.gameSound.GameSound;
import necesse.engine.util.GameBlackboard;
import necesse.engine.util.GameRandom;
import necesse.entity.mobs.AttackAnimMob;
import necesse.entity.mobs.Attacker;
import necesse.entity.mobs.GameDamage;
import necesse.entity.mobs.Mob;
import necesse.entity.mobs.PlayerMob;
import necesse.entity.mobs.attackHandler.AttackHandler;
import necesse.entity.mobs.buffs.BuffModifiers;
import necesse.entity.mobs.gameDamageType.DamageType;
import necesse.entity.mobs.itemAttacker.ItemAttackSlot;
import necesse.entity.mobs.itemAttacker.ItemAttackerMob;
import necesse.entity.projectile.Projectile;
import necesse.entity.projectile.modifiers.ProjectileModifier;
import necesse.entity.projectile.modifiers.ResilienceOnHitProjectileModifier;
import necesse.gfx.GameColor;
import necesse.gfx.GameResources;
import necesse.gfx.camera.GameCamera;
import necesse.gfx.drawOptions.DrawOptions;
import necesse.gfx.drawOptions.itemAttack.ItemAttackDrawOptions;
import necesse.gfx.gameTexture.GameSprite;
import necesse.gfx.gameTexture.GameTexture;
import necesse.gfx.gameTexture.MergeFunction;
import necesse.gfx.gameTooltips.ListGameTooltips;
import necesse.gfx.gameTooltips.StringTooltips;
import necesse.inventory.InventoryItem;
import necesse.inventory.enchants.ToolItemModifiers;
import necesse.inventory.item.Item;
import necesse.inventory.item.ItemControllerInteract;
import necesse.inventory.item.ItemInteractAction;
import necesse.inventory.item.ItemStatTip;
import necesse.inventory.item.ItemStatTipList;
import necesse.inventory.item.LocalMessageDoubleItemStatTip;
import necesse.inventory.item.bulletItem.BulletItem;
import necesse.level.maps.Level;

public class ModularPistol
extends ModularGun
implements ItemInteractAction {
    public ModularPistol() {
        this.rarity = Item.Rarity.COMMON;
        this.attackAnimTime.setBaseValue(400);
        this.attackXOffset = 12;
        this.attackYOffset = 14;
        this.attackDamage.setBaseValue(0.0f).setUpgradedValue(5.0f, 0.0f);
        this.attackRange.setBaseValue(820);
        this.velocity.setBaseValue(320);
        this.setItemCategory(new String[]{"TF", "pistol"});
    }

    public InventoryItem defaultBarrel(InventoryItem item) {
        InventoryItem defaultItem = ItemRegistry.getItem((String)item.getGndData().getString("BarrelItem", "BarrelPistolIron")).getDefaultItem(null, 1);
        if (item.getGndData().hasKey("BarrelBonus")) {
            item.getGndData().copyKeysToTarget(defaultItem.getGndData(), new String[]{"BarrelBonus", "BarrelBonusValue"});
        }
        return defaultItem;
    }

    public InventoryItem defaultBody(InventoryItem item) {
        InventoryItem defaultItem = ItemRegistry.getItem((String)item.getGndData().getString("BodyItem", "BodyPistolBasic")).getDefaultItem(null, 1);
        if (item.getGndData().hasKey("BodyBonus")) {
            item.getGndData().copyKeysToTarget(defaultItem.getGndData(), new String[]{"BodyBonus", "BodyBonusValue"});
        }
        return ItemRegistry.getItem((String)item.getGndData().getString("BodyItem", "BodyPickaxeBasic")).getDefaultItem(null, 1);
    }

    public InventoryItem defaultStock(InventoryItem item) {
        InventoryItem defaultItem = ItemRegistry.getItem((String)item.getGndData().getString("StockItem", "StockPistolIron")).getDefaultItem(null, 1);
        if (item.getGndData().hasKey("StockBonus")) {
            item.getGndData().copyKeysToTarget(defaultItem.getGndData(), new String[]{"StockBonus", "StockBonusValue"});
        }
        return defaultItem;
    }

    protected ListGameTooltips getDisplayNameTooltips(InventoryItem item, PlayerMob perspective, GameBlackboard blackboard) {
        ListGameTooltips tooltips = new ListGameTooltips();
        if (!item.getGndData().hasKey("StockItem")) {
            tooltips.add((Object)new StringTooltips("Pistol Template", new Color(255, 255, 255)));
            tooltips.add((Object)new StringTooltips("I see you cheating :)", new Color(255, 0, 0)));
        } else {
            GameColor tiercolor = GameColor.ITEM_COMMON;
            if (item.getGndData().getFloat("Rarity", 0.0f) >= 5.0f) {
                tiercolor = GameColor.ITEM_LEGENDARY;
            } else if (item.getGndData().getFloat("Rarity", 0.0f) >= 4.0f) {
                tiercolor = GameColor.ITEM_QUEST;
            } else if (item.getGndData().getFloat("Rarity", 0.0f) >= 3.0f) {
                tiercolor = GameColor.ITEM_RARE;
            } else if (item.getGndData().getFloat("Rarity", 0.0f) >= 2.0f) {
                tiercolor = GameColor.ITEM_UNCOMMON;
            }
            if (item.getGndData().hasKey("name")) {
                tooltips.add((Object)new StringTooltips(item.getGndData().getString("name", "Wack"), tiercolor));
            } else {
                tooltips.add((Object)new StringTooltips(Localization.translate((String)"item", (String)(item.getGndData().getString("BodyItem") + "Name")) + " " + Localization.translate((String)"item", (String)(item.getGndData().getString("StockItem") + "Name")) + " " + Localization.translate((String)"item", (String)this.getStringID()), tiercolor));
            }
            int upgradeLevel = this.getUpgradeLevel(item);
            if (upgradeLevel > 0) {
                String tierString;
                int tier = upgradeLevel / 100;
                if ((float)tier == (float)upgradeLevel / 100.0f) {
                    tierString = String.valueOf(tier);
                } else {
                    int extra = upgradeLevel - tier * 100;
                    tierString = tier + " +" + extra + "%";
                }
                tooltips.add((Object)new StringTooltips(Localization.translate((String)"item", (String)"tier", (String)"tiernumber", (String)tierString), new Color(133, 49, 168)));
            }
        }
        return tooltips;
    }

    protected void addExtraGunTooltips(ListGameTooltips tooltips, InventoryItem item, PlayerMob perspective, GameBlackboard blackboard) {
        if (!Control.INV_QUICK_TRASH.isDown() && !Control.INV_QUICK_MOVE.isDown()) {
            super.addExtraGunTooltips(tooltips, item, perspective, blackboard);
        }
    }

    public ListGameTooltips getPreEnchantmentTooltips(InventoryItem item, PlayerMob perspective, GameBlackboard blackboard) {
        ListGameTooltips tooltips = new ListGameTooltips();
        if (!Control.INV_QUICK_TRASH.isDown() && !Control.INV_QUICK_MOVE.isDown()) {
            tooltips = super.getPreEnchantmentTooltips(item, perspective, blackboard);
        }
        if (!item.getGndData().hasKey("StockItem")) {
            return tooltips;
        }
        if (!Control.INV_QUICK_TRASH.isDown() && !Control.INV_QUICK_MOVE.isDown()) {
            this.addExtraGunTooltips(tooltips, item, perspective, blackboard);
        }
        if (Control.INV_QUICK_TRASH.isDown()) {
            tooltips.add(Localization.translate((String)"itemtooltip", (String)"Barrel") + " " + Localization.translate((String)"item", (String)(item.getGndData().getString("BarrelItem", "BarrelPistolIron") + "Name")));
            tooltips.add(Localization.translate((String)"itemtooltip", (String)"Body") + " " + Localization.translate((String)"item", (String)(item.getGndData().getString("BodyItem", "BodyPistolBasic") + "Name")));
            tooltips.add(Localization.translate((String)"itemtooltip", (String)"Stock") + " " + Localization.translate((String)"item", (String)(item.getGndData().getString("StockItem", "StockPistolIron") + "Name")));
        } else if (Control.INV_QUICK_MOVE.isDown()) {
            tooltips.add(Localization.translate((String)"barreltooltip", (String)"BarrelTip"));
            tooltips.add(Localization.translate((String)"barreltooltip", (String)(item.getGndData().getString("BarrelItem", "BarrelPistolIron") + "Tip")));
            tooltips.add(Localization.translate((String)"bodytooltip", (String)"BodyTip"));
            tooltips.add(Localization.translate((String)"bodytooltip", (String)(item.getGndData().getString("BodyItem", "BodyPistolBasic") + "Tip")));
            tooltips.add(Localization.translate((String)"stocktooltip", (String)"StockTip"));
            tooltips.add(Localization.translate((String)"stocktooltip", (String)(item.getGndData().getString("StockItem", "StockPistolIron") + "Tip")));
        } else {
            if (this.getAmmoConsumeChance(null, item) < 1.0f) {
                tooltips.add(Localization.translate((String)"itemtooltip", (String)"AmmoConsumeTip", (String)"useage", (Object)Math.round((1.0f - this.getAmmoConsumeChance(null, item)) * 100.0f)));
            }
            if (this.getManaCost(item) > 0.0f) {
                float modifier = (perspective == null ? (Float)BuffModifiers.MANA_USAGE.defaultBuffManagerValue : (Float)perspective.buffManager.getModifier(BuffModifiers.MANA_USAGE)).floatValue();
                float currentManaCost = this.getManaCost(item) * modifier;
                LocalMessageDoubleItemStatTip tip = new LocalMessageDoubleItemStatTip("itemtooltip", "manacosttip", "value", (double)currentManaCost, 1);
                tooltips.add((Object)tip.toTooltip(Color.green, Color.red, Color.white, false));
            }
            tooltips.add(Localization.translate((String)"itemtooltip", (String)"holdShift", (String)"shift", (String)"invquickmove"));
            tooltips.add(Localization.translate((String)"itemtooltip", (String)"holdCtrl", (String)"ctrl", (String)"invtrash"));
        }
        return tooltips;
    }

    protected void addAmmoTooltips(ListGameTooltips tooltips, InventoryItem item) {
        if (!Control.INV_QUICK_TRASH.isDown() && !Control.INV_QUICK_MOVE.isDown()) {
            super.addAmmoTooltips(tooltips, item);
        }
    }

    public void showAttack(Level level, int x, int y, ItemAttackerMob attackerMob, int attackHeight, InventoryItem item, int animAttack, int seed, GNDItemMap mapContent) {
        InventoryItem bodyItem = ItemRegistry.getItem((String)item.getGndData().getString("BodyItem", "BodyPistolBasic")).getDefaultItem(null, 1);
        if (level.isClient() && !bodyItem.getGndData().getString("BodyName").equalsIgnoreCase("Burst") && !bodyItem.getGndData().getString("BodyName").equalsIgnoreCase("Ripper") && !bodyItem.getGndData().getString("BodyName").equalsIgnoreCase("Economic")) {
            this.playFireSound((AttackAnimMob)attackerMob, item);
        }
    }

    public void playFireSound(AttackAnimMob mob, InventoryItem item) {
        InventoryItem bodyItem = ItemRegistry.getItem((String)item.getGndData().getString("BodyItem", "BodyPistolBasic")).getDefaultItem(null, 1);
        if (bodyItem.getGndData().getString("BodyName").equalsIgnoreCase("Magic")) {
            SoundManager.playSound((GameSound)GameResources.firespell1, (SoundEffect)SoundEffect.effect((PrimitiveSoundEmitter)mob).volume(0.8f).pitch(GameRandom.globalRandom.getFloatBetween(1.3f, 1.37f)));
        } else {
            SoundManager.playSound((GameSound)GameResources.handgun, (SoundEffect)SoundEffect.effect((PrimitiveSoundEmitter)mob).volume(0.7f).pitch(GameRandom.globalRandom.getFloatBetween(1.15f, 1.2f)));
        }
    }

    public void draw(InventoryItem item, PlayerMob perspective, int x, int y, boolean inInventory) {
        super.draw(item, perspective, x, y, inInventory);
    }

    public void drawIcon(InventoryItem item, PlayerMob perspective, int x, int y, int size, Color color) {
        color = color != null ? MergeFunction.MULTIPLY.merge(color, this.getDrawColor(item, perspective)) : this.getDrawColor(item, perspective);
        new GameSprite(GameTexture.fromFile((String)("items/" + item.getGndData().getString("BarrelItem", "BarrelPistolIron")))).initDraw().color(color).size(size).draw(x, y);
        new GameSprite(GameTexture.fromFile((String)("items/" + item.getGndData().getString("BodyItem", "BodyPistolBasic")))).initDraw().color(color).size(size).depth(-1.0f).draw(x, y);
        new GameSprite(GameTexture.fromFile((String)("items/" + item.getGndData().getString("StockItem", "StockPistolIron")))).initDraw().color(color).size(size).draw(x, y);
    }

    public void setDrawAttackRotation(InventoryItem item, ItemAttackDrawOptions drawOptions, float attackDirX, float attackDirY, float attackProgress) {
        super.setDrawAttackRotation(item, drawOptions, attackDirX, attackDirY, attackProgress);
        drawOptions.addedArmPosOffset(-3, 5);
    }

    public GameSprite getAttackSprite(InventoryItem item, PlayerMob player) {
        return new GameSprite(GameTexture.fromFile((String)"player/weapons/handgun"));
    }

    public DamageType getDamageType(InventoryItem item) {
        InventoryItem bodyItem = ItemRegistry.getItem((String)item.getGndData().getString("BodyItem", "BodyPistolBasic")).getDefaultItem(null, 1);
        if (bodyItem.getGndData().getString("BodyName").equalsIgnoreCase("Magic")) {
            return DamageTypeRegistry.MAGIC;
        }
        return DamageTypeRegistry.RANGED;
    }

    public GameDamage getFlatAttackDamage(InventoryItem item) {
        InventoryItem barrelItem = ItemRegistry.getItem((String)item.getGndData().getString("BarrelItem", "BarrelPistolIron")).getDefaultItem(null, 1);
        InventoryItem bodyItem = ItemRegistry.getItem((String)item.getGndData().getString("BodyItem", "BodyPistolBasic")).getDefaultItem(null, 1);
        InventoryItem stockItem = ItemRegistry.getItem((String)item.getGndData().getString("StockItem", "StockPistolIron")).getDefaultItem(null, 1);
        GNDItemMap gndData = item.getGndData();
        if (gndData.hasKey("damage")) {
            GNDItem gndItem = gndData.getItem("damage");
            if (gndItem instanceof GNDItemGameDamage) {
                return ((GNDItemGameDamage)gndItem).damage;
            }
            if (gndItem instanceof GNDItem.GNDPrimitive) {
                float damage = ((GNDItem.GNDPrimitive)gndItem).getFloat();
                return new GameDamage(this.getDamageType(item), damage);
            }
        }
        if (this.getUpgradeTier(item) > 0.0f) {
            if (stockItem.getGndData().hasKey("StockDamageUpgrade" + this.getUpgradeLevel(item) / 100)) {
                return new GameDamage(this.getDamageType(item), stockItem.getGndData().getFloat("StockDamageUpgrade" + this.getUpgradeLevel(item) / 100, 16.0f) * barrelItem.getGndData().getFloat("DamageMod", 1.0f) * bodyItem.getGndData().getFloat("DamageMod", 1.0f), stockItem.getGndData().getFloat("ArmorPen", 0.0f) + barrelItem.getGndData().getFloat("ArmorPen", 0.0f) + bodyItem.getGndData().getFloat("ArmorPen", 0.0f), stockItem.getGndData().getFloat("CritChance", 0.0f) + barrelItem.getGndData().getFloat("CritChance", 0.0f) + bodyItem.getGndData().getFloat("CritChance", 0.0f));
            }
            float upgMod = (stockItem.getGndData().getFloat("StockDamageUpgrade10", 66.0f) - stockItem.getGndData().getFloat("StockDamageUpgrade1", 50.0f)) / 4.0f;
            return new GameDamage(this.getDamageType(item), (stockItem.getGndData().getFloat("StockDamageUpgrade1", 50.0f) + upgMod * (this.getUpgradeTier(item) - 1.0f)) * barrelItem.getGndData().getFloat("DamageMod", 1.0f) * bodyItem.getGndData().getFloat("DamageMod", 1.0f), stockItem.getGndData().getFloat("ArmorPen", 0.0f) + barrelItem.getGndData().getFloat("ArmorPen", 0.0f) + bodyItem.getGndData().getFloat("ArmorPen", 0.0f), stockItem.getGndData().getFloat("CritChance", 0.0f) + barrelItem.getGndData().getFloat("CritChance", 0.0f) + bodyItem.getGndData().getFloat("CritChance", 0.0f));
        }
        return new GameDamage(this.getDamageType(item), stockItem.getGndData().getFloat("Damage", 16.0f) * barrelItem.getGndData().getFloat("DamageMod", 1.0f) * bodyItem.getGndData().getFloat("DamageMod", 1.0f), stockItem.getGndData().getFloat("ArmorPen", 0.0f) + barrelItem.getGndData().getFloat("ArmorPen", 0.0f) + bodyItem.getGndData().getFloat("ArmorPen", 0.0f), stockItem.getGndData().getFloat("CritChance", 0.0f) + barrelItem.getGndData().getFloat("CritChance", 0.0f) + bodyItem.getGndData().getFloat("CritChance", 0.0f));
    }

    public float getAttackSpeedModifier(InventoryItem item, ItemAttackerMob attackerMob) {
        InventoryItem barrelItem = ItemRegistry.getItem((String)item.getGndData().getString("BarrelItem", "BarrelPistolIron")).getDefaultItem(null, 1);
        InventoryItem bodyItem = ItemRegistry.getItem((String)item.getGndData().getString("BodyItem", "BodyPistolBasic")).getDefaultItem(null, 1);
        InventoryItem stockItem = ItemRegistry.getItem((String)item.getGndData().getString("StockItem", "StockPistolIron")).getDefaultItem(null, 1);
        DamageType damageType = this.getDamageType(item);
        return damageType.calculateTotalAttackSpeedModifier((Attacker)attackerMob, ((Float)this.getEnchantment(item).applyModifierUnlimited(ToolItemModifiers.ATTACK_SPEED, (Object)((Float)ToolItemModifiers.ATTACK_SPEED.defaultBuffValue))).floatValue()) * (stockItem.getGndData().getFloat("AttackSpeed", 1.0f) * barrelItem.getGndData().getFloat("AttackSpeed", 1.0f) * bodyItem.getGndData().getFloat("AttackSpeed", 1.0f));
    }

    public float getAttackMovementMod(InventoryItem item) {
        InventoryItem barrelItem = ItemRegistry.getItem((String)item.getGndData().getString("BarrelItem", "BarrelPistolIron")).getDefaultItem(null, 1);
        InventoryItem bodyItem = ItemRegistry.getItem((String)item.getGndData().getString("BodyItem", "BodyPistolBasic")).getDefaultItem(null, 1);
        InventoryItem stockItem = ItemRegistry.getItem((String)item.getGndData().getString("StockItem", "StockPistolIron")).getDefaultItem(null, 1);
        if (0.5f + (barrelItem.getGndData().getFloat("MovementMod", 0.0f) + bodyItem.getGndData().getFloat("MovementMod", 0.0f) + stockItem.getGndData().getFloat("MovementMod", 0.0f)) >= 1.0f) {
            return 1.0f;
        }
        return 0.5f + (barrelItem.getGndData().getFloat("MovementMod", 0.0f) + bodyItem.getGndData().getFloat("MovementMod", 0.0f) + stockItem.getGndData().getFloat("MovementMod", 0.0f));
    }

    public float getAmmoConsumeChance(ItemAttackerMob attackerMob, InventoryItem item) {
        return ModularBase.getAmmoConsumeChance(attackerMob, item, this.defaultBarrel(item), this.defaultBody(item), this.defaultStock(item), this.ammoConsumeChance);
    }

    public float getFlatManaCost(InventoryItem item) {
        InventoryItem bodyItem = ItemRegistry.getItem((String)item.getGndData().getString("BodyItem", "BodyPistolBasic")).getDefaultItem(null, 1);
        GNDItemMap gndData = bodyItem.getGndData();
        return gndData.hasKey("manaCost") ? gndData.getFloat("manaCost") + this.getFlatAttackDamage((InventoryItem)item).damage * 0.05f : 0.0f;
    }

    public void addManaCostTip(ItemStatTipList list, InventoryItem currentItem, InventoryItem lastItem, Mob mob) {
        float modifier = (mob == null ? (Float)BuffModifiers.MANA_USAGE.defaultBuffManagerValue : (Float)mob.buffManager.getModifier(BuffModifiers.MANA_USAGE)).floatValue();
        float currentManaCost = this.getManaCost(currentItem) * modifier;
        LocalMessageDoubleItemStatTip tip = new LocalMessageDoubleItemStatTip("itemtooltip", "manacosttip", "value", (double)currentManaCost, 1);
        if (lastItem != null) {
            tip.setCompareValue((double)(this.getManaCost(lastItem) * modifier), false);
        }
        list.add(1000, (ItemStatTip)tip);
    }

    public float getManaCost(InventoryItem item) {
        return this.getFlatManaCost(item) * this.getManaUsageModifier(item);
    }

    public void consumeMana(ItemAttackerMob attackerMob, InventoryItem item) {
        this.consumeMana(this.getManaCost(item), attackerMob);
    }

    public InventoryItem onAttack(Level level, int x, int y, ItemAttackerMob attackerMob, int attackHeight, InventoryItem item, ItemAttackSlot slot, int animAttack, int seed, GNDItemMap mapContent) {
        InventoryItem bodyItem = ItemRegistry.getItem((String)item.getGndData().getString("BodyItem", "BodyPistolBasic")).getDefaultItem(null, 1);
        if (bodyItem.getGndData().getString("BodyName").equalsIgnoreCase("Burst")) {
            attackerMob.startAttackHandler((AttackHandler)new BurstFireAttackHandler(attackerMob, slot, item, this, seed, x, y, bodyItem.getGndData().getInt("ReloadTime", 1700), bodyItem.getGndData().getInt("ShotTime", 170), bodyItem.getGndData().getInt("ShotAmount", 3)));
        } else if (bodyItem.getGndData().getString("BodyName").equalsIgnoreCase("Ripper")) {
            attackerMob.startAttackHandler((AttackHandler)new RipperAttackHandler(attackerMob, slot, item, this, seed, x, y));
        } else if (bodyItem.getGndData().getString("BodyName").equalsIgnoreCase("Economic")) {
            attackerMob.startAttackHandler((AttackHandler)new MisfireAttackHandler(attackerMob, slot, item, this, seed, x, y, bodyItem.getGndData().getFloat("MisfireChance", 0.12f)));
        } else if (bodyItem.getGndData().getString("BodyName").equalsIgnoreCase("Chaingun")) {
            attackerMob.startAttackHandler((AttackHandler)new BuildupFireAttackHandler(attackerMob, slot, item, this, seed, x, y));
        } else {
            super.onAttack(level, x, y, attackerMob, attackHeight, item, slot, animAttack, seed, mapContent);
        }
        return item;
    }

    public int getKnockback(InventoryItem item, Attacker attacker) {
        Mob attackOwner;
        InventoryItem barrelItem = ItemRegistry.getItem((String)item.getGndData().getString("BarrelItem", "BarrelPistolIron")).getDefaultItem(null, 1);
        InventoryItem bodyItem = ItemRegistry.getItem((String)item.getGndData().getString("BodyItem", "BodyPistolBasic")).getDefaultItem(null, 1);
        InventoryItem stockItem = ItemRegistry.getItem((String)item.getGndData().getString("StockItem", "StockPistolIron")).getDefaultItem(null, 1);
        int knockback = this.knockback.getValue(0.0f);
        float buffMod = 1.0f;
        Mob mob = attackOwner = attacker != null ? attacker.getAttackOwner() : null;
        if (attackOwner != null) {
            buffMod = ((Float)attackOwner.buffManager.getModifier(BuffModifiers.KNOCKBACK_OUT)).floatValue();
        }
        return Math.round((float)knockback * ((Float)this.getEnchantment(item).applyModifierLimited(ToolItemModifiers.KNOCKBACK, (Object)((Float)ToolItemModifiers.KNOCKBACK.defaultBuffManagerValue))).floatValue() * buffMod * barrelItem.getGndData().getFloat("KnockbackMod", 1.0f) * bodyItem.getGndData().getFloat("KnockbackMod", 1.0f) * stockItem.getGndData().getFloat("KnockbackMod", 1.0f));
    }

    public int getProjectileVelocity(InventoryItem item, Mob mob) {
        InventoryItem barrelItem = ItemRegistry.getItem((String)item.getGndData().getString("BarrelItem", "BarrelPistolIron")).getDefaultItem(null, 1);
        InventoryItem bodyItem = ItemRegistry.getItem((String)item.getGndData().getString("BodyItem", "BodyPistolBasic")).getDefaultItem(null, 1);
        InventoryItem stockItem = ItemRegistry.getItem((String)item.getGndData().getString("StockItem", "StockPistolIron")).getDefaultItem(null, 1);
        int velocity = this.getFlatVelocity(item);
        return Math.round(((Float)this.getEnchantment(item).applyModifierLimited(ToolItemModifiers.VELOCITY, (Object)((Float)ToolItemModifiers.VELOCITY.defaultBuffManagerValue))).floatValue() * (float)velocity * ((Float)mob.buffManager.getModifier(BuffModifiers.PROJECTILE_VELOCITY)).floatValue() * barrelItem.getGndData().getFloat("ProjectileSpeedMod", 1.0f) * bodyItem.getGndData().getFloat("ProjectileSpeedMod", 1.0f) * stockItem.getGndData().getFloat("ProjectileSpeedMod", 1.0f));
    }

    public Projectile getProjectile(InventoryItem item, BulletItem bulletItem, float x, float y, float targetX, float targetY, int range, ItemAttackerMob attackerMob) {
        InventoryItem barrelItem = ItemRegistry.getItem((String)item.getGndData().getString("BarrelItem", "BarrelPistolIron")).getDefaultItem(null, 1);
        InventoryItem bodyItem = ItemRegistry.getItem((String)item.getGndData().getString("BodyItem", "BodyPistolBasic")).getDefaultItem(null, 1);
        InventoryItem stockItem = ItemRegistry.getItem((String)item.getGndData().getString("StockItem", "StockPistolIron")).getDefaultItem(null, 1);
        return super.getProjectile(item, bulletItem, x, y + 5.0f, targetX, targetY + 5.0f, range + barrelItem.getGndData().getInt("RangeAdd", 0) + bodyItem.getGndData().getInt("RangeAdd", 0) + stockItem.getGndData().getInt("RangeAdd", 0), attackerMob);
    }

    protected void fireProjectiles(Level level, int x, int y, ItemAttackerMob attackerMob, InventoryItem item, int seed, BulletItem bullet, boolean dropItem, GNDItemMap mapContent) {
        int range;
        InventoryItem barrelItem = ItemRegistry.getItem((String)item.getGndData().getString("BarrelItem", "BarrelPistolIron")).getDefaultItem(null, 1);
        InventoryItem bodyItem = ItemRegistry.getItem((String)item.getGndData().getString("BodyItem", "BodyPistolBasic")).getDefaultItem(null, 1);
        InventoryItem stockItem = ItemRegistry.getItem((String)item.getGndData().getString("StockItem", "StockPistolIron")).getDefaultItem(null, 1);
        GameRandom random = new GameRandom((long)seed);
        GameRandom spreadRandom = new GameRandom((long)(seed + 10));
        if (this.controlledRange) {
            Point newTarget = this.controlledRangePosition(new GameRandom((long)(seed + 10)), (Mob)attackerMob, x, y, item, this.controlledMinRange, this.controlledInaccuracy);
            x = newTarget.x;
            y = newTarget.y;
            range = (int)attackerMob.getDistance((float)x, (float)y);
        } else {
            range = this.getAttackRange(item);
        }
        Projectile projectile = this.getProjectile(item, bullet, attackerMob.x, attackerMob.y, x, y, range, attackerMob);
        this.setModifier(projectile, item);
        projectile.dropItem = dropItem;
        projectile.getUniqueID(new GameRandom((long)seed));
        attackerMob.addAndSendAttackerProjectile(projectile, this.moveDist);
        if (bodyItem.getGndData().getString("BodyName").equalsIgnoreCase("Magic")) {
            this.consumeMana(attackerMob, item);
        }
        projectile.setAngle(projectile.getAngle() + (spreadRandom.nextFloat() - 0.5f) * (4.0f * barrelItem.getGndData().getFloat("SpreadMod", 1.0f) * bodyItem.getGndData().getFloat("SpreadMod", 1.0f) * stockItem.getGndData().getFloat("SpreadMod", 1.0f)));
    }

    public boolean canLevelInteract(Level level, int x, int y, ItemAttackerMob attackerMob, InventoryItem item) {
        InventoryItem bodyItem = ItemRegistry.getItem((String)item.getGndData().getString("BodyItem", "BodyPistolBasic")).getDefaultItem(null, 1);
        Item bulletcheck = attackerMob.getFirstPlayerOwner().getInv().main.getFirstItem(level, attackerMob.getFirstPlayerOwner(), this.ammoItems(), "bulletammo");
        return bulletcheck != null && bodyItem.getGndData().getString("BodyName", "Basic").equalsIgnoreCase("Chaingun") && item.getGndData().getInt("ChargedShots") > 0;
    }

    public void setModifier(Projectile projectile, InventoryItem item) {
        InventoryItem bodyItem = ItemRegistry.getItem((String)item.getGndData().getString("BodyItem", "BodyPistolBasic")).getDefaultItem(null, 1);
        if (bodyItem.getGndData().getString("BodyName").equalsIgnoreCase("Crystal")) {
            projectile.setModifier((ProjectileModifier)new CrystalizeModifier(this.getResilienceGain(item)));
        } else {
            projectile.setModifier((ProjectileModifier)new ResilienceOnHitProjectileModifier(this.getResilienceGain(item)));
        }
    }

    public float getItemCooldownPercent(InventoryItem item, PlayerMob perspective) {
        InventoryItem bodyItem = ItemRegistry.getItem((String)item.getGndData().getString("BodyItem", "BodyPistolBasic")).getDefaultItem(null, 1);
        return 0.0f;
    }

    public ItemControllerInteract getControllerInteract(Level level, PlayerMob player, InventoryItem item, boolean beforeObjectInteract, int interactDir, LinkedList<Rectangle> mobInteractBoxes, LinkedList<Rectangle> tileInteractBoxes) {
        Point2D.Float controllerAimDir = player.getControllerAimDir();
        Point levelPos = this.getControllerAttackLevelPos(level, controllerAimDir.x, controllerAimDir.y, player, item);
        return new ItemControllerInteract(levelPos.x, levelPos.y){

            public DrawOptions getDrawOptions(GameCamera camera) {
                return null;
            }

            public void onCurrentlyFocused(GameCamera camera) {
            }
        };
    }
}

