/*
 * Decompiled with CFR 0.152.
 */
package gunsmith.items.tools;

import gunsmith.gunsmith;
import gunsmith.items.tools.ModularBase;
import gunsmith.packets.RequestItemPacket;
import gunsmith.scripts.ObjectRadiusSearch;
import gunsmith.scripts.RGBToHex;
import java.awt.Color;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import necesse.engine.GlobalData;
import necesse.engine.input.Control;
import necesse.engine.localization.Localization;
import necesse.engine.localization.message.GameMessage;
import necesse.engine.localization.message.StaticMessage;
import necesse.engine.network.Packet;
import necesse.engine.network.gameNetworkData.GNDItemMap;
import necesse.engine.registries.BuffRegistry;
import necesse.engine.registries.DamageTypeRegistry;
import necesse.engine.registries.ItemRegistry;
import necesse.engine.sound.PrimitiveSoundEmitter;
import necesse.engine.sound.SoundEffect;
import necesse.engine.sound.SoundManager;
import necesse.engine.sound.gameSound.GameSound;
import necesse.engine.util.GameBlackboard;
import necesse.engine.util.GameMath;
import necesse.engine.util.GameRandom;
import necesse.engine.util.LineHitbox;
import necesse.entity.levelEvent.mobAbilityLevelEvent.ToolItemMobAbilityEvent;
import necesse.entity.mobs.AttackAnimMob;
import necesse.entity.mobs.Attacker;
import necesse.entity.mobs.GameDamage;
import necesse.entity.mobs.Mob;
import necesse.entity.mobs.PlayerMob;
import necesse.entity.mobs.buffs.ActiveBuff;
import necesse.entity.mobs.buffs.BuffModifiers;
import necesse.entity.mobs.itemAttacker.ItemAttackSlot;
import necesse.entity.mobs.itemAttacker.ItemAttackerMob;
import necesse.entity.particle.Particle;
import necesse.gfx.GameResources;
import necesse.gfx.camera.GameCamera;
import necesse.gfx.drawOptions.DrawOptions;
import necesse.gfx.drawOptions.itemAttack.ItemAttackDrawOptions;
import necesse.gfx.gameTexture.GameSprite;
import necesse.gfx.gameTexture.GameTexture;
import necesse.gfx.gameTexture.MergeFunction;
import necesse.gfx.gameTooltips.ListGameTooltips;
import necesse.inventory.InventoryItem;
import necesse.inventory.enchants.ToolItemModifiers;
import necesse.inventory.item.ItemControllerInteract;
import necesse.inventory.item.ItemInteractAction;
import necesse.inventory.item.ItemStatTip;
import necesse.inventory.item.ItemStatTipList;
import necesse.inventory.item.LocalMessageDoubleItemStatTip;
import necesse.inventory.item.StringItemStatTip;
import necesse.inventory.item.toolItem.ToolItem;
import necesse.inventory.item.toolItem.pickaxeToolItem.CustomPickaxeToolItem;
import necesse.level.gameObject.RockOreObject;
import necesse.level.maps.Level;

public class ModularPickaxe
extends CustomPickaxeToolItem
implements ItemInteractAction {
    public ModularPickaxe() {
        super(0, 0, 0.0f, 0, 50, 80, 500, null);
        this.damageType = DamageTypeRegistry.MELEE;
        this.showAttackAllDirections = true;
        this.attackXOffset = 0;
        this.attackYOffset = 9;
        this.setItemCategory(new String[]{"TF", "pickaxe"});
    }

    public boolean animDrawBehindHand(InventoryItem item) {
        return true;
    }

    public InventoryItem defaultBarrel(InventoryItem item) {
        InventoryItem defaultItem = ItemRegistry.getItem((String)item.getGndData().getString("BarrelItem", "HeadPickaxeWood")).getDefaultItem(null, 1);
        if (item.getGndData().hasKey("BarrelBonus")) {
            item.getGndData().copyKeysToTarget(defaultItem.getGndData(), new String[]{"BarrelBonus", "BarrelBonusValue"});
        }
        return defaultItem;
    }

    public InventoryItem defaultBody(InventoryItem item) {
        InventoryItem defaultItem = ItemRegistry.getItem((String)item.getGndData().getString("BodyItem", "BodyPickaxeBasic")).getDefaultItem(null, 1);
        if (item.getGndData().hasKey("BodyBonus")) {
            item.getGndData().copyKeysToTarget(defaultItem.getGndData(), new String[]{"BodyBonus", "BodyBonusValue"});
        }
        return defaultItem;
    }

    public InventoryItem defaultStock(InventoryItem item) {
        InventoryItem defaultItem = ItemRegistry.getItem((String)item.getGndData().getString("StockItem", "ShaftPickaxeWood")).getDefaultItem(null, 1);
        if (item.getGndData().hasKey("StockBonus")) {
            item.getGndData().copyKeysToTarget(defaultItem.getGndData(), new String[]{"StockBonus", "StockBonusValue"});
        }
        return defaultItem;
    }

    protected ListGameTooltips getDisplayNameTooltips(InventoryItem item, PlayerMob perspective, GameBlackboard blackboard) {
        return ModularBase.getDisplayNameTooltips(item, perspective, blackboard, this.defaultBarrel(item), this.defaultBody(item), this.defaultStock(item));
    }

    public ListGameTooltips getPreEnchantmentTooltips(InventoryItem item, PlayerMob perspective, GameBlackboard blackboard) {
        ListGameTooltips tooltips = new ListGameTooltips();
        Control statsKey = Control.getControl((String)gunsmith.settingsGetter.getSelection("viewStats").toString());
        Control partsKey = Control.getControl((String)gunsmith.settingsGetter.getSelection("viewParts").toString());
        if (!partsKey.isDown() && !statsKey.isDown()) {
            tooltips = super.getPreEnchantmentTooltips(item, perspective, blackboard);
        }
        if (!item.getGndData().hasKey("StockItem")) {
            return tooltips;
        }
        if (partsKey.isDown() && partsKey != statsKey) {
            tooltips.add(Localization.translate((String)"itemtooltip", (String)"Head") + " " + Localization.translate((String)"item", (String)(item.getGndData().getString("BarrelItem", "HeadPickaxeWood") + "Name")));
            tooltips.add(Localization.translate((String)"itemtooltip", (String)"Brace") + " " + Localization.translate((String)"item", (String)(item.getGndData().getString("BodyItem", "BodyPickaxeBasic") + "Name")));
            tooltips.add(Localization.translate((String)"itemtooltip", (String)"Shaft") + " " + Localization.translate((String)"item", (String)(item.getGndData().getString("StockItem", "ShaftPickaxeWood") + "Name")));
        } else if (statsKey.isDown() || statsKey.isDown() && statsKey == partsKey || partsKey.isDown() && statsKey == partsKey) {
            String color;
            if (statsKey == partsKey) {
                tooltips.add(Localization.translate((String)"itemtooltip", (String)"Head") + " " + Localization.translate((String)"item", (String)(item.getGndData().getString("BarrelItem", "HeadPickaxeWood") + "Name")));
                tooltips.add(Localization.translate((String)"itemtooltip", (String)"Brace") + " " + Localization.translate((String)"item", (String)(item.getGndData().getString("BodyItem", "BodyPickaxeBasic") + "Name")));
                tooltips.add(Localization.translate((String)"itemtooltip", (String)"Shaft") + " " + Localization.translate((String)"item", (String)(item.getGndData().getString("StockItem", "ShaftPickaxeWood") + "Name")));
            }
            tooltips.add(Localization.translate((String)"barreltooltip", (String)"HeadTip"));
            if (item.getGndData().hasKey("BarrelBonus")) {
                color = RGBToHex.RGBToHex(gunsmith.settingsGetter.getColor("bonusColor"));
                StringBuilder stringBuilder = new StringBuilder();
                if (item.getGndData().getFloat("BarrelBonusValue") >= this.defaultStock(item).getGndData().getFloat(stringBuilder.append("High").append(item.getGndData().getString("BarrelBonus")).toString())) {
                    color = RGBToHex.RGBToHex(gunsmith.settingsGetter.getColor("bonusMaxColor"));
                }
                if (item.getGndData().getString("BarrelBonus").equalsIgnoreCase("BonusAttackSpeed")) {
                    if (item.getGndData().getFloat("BarrelBonusValue") > 0.0f) {
                        tooltips.add(Localization.translate((String)"bonusmodtip", (String)item.getGndData().getString("BarrelBonus"), (Object[])new Object[]{"value", Float.valueOf(item.getGndData().getFloat("BarrelBonusValue") / 10.0f), "unit", "+", "color", color}));
                    } else {
                        tooltips.add(Localization.translate((String)"bonusmodtip", (String)item.getGndData().getString("BarrelBonus"), (Object[])new Object[]{"value", Float.valueOf(item.getGndData().getFloat("BarrelBonusValue") / 10.0f), "unit", "", "color", color}));
                    }
                } else if (item.getGndData().getFloat("BarrelBonusValue") > 0.0f) {
                    tooltips.add(Localization.translate((String)"bonusmodtip", (String)item.getGndData().getString("BarrelBonus"), (Object[])new Object[]{"value", Float.valueOf(item.getGndData().getFloat("BarrelBonusValue")), "unit", "+", "color", color}));
                } else {
                    tooltips.add(Localization.translate((String)"bonusmodtip", (String)item.getGndData().getString("BarrelBonus"), (Object[])new Object[]{"value", Float.valueOf(item.getGndData().getFloat("BarrelBonusValue")), "unit", "", "color", color}));
                }
            }
            tooltips.add(Localization.translate((String)"barreltooltip", (String)(item.getGndData().getString("BarrelItem", "HeadPickaxeIron") + "Tip")));
            tooltips.add(Localization.translate((String)"bodytooltip", (String)"BraceTip"));
            if (item.getGndData().hasKey("BodyBonus")) {
                color = RGBToHex.RGBToHex(gunsmith.settingsGetter.getColor("bonusColor"));
                StringBuilder stringBuilder = new StringBuilder();
                if (item.getGndData().getFloat("BodyBonusValue") >= this.defaultStock(item).getGndData().getFloat(stringBuilder.append("High").append(item.getGndData().getString("BodyBonus")).toString())) {
                    color = RGBToHex.RGBToHex(gunsmith.settingsGetter.getColor("bonusMaxColor"));
                }
                if (item.getGndData().getString("BodyBonus").equalsIgnoreCase("BonusAttackSpeed")) {
                    if (item.getGndData().getFloat("BodyBonusValue") > 0.0f) {
                        tooltips.add(Localization.translate((String)"bonusmodtip", (String)item.getGndData().getString("BodyBonus"), (Object[])new Object[]{"value", Float.valueOf(item.getGndData().getFloat("BodyBonusValue") / 10.0f), "unit", "+", "color", color}));
                    } else {
                        tooltips.add(Localization.translate((String)"bonusmodtip", (String)item.getGndData().getString("BodyBonus"), (Object[])new Object[]{"value", Float.valueOf(item.getGndData().getFloat("BodyBonusValue") / 10.0f), "unit", "", "color", color}));
                    }
                } else if (item.getGndData().getFloat("BodyBonusValue") > 0.0f) {
                    tooltips.add(Localization.translate((String)"bonusmodtip", (String)item.getGndData().getString("BodyBonus"), (Object[])new Object[]{"value", Float.valueOf(item.getGndData().getFloat("BodyBonusValue")), "unit", "+", "color", color}));
                } else {
                    tooltips.add(Localization.translate((String)"bonusmodtip", (String)item.getGndData().getString("BodyBonus"), (Object[])new Object[]{"value", Float.valueOf(item.getGndData().getFloat("BodyBonusValue")), "unit", "", "color", color}));
                }
            }
            tooltips.add(Localization.translate((String)"bodytooltip", (String)(item.getGndData().getString("BodyItem", "BodyPickaxeBasic") + "Tip")), 400);
            tooltips.add(Localization.translate((String)"stocktooltip", (String)"ShaftTip"));
            if (item.getGndData().hasKey("StockBonus")) {
                color = RGBToHex.RGBToHex(gunsmith.settingsGetter.getColor("bonusColor"));
                StringBuilder stringBuilder = new StringBuilder();
                if (item.getGndData().getFloat("StockBonusValue") >= this.defaultStock(item).getGndData().getFloat(stringBuilder.append("High").append(item.getGndData().getString("StockBonus")).toString())) {
                    color = RGBToHex.RGBToHex(gunsmith.settingsGetter.getColor("bonusMaxColor"));
                }
                if (item.getGndData().getString("StockBonus").equalsIgnoreCase("BonusAttackSpeed")) {
                    if (item.getGndData().getFloat("StockBonusValue") > 0.0f) {
                        tooltips.add(Localization.translate((String)"bonusmodtip", (String)item.getGndData().getString("StockBonus"), (Object[])new Object[]{"value", Float.valueOf(item.getGndData().getFloat("StockBonusValue") / 10.0f), "unit", "+", "color", color}));
                    } else {
                        tooltips.add(Localization.translate((String)"bonusmodtip", (String)item.getGndData().getString("StockBonus"), (Object[])new Object[]{"value", Float.valueOf(item.getGndData().getFloat("StockBonusValue") / 10.0f), "unit", "", "color", color}));
                    }
                } else if (item.getGndData().getFloat("StockBonusValue") > 0.0f) {
                    tooltips.add(Localization.translate((String)"bonusmodtip", (String)item.getGndData().getString("StockBonus"), (Object[])new Object[]{"value", Float.valueOf(item.getGndData().getFloat("StockBonusValue")), "unit", "+", "color", color}));
                } else {
                    tooltips.add(Localization.translate((String)"bonusmodtip", (String)item.getGndData().getString("StockBonus"), (Object[])new Object[]{"value", Float.valueOf(item.getGndData().getFloat("StockBonusValue")), "unit", "", "color", color}));
                }
            }
            tooltips.add(Localization.translate((String)"stocktooltip", (String)(item.getGndData().getString("StockItem", "ShaftPickaxeWood") + "Tip")));
        } else {
            if (item.getGndData().getString("BodyItem", "BodyPickaxeBasic").equalsIgnoreCase("BodyPickaxeAccelerating")) {
                tooltips.add(Localization.translate((String)"itemtooltip", (String)"pickaxeAccelerating"));
            }
            if (item.getGndData().getString("BodyItem", "BodyPickaxeBasic").equalsIgnoreCase("BodyPickaxeDowsing")) {
                tooltips.add(Localization.translate((String)"itemtooltip", (String)"pickaxeDowsing"));
            }
            if (partsKey == statsKey) {
                tooltips.add(Localization.translate((String)"itemtooltip", (String)"holdparts", (String)"shift", (String)statsKey.id));
            } else {
                tooltips.add(Localization.translate((String)"itemtooltip", (String)"holdShift", (String)"shift", (String)statsKey.id));
                tooltips.add(Localization.translate((String)"itemtooltip", (String)"holdCtrl", (String)"ctrl", (String)partsKey.id));
            }
        }
        return tooltips;
    }

    public void addStatTooltips(ItemStatTipList list, InventoryItem currentItem, InventoryItem lastItem, ItemAttackerMob perspective, boolean forceAdd) {
        this.addToolTierTip(list, currentItem, lastItem, (Mob)perspective, true);
        this.addToolDPSTip(list, currentItem, lastItem, perspective, true);
        this.addMobDamageTip(list, currentItem, lastItem, (Mob)perspective);
        this.addAttackSpeedTip(list, currentItem, lastItem, perspective);
        this.addAddedRangeTip(list, currentItem, lastItem, (Mob)perspective, forceAdd);
    }

    public void addToolTierTip(ItemStatTipList list, InventoryItem currentItem, InventoryItem lastItem, Mob perspective, boolean forceAdd) {
        float lastTier;
        float tier = this.getToolTier(currentItem, perspective);
        float f = lastTier = lastItem == null ? tier : this.getToolTier(lastItem, perspective);
        if (tier != lastTier || forceAdd) {
            LocalMessageDoubleItemStatTip tip = new LocalMessageDoubleItemStatTip("itemtooltip", "toolDamageTier", "value", (double)tier, 1);
            if (lastItem != null) {
                tip.setCompareValue((double)lastTier);
            }
            list.add(30, (ItemStatTip)tip);
        }
    }

    public int getToolDps(InventoryItem item, Mob persepctive) {
        int toolDps = this.getFlatToolDps(item);
        int buffModifierFlat = persepctive == null ? 0 : (Integer)persepctive.buffManager.getModifier(BuffModifiers.TOOL_DAMAGE_FLAT);
        float buffModifier = persepctive == null ? 1.0f : ((Float)persepctive.buffManager.getModifier(BuffModifiers.TOOL_DAMAGE)).floatValue();
        return Math.round((float)(toolDps + buffModifierFlat) * buffModifier * ((Float)this.getEnchantment(item).applyModifierLimited(ToolItemModifiers.TOOL_DAMAGE, (Object)((Float)ToolItemModifiers.TOOL_DAMAGE.defaultBuffManagerValue))).floatValue());
    }

    public void addToolDPSTip(ItemStatTipList list, InventoryItem currentItem, InventoryItem lastItem, ItemAttackerMob perspective, boolean forceAdd) {
        int lastDps;
        int dps = this.getToolDps(currentItem, (Mob)perspective);
        int n = lastDps = lastItem == null ? -1 : this.getToolDps(lastItem, (Mob)perspective);
        if (dps > 0 || lastDps > 0 || forceAdd) {
            LocalMessageDoubleItemStatTip tip = new LocalMessageDoubleItemStatTip("itemtooltip", "tooldmg", "value", (double)dps, 0);
            if (lastItem != null) {
                tip.setCompareValue((double)lastDps);
            }
            list.add(50, (ItemStatTip)tip);
        }
        if (GlobalData.debugActive()) {
            String debugToolString = this.getToolHitDamageString(currentItem, perspective);
            StringItemStatTip debugToolTip = new StringItemStatTip(debugToolString){

                public GameMessage toMessage(Color betterColor, Color worseColor, Color neutralColor, boolean showDifference) {
                    return new StaticMessage("Tool hit damage: " + this.getReplaceValue(betterColor, worseColor, neutralColor, showDifference));
                }
            };
            if (lastItem != null) {
                String lastDebugToolString = this.getToolHitDamageString(lastItem, perspective);
                debugToolTip.setCompareValue(lastDebugToolString, dps == lastDps ? null : Boolean.valueOf(dps > lastDps));
            }
            list.add(40, (ItemStatTip)debugToolTip);
        }
    }

    public void addMobDamageTip(ItemStatTipList list, InventoryItem currentItem, InventoryItem lastItem, Mob perspective) {
        float lastMobDamage;
        float mobDamage = this.getFlatAttackDamage((InventoryItem)currentItem).damage;
        float f = lastMobDamage = lastItem == null ? 0.0f : this.getFlatAttackDamage((InventoryItem)lastItem).damage;
        if (mobDamage != 0.0f || lastMobDamage != 0.0f) {
            LocalMessageDoubleItemStatTip tip = new LocalMessageDoubleItemStatTip("itemtooltip", "toolMobDamage", "value", (double)Math.round(mobDamage), 0);
            tip.setValueToString(GameMath::removeDecimalIfZero);
            if (lastItem != null) {
                tip.setCompareValue((double)Math.round(lastMobDamage));
            }
            list.add(51, (ItemStatTip)tip);
        }
    }

    public void addAddedRangeTip(ItemStatTipList list, InventoryItem currentItem, InventoryItem lastItem, Mob perspective, boolean forceAdd) {
        int lastAddedRange;
        int addedRange = this.getAddedRange(currentItem);
        float bonusMod = 1.0f;
        if (this.defaultBarrel(currentItem).getGndData().getString("BarrelBonus", "null").equalsIgnoreCase("BonusRangeMod")) {
            bonusMod += this.defaultBarrel(currentItem).getGndData().getFloat("BarrelBonusValue", 0.0f) / 100.0f;
        }
        if (this.defaultBody(currentItem).getGndData().getString("BodyBonus", "null").equalsIgnoreCase("BonusRangeMod")) {
            bonusMod += this.defaultBody(currentItem).getGndData().getFloat("BodyBonusValue", 0.0f) / 100.0f;
        }
        if (this.defaultStock(currentItem).getGndData().getString("StockBonus", "null").equalsIgnoreCase("BonusRangeMod")) {
            bonusMod += this.defaultStock(currentItem).getGndData().getFloat("StockBonusValue", 0.0f) / 100.0f;
        }
        float rangeMod = bonusMod + this.defaultBarrel(currentItem).getGndData().getFloat("extraRangeMod", 0.0f) + this.defaultBody(currentItem).getGndData().getFloat("extraRangeMod", 0.0f) + this.defaultStock(currentItem).getGndData().getFloat("extraRangeMod", 0.0f);
        int n = lastAddedRange = lastItem == null ? 0 : this.getAddedRange(lastItem);
        if (addedRange != 0 || lastAddedRange != 0 || bonusMod > 1.0f || forceAdd) {
            LocalMessageDoubleItemStatTip tip = addedRange != 0 ? (rangeMod == 1.0f ? new LocalMessageDoubleItemStatTip("itemtooltip", "tooladdrange", "value", (double)addedRange, 0) : new LocalMessageDoubleItemStatTip("itemtooltip", "tooladdrange", "value", (double)addedRange * (3.5 * (double)rangeMod), 0)) : new LocalMessageDoubleItemStatTip("itemtooltip", "tooladdrange", "value", 3.5 * (double)rangeMod, 0);
            tip.setValueToString(value -> value >= 0.0 ? "+" + GameMath.removeDecimalIfZero((double)value) : GameMath.removeDecimalIfZero((double)value));
            if (lastItem != null) {
                tip.setCompareValue((double)lastAddedRange);
            }
            list.add(250, (ItemStatTip)tip);
        }
    }

    public void draw(InventoryItem item, PlayerMob perspective, int x, int y, boolean inInventory) {
        super.draw(item, perspective, x, y, inInventory);
    }

    public void drawIcon(InventoryItem item, PlayerMob perspective, int x, int y, int size, Color color) {
        File texture;
        color = color != null ? MergeFunction.MULTIPLY.merge(color, this.getDrawColor(item, perspective)) : this.getDrawColor(item, perspective);
        new GameSprite(GameTexture.fromFile((String)("items/" + item.getGndData().getString("BarrelItem", "HeadPickaxeIron")))).initDraw().color(color).size(size).draw(x, y);
        new GameSprite(GameTexture.fromFile((String)("items/" + item.getGndData().getString("StockItem", "ShaftPickaxeIron")))).initDraw().color(color).size(size).draw(x, y);
        new GameSprite(GameTexture.fromFile((String)("items/" + item.getGndData().getString("BodyItem", "BodyPickaxeBasic")))).initDraw().color(color).size(size).depth(-1.0f).draw(x, y);
        float bonusSize = 0.0f;
        if (ModularBase.getFlatAttackRangeOnlyBonusMod(item, this.defaultBarrel(item), this.defaultBody(item), this.defaultStock(item), this.attackRange.getValue(this.getUpgradeTier(item))) != 1.0f) {
            bonusSize = ModularBase.getFlatAttackRangeOnlyBonusMod(item, this.defaultBarrel(item), this.defaultBody(item), this.defaultStock(item), this.attackRange.getValue(this.getUpgradeTier(item))) - 1.0f;
        }
        if (bonusSize != 0.0f) {
            int bonusSizeText = Math.round((bonusSize + 1.0f) * 100.0f);
            texture = new File(gunsmith.modDirectory + "/attackTextures/" + item.getGndData().getString("BarrelItem", "HeadPickaxeIron") + item.getGndData().getString("BodyItem", "BodyPickaxeBasic") + item.getGndData().getString("StockItem", "ShaftPickaxeIron") + bonusSizeText + ".png");
        } else {
            texture = new File(gunsmith.modDirectory + "/attackTextures/" + item.getGndData().getString("BarrelItem", "HeadPickaxeIron") + item.getGndData().getString("BodyItem", "BodyPickaxeBasic") + item.getGndData().getString("StockItem", "ShaftPickaxeIron") + ".png");
        }
        if (!texture.exists()) {
            GameTexture baseWorld = GameTexture.fromFile((String)"player/weapons/pickaxe/ModularPickaxeBase.png", (boolean)true);
            GameTexture barrelMatTex = GameTexture.fromFile((String)("player/weapons/pickaxe/" + item.getGndData().getString("BarrelItem", "HeadPickaxeIron") + ".png"), (boolean)true);
            GameTexture bodyMatTex = GameTexture.fromFile((String)("player/weapons/pickaxe/" + item.getGndData().getString("BodyItem", "BodyPickaxeBasic") + ".png"), (boolean)true);
            GameTexture stockMatTex = GameTexture.fromFile((String)("player/weapons/pickaxe/" + item.getGndData().getString("StockItem", "ShaftPickaxeIron") + ".png"), (boolean)true);
            GameTexture attackTex = new GameTexture("debug", baseWorld.getWidth(), baseWorld.getHeight());
            attackTex.merge(barrelMatTex, 0, 0, MergeFunction.NORMAL);
            attackTex.merge(stockMatTex, 0, 0, MergeFunction.NORMAL);
            attackTex.merge(bodyMatTex, 0, 0, MergeFunction.NORMAL);
            int sizeBonusFlat = this.defaultBarrel(item).getGndData().getInt("RangeAdd", 0) + this.defaultBody(item).getGndData().getInt("RangeAdd", 0) + this.defaultStock(item).getGndData().getInt("RangeAdd", 0);
            float sizeBonusMod = 1.0f + this.defaultBarrel(item).getGndData().getFloat("RangeMod", 0.0f) + this.defaultBody(item).getGndData().getFloat("RangeMod", 0.0f) + this.defaultStock(item).getGndData().getFloat("RangeMod", 0.0f);
            if (ModularBase.getFlatAttackRangeOnlyBonusMod(item, this.defaultBarrel(item), this.defaultBody(item), this.defaultStock(item), this.attackRange.getValue(this.getUpgradeTier(item))) != 1.0f) {
                bonusSize = ModularBase.getFlatAttackRangeOnlyBonusMod(item, this.defaultBarrel(item), this.defaultBody(item), this.defaultStock(item), this.attackRange.getValue(this.getUpgradeTier(item))) - 1.0f;
            }
            float sizeMod = (float)(this.attackRange.defaultValue + sizeBonusFlat) * sizeBonusMod / (float)this.attackRange.defaultValue;
            float sizeModBonus = (float)(this.attackRange.defaultValue + sizeBonusFlat) * (sizeBonusMod + bonusSize) / (float)this.attackRange.defaultValue;
            GameTexture finalized = attackTex.resize(Math.round((float)baseWorld.getWidth() * sizeMod), Math.round((float)baseWorld.getHeight() * sizeMod), 1, 1);
            GameTexture finalizedBonus = attackTex.resize(Math.round((float)baseWorld.getWidth() * sizeModBonus), Math.round((float)baseWorld.getHeight() * sizeModBonus), 1, 1);
            attackTex.delete();
            finalized.makeFinal();
            finalizedBonus.makeFinal();
            finalized.saveTextureImage(gunsmith.modDirectory + "/attackTextures/" + item.getGndData().getString("BarrelItem", "HeadPickaxeIron") + item.getGndData().getString("BodyItem", "BodyPickaxeBasic") + item.getGndData().getString("StockItem", "ShaftPickaxeIron"));
            if (bonusSize != 0.0f) {
                int bonusSizeText = Math.round((bonusSize + 1.0f) * 100.0f);
                finalizedBonus.saveTextureImage(gunsmith.modDirectory + "/attackTextures/" + item.getGndData().getString("BarrelItem", "HeadPickaxeIron") + item.getGndData().getString("BodyItem", "BodyPickaxeBasic") + item.getGndData().getString("StockItem", "ShaftPickaxeIron") + bonusSizeText);
            }
        }
    }

    public GameSprite getAttackSprite(InventoryItem item, PlayerMob player) {
        File texture;
        float bonusSize = 0.0f;
        if (ModularBase.getFlatAttackRangeOnlyBonusMod(item, this.defaultBarrel(item), this.defaultBody(item), this.defaultStock(item), this.attackRange.getValue(this.getUpgradeTier(item))) != 1.0f) {
            bonusSize = ModularBase.getFlatAttackRangeOnlyBonusMod(item, this.defaultBarrel(item), this.defaultBody(item), this.defaultStock(item), this.attackRange.getValue(this.getUpgradeTier(item))) - 1.0f;
        }
        if (bonusSize != 0.0f) {
            int bonusSizeText = Math.round((bonusSize + 1.0f) * 100.0f);
            texture = new File(gunsmith.modDirectory + "/attackTextures/" + item.getGndData().getString("BarrelItem", "HeadPickaxeIron") + item.getGndData().getString("BodyItem", "BodyPickaxeBasic") + item.getGndData().getString("StockItem", "ShaftPickaxeIron") + bonusSizeText + ".png");
        } else {
            texture = new File(gunsmith.modDirectory + "/attackTextures/" + item.getGndData().getString("BarrelItem", "HeadPickaxeIron") + item.getGndData().getString("BodyItem", "BodyPickaxeBasic") + item.getGndData().getString("StockItem", "ShaftPickaxeIron") + ".png");
        }
        GameTexture attTex = null;
        try {
            attTex = GameTexture.fromFileRawOutside((String)texture.getPath(), (boolean)true);
        }
        catch (FileNotFoundException e) {
            if (!texture.exists()) {
                player.getClient().network.sendPacket((Packet)new RequestItemPacket(player.getPlayerSlot(), item));
            }
            return new GameSprite(GameTexture.fromFile((String)"player/weapons/demonicpickaxe.png"));
        }
        if (!texture.exists()) {
            player.getClient().network.sendPacket((Packet)new RequestItemPacket(player.getPlayerSlot(), item));
            return new GameSprite(GameTexture.fromFile((String)"player/weapons/demonicpickaxe.png"));
        }
        return new GameSprite(attTex);
    }

    public GameSprite getWorldItemSprite(InventoryItem item, PlayerMob perspective) {
        return this.getAttackSprite(item, perspective);
    }

    public float getToolTier(InventoryItem item, Mob perspective) {
        return ModularBase.getToolTier(item, perspective, this.defaultBarrel(item), this.defaultBody(item), this.defaultStock(item));
    }

    public int getFlatToolDps(InventoryItem item) {
        return ModularBase.getFlatToolDps(item, this.defaultBarrel(item), this.defaultBody(item), this.defaultStock(item));
    }

    public int getAddedRange(InventoryItem item) {
        return ModularBase.getAddedRange(item, this.defaultBarrel(item), this.defaultBody(item), this.defaultStock(item), (ToolItem)this);
    }

    public int getMiningRange(InventoryItem item, ItemAttackerMob attackerMob) {
        return ModularBase.getMiningRange(item, this.defaultBarrel(item), this.defaultBody(item), this.defaultStock(item), attackerMob, this.getAddedRange(item));
    }

    public float getAttackMovementMod(InventoryItem item) {
        return ModularBase.getAttackMovementMod(item, this.defaultBarrel(item), this.defaultBody(item), this.defaultStock(item));
    }

    public int getFlatAttackAnimTime(InventoryItem item) {
        return ModularBase.getFlatAttackAnimTime(item, this.defaultBarrel(item), this.defaultBody(item), this.defaultStock(item));
    }

    public float getAttackSpeedModifier(InventoryItem item, ItemAttackerMob attackerMob) {
        return ModularBase.getAttackSpeedModifier(item, attackerMob, this.defaultBarrel(item), this.defaultBody(item), this.defaultStock(item), this.damageType, this.getEnchantment(item));
    }

    public GameDamage getFlatAttackDamage(InventoryItem item) {
        return ModularBase.getFlatAttackDamage(item, this.defaultBarrel(item), this.defaultBody(item), this.defaultStock(item), this.getDamageType(item));
    }

    public int getFlatAttackRange(InventoryItem item) {
        return ModularBase.getFlatAttackRange(item, this.defaultBarrel(item), this.defaultBody(item), this.defaultStock(item), this.attackRange.getValue(this.getUpgradeTier(item)));
    }

    public int getKnockback(InventoryItem item, Attacker attacker) {
        return ModularBase.getKnockback(item, this.defaultBarrel(item), this.defaultBody(item), this.defaultStock(item), this.knockback, attacker, this.getEnchantment(item));
    }

    public float getFlatManaCost(InventoryItem item) {
        return ModularBase.getFlatManaCost(item, this.defaultBarrel(item), this.defaultBody(item), this.defaultStock(item), (ToolItem)this);
    }

    public float getResilienceGain(InventoryItem item) {
        return ModularBase.getResilienceGain(item, this.defaultBarrel(item), this.defaultBody(item), this.defaultStock(item), (ToolItem)this, this.resilienceGain);
    }

    public int getFlatLifeCost(InventoryItem item) {
        return ModularBase.getFlatLifeCost(item, this.defaultBarrel(item), this.defaultBody(item), this.defaultStock(item), (ToolItem)this, this.lifeCost.getValue(this.getUpgradeTier(item)));
    }

    public int getLifeSteal(InventoryItem item) {
        return ModularBase.getLifeSteal(item, this.defaultBarrel(item), this.defaultBody(item), this.defaultStock(item), (ToolItem)this, this.lifeSteal.getValue(this.getUpgradeTier(item)));
    }

    public void showAttack(Level level, int x, int y, ItemAttackerMob attackerMob, int attackHeight, InventoryItem item, int animAttack, int seed, GNDItemMap mapContent) {
        if (level.isClient()) {
            SoundManager.playSound((GameSound)GameResources.swing2, (SoundEffect)SoundEffect.effect((PrimitiveSoundEmitter)attackerMob));
        }
        if (this.getFlatLifeCost(item) != 0) {
            attackerMob.setHealth(attackerMob.getHealth() - this.getFlatLifeCost(item), (Attacker)attackerMob);
            attackerMob.sendHealthPacket(false);
        }
        this.consumeMana(attackerMob, item);
    }

    public InventoryItem onAttack(Level level, int x, int y, ItemAttackerMob attackerMob, int attackHeight, InventoryItem item, ItemAttackSlot slot, int animAttack, int seed, GNDItemMap mapContent) {
        super.onAttack(level, x, y, attackerMob, attackHeight, item, slot, animAttack, seed, mapContent);
        return item;
    }

    public void hitMob(InventoryItem item, ToolItemMobAbilityEvent event, Level level, Mob target, Mob attacker) {
        if (this.getLifeSteal(item) > 0) {
            attacker.setHealth(attacker.getHealth() + this.getLifeSteal(item));
            attacker.sendHealthPacket(false);
        }
        if (event.totalHits == 0 && target.canGiveResilience((Attacker)attacker)) {
            attacker.addResilience(this.getResilienceGain(item));
        }
        target.isServerHit(this.getAttackDamage(item), target.x - attacker.x, target.y - attacker.y, (float)this.getKnockback(item, (Attacker)attacker), (Attacker)attacker);
        InventoryItem barrelItem = ItemRegistry.getItem((String)item.getGndData().getString("BarrelItem", "HeadPickaxeIron")).getDefaultItem(null, 1);
        if (barrelItem.getGndData().getString("BarrelName", "HeadPickaxeIron").equalsIgnoreCase("Magma") && level.isServer() && target != null) {
            ActiveBuff ab = new ActiveBuff(BuffRegistry.getBuff((String)"MagmaPickDebuff"), target, 10.0f, (Attacker)attacker);
            target.addBuff(ab, true);
        }
    }

    public boolean canLevelInteract(Level level, int x, int y, ItemAttackerMob attackerMob, InventoryItem item) {
        InventoryItem bodyItem = this.defaultBody(item);
        if (attackerMob.isPlayer) {
            if (bodyItem.getGndData().getString("BodyName", "Basic").equalsIgnoreCase("Dowsing")) {
                return attackerMob.buffManager.getStacks(BuffRegistry.getBuff((String)"DowsingPickaxeCooldown")) < 5;
            }
            if (bodyItem.getGndData().getString("BodyName", "Basic").equalsIgnoreCase("Accelerating")) {
                return attackerMob.buffManager.getStacks(BuffRegistry.getBuff((String)"AccelerationPickaxeStacks")) > 0;
            }
        }
        return false;
    }

    public InventoryItem onLevelInteract(Level level, int x, int y, ItemAttackerMob attackerMob, int attackHeight, InventoryItem item, ItemAttackSlot slot, int seed, GNDItemMap mapContent) {
        InventoryItem bodyItem = this.defaultBody(item);
        if (attackerMob.isPlayer && level.isClient()) {
            if (bodyItem.getGndData().getString("BodyName", "Basic").equalsIgnoreCase("Dowsing")) {
                this.DowsingAbility(level, attackerMob);
            } else if (bodyItem.getGndData().getString("BodyName", "Basic").equalsIgnoreCase("Accelerating")) {
                this.AcceleratingAbility(level, attackerMob);
            }
        }
        return item;
    }

    public void AcceleratingAbility(Level level, ItemAttackerMob attackerMob) {
        ActiveBuff ab = new ActiveBuff("AccelerationPickaxeBuff", (Mob)attackerMob, 10.0f, null);
        ab.getGndData().setInt("stacks", attackerMob.buffManager.getBuff(BuffRegistry.getBuff((String)"AccelerationPickaxeStacks")).getStacks());
        attackerMob.buffManager.addBuff(ab, true);
        SoundManager.playSound((GameSound)gunsmith.PickaxeAccelerate, (SoundEffect)SoundEffect.effect((PrimitiveSoundEmitter)attackerMob).volume(1.0f).pitch(1.1f));
        attackerMob.buffManager.removeBuff(BuffRegistry.getBuff((String)"AccelerationPickaxeStacks"), true);
        for (int i = 0; i < 4; ++i) {
            if (!attackerMob.isVisible()) continue;
            ItemAttackerMob owner = attackerMob;
            AtomicReference<Float> currentAngle = new AtomicReference<Float>(Float.valueOf(GameRandom.globalRandom.nextFloat() * 360.0f));
            float distance = 20.0f;
            owner.getLevel().entityManager.addParticle(owner.x + GameMath.sin((float)currentAngle.get().floatValue()) * distance, owner.y + GameMath.cos((float)currentAngle.get().floatValue()) * distance * 0.75f, Particle.GType.CRITICAL).color(new Color(255, 146, 85)).height(0.0f).moves((arg_0, arg_1, arg_2, arg_3, arg_4) -> ModularPickaxe.lambda$AcceleratingAbility$1(currentAngle, distance, (Mob)owner, arg_0, arg_1, arg_2, arg_3, arg_4)).lifeTime(1000).sizeFades(16, 24);
        }
    }

    public float getItemCooldownPercent(InventoryItem item, PlayerMob perspective) {
        return 0.0f;
    }

    public ItemControllerInteract getControllerInteract(Level level, PlayerMob player, InventoryItem item, boolean beforeObjectInteract, int interactDir, LinkedList<Rectangle> mobInteractBoxes, LinkedList<Rectangle> tileInteractBoxes) {
        Point2D.Float controllerAimDir = player.getControllerAimDir();
        Point levelPos = this.getControllerAttackLevelPos(level, controllerAimDir.x, controllerAimDir.y, player, item);
        return new ItemControllerInteract(levelPos.x, levelPos.y){

            public DrawOptions getDrawOptions(GameCamera camera) {
                return null;
            }

            public void onCurrentlyFocused(GameCamera camera) {
            }
        };
    }

    public void DowsingAbility(Level level, ItemAttackerMob attackerMob) {
        ActiveBuff ab = new ActiveBuff("DowsingPickaxeCooldown", (Mob)attackerMob, 10.0f, (Attacker)attackerMob);
        attackerMob.buffManager.addBuff(ab, true);
        Point orePoint = ObjectRadiusSearch.ObjectRadiusSearchPoint(new Point(attackerMob.getTileX(), attackerMob.getTileY()), 30, level);
        if (orePoint != null) {
            int i;
            RockOreObject oreObject = (RockOreObject)level.objectLayer.getObject(0, orePoint.x, orePoint.y);
            Color oreColor = new Color(255, 255, 255);
            if (oreObject.droppedOre.equalsIgnoreCase("copperore")) {
                oreColor = new Color(227, 125, 82);
            } else if (oreObject.droppedOre.equalsIgnoreCase("ironore")) {
                oreColor = new Color(188, 155, 132);
            } else if (oreObject.droppedOre.equalsIgnoreCase("goldore")) {
                oreColor = new Color(241, 215, 88);
            } else if (oreObject.droppedOre.equalsIgnoreCase("ivyore")) {
                oreColor = new Color(160, 237, 109);
            } else if (oreObject.droppedOre.equalsIgnoreCase("myceliumore")) {
                oreColor = new Color(241, 139, 56);
            } else if (oreObject.droppedOre.equalsIgnoreCase("glacialore")) {
                oreColor = new Color(97, 231, 243);
            } else if (oreObject.droppedOre.equalsIgnoreCase("nightsteelore")) {
                oreColor = new Color(61, 76, 126);
            } else if (oreObject.droppedOre.equalsIgnoreCase("spideriteore")) {
                oreColor = new Color(159, 227, 113);
            } else if (oreObject.droppedOre.equalsIgnoreCase("tungstenore")) {
                oreColor = new Color(55, 67, 94);
            } else if (oreObject.droppedOre.equalsIgnoreCase("alchemyshard")) {
                oreColor = new Color(255, 94, 156);
            } else if (oreObject.droppedOre.equalsIgnoreCase("amberore")) {
                oreColor = new Color(237, 172, 99);
            } else if (oreObject.droppedOre.equalsIgnoreCase("ancientfossilore")) {
                oreColor = new Color(163, 115, 60);
            } else if (oreObject.droppedOre.equalsIgnoreCase("frostshardore")) {
                oreColor = new Color(128, 255, 244);
            } else if (oreObject.droppedOre.equalsIgnoreCase("lifequartzore")) {
                oreColor = new Color(255, 182, 182);
            } else if (oreObject.droppedOre.equalsIgnoreCase("quartzore")) {
                oreColor = new Color(255, 249, 209);
            } else if (oreObject.droppedOre.equalsIgnoreCase("slimeum")) {
                oreColor = new Color(6, 196, 6);
            } else if (oreObject.droppedOre.equalsIgnoreCase("upgradeshard")) {
                oreColor = new Color(28, 92, 230);
            } else {
                GameTexture oreTex = GameTexture.fromFile((String)("objects/" + oreObject.droppedOre));
                if (oreTex != null) {
                    for (int i2 = 0; i2 < oreTex.getHeight(); ++i2) {
                        for (int j = 0; j < oreTex.getWidth(); ++j) {
                            if (oreTex.getAlpha(i2, j) != 255) continue;
                            oreColor = new Color(oreTex.getRed(i2, j), oreTex.getGreen(i2, j), oreTex.getBlue(i2, j));
                        }
                    }
                }
            }
            double dx = orePoint.x - attackerMob.getTileX();
            double dy = orePoint.y - attackerMob.getTileY();
            float angle = (float)Math.toDegrees(Math.atan2(dy, dx));
            SoundManager.playSound((GameSound)gunsmith.PickaxeDowsing, (SoundEffect)SoundEffect.effect((PrimitiveSoundEmitter)attackerMob).volume(0.5f).pitch(0.8f + (float)attackerMob.buffManager.getStacks(BuffRegistry.getBuff((String)"DowsingPickaxeCooldown")) / 10.0f));
            for (i = 0; i < 8; ++i) {
                level.entityManager.addParticle(attackerMob.x + (float)(GameRandom.globalRandom.nextGaussian() * 6.0), attackerMob.y + (float)(GameRandom.globalRandom.nextGaussian() * 8.0), Particle.GType.IMPORTANT_COSMETIC).movesConstantAngle(angle + GameRandom.globalRandom.getFloatBetween(-15.0f, 15.0f), (float)(30 + GameRandom.globalRandom.getIntBetween(0, 10))).sizeFades(1, 10).color(oreColor).height(16.0f).lifeTime(700).givesLight(30).size((options, lifeTime, timeAlive, lifePercent) -> options.size(10)).fadesAlphaTime(1, 500);
                SoundManager.playSound((GameSound)GameResources.cling, (SoundEffect)SoundEffect.effect((PrimitiveSoundEmitter)attackerMob).volume(0.6f).pitch(GameRandom.globalRandom.getFloatBetween(2.1f, 3.5f)));
            }
            for (i = 0; i < 5; ++i) {
                level.entityManager.addParticle(attackerMob.x + (float)(GameRandom.globalRandom.nextGaussian() * 6.0), attackerMob.y + (float)(GameRandom.globalRandom.nextGaussian() * 8.0), Particle.GType.IMPORTANT_COSMETIC).movesConstantAngle(angle + GameRandom.globalRandom.getFloatBetween(-10.0f, 10.0f), (float)(45 + GameRandom.globalRandom.getIntBetween(0, 10))).color(oreColor).height(16.0f).lifeTime(850 + GameRandom.globalRandom.getIntBetween(0, 100)).givesLight(85).size((options, lifeTime, timeAlive, lifePercent) -> options.size(12)).sizeFades(1, 10).fadesAlphaTime(1, 500);
            }
            for (i = 0; i < 3; ++i) {
                level.entityManager.addParticle(attackerMob.x + (float)(GameRandom.globalRandom.nextGaussian() * 6.0), attackerMob.y + (float)(GameRandom.globalRandom.nextGaussian() * 8.0), Particle.GType.IMPORTANT_COSMETIC).movesConstantAngle(angle + GameRandom.globalRandom.getFloatBetween(-5.0f, 5.0f), (float)(60 + GameRandom.globalRandom.getIntBetween(0, 10))).color(oreColor).height(16.0f).lifeTime(1000 + GameRandom.globalRandom.getIntBetween(0, 100)).givesLight(100).size((options, lifeTime, timeAlive, lifePercent) -> options.size(14)).sizeFades(1, 10).fadesAlphaTime(1, 500);
            }
        } else {
            SoundManager.playSound((GameSound)GameResources.electricExplosion, (SoundEffect)SoundEffect.effect((PrimitiveSoundEmitter)attackerMob).volume(0.7f).pitch(GameRandom.globalRandom.getFloatBetween(0.9f, 1.0f)));
        }
    }

    public ItemAttackDrawOptions setupItemSpriteAttackDrawOptions(ItemAttackDrawOptions options, InventoryItem item, PlayerMob player, int mobDir, float attackDirX, float attackDirY, float attackProgress, Color itemColor) {
        ItemAttackDrawOptions.AttackItemSprite itemSprite = options.itemSprite(this.getAttackSprite(item, player));
        itemSprite.itemRotatePoint(this.attackXOffset, this.attackYOffset);
        itemSprite.itemRawCoords();
        if (itemColor != null) {
            itemSprite.itemColor(itemColor);
        }
        return itemSprite.itemEnd();
    }

    public float getHitboxSwingAngle(InventoryItem item, int dir) {
        return 90.0f;
    }

    public float getHitboxSwingAngleOffset(InventoryItem item, int dir, float swingAngle) {
        return 0.0f;
    }

    public Function<Float, Float> getSwingDirection(InventoryItem item, AttackAnimMob mob) {
        int attackDir = mob.getDir();
        float animSwingAngle = this.getHitboxSwingAngle(item, attackDir);
        float animSwingAngleOffset = this.getHitboxSwingAngleOffset(item, attackDir, animSwingAngle);
        Function<Float, Float> angleGetter = attackDir == 0 ? (this.getAnimInverted(item) ? progress -> Float.valueOf(-progress.floatValue() * animSwingAngle - animSwingAngleOffset) : progress -> Float.valueOf(180.0f + progress.floatValue() * 2.0f * animSwingAngle + animSwingAngleOffset)) : (attackDir == 1 ? (this.getAnimInverted(item) ? progress -> Float.valueOf(90.0f - progress.floatValue() * animSwingAngle - animSwingAngleOffset) : progress -> Float.valueOf(270.0f + progress.floatValue() * animSwingAngle + animSwingAngleOffset)) : (attackDir == 2 ? (this.getAnimInverted(item) ? progress -> Float.valueOf(180.0f - progress.floatValue() * animSwingAngle - animSwingAngleOffset) : progress -> Float.valueOf(progress.floatValue() * 2.0f * animSwingAngle + animSwingAngleOffset)) : (this.getAnimInverted(item) ? progress -> Float.valueOf(90.0f + progress.floatValue() * animSwingAngle + animSwingAngleOffset) : progress -> Float.valueOf(270.0f - progress.floatValue() * animSwingAngle - animSwingAngleOffset))));
        return angleGetter;
    }

    public ArrayList<Shape> getHitboxes(InventoryItem item, AttackAnimMob mob, int aimX, int aimY, ToolItemMobAbilityEvent event, boolean forDebug) {
        ArrayList<Shape> out = new ArrayList<Shape>();
        int attackRange = Math.round((float)this.getFlatAttackRange(item) * 0.85f);
        float lastProgress = event.lastHitboxProgress;
        float nextProgress = mob.getAttackAnimProgress();
        float circumference = (float)(Math.PI * (double)attackRange);
        float percPerWidth = Math.max(10.0f, this.width) / circumference;
        Point2D.Float base = new Point2D.Float(mob.x, mob.y);
        int attackDir = mob.getDir();
        if (attackDir == 0) {
            base.x += 8.0f;
        } else if (attackDir == 2) {
            base.x -= 8.0f;
        }
        for (float progress = lastProgress; progress <= nextProgress; progress += percPerWidth) {
            float angle = this.getSwingDirection(item, mob).apply(Float.valueOf(progress)).floatValue();
            Point2D.Float dir = GameMath.getAngleDir((float)angle);
            Line2D.Float attackLine = new Line2D.Float(base.x, base.y, dir.x * (float)attackRange + mob.x, dir.y * (float)attackRange + mob.y);
            if (this.width > 0.0f) {
                out.add((Shape)new LineHitbox((Line2D)attackLine, this.width));
            } else {
                out.add(attackLine);
            }
            if (forDebug) continue;
            event.lastHitboxProgress = progress;
        }
        return out;
    }

    private static /* synthetic */ void lambda$AcceleratingAbility$1(AtomicReference currentAngle, float distance, Mob owner, Point2D.Float pos, float delta, int lifeTime, int timeAlive, float lifePercent) {
        float angle = currentAngle.accumulateAndGet(Float.valueOf(delta * 150.0f / 250.0f), Float::sum).floatValue();
        float distY = distance * 0.75f;
        pos.x = owner.x + GameMath.sin((float)angle) * distance;
        pos.y = owner.y + GameMath.cos((float)angle) * distY * 0.75f;
    }
}

