/*
 * Decompiled with CFR 0.152.
 */
package gunsmith.items.tools;

import gunsmith.events.DeflectingToolItemMobAbilityEvent;
import gunsmith.items.tools.ModularBase;
import java.awt.Color;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.function.BiConsumer;
import necesse.engine.input.Control;
import necesse.engine.localization.Localization;
import necesse.engine.network.Packet;
import necesse.engine.network.client.ClientClient;
import necesse.engine.network.gameNetworkData.GNDItemMap;
import necesse.engine.network.packet.PacketSummonFocus;
import necesse.engine.registries.BuffRegistry;
import necesse.engine.registries.ItemRegistry;
import necesse.engine.registries.MobRegistry;
import necesse.engine.util.GameBlackboard;
import necesse.engine.util.GameRandom;
import necesse.engine.util.ObjectValue;
import necesse.entity.levelEvent.GlaiveShowAttackEvent;
import necesse.entity.levelEvent.LevelEvent;
import necesse.entity.levelEvent.mobAbilityLevelEvent.ToolItemMobAbilityEvent;
import necesse.entity.mobs.AttackAnimMob;
import necesse.entity.mobs.Attacker;
import necesse.entity.mobs.GameDamage;
import necesse.entity.mobs.Mob;
import necesse.entity.mobs.PlayerMob;
import necesse.entity.mobs.buffs.ActiveBuff;
import necesse.entity.mobs.buffs.staticBuffs.Buff;
import necesse.entity.mobs.itemAttacker.FollowPosition;
import necesse.entity.mobs.itemAttacker.ItemAttackSlot;
import necesse.entity.mobs.itemAttacker.ItemAttackerMob;
import necesse.entity.mobs.summon.summonFollowingMob.attackingFollowingMob.DryadSpiritFollowingMob;
import necesse.entity.particle.Particle;
import necesse.gfx.GameResources;
import necesse.gfx.camera.GameCamera;
import necesse.gfx.drawOptions.DrawOptions;
import necesse.gfx.gameTooltips.ListGameTooltips;
import necesse.inventory.InventoryItem;
import necesse.inventory.item.Item;
import necesse.inventory.item.ItemControllerInteract;
import necesse.inventory.item.ItemInteractAction;
import necesse.inventory.item.toolItem.ToolItem;
import necesse.inventory.item.toolItem.glaiveToolItem.GlaiveToolItem;
import necesse.inventory.item.toolItem.summonToolItem.SummonToolItem;
import necesse.level.maps.Level;

public class ModularGlaive
extends GlaiveToolItem
implements ItemInteractAction {
    public InventoryItem defaultBarrel(InventoryItem item) {
        InventoryItem defaultItem = ItemRegistry.getItem((String)item.getGndData().getString("BarrelItem", "HeadGlaiveGold")).getDefaultItem(null, 1);
        if (item.getGndData().hasKey("BarrelBonus")) {
            item.getGndData().copyKeysToTarget(defaultItem.getGndData(), new String[]{"BarrelBonus", "BarrelBonusValue"});
        }
        return defaultItem;
    }

    public InventoryItem defaultBody(InventoryItem item) {
        InventoryItem defaultItem = ItemRegistry.getItem((String)item.getGndData().getString("BodyItem", "BodyGlaiveBasic")).getDefaultItem(null, 1);
        if (item.getGndData().hasKey("BodyBonus")) {
            item.getGndData().copyKeysToTarget(defaultItem.getGndData(), new String[]{"BodyBonus", "BodyBonusValue"});
        }
        return defaultItem;
    }

    public InventoryItem defaultStock(InventoryItem item) {
        InventoryItem defaultItem = ItemRegistry.getItem((String)item.getGndData().getString("StockItem", "ShaftGlaiveWood")).getDefaultItem(null, 1);
        if (item.getGndData().hasKey("StockBonus")) {
            item.getGndData().copyKeysToTarget(defaultItem.getGndData(), new String[]{"StockBonus", "StockBonusValue"});
        }
        return defaultItem;
    }

    public ModularGlaive() {
        super(500, null);
        this.rarity = Item.Rarity.EPIC;
        this.attackAnimTime.setBaseValue(400);
        this.attackDamage.setBaseValue(60.0f).setUpgradedValue(1.0f, 65.0f);
        this.attackRange.setBaseValue(200);
        this.knockback.setBaseValue(75);
        this.width = 20.0f;
        this.attackXOffset = 58;
        this.attackYOffset = 58;
        this.canBeUsedForRaids = false;
        this.useForRaidsOnlyIfObtained = false;
        this.setItemCategory(new String[]{"TF", "glaive"});
    }

    protected ListGameTooltips getDisplayNameTooltips(InventoryItem item, PlayerMob perspective, GameBlackboard blackboard) {
        return ModularBase.getDisplayNameTooltips(item, perspective, blackboard, this.defaultBarrel(item), this.defaultBody(item), this.defaultStock(item));
    }

    public ListGameTooltips getPreEnchantmentTooltips(InventoryItem item, PlayerMob perspective, GameBlackboard blackboard) {
        ListGameTooltips tooltips = new ListGameTooltips();
        if (!Control.INV_QUICK_TRASH.isDown() && !Control.INV_QUICK_MOVE.isDown()) {
            tooltips = super.getPreEnchantmentTooltips(item, perspective, blackboard);
        }
        if (!item.getGndData().hasKey("StockItem")) {
            return tooltips;
        }
        if (Control.INV_QUICK_TRASH.isDown()) {
            tooltips.add(Localization.translate((String)"itemtooltip", (String)"Head") + " " + Localization.translate((String)"item", (String)(item.getGndData().getString("BarrelItem", "HeadGlaiveGold") + "Name")), 400);
            tooltips.add(Localization.translate((String)"itemtooltip", (String)"Grip") + " " + Localization.translate((String)"item", (String)(item.getGndData().getString("BodyItem", "BodyGlaiveBasic") + "Name")), 400);
            tooltips.add(Localization.translate((String)"itemtooltip", (String)"Shaft") + " " + Localization.translate((String)"item", (String)(item.getGndData().getString("StockItem", "ShaftGlaiveWood") + "Name")), 400);
        } else if (Control.INV_QUICK_MOVE.isDown()) {
            String color;
            tooltips.add(Localization.translate((String)"barreltooltip", (String)"HeadTip"));
            if (item.getGndData().hasKey("BarrelBonus")) {
                color = "\u00a7#07BFE8";
                StringBuilder stringBuilder = new StringBuilder();
                if (item.getGndData().getFloat("BarrelBonusValue") >= this.defaultStock(item).getGndData().getFloat(stringBuilder.append("High").append(item.getGndData().getString("BarrelBonus")).toString())) {
                    color = "\u00a7#E655E6";
                }
                if (item.getGndData().getString("BarrelBonus").equalsIgnoreCase("BonusAttackSpeed")) {
                    if (item.getGndData().getFloat("BarrelBonusValue") > 0.0f) {
                        tooltips.add(Localization.translate((String)"bonusmodtip", (String)item.getGndData().getString("BarrelBonus"), (Object[])new Object[]{"value", Float.valueOf(item.getGndData().getFloat("BarrelBonusValue") / 10.0f), "unit", "+", "color", color}));
                    } else {
                        tooltips.add(Localization.translate((String)"bonusmodtip", (String)item.getGndData().getString("BarrelBonus"), (Object[])new Object[]{"value", Float.valueOf(item.getGndData().getFloat("BarrelBonusValue") / 10.0f), "unit", "", "color", color}));
                    }
                } else if (item.getGndData().getFloat("BarrelBonusValue") > 0.0f) {
                    tooltips.add(Localization.translate((String)"bonusmodtip", (String)item.getGndData().getString("BarrelBonus"), (Object[])new Object[]{"value", Float.valueOf(item.getGndData().getFloat("BarrelBonusValue")), "unit", "+", "color", color}));
                } else {
                    tooltips.add(Localization.translate((String)"bonusmodtip", (String)item.getGndData().getString("BarrelBonus"), (Object[])new Object[]{"value", Float.valueOf(item.getGndData().getFloat("BarrelBonusValue")), "unit", "", "color", color}));
                }
            }
            tooltips.add(Localization.translate((String)"barreltooltip", (String)(item.getGndData().getString("BarrelItem", "HeadGlaiveGold") + "Tip")), 400);
            tooltips.add(Localization.translate((String)"bodytooltip", (String)"GripTip"));
            if (item.getGndData().hasKey("BodyBonus")) {
                color = "\u00a7#07BFE8";
                StringBuilder stringBuilder = new StringBuilder();
                if (item.getGndData().getFloat("BodyBonusValue") >= this.defaultStock(item).getGndData().getFloat(stringBuilder.append("High").append(item.getGndData().getString("BodyBonus")).toString())) {
                    color = "\u00a7#E655E6";
                }
                if (item.getGndData().getString("BodyBonus").equalsIgnoreCase("BonusAttackSpeed")) {
                    if (item.getGndData().getFloat("BodyBonusValue") > 0.0f) {
                        tooltips.add(Localization.translate((String)"bonusmodtip", (String)item.getGndData().getString("BodyBonus"), (Object[])new Object[]{"value", Float.valueOf(item.getGndData().getFloat("BodyBonusValue") / 10.0f), "unit", "+", "color", color}));
                    } else {
                        tooltips.add(Localization.translate((String)"bonusmodtip", (String)item.getGndData().getString("BodyBonus"), (Object[])new Object[]{"value", Float.valueOf(item.getGndData().getFloat("BodyBonusValue") / 10.0f), "unit", "", "color", color}));
                    }
                } else if (item.getGndData().getFloat("BodyBonusValue") > 0.0f) {
                    tooltips.add(Localization.translate((String)"bonusmodtip", (String)item.getGndData().getString("BodyBonus"), (Object[])new Object[]{"value", Float.valueOf(item.getGndData().getFloat("BodyBonusValue")), "unit", "+", "color", color}));
                } else {
                    tooltips.add(Localization.translate((String)"bonusmodtip", (String)item.getGndData().getString("BodyBonus"), (Object[])new Object[]{"value", Float.valueOf(item.getGndData().getFloat("BodyBonusValue")), "unit", "", "color", color}));
                }
            }
            tooltips.add(Localization.translate((String)"bodytooltip", (String)(item.getGndData().getString("BodyItem", "BodyGlaiveBasic") + "Tip")), 400);
            tooltips.add(Localization.translate((String)"stocktooltip", (String)"ShaftTip"));
            if (item.getGndData().hasKey("StockBonus")) {
                color = "\u00a7#07BFE8";
                StringBuilder stringBuilder = new StringBuilder();
                if (item.getGndData().getFloat("StockBonusValue") >= this.defaultStock(item).getGndData().getFloat(stringBuilder.append("High").append(item.getGndData().getString("StockBonus")).toString())) {
                    color = "\u00a7#E655E6";
                }
                if (item.getGndData().getString("StockBonus").equalsIgnoreCase("BonusAttackSpeed")) {
                    if (item.getGndData().getFloat("StockBonusValue") > 0.0f) {
                        tooltips.add(Localization.translate((String)"bonusmodtip", (String)item.getGndData().getString("StockBonus"), (Object[])new Object[]{"value", Float.valueOf(item.getGndData().getFloat("StockBonusValue") / 10.0f), "unit", "+", "color", color}));
                    } else {
                        tooltips.add(Localization.translate((String)"bonusmodtip", (String)item.getGndData().getString("StockBonus"), (Object[])new Object[]{"value", Float.valueOf(item.getGndData().getFloat("StockBonusValue") / 10.0f), "unit", "", "color", color}));
                    }
                } else if (item.getGndData().getFloat("StockBonusValue") > 0.0f) {
                    tooltips.add(Localization.translate((String)"bonusmodtip", (String)item.getGndData().getString("StockBonus"), (Object[])new Object[]{"value", Float.valueOf(item.getGndData().getFloat("StockBonusValue")), "unit", "+", "color", color}));
                } else {
                    tooltips.add(Localization.translate((String)"bonusmodtip", (String)item.getGndData().getString("StockBonus"), (Object[])new Object[]{"value", Float.valueOf(item.getGndData().getFloat("StockBonusValue")), "unit", "", "color", color}));
                }
            }
            tooltips.add(Localization.translate((String)"stocktooltip", (String)(item.getGndData().getString("StockItem", "ShaftGlaiveWood") + "Tip")), 400);
        } else {
            if (item.getGndData().getString("BodyItem", "").equalsIgnoreCase("BodyGlaiveDryad")) {
                tooltips.add(Localization.translate((String)"toolabilitytip", (String)"BodyGlaiveDryadTip"), 400);
            }
            tooltips.add(Localization.translate((String)"itemtooltip", (String)"holdShift", (String)"shift", (String)"invquickmove"), 400);
            tooltips.add(Localization.translate((String)"itemtooltip", (String)"holdCtrl", (String)"ctrl", (String)"invtrash"), 400);
        }
        return tooltips;
    }

    public void showAttack(Level level, int x, int y, ItemAttackerMob attackerMob, int attackHeight, final InventoryItem item, int animAttack, int seed, GNDItemMap mapContent) {
        super.showAttack(level, x, y, attackerMob, attackHeight, item, animAttack, seed, mapContent);
        final InventoryItem barrelItem = this.defaultBarrel(item);
        final InventoryItem bodyItem = this.defaultBody(item);
        final InventoryItem stockItem = this.defaultStock(item);
        if (level.isClient() && (barrelItem.getGndData().getBoolean("ShowAttack") || bodyItem.getGndData().getBoolean("ShowAttack") || stockItem.getGndData().getBoolean("ShowAttack"))) {
            level.entityManager.addLevelEventHidden((LevelEvent)new GlaiveShowAttackEvent((AttackAnimMob)attackerMob, x, y, seed, 10.0f){

                public void tick(float angle) {
                    GameRandom gameRandom = new GameRandom();
                    float colorModifier = gameRandom.getFloatBetween(0.0f, 1.0f);
                    Color randomColor = ModularGlaive.this.getParticleColor(colorModifier, item);
                    Point2D.Float angleDir = this.getAngleDir(angle);
                    if (barrelItem.getGndData().getString("AttackDisplay").equalsIgnoreCase("Slime") || bodyItem.getGndData().getString("AttackDisplay").equalsIgnoreCase("Slime") || stockItem.getGndData().getString("AttackDisplay").equalsIgnoreCase("Slime")) {
                        this.level.entityManager.addParticle(this.attackMob.x + angleDir.x * 85.0f + (float)this.attackMob.getCurrentAttackDrawXOffset(), this.attackMob.y + angleDir.y * 85.0f + (float)this.attackMob.getCurrentAttackDrawYOffset(), Particle.GType.COSMETIC).sprite(GameResources.bubbleParticle.sprite(0, 0, 12)).color(randomColor).movesConstant(angleDir.x * 40.0f, angleDir.y * 40.0f).lifeTime(400);
                        this.level.entityManager.addParticle(this.attackMob.x - angleDir.x * 85.0f + (float)this.attackMob.getCurrentAttackDrawXOffset(), this.attackMob.y - angleDir.y * 85.0f + (float)this.attackMob.getCurrentAttackDrawYOffset(), Particle.GType.COSMETIC).sprite(GameResources.bubbleParticle.sprite(0, 0, 12)).color(randomColor).movesConstant(angleDir.x * -40.0f, angleDir.y * -40.0f).lifeTime(400);
                    }
                    if (barrelItem.getGndData().getString("AttackDisplay").equalsIgnoreCase("Fire") || bodyItem.getGndData().getString("AttackDisplay").equalsIgnoreCase("Fire") || stockItem.getGndData().getString("AttackDisplay").equalsIgnoreCase("Fire")) {
                        this.level.entityManager.addParticle(this.attackMob.x + angleDir.x * 85.0f + (float)this.attackMob.getCurrentAttackDrawXOffset(), this.attackMob.y + angleDir.y * 85.0f + (float)this.attackMob.getCurrentAttackDrawYOffset(), Particle.GType.COSMETIC).sprite(GameResources.puffParticles.sprite(GameRandom.globalRandom.getIntBetween(1, 2), 0, 12)).color(new Color(187, GameRandom.globalRandom.getIntBetween(60, 100), 0)).sizeFadesInAndOut(8, 24, 50, 15).movesConstant(angleDir.x * GameRandom.globalRandom.getFloatBetween(5.0f, 60.0f), angleDir.y * GameRandom.globalRandom.getFloatBetween(5.0f, 60.0f)).lifeTime(400);
                        this.level.entityManager.addParticle(this.attackMob.x - angleDir.x * 85.0f + (float)this.attackMob.getCurrentAttackDrawXOffset(), this.attackMob.y - angleDir.y * 85.0f + (float)this.attackMob.getCurrentAttackDrawYOffset(), Particle.GType.COSMETIC).sprite(GameResources.puffParticles.sprite(GameRandom.globalRandom.getIntBetween(1, 2), 0, 12)).color(new Color(187, GameRandom.globalRandom.getIntBetween(60, 100), 0)).sizeFadesInAndOut(8, 24, 50, 15).movesConstant(angleDir.x * GameRandom.globalRandom.getFloatBetween(-5.0f, -60.0f), angleDir.y * GameRandom.globalRandom.getFloatBetween(-5.0f, -60.0f)).lifeTime(250);
                    }
                    if (barrelItem.getGndData().getString("AttackDisplay").equalsIgnoreCase("Cryo") || bodyItem.getGndData().getString("AttackDisplay").equalsIgnoreCase("Cryo") || stockItem.getGndData().getString("AttackDisplay").equalsIgnoreCase("Cryo")) {
                        this.level.entityManager.addParticle(this.attackMob.x + angleDir.x * 75.0f + (float)this.attackMob.getCurrentAttackDrawXOffset(), this.attackMob.y + angleDir.y * 75.0f + (float)this.attackMob.getCurrentAttackDrawYOffset(), Particle.GType.COSMETIC).color(new Color(0, 222, 218)).minDrawLight(150).givesLight(179.0f, 1.0f).lifeTime(400);
                        this.level.entityManager.addParticle(this.attackMob.x - angleDir.x * 75.0f + (float)this.attackMob.getCurrentAttackDrawXOffset(), this.attackMob.y - angleDir.y * 75.0f + (float)this.attackMob.getCurrentAttackDrawYOffset(), Particle.GType.COSMETIC).color(new Color(0, 222, 218)).minDrawLight(150).givesLight(179.0f, 1.0f).lifeTime(400);
                    }
                }
            });
        }
        Ellipse2D.Float circle = new Ellipse2D.Float(attackerMob.x - (float)this.getAttackRange(item) * 1.48f / 2.0f, attackerMob.y - (float)this.getAttackRange(item) * 1.48f / 2.0f, (float)this.getAttackRange(item) * 1.48f, (float)this.getAttackRange(item) * 1.48f);
        if (bodyItem.getGndData().getString("BodyName", "Basic").equalsIgnoreCase("Fire")) {
            level.entityManager.mobs.streamArea((float)x, (float)y, 1000).forEach(m -> this.buffHit(circle, (Mob)m, attackerMob));
        }
    }

    public void draw(InventoryItem item, PlayerMob perspective, int x, int y, boolean inInventory) {
        super.draw(item, perspective, x, y, inInventory);
    }

    public Color getParticleColor(float modifier, InventoryItem item) {
        InventoryItem bodyItem = this.defaultBody(item);
        if (bodyItem.getGndData().getString("BodyName", "Basic").equalsIgnoreCase("Slime")) {
            return new Color((int)(70.0f * (1.0f + 1.8f * modifier)), (int)(178.0f * (1.0f + 0.3f * modifier)), (int)(170.0f * (1.0f + 0.2f * modifier)));
        }
        if (bodyItem.getGndData().getString("BodyName", "Basic").equalsIgnoreCase("Fire")) {
            return new Color((int)(70.0f * (1.0f + 1.8f * modifier)), (int)(178.0f * (1.0f + 0.3f * modifier)), (int)(170.0f * (1.0f + 0.2f * modifier)));
        }
        return new Color((int)(70.0f * (1.0f + 1.8f * modifier)), (int)(178.0f * (1.0f + 0.3f * modifier)), (int)(170.0f * (1.0f + 0.2f * modifier)));
    }

    public float getAttackMovementMod(InventoryItem item) {
        return ModularBase.getAttackMovementMod(item, this.defaultBarrel(item), this.defaultBody(item), this.defaultStock(item));
    }

    public int getFlatAttackAnimTime(InventoryItem item) {
        return ModularBase.getFlatAttackAnimTime(item, this.defaultBarrel(item), this.defaultBody(item), this.defaultStock(item));
    }

    public float getAttackSpeedModifier(InventoryItem item, ItemAttackerMob attackerMob) {
        return ModularBase.getAttackSpeedModifier(item, attackerMob, this.defaultBarrel(item), this.defaultBody(item), this.defaultStock(item), this.damageType, this.getEnchantment(item));
    }

    public GameDamage getFlatAttackDamage(InventoryItem item) {
        return ModularBase.getFlatAttackDamage(item, this.defaultBarrel(item), this.defaultBody(item), this.defaultStock(item), this.getDamageType(item));
    }

    public int getFlatAttackRange(InventoryItem item) {
        return ModularBase.getFlatAttackRange(item, this.defaultBarrel(item), this.defaultBody(item), this.defaultStock(item), this.attackRange.getValue(this.getUpgradeTier(item)));
    }

    public int getKnockback(InventoryItem item, Attacker attacker) {
        return ModularBase.getKnockback(item, this.defaultBarrel(item), this.defaultBody(item), this.defaultStock(item), this.knockback, attacker, this.getEnchantment(item));
    }

    public float getFlatManaCost(InventoryItem item) {
        return ModularBase.getFlatManaCost(item, this.defaultBarrel(item), this.defaultBody(item), this.defaultStock(item), (ToolItem)this);
    }

    public float getResilienceGain(InventoryItem item) {
        return ModularBase.getResilienceGain(item, this.defaultBarrel(item), this.defaultBody(item), this.defaultStock(item), (ToolItem)this, this.resilienceGain);
    }

    public int getFlatLifeCost(InventoryItem item) {
        return ModularBase.getFlatLifeCost(item, this.defaultBarrel(item), this.defaultBody(item), this.defaultStock(item), (ToolItem)this, this.lifeCost.getValue(this.getUpgradeTier(item)));
    }

    public int getLifeSteal(InventoryItem item) {
        return ModularBase.getLifeSteal(item, this.defaultBarrel(item), this.defaultBody(item), this.defaultStock(item), (ToolItem)this, this.lifeSteal.getValue(this.getUpgradeTier(item)));
    }

    public InventoryItem onAttack(Level level, int x, int y, ItemAttackerMob attackerMob, int attackHeight, InventoryItem item, ItemAttackSlot slot, int animAttack, int seed, GNDItemMap mapContent) {
        if (animAttack == 0) {
            int animTime = this.getAttackAnimTime(item, attackerMob);
            if (this.defaultBody(item).getGndData().getString("BodyName", "Basic").equalsIgnoreCase("Block")) {
                Ellipse2D.Float circle = new Ellipse2D.Float(attackerMob.x - (float)(this.getFlatAttackRange(item) / 2), attackerMob.y - (float)(this.getFlatAttackRange(item) / 2), this.getFlatAttackRange(item), this.getFlatAttackRange(item));
                DeflectingToolItemMobAbilityEvent event = new DeflectingToolItemMobAbilityEvent((AttackAnimMob)attackerMob, seed, item, x - attackerMob.getX(), y - attackerMob.getY() + attackHeight, animTime, animTime / 2, circle);
                attackerMob.addAndSendAttackerLevelEvent((LevelEvent)event);
            } else {
                ToolItemMobAbilityEvent event = new ToolItemMobAbilityEvent((AttackAnimMob)attackerMob, seed, item, x - attackerMob.getX(), y - attackerMob.getY() + attackHeight, animTime, animTime / 2);
                attackerMob.addAndSendAttackerLevelEvent((LevelEvent)event);
            }
        }
        return item;
    }

    public void hitMob(InventoryItem item, ToolItemMobAbilityEvent event, Level level, Mob target, Mob attacker) {
        super.hitMob(item, event, level, target, attacker);
        InventoryItem barrelItem = this.defaultBarrel(item);
        InventoryItem bodyItem = this.defaultBody(item);
        InventoryItem stockItem = this.defaultStock(item);
        if (bodyItem.getGndData().getString("BodyName", "Basic").equalsIgnoreCase("Dryad")) {
            Buff dryadHaunted = BuffRegistry.Debuffs.DRYAD_HAUNTED;
            ActiveBuff ab = new ActiveBuff(dryadHaunted, target, 10000, (Attacker)attacker);
            ab.setStacks(1, 10000, (Attacker)attacker);
            target.buffManager.addBuff(ab, true);
            if (target.buffManager.getStacks(dryadHaunted) >= 10) {
                target.buffManager.removeBuff(dryadHaunted, true);
                ModularGlaive.spawnDryadSpirit(attacker);
            }
            ActiveBuff ab2 = new ActiveBuff(BuffRegistry.getBuff((String)"GlaiveDryadStacks"), attacker, 10000, (Attacker)attacker);
            attacker.buffManager.addBuff(ab2, true);
        }
        if (barrelItem.getGndData().getString("BodyName", "Basic").equalsIgnoreCase("Frost")) {
            ActiveBuff ab = new ActiveBuff(BuffRegistry.Debuffs.FROSTSLOW, target, 4.0f, (Attacker)attacker);
            target.addBuff(ab, true);
        }
    }

    public static void spawnDryadSpirit(Mob owner) {
        if (owner != null && owner.isServer()) {
            int maxSummons = 5;
            DryadSpiritFollowingMob summonedMob = (DryadSpiritFollowingMob)MobRegistry.getMob((String)"dryadspirit", (Level)owner.getLevel());
            ((ItemAttackerMob)owner).serverFollowersManager.addFollower("summonedmobtemp", (Mob)summonedMob, FollowPosition.FLYING_CIRCLE_FAST, "summonedmob", 1.0f, p -> maxSummons, (BiConsumer)null, false);
            Point2D.Float spawnPoint = SummonToolItem.findSpawnLocation((Mob)summonedMob, (Level)owner.getLevel(), (float)owner.x, (float)owner.y);
            owner.getLevel().entityManager.addMob((Mob)summonedMob, spawnPoint.x, spawnPoint.y);
        }
    }

    public void buffHit(Shape circle, Mob mob, ItemAttackerMob attackerMob) {
        if (circle.intersects(mob.getHitBox()) && mob.canBeHit((Attacker)attackerMob)) {
            ActiveBuff ab = new ActiveBuff(BuffRegistry.getBuff((String)"MagmaPickDebuff"), mob, 3.0f, (Attacker)attackerMob);
            mob.buffManager.addBuff(ab, true);
            mob.collisionHitCooldowns.resetCooldowns();
        }
    }

    public ItemControllerInteract getControllerInteract(Level level, PlayerMob player, InventoryItem item, boolean beforeObjectInteract, int interactDir, LinkedList<Rectangle> mobInteractBoxes, LinkedList<Rectangle> tileInteractBoxes) {
        Point2D.Float controllerAimDir = player.getControllerAimDir();
        Point levelPos = this.getControllerAttackLevelPos(level, controllerAimDir.x, controllerAimDir.y, player, item);
        return new ItemControllerInteract(levelPos.x, levelPos.y){

            public DrawOptions getDrawOptions(GameCamera camera) {
                return null;
            }

            public void onCurrentlyFocused(GameCamera camera) {
            }
        };
    }

    public boolean canLevelInteract(Level level, int x, int y, ItemAttackerMob attackerMob, InventoryItem item) {
        InventoryItem bodyItem = this.defaultBody(item);
        return bodyItem.getGndData().getString("BodyName", "Basic").equalsIgnoreCase("Dryad");
    }

    public InventoryItem onLevelInteract(Level level, int x, int y, ItemAttackerMob attackerMob, int attackHeight, InventoryItem item, ItemAttackSlot slot, int seed, GNDItemMap mapContent) {
        if (attackerMob.isPlayer) {
            ModularGlaive.runSummonFocus(level, x, y, (PlayerMob)attackerMob);
        }
        return item;
    }

    public static void runSummonFocus(Level level, int x, int y, PlayerMob player) {
        if (level.isClient()) {
            Mob newFocus = ModularGlaive.getNextSummonFocus(level, x, y, player);
            ClientClient me = level.getClient().getClient();
            if (me != null) {
                me.playerMob.summonFocusUniqueID = newFocus == null ? -1 : newFocus.getUniqueID();
                level.getClient().network.sendPacket((Packet)new PacketSummonFocus(newFocus));
            }
        }
    }

    public static Mob getNextSummonFocus(Level level, int x, int y, PlayerMob player) {
        if (level.isClient()) {
            Mob nextFocus = level.entityManager.streamAreaMobsAndPlayersTileRange(x, y, 10).filter(m -> m.canBeTargeted((Mob)player, player.getNetworkClient()) && m.getSelectBox().contains(x, y)).findFirst().orElse(null);
            if (nextFocus == null) {
                nextFocus = level.entityManager.streamAreaMobsAndPlayersTileRange(x, y, 10).filter(m -> m.canBeTargeted((Mob)player, player.getNetworkClient())).map(m -> {
                    Rectangle selectBox = m.getSelectBox();
                    return new ObjectValue(m, (Object)new Point2D.Double(selectBox.getCenterX(), selectBox.getCenterY()).distance(x, y));
                }).filter(m -> (Double)m.value < 75.0).findBestDistance(1, Comparator.comparingDouble(m -> (Double)m.value)).map(m -> (Mob)m.object).orElse(null);
            }
            return nextFocus;
        }
        return null;
    }

    public int getMobInteractAnimTime(InventoryItem item, ItemAttackerMob attackerMob) {
        return 0;
    }

    public int getLevelInteractAttackAnimTime(InventoryItem item, ItemAttackerMob attackerMob) {
        return 0;
    }

    public void showLevelInteract(Level level, int x, int y, ItemAttackerMob attackerMob, int attackHeight, InventoryItem item, int seed, GNDItemMap mapContent) {
    }
}

