/*
 * Decompiled with CFR 0.152.
 */
package gunsmith.items.tools;

import gunsmith.items.tools.ModularGun;
import java.awt.Color;
import necesse.engine.localization.Localization;
import necesse.engine.util.GameBlackboard;
import necesse.entity.mobs.Attacker;
import necesse.entity.mobs.GameDamage;
import necesse.entity.mobs.Mob;
import necesse.entity.mobs.PlayerMob;
import necesse.entity.mobs.buffs.BuffModifiers;
import necesse.entity.mobs.gameDamageType.DamageType;
import necesse.entity.mobs.itemAttacker.ItemAttackerMob;
import necesse.gfx.GameColor;
import necesse.gfx.gameTooltips.ListGameTooltips;
import necesse.gfx.gameTooltips.StringTooltips;
import necesse.inventory.InventoryItem;
import necesse.inventory.enchants.ToolDamageEnchantment;
import necesse.inventory.enchants.ToolItemEnchantment;
import necesse.inventory.enchants.ToolItemModifiers;
import necesse.inventory.item.toolItem.ToolItem;
import necesse.inventory.item.upgradeUtils.FloatUpgradeValue;
import necesse.inventory.item.upgradeUtils.IntUpgradeValue;

public class ModularBase {
    public static ListGameTooltips getDisplayNameTooltips(InventoryItem item, PlayerMob perspective, GameBlackboard blackboard, InventoryItem barrelItem, InventoryItem bodyItem, InventoryItem stockItem) {
        ListGameTooltips tooltips = new ListGameTooltips();
        if (!item.getGndData().hasKey("StockItem")) {
            tooltips.add((Object)new StringTooltips(item.item.getStringID() + " Template", new Color(255, 255, 255)));
            tooltips.add((Object)new StringTooltips("I see you cheating :)", new Color(255, 0, 0)));
        } else {
            float rarity = barrelItem.getGndData().getFloat("Rarity", 0.0f) + bodyItem.getGndData().getFloat("Rarity", 0.0f) + stockItem.getGndData().getFloat("Rarity", 0.0f);
            GameColor tiercolor = GameColor.ITEM_COMMON;
            if (rarity >= 6.0f) {
                tiercolor = GameColor.ITEM_QUEST;
            } else if (rarity >= 5.0f) {
                tiercolor = GameColor.ITEM_LEGENDARY;
            } else if (rarity >= 4.0f) {
                tiercolor = GameColor.ITEM_RARE;
            } else if (rarity >= 3.0f) {
                tiercolor = GameColor.ITEM_EPIC;
            } else if (rarity >= 2.0f) {
                tiercolor = GameColor.ITEM_UNCOMMON;
            }
            if (item.getGndData().hasKey("name")) {
                tooltips.add((Object)new StringTooltips(item.getGndData().getString("name", "Wack"), tiercolor));
            } else if (item.item instanceof ModularGun) {
                tooltips.add((Object)new StringTooltips(Localization.translate((String)"item", (String)(item.getGndData().getString("BodyItem") + "Name")) + " " + Localization.translate((String)"item", (String)(item.getGndData().getString("StockItem") + "Name")) + " " + Localization.translate((String)"item", (String)item.item.getStringID()), tiercolor));
            } else {
                tooltips.add((Object)new StringTooltips(Localization.translate((String)"item", (String)(item.getGndData().getString("BodyItem") + "Name")) + " " + Localization.translate((String)"item", (String)(item.getGndData().getString("BarrelItem") + "Name")) + " " + Localization.translate((String)"item", (String)item.item.getStringID()), tiercolor));
            }
            int upgradeLevel = item.item.getUpgradeLevel(item);
            if (upgradeLevel > 0) {
                String tierString;
                int tier = upgradeLevel / 100;
                if ((float)tier == (float)upgradeLevel / 100.0f) {
                    tierString = String.valueOf(tier);
                } else {
                    int extra = upgradeLevel - tier * 100;
                    tierString = tier + " +" + extra + "%";
                }
                tooltips.add((Object)new StringTooltips(Localization.translate((String)"item", (String)"tier", (String)"tiernumber", (String)tierString), new Color(133, 49, 168)));
            }
        }
        return tooltips;
    }

    public static float getAttackMovementMod(InventoryItem item, InventoryItem barrelItem, InventoryItem bodyItem, InventoryItem stockItem) {
        float bonus = 0.0f;
        if (barrelItem.getGndData().getString("BarrelBonus", "null").equalsIgnoreCase("BonusMoveSpeed")) {
            bonus += barrelItem.getGndData().getFloat("BarrelBonusValue", 0.0f) / 100.0f;
        }
        if (bodyItem.getGndData().getString("BodyBonus", "null").equalsIgnoreCase("BonusMoveSpeed")) {
            bonus += bodyItem.getGndData().getFloat("BodyBonusValue", 0.0f) / 100.0f;
        }
        if (stockItem.getGndData().getString("StockBonus", "null").equalsIgnoreCase("BonusMoveSpeed")) {
            bonus += stockItem.getGndData().getFloat("StockBonusValue", 0.0f) / 100.0f;
        }
        if (0.5f + bonus + (barrelItem.getGndData().getFloat("MovementMod", 0.0f) + bodyItem.getGndData().getFloat("MovementMod", 0.0f) + stockItem.getGndData().getFloat("MovementMod", 0.0f)) >= 1.0f) {
            return 1.0f;
        }
        return 0.5f + bonus + (barrelItem.getGndData().getFloat("MovementMod", 0.0f) + bodyItem.getGndData().getFloat("MovementMod", 0.0f) + stockItem.getGndData().getFloat("MovementMod", 0.0f));
    }

    public static int getFlatAttackAnimTime(InventoryItem item, InventoryItem barrelItem, InventoryItem bodyItem, InventoryItem stockItem) {
        float bonus = 0.0f;
        if (barrelItem.getGndData().getString("BarrelBonus", "null").equalsIgnoreCase("BonusAttackSpeed")) {
            bonus += barrelItem.getGndData().getFloat("BarrelBonusValue", 0.0f);
        }
        if (bodyItem.getGndData().getString("BodyBonus", "null").equalsIgnoreCase("BonusAttackSpeed")) {
            bonus += bodyItem.getGndData().getFloat("BodyBonusValue", 0.0f);
        }
        if (stockItem.getGndData().getString("StockBonus", "null").equalsIgnoreCase("BonusAttackSpeed")) {
            bonus += stockItem.getGndData().getFloat("StockBonusValue", 0.0f);
        }
        int acceleration = item.getGndData().getInt("accelerationSwings", 0);
        return Math.round((float)(barrelItem.getGndData().getInt("attackSpeed", 0) + bodyItem.getGndData().getInt("attackSpeed", 0) + stockItem.getGndData().getInt("attackSpeed", 0)) - bonus + (float)(acceleration * 100));
    }

    public static float getAttackSpeedModifier(InventoryItem item, ItemAttackerMob attackerMob, InventoryItem barrelItem, InventoryItem bodyItem, InventoryItem stockItem, DamageType type, ToolDamageEnchantment enchantment) {
        float bonus = 1.0f;
        if (barrelItem.getGndData().getString("BarrelBonus", "null").equalsIgnoreCase("BonusAttackSpeedMod")) {
            bonus += barrelItem.getGndData().getFloat("BarrelBonusValue", 0.0f) / 100.0f;
        }
        if (bodyItem.getGndData().getString("BodyBonus", "null").equalsIgnoreCase("BonusAttackSpeedMod")) {
            bonus += bodyItem.getGndData().getFloat("BodyBonusValue", 0.0f) / 100.0f;
        }
        if (stockItem.getGndData().getString("StockBonus", "null").equalsIgnoreCase("BonusAttackSpeedMod")) {
            bonus += stockItem.getGndData().getFloat("StockBonusValue", 0.0f) / 100.0f;
        }
        float speedMod = bonus + barrelItem.getGndData().getFloat("attackSpeedMod", 0.0f) + bodyItem.getGndData().getFloat("attackSpeedMod", 0.0f) + stockItem.getGndData().getFloat("attackSpeedMod", 0.0f);
        return type.calculateTotalAttackSpeedModifier((Attacker)attackerMob, ((Float)enchantment.applyModifierUnlimited(ToolItemModifiers.ATTACK_SPEED, (Object)((Float)ToolItemModifiers.ATTACK_SPEED.defaultBuffValue))).floatValue()) * speedMod;
    }

    public static float getAttackSpeedModifier(InventoryItem item, ItemAttackerMob attackerMob, InventoryItem barrelItem, InventoryItem bodyItem, InventoryItem stockItem, DamageType type, ToolItemEnchantment enchantment) {
        float bonus = 1.0f;
        if (barrelItem.getGndData().getString("BarrelBonus", "null").equalsIgnoreCase("BonusAttackSpeedMod")) {
            bonus += barrelItem.getGndData().getFloat("BarrelBonusValue", 0.0f) / 100.0f;
        }
        if (bodyItem.getGndData().getString("BodyBonus", "null").equalsIgnoreCase("BonusAttackSpeedMod")) {
            bonus += bodyItem.getGndData().getFloat("BodyBonusValue", 0.0f) / 100.0f;
        }
        if (stockItem.getGndData().getString("StockBonus", "null").equalsIgnoreCase("BonusAttackSpeedMod")) {
            bonus += stockItem.getGndData().getFloat("StockBonusValue", 0.0f) / 100.0f;
        }
        float speedMod = bonus + barrelItem.getGndData().getFloat("attackSpeedMod", 0.0f) + bodyItem.getGndData().getFloat("attackSpeedMod", 0.0f) + stockItem.getGndData().getFloat("attackSpeedMod", 0.0f);
        return type.calculateTotalAttackSpeedModifier((Attacker)attackerMob, ((Float)enchantment.applyModifierUnlimited(ToolItemModifiers.ATTACK_SPEED, (Object)((Float)ToolItemModifiers.ATTACK_SPEED.defaultBuffValue))).floatValue()) * speedMod;
    }

    public static GameDamage getFlatAttackDamage(InventoryItem item, InventoryItem barrelItem, InventoryItem bodyItem, InventoryItem stockItem, DamageType type) {
        float damageBonus = 0.0f;
        float damageBonusMod = 1.0f;
        if (barrelItem.getGndData().getString("BarrelBonus", "null").equalsIgnoreCase("BonusDamage")) {
            damageBonus += barrelItem.getGndData().getFloat("BarrelBonusValue", 0.0f);
        }
        if (bodyItem.getGndData().getString("BodyBonus", "null").equalsIgnoreCase("BonusDamage")) {
            damageBonus += bodyItem.getGndData().getFloat("BodyBonusValue", 0.0f);
        }
        if (stockItem.getGndData().getString("StockBonus", "null").equalsIgnoreCase("BonusDamage")) {
            damageBonus += stockItem.getGndData().getFloat("StockBonusValue", 0.0f);
        }
        if (barrelItem.getGndData().getString("BarrelBonus", "null").equalsIgnoreCase("BonusDamageMod")) {
            damageBonusMod += barrelItem.getGndData().getFloat("BarrelBonusValue", 0.0f) / 100.0f;
        }
        if (bodyItem.getGndData().getString("BodyBonus", "null").equalsIgnoreCase("BonusDamageMod")) {
            damageBonusMod += bodyItem.getGndData().getFloat("BodyBonusValue", 0.0f) / 100.0f;
        }
        if (stockItem.getGndData().getString("StockBonus", "null").equalsIgnoreCase("BonusDamageMod")) {
            damageBonusMod += stockItem.getGndData().getFloat("StockBonusValue", 0.0f) / 100.0f;
        }
        float armorPenBonus = 0.0f;
        float armorPenBonusMod = 1.0f;
        if (barrelItem.getGndData().getString("BarrelBonus", "null").equalsIgnoreCase("BonusArmorPen")) {
            armorPenBonus += barrelItem.getGndData().getFloat("BarrelBonusValue", 0.0f);
        }
        if (bodyItem.getGndData().getString("BodyBonus", "null").equalsIgnoreCase("BonusArmorPen")) {
            armorPenBonus += bodyItem.getGndData().getFloat("BodyBonusValue", 0.0f);
        }
        if (stockItem.getGndData().getString("StockBonus", "null").equalsIgnoreCase("BonusArmorPen")) {
            armorPenBonus += stockItem.getGndData().getFloat("StockBonusValue", 0.0f);
        }
        if (barrelItem.getGndData().getString("BarrelBonus", "null").equalsIgnoreCase("BonusArmorPenMod")) {
            armorPenBonusMod += barrelItem.getGndData().getFloat("BarrelBonusValue", 0.0f) / 100.0f;
        }
        if (bodyItem.getGndData().getString("BodyBonus", "null").equalsIgnoreCase("BonusArmorPenMod")) {
            armorPenBonusMod += bodyItem.getGndData().getFloat("BodyBonusValue", 0.0f) / 100.0f;
        }
        if (stockItem.getGndData().getString("StockBonus", "null").equalsIgnoreCase("BonusArmorPenMod")) {
            armorPenBonusMod += stockItem.getGndData().getFloat("StockBonusValue", 0.0f) / 100.0f;
        }
        float critChanceBonus = 0.0f;
        if (barrelItem.getGndData().getString("BarrelBonus", "null").equalsIgnoreCase("BonusCritChance")) {
            critChanceBonus += barrelItem.getGndData().getFloat("BarrelBonusValue", 0.0f) / 100.0f;
        }
        if (bodyItem.getGndData().getString("BodyBonus", "null").equalsIgnoreCase("BonusCritChance")) {
            critChanceBonus += bodyItem.getGndData().getFloat("BodyBonusValue", 0.0f) / 100.0f;
        }
        if (stockItem.getGndData().getString("StockBonus", "null").equalsIgnoreCase("BonusCritChance")) {
            critChanceBonus += stockItem.getGndData().getFloat("StockBonusValue", 0.0f) / 100.0f;
        }
        float armorPen = armorPenBonus + barrelItem.getGndData().getFloat("ArmorPen", 0.0f) + bodyItem.getGndData().getFloat("ArmorPen", 0.0f) + stockItem.getGndData().getFloat("ArmorPen", 0.0f);
        if (armorPenBonusMod > 0.0f) {
            armorPen *= armorPenBonusMod;
        }
        float critChance = critChanceBonus + barrelItem.getGndData().getFloat("CritChance", 0.0f) + bodyItem.getGndData().getFloat("CritChance", 0.0f) + stockItem.getGndData().getFloat("CritChance", 0.0f);
        float damage = damageBonus + barrelItem.getGndData().getFloat("attackDamage", 0.0f) + bodyItem.getGndData().getFloat("attackDamage", 0.0f) + stockItem.getGndData().getFloat("attackDamage", 0.0f);
        float damageModBase = 1.0f + barrelItem.getGndData().getFloat("DamageMod", 0.0f) + bodyItem.getGndData().getFloat("DamageMod", 0.0f) + stockItem.getGndData().getFloat("DamageMod", 0.0f);
        if (barrelItem.getGndData().hasKey("HeadDamageUpgrade" + item.item.getUpgradeLevel(item)) || barrelItem.getGndData().hasKey("HeadDamageUpgrade1") || barrelItem.getGndData().hasKey("HeadDamageUpgrade10")) {
            if (item.item.getUpgradeTier(item) > 0.0f) {
                if (barrelItem.getGndData().hasKey("HeadDamageUpgrade" + item.item.getUpgradeLevel(item) / 100)) {
                    return new GameDamage(type, (barrelItem.getGndData().getFloat("HeadDamageUpgrade" + item.item.getUpgradeLevel(item) / 100, 16.0f) + damage - barrelItem.getGndData().getFloat("attackDamage", 0.0f)) * damageModBase * damageBonusMod, armorPen, critChance);
                }
                float upgMod = (barrelItem.getGndData().getFloat("HeadDamageUpgrade10", 66.0f) - barrelItem.getGndData().getFloat("HeadDamageUpgrade1", 50.0f)) / 9.0f;
                return new GameDamage(type, (barrelItem.getGndData().getFloat("HeadDamageUpgrade1", 50.0f) + upgMod * (item.item.getUpgradeTier(item) - 1.0f) + damage - barrelItem.getGndData().getFloat("attackDamage", 0.0f)) * damageModBase * damageBonusMod, armorPen, critChance);
            }
            return new GameDamage(type, damage * damageModBase * damageBonusMod, armorPen, critChance);
        }
        if (bodyItem.getGndData().hasKey("BodyDamageUpgrade" + item.item.getUpgradeLevel(item)) || bodyItem.getGndData().hasKey("BodyDamageUpgrade1") || bodyItem.getGndData().hasKey("BodyDamageUpgrade10")) {
            if (item.item.getUpgradeTier(item) > 0.0f) {
                if (bodyItem.getGndData().hasKey("BodyDamageUpgrade" + item.item.getUpgradeLevel(item) / 100)) {
                    return new GameDamage(type, (bodyItem.getGndData().getFloat("BodyDamageUpgrade" + item.item.getUpgradeLevel(item) / 100, 16.0f) + damage - bodyItem.getGndData().getFloat("attackDamage", 0.0f)) * damageModBase * damageBonusMod, armorPen, critChance);
                }
                float upgMod = (bodyItem.getGndData().getFloat("BodyDamageUpgrade5", 66.0f) - bodyItem.getGndData().getFloat("BodyDamageUpgrade1", 50.0f)) / 9.0f;
                return new GameDamage(type, (bodyItem.getGndData().getFloat("BodyDamageUpgrade1", 50.0f) + upgMod * (item.item.getUpgradeTier(item) - 1.0f) + damage - bodyItem.getGndData().getFloat("attackDamage", 0.0f)) * damageModBase * damageBonusMod, armorPen, critChance);
            }
            return new GameDamage(type, damage * damageModBase * damageBonusMod, armorPen, critChance);
        }
        if (item.item.getUpgradeTier(item) > 0.0f) {
            if (stockItem.getGndData().hasKey("StockDamageUpgrade" + item.item.getUpgradeLevel(item) / 100)) {
                return new GameDamage(type, (stockItem.getGndData().getFloat("StockDamageUpgrade" + item.item.getUpgradeLevel(item) / 100, 16.0f) + damage - stockItem.getGndData().getFloat("attackDamage", 0.0f)) * damageModBase * damageBonusMod, armorPen, critChance);
            }
            float upgMod = (stockItem.getGndData().getFloat("StockDamageUpgrade10", 66.0f) - stockItem.getGndData().getFloat("StockDamageUpgrade1", 50.0f)) / 9.0f;
            return new GameDamage(type, (stockItem.getGndData().getFloat("StockDamageUpgrade1", 50.0f) + upgMod * (item.item.getUpgradeTier(item) - 1.0f) + damage - stockItem.getGndData().getFloat("attackDamage", 0.0f)) * damageModBase * damageBonusMod, armorPen, critChance);
        }
        return new GameDamage(type, damage * damageModBase * damageBonusMod, armorPen, critChance);
    }

    public static int getFlatAttackRange(InventoryItem item, InventoryItem barrelItem, InventoryItem bodyItem, InventoryItem stockItem, int flatAttackRange) {
        float bonus = 0.0f;
        float bonusMod = 1.0f;
        if (barrelItem.getGndData().getString("BarrelBonus", "null").equalsIgnoreCase("BonusAttackRange")) {
            bonus += barrelItem.getGndData().getFloat("BarrelBonusValue", 0.0f);
        }
        if (bodyItem.getGndData().getString("BodyBonus", "null").equalsIgnoreCase("BonusAttackRange")) {
            bonus += bodyItem.getGndData().getFloat("BodyBonusValue", 0.0f);
        }
        if (stockItem.getGndData().getString("StockBonus", "null").equalsIgnoreCase("BonusAttackRange")) {
            bonus += stockItem.getGndData().getFloat("StockBonusValue", 0.0f);
        }
        if (barrelItem.getGndData().getString("BarrelBonus", "null").equalsIgnoreCase("BonusAttackRangeMod")) {
            bonusMod += barrelItem.getGndData().getFloat("BarrelBonusValue", 0.0f) / 100.0f;
        }
        if (bodyItem.getGndData().getString("BodyBonus", "null").equalsIgnoreCase("BonusAttackRangeMod")) {
            bonusMod += bodyItem.getGndData().getFloat("BodyBonusValue", 0.0f) / 100.0f;
        }
        if (stockItem.getGndData().getString("StockBonus", "null").equalsIgnoreCase("BonusAttackRangeMod")) {
            bonusMod += stockItem.getGndData().getFloat("StockBonusValue", 0.0f) / 100.0f;
        }
        int attackRange = flatAttackRange + Math.round(bonus) + barrelItem.getGndData().getInt("RangeAdd", 0) + bodyItem.getGndData().getInt("RangeAdd", 0) + stockItem.getGndData().getInt("RangeAdd", 0);
        float attackRangeMod = bonusMod + barrelItem.getGndData().getFloat("RangeMod", 0.0f) + bodyItem.getGndData().getFloat("RangeMod", 0.0f) + stockItem.getGndData().getFloat("RangeMod", 0.0f);
        return Math.round((float)attackRange * attackRangeMod);
    }

    public static float getFlatAttackRangeOnlyBonusMod(InventoryItem item, InventoryItem barrelItem, InventoryItem bodyItem, InventoryItem stockItem, int flatAttackRange) {
        float bonusMod = 1.0f;
        if (barrelItem.getGndData().getString("BarrelBonus", "null").equalsIgnoreCase("BonusAttackRangeMod")) {
            bonusMod += barrelItem.getGndData().getFloat("BarrelBonusValue", 0.0f) / 100.0f;
        }
        if (bodyItem.getGndData().getString("BodyBonus", "null").equalsIgnoreCase("BonusAttackRangeMod")) {
            bonusMod += bodyItem.getGndData().getFloat("BodyBonusValue", 0.0f) / 100.0f;
        }
        if (stockItem.getGndData().getString("StockBonus", "null").equalsIgnoreCase("BonusAttackRangeMod")) {
            bonusMod += stockItem.getGndData().getFloat("StockBonusValue", 0.0f) / 100.0f;
        }
        return bonusMod;
    }

    public static int getKnockback(InventoryItem item, InventoryItem barrelItem, InventoryItem bodyItem, InventoryItem stockItem, IntUpgradeValue knockbacks, Attacker attacker, ToolDamageEnchantment enchantment) {
        Mob attackOwner;
        float bonus = 0.0f;
        float bonusMod = 1.0f;
        if (barrelItem.getGndData().getString("BarrelBonus", "null").equalsIgnoreCase("BonusKnockback")) {
            bonus += barrelItem.getGndData().getFloat("BarrelBonusValue", 0.0f);
        }
        if (bodyItem.getGndData().getString("BodyBonus", "null").equalsIgnoreCase("BonusKnockback")) {
            bonus += bodyItem.getGndData().getFloat("BodyBonusValue", 0.0f);
        }
        if (stockItem.getGndData().getString("StockBonus", "null").equalsIgnoreCase("BonusKnockback")) {
            bonus += stockItem.getGndData().getFloat("StockBonusValue", 0.0f);
        }
        if (barrelItem.getGndData().getString("BarrelBonus", "null").equalsIgnoreCase("BonusKnockbackMod")) {
            bonusMod += barrelItem.getGndData().getFloat("BarrelBonusValue", 0.0f) / 100.0f;
        }
        if (bodyItem.getGndData().getString("BodyBonus", "null").equalsIgnoreCase("BonusKnockbackMod")) {
            bonusMod += bodyItem.getGndData().getFloat("BodyBonusValue", 0.0f) / 100.0f;
        }
        if (stockItem.getGndData().getString("StockBonus", "null").equalsIgnoreCase("BonusKnockbackMod")) {
            bonusMod += stockItem.getGndData().getFloat("StockBonusValue", 0.0f) / 100.0f;
        }
        int knockback = Math.round(bonus) + knockbacks.getValue(0.0f) + barrelItem.getGndData().getInt("Knockback", 0) + bodyItem.getGndData().getInt("Knockback", 0) + stockItem.getGndData().getInt("Knockback", 0);
        float knockbackMod = bonusMod + barrelItem.getGndData().getFloat("KnockbackMod", 0.0f) + bodyItem.getGndData().getFloat("KnockbackMod", 0.0f) + stockItem.getGndData().getFloat("KnockbackMod", 0.0f);
        Mob mob = attackOwner = attacker != null ? attacker.getAttackOwner() : null;
        if (attackOwner != null) {
            knockbackMod += ((Float)attackOwner.buffManager.getModifier(BuffModifiers.KNOCKBACK_OUT)).floatValue();
        }
        return knockbackMod > 1.0f ? Math.round((float)knockback * ((Float)enchantment.applyModifierLimited(ToolItemModifiers.KNOCKBACK, (Object)((Float)ToolItemModifiers.KNOCKBACK.defaultBuffManagerValue))).floatValue() * knockbackMod) : Math.round((float)knockback * ((Float)enchantment.applyModifierLimited(ToolItemModifiers.KNOCKBACK, (Object)((Float)ToolItemModifiers.KNOCKBACK.defaultBuffManagerValue))).floatValue());
    }

    public static int getKnockback(InventoryItem item, InventoryItem barrelItem, InventoryItem bodyItem, InventoryItem stockItem, IntUpgradeValue knockbacks, Attacker attacker, ToolItemEnchantment enchantment) {
        Mob attackOwner;
        float bonus = 0.0f;
        float bonusMod = 1.0f;
        if (barrelItem.getGndData().getString("BarrelBonus", "null").equalsIgnoreCase("BonusKnockback")) {
            bonus += barrelItem.getGndData().getFloat("BarrelBonusValue", 0.0f);
        }
        if (bodyItem.getGndData().getString("BodyBonus", "null").equalsIgnoreCase("BonusKnockback")) {
            bonus += bodyItem.getGndData().getFloat("BodyBonusValue", 0.0f);
        }
        if (stockItem.getGndData().getString("StockBonus", "null").equalsIgnoreCase("BonusKnockback")) {
            bonus += stockItem.getGndData().getFloat("StockBonusValue", 0.0f);
        }
        if (barrelItem.getGndData().getString("BarrelBonus", "null").equalsIgnoreCase("BonusKnockbackMod")) {
            bonusMod += barrelItem.getGndData().getFloat("BarrelBonusValue", 0.0f) / 100.0f;
        }
        if (bodyItem.getGndData().getString("BodyBonus", "null").equalsIgnoreCase("BonusKnockbackMod")) {
            bonusMod += bodyItem.getGndData().getFloat("BodyBonusValue", 0.0f) / 100.0f;
        }
        if (stockItem.getGndData().getString("StockBonus", "null").equalsIgnoreCase("BonusKnockbackMod")) {
            bonusMod += stockItem.getGndData().getFloat("StockBonusValue", 0.0f) / 100.0f;
        }
        int knockback = Math.round(bonus) + knockbacks.getValue(0.0f) + barrelItem.getGndData().getInt("Knockback", 0) + bodyItem.getGndData().getInt("Knockback", 0) + stockItem.getGndData().getInt("Knockback", 0);
        float knockbackMod = bonusMod + barrelItem.getGndData().getFloat("KnockbackMod", 0.0f) + bodyItem.getGndData().getFloat("KnockbackMod", 0.0f) + stockItem.getGndData().getFloat("KnockbackMod", 0.0f);
        Mob mob = attackOwner = attacker != null ? attacker.getAttackOwner() : null;
        if (attackOwner != null) {
            knockbackMod = ((Float)attackOwner.buffManager.getModifier(BuffModifiers.KNOCKBACK_OUT)).floatValue();
        }
        return knockbackMod > 1.0f ? Math.round((float)knockback * ((Float)enchantment.applyModifierLimited(ToolItemModifiers.KNOCKBACK, (Object)((Float)ToolItemModifiers.KNOCKBACK.defaultBuffManagerValue))).floatValue() * knockbackMod) : Math.round((float)knockback * ((Float)enchantment.applyModifierLimited(ToolItemModifiers.KNOCKBACK, (Object)((Float)ToolItemModifiers.KNOCKBACK.defaultBuffManagerValue))).floatValue());
    }

    public static int getFlatToolDps(InventoryItem item, InventoryItem barrelItem, InventoryItem bodyItem, InventoryItem stockItem) {
        float bonus = 0.0f;
        float bonusMod = 1.0f;
        if (barrelItem.getGndData().getString("BarrelBonus", "null").equalsIgnoreCase("BonusPower")) {
            bonus += barrelItem.getGndData().getFloat("BarrelBonusValue", 0.0f);
        }
        if (bodyItem.getGndData().getString("BodyBonus", "null").equalsIgnoreCase("BonusPower")) {
            bonus += bodyItem.getGndData().getFloat("BodyBonusValue", 0.0f);
        }
        if (stockItem.getGndData().getString("StockBonus", "null").equalsIgnoreCase("BonusPower")) {
            bonus += stockItem.getGndData().getFloat("StockBonusValue", 0.0f);
        }
        if (barrelItem.getGndData().getString("BarrelBonus", "null").equalsIgnoreCase("BonusPowerMod")) {
            bonusMod += barrelItem.getGndData().getFloat("BarrelBonusValue", 0.0f) / 100.0f;
        }
        if (bodyItem.getGndData().getString("BodyBonus", "null").equalsIgnoreCase("BonusPowerMod")) {
            bonusMod += bodyItem.getGndData().getFloat("BodyBonusValue", 0.0f) / 100.0f;
        }
        if (stockItem.getGndData().getString("StockBonus", "null").equalsIgnoreCase("BonusPowerMod")) {
            bonusMod += stockItem.getGndData().getFloat("StockBonusValue", 0.0f) / 100.0f;
        }
        float toolDamage = bonus + bodyItem.getGndData().getFloat("toolDpsFlat", 0.0f) + stockItem.getGndData().getFloat("toolDpsFlat", 0.0f);
        float toolDamageMod = bonusMod + barrelItem.getGndData().getFloat("toolDpsMod", 0.0f) + bodyItem.getGndData().getFloat("toolDpsMod", 0.0f) + stockItem.getGndData().getFloat("toolDpsMod", 0.0f);
        if (item.item.getUpgradeTier(item) > 0.0f) {
            if (barrelItem.getGndData().hasKey("HeadDPSUpgrade" + item.item.getUpgradeLevel(item) / 100)) {
                return Math.round((barrelItem.getGndData().getFloat("HeadDPSUpgrade" + item.item.getUpgradeLevel(item) / 100, 16.0f) + toolDamage) * toolDamageMod);
            }
            float upgMod = (barrelItem.getGndData().getFloat("HeadDPSUpgrade10", 588.0f) - barrelItem.getGndData().getFloat("HeadDPSUpgrade1", 210.0f)) / 10.0f;
            return Math.round((barrelItem.getGndData().getFloat("HeadDPSUpgrade1", 210.0f) + upgMod * (item.item.getUpgradeTier(item) - 1.0f) + toolDamage) * toolDamageMod);
        }
        return Math.round(((float)barrelItem.getGndData().getInt("toolDpsFlat", 0) + toolDamage) * toolDamageMod);
    }

    public static int getAddedRange(InventoryItem item, InventoryItem barrelItem, InventoryItem bodyItem, InventoryItem stockItem, ToolItem toolItem) {
        float bonus = 0.0f;
        if (barrelItem.getGndData().getString("BarrelBonus", "null").equalsIgnoreCase("BonusRange")) {
            bonus += barrelItem.getGndData().getFloat("BarrelBonusValue", 0.0f);
        }
        if (bodyItem.getGndData().getString("BodyBonus", "null").equalsIgnoreCase("BonusRange")) {
            bonus += bodyItem.getGndData().getFloat("BodyBonusValue", 0.0f);
        }
        if (stockItem.getGndData().getString("StockBonus", "null").equalsIgnoreCase("BonusRange")) {
            bonus += stockItem.getGndData().getFloat("StockBonusValue", 0.0f);
        }
        float range = bonus + (float)(barrelItem.getGndData().getInt("extraRange", 0) + bodyItem.getGndData().getInt("extraRange", 0) + stockItem.getGndData().getInt("extraRange", 0));
        return Math.round(range);
    }

    public static int getMiningRange(InventoryItem item, InventoryItem barrelItem, InventoryItem bodyItem, InventoryItem stockItem, ItemAttackerMob attackerMob, int range) {
        float rangeMod;
        float bonusMod = 1.0f;
        if (barrelItem.getGndData().getString("BarrelBonus", "null").equalsIgnoreCase("BonusRangeMod")) {
            bonusMod += barrelItem.getGndData().getFloat("BarrelBonusValue", 0.0f) / 100.0f;
        }
        if (bodyItem.getGndData().getString("BodyBonus", "null").equalsIgnoreCase("BonusRangeMod")) {
            bonusMod += bodyItem.getGndData().getFloat("BodyBonusValue", 0.0f) / 100.0f;
        }
        if (stockItem.getGndData().getString("StockBonus", "null").equalsIgnoreCase("BonusRangeMod")) {
            bonusMod += stockItem.getGndData().getFloat("StockBonusValue", 0.0f) / 100.0f;
        }
        return (rangeMod = bonusMod + barrelItem.getGndData().getFloat("extraRangeMod", 0.0f) + bodyItem.getGndData().getFloat("extraRangeMod", 0.0f) + stockItem.getGndData().getFloat("extraRangeMod", 0.0f)) > 1.0f ? (int)(((3.5f + (float)range) * rangeMod + (attackerMob == null ? 0.0f : ((Float)attackerMob.buffManager.getModifier(BuffModifiers.MINING_RANGE)).floatValue())) * 32.0f) : (int)((3.5f + (float)range + (attackerMob == null ? 0.0f : ((Float)attackerMob.buffManager.getModifier(BuffModifiers.MINING_RANGE)).floatValue())) * 32.0f);
    }

    public static float getToolTier(InventoryItem item, Mob perspective, InventoryItem barrelItem, InventoryItem bodyItem, InventoryItem stockItem) {
        float bonus = 0.0f;
        if (barrelItem.getGndData().getString("BarrelBonus", "null").equalsIgnoreCase("BonusToolTier")) {
            bonus += barrelItem.getGndData().getFloat("BarrelBonusValue", 0.0f) / 100.0f;
        }
        if (bodyItem.getGndData().getString("BodyBonus", "null").equalsIgnoreCase("BonusToolTier")) {
            bonus += bodyItem.getGndData().getFloat("BodyBonusValue", 0.0f) / 100.0f;
        }
        if (stockItem.getGndData().getString("StockBonus", "null").equalsIgnoreCase("BonusToolTier")) {
            bonus += stockItem.getGndData().getFloat("StockBonusValue", 0.0f) / 100.0f;
        }
        float tier = bonus + barrelItem.getGndData().getFloat("toolTier", 0.0f) + bodyItem.getGndData().getFloat("toolTier", 0.0f) + stockItem.getGndData().getFloat("toolTier", 0.0f);
        if (item.item.getUpgradeLevel(item) / 100 > 0) {
            return tier > 10.0f ? tier + (float)(perspective == null ? 0 : (Integer)perspective.buffManager.getModifier(BuffModifiers.TOOL_TIER)) : 10.0f + (float)(perspective == null ? 0 : (Integer)perspective.buffManager.getModifier(BuffModifiers.TOOL_TIER));
        }
        return tier > 0.0f ? tier + (float)(perspective == null ? 0 : (Integer)perspective.buffManager.getModifier(BuffModifiers.TOOL_TIER)) : 0.0f + (float)(perspective == null ? 0 : (Integer)perspective.buffManager.getModifier(BuffModifiers.TOOL_TIER));
    }

    public static float getFlatManaCost(InventoryItem item, InventoryItem barrelItem, InventoryItem bodyItem, InventoryItem stockItem, ToolItem toolItem) {
        float bonus = 0.0f;
        float bonusMod = 1.0f;
        if (barrelItem.getGndData().getString("BarrelBonus", "null").equalsIgnoreCase("BonusManaCost")) {
            bonus += barrelItem.getGndData().getFloat("BarrelBonusValue", 0.0f);
        }
        if (bodyItem.getGndData().getString("BodyBonus", "null").equalsIgnoreCase("BonusManaCost")) {
            bonus += bodyItem.getGndData().getFloat("BodyBonusValue", 0.0f);
        }
        if (stockItem.getGndData().getString("StockBonus", "null").equalsIgnoreCase("BonusManaCost")) {
            bonus += stockItem.getGndData().getFloat("StockBonusValue", 0.0f);
        }
        if (barrelItem.getGndData().getString("BarrelBonus", "null").equalsIgnoreCase("BonusManaCostMod")) {
            bonusMod += barrelItem.getGndData().getFloat("BarrelBonusValue", 0.0f) / 100.0f;
        }
        if (bodyItem.getGndData().getString("BodyBonus", "null").equalsIgnoreCase("BonusManaCostMod")) {
            bonusMod += bodyItem.getGndData().getFloat("BodyBonusValue", 0.0f) / 100.0f;
        }
        if (stockItem.getGndData().getString("StockBonus", "null").equalsIgnoreCase("BonusManaCostMod")) {
            bonusMod += stockItem.getGndData().getFloat("StockBonusValue", 0.0f) / 100.0f;
        }
        float cost = bonus + (barrelItem.getGndData().getFloat("ManaCost", 0.0f) + bodyItem.getGndData().getFloat("ManaCost", 0.0f) + stockItem.getGndData().getFloat("ManaCost", 0.0f));
        float costMod = bonusMod + (barrelItem.getGndData().getFloat("ManaCostMod", 0.0f) + bodyItem.getGndData().getFloat("ManaCostMod", 0.0f) + stockItem.getGndData().getFloat("ManaCostMod", 0.0f));
        float costDamageMod = 0.05f;
        if (barrelItem.getGndData().hasKey("ManaCostDamageMod") || bodyItem.getGndData().hasKey("ManaCostDamageMod") || stockItem.getGndData().hasKey("ManaCostDamageMod")) {
            costDamageMod = barrelItem.getGndData().getFloat("ManaCostDamageMod", 0.0f) + bodyItem.getGndData().getFloat("ManaCostDamageMod", 0.0f) + stockItem.getGndData().getFloat("ManaCostDamageMod", 0.0f);
        }
        if (cost > 0.0f) {
            if (costDamageMod > 0.0f) {
                return costMod > 1.0f ? cost * costMod + toolItem.getFlatAttackDamage((InventoryItem)item).damage * costDamageMod : cost + toolItem.getFlatAttackDamage((InventoryItem)item).damage * costDamageMod;
            }
            return costMod > 1.0f ? cost * costMod : cost;
        }
        return 0.0f;
    }

    public static int getFlatLifeCost(InventoryItem item, InventoryItem barrelItem, InventoryItem bodyItem, InventoryItem stockItem, ToolItem toolItem, int lifeCost) {
        float bonus = 0.0f;
        float bonusMod = 1.0f;
        if (barrelItem.getGndData().getString("BarrelBonus", "null").equalsIgnoreCase("BonusLifeCost")) {
            bonus += barrelItem.getGndData().getFloat("BarrelBonusValue", 0.0f);
        }
        if (bodyItem.getGndData().getString("BodyBonus", "null").equalsIgnoreCase("BonusLifeCost")) {
            bonus += bodyItem.getGndData().getFloat("BodyBonusValue", 0.0f);
        }
        if (stockItem.getGndData().getString("StockBonus", "null").equalsIgnoreCase("BonusLifeCost")) {
            bonus += stockItem.getGndData().getFloat("StockBonusValue", 0.0f);
        }
        if (barrelItem.getGndData().getString("BarrelBonus", "null").equalsIgnoreCase("BonusLifeCostMod")) {
            bonusMod += barrelItem.getGndData().getFloat("BarrelBonusValue", 0.0f) / 100.0f;
        }
        if (bodyItem.getGndData().getString("BodyBonus", "null").equalsIgnoreCase("BonusLifeCostMod")) {
            bonusMod += bodyItem.getGndData().getFloat("BodyBonusValue", 0.0f) / 100.0f;
        }
        if (stockItem.getGndData().getString("StockBonus", "null").equalsIgnoreCase("BonusLifeCostMod")) {
            bonusMod += stockItem.getGndData().getFloat("StockBonusValue", 0.0f) / 100.0f;
        }
        float cost = bonus + (barrelItem.getGndData().getFloat("LifeCost", 0.0f) + bodyItem.getGndData().getFloat("LifeCost", 0.0f) + stockItem.getGndData().getFloat("LifeCost", 0.0f));
        float costMod = bonusMod + (barrelItem.getGndData().getFloat("LifeCostMod", 0.0f) + bodyItem.getGndData().getFloat("LifeCostMod", 0.0f) + stockItem.getGndData().getFloat("LifeCostMod", 0.0f));
        return costMod > 1.0f ? Math.round((cost + (float)lifeCost) * costMod) : Math.round(cost + (float)lifeCost);
    }

    public static int getLifeSteal(InventoryItem item, InventoryItem barrelItem, InventoryItem bodyItem, InventoryItem stockItem, ToolItem toolItem, int lifeSteal) {
        float bonus = 0.0f;
        float bonusMod = 1.0f;
        if (barrelItem.getGndData().getString("BarrelBonus", "null").equalsIgnoreCase("BonusLifeSteal")) {
            bonus += barrelItem.getGndData().getFloat("BarrelBonusValue", 0.0f);
        }
        if (bodyItem.getGndData().getString("BodyBonus", "null").equalsIgnoreCase("BonusLifeSteal")) {
            bonus += bodyItem.getGndData().getFloat("BodyBonusValue", 0.0f);
        }
        if (stockItem.getGndData().getString("StockBonus", "null").equalsIgnoreCase("BonusLifeSteal")) {
            bonus += stockItem.getGndData().getFloat("StockBonusValue", 0.0f);
        }
        if (barrelItem.getGndData().getString("BarrelBonus", "null").equalsIgnoreCase("BonusLifeStealMod")) {
            bonusMod += barrelItem.getGndData().getFloat("BarrelBonusValue", 0.0f) / 100.0f;
        }
        if (bodyItem.getGndData().getString("BodyBonus", "null").equalsIgnoreCase("BonusLifeStealMod")) {
            bonusMod += bodyItem.getGndData().getFloat("BodyBonusValue", 0.0f) / 100.0f;
        }
        if (stockItem.getGndData().getString("StockBonus", "null").equalsIgnoreCase("BonusLifeStealMod")) {
            bonusMod += stockItem.getGndData().getFloat("StockBonusValue", 0.0f) / 100.0f;
        }
        float cost = bonus + (barrelItem.getGndData().getFloat("LifeSteal", 3.0f) + bodyItem.getGndData().getFloat("LifeSteal", 0.0f) + stockItem.getGndData().getFloat("LifeSteal", 0.0f));
        float costMod = bonusMod + (barrelItem.getGndData().getFloat("LifeStealMod", 0.0f) + bodyItem.getGndData().getFloat("LifeStealMod", 0.0f) + stockItem.getGndData().getFloat("LifeStealMod", 0.0f));
        return costMod > 1.0f ? Math.round((cost + (float)lifeSteal) * costMod) : Math.round(cost + (float)lifeSteal);
    }

    public static float getResilienceGain(InventoryItem item, InventoryItem barrelItem, InventoryItem bodyItem, InventoryItem stockItem, ToolItem toolItem, FloatUpgradeValue resilienceGain) {
        float bonus = 0.0f;
        float bonusMod = 1.0f;
        if (barrelItem.getGndData().getString("BarrelBonus", "null").equalsIgnoreCase("BonusResilienceAdd")) {
            bonus += barrelItem.getGndData().getFloat("BarrelBonusValue", 0.0f);
        }
        if (bodyItem.getGndData().getString("BodyBonus", "null").equalsIgnoreCase("BonusResilienceAdd")) {
            bonus += bodyItem.getGndData().getFloat("BodyBonusValue", 0.0f);
        }
        if (stockItem.getGndData().getString("StockBonus", "null").equalsIgnoreCase("BonusResilienceAdd")) {
            bonus += stockItem.getGndData().getFloat("StockBonusValue", 0.0f);
        }
        if (barrelItem.getGndData().getString("BarrelBonus", "null").equalsIgnoreCase("BonusResilienceMod")) {
            bonusMod += barrelItem.getGndData().getFloat("BarrelBonusValue", 0.0f) / 100.0f;
        }
        if (bodyItem.getGndData().getString("BodyBonus", "null").equalsIgnoreCase("BonusResilienceMod")) {
            bonusMod += bodyItem.getGndData().getFloat("BodyBonusValue", 0.0f) / 100.0f;
        }
        if (stockItem.getGndData().getString("StockBonus", "null").equalsIgnoreCase("BonusResilienceMod")) {
            bonusMod += stockItem.getGndData().getFloat("StockBonusValue", 0.0f) / 100.0f;
        }
        float add = bonus + (barrelItem.getGndData().getFloat("ResilienceAdd", 0.0f) + bodyItem.getGndData().getFloat("ResilienceAdd", 0.0f) + stockItem.getGndData().getFloat("ResilienceAdd", 0.0f));
        float mod = bonusMod + (barrelItem.getGndData().getFloat("ResilienceMod", 0.0f) + bodyItem.getGndData().getFloat("ResilienceMod", 0.0f) + stockItem.getGndData().getFloat("ResilienceMod", 0.0f));
        return mod > 1.0f ? (add + resilienceGain.getValue((float)toolItem.getUpgradeLevel(item)).floatValue() + ((Float)toolItem.getEnchantment(item).applyModifierLimited(ToolItemModifiers.RESILIENCE_GAIN, (Object)((Float)ToolItemModifiers.RESILIENCE_GAIN.defaultBuffManagerValue))).floatValue()) * mod : add + resilienceGain.getValue((float)toolItem.getUpgradeLevel(item)).floatValue() + ((Float)toolItem.getEnchantment(item).applyModifierLimited(ToolItemModifiers.RESILIENCE_GAIN, (Object)((Float)ToolItemModifiers.RESILIENCE_GAIN.defaultBuffManagerValue))).floatValue();
    }

    public static float getAmmoConsumeChance(ItemAttackerMob attackerMob, InventoryItem item, InventoryItem barrelItem, InventoryItem bodyItem, InventoryItem stockItem, float ammoConsumeChance) {
        float playerMod;
        float bonus = 0.0f;
        if (barrelItem.getGndData().getString("BarrelBonus", "null").equalsIgnoreCase("BonusAmmoUseAdd")) {
            bonus += barrelItem.getGndData().getFloat("BarrelBonusValue", 0.0f) / 100.0f;
        }
        if (bodyItem.getGndData().getString("BodyBonus", "null").equalsIgnoreCase("BonusAmmoUseAdd")) {
            bonus += bodyItem.getGndData().getFloat("BodyBonusValue", 0.0f) / 100.0f;
        }
        if (stockItem.getGndData().getString("StockBonus", "null").equalsIgnoreCase("BonusAmmoUseAdd")) {
            bonus += stockItem.getGndData().getFloat("StockBonusValue", 0.0f) / 100.0f;
        }
        float f = playerMod = attackerMob == null ? 1.0f : ((Float)attackerMob.buffManager.getModifier(BuffModifiers.BULLET_USAGE)).floatValue();
        if (item.getGndData().getInt("shotsRemaining", 0) > 0) {
            return 0.0f;
        }
        return (ammoConsumeChance + bonus + barrelItem.getGndData().getFloat("AmmoUseAdd", 0.0f) + bodyItem.getGndData().getFloat("AmmoUseAdd", 0.0f) + stockItem.getGndData().getFloat("AmmoUseAdd", 0.0f)) * playerMod;
    }

    public static float getSpread(InventoryItem item, InventoryItem barrelItem, InventoryItem bodyItem, InventoryItem stockItem, float baseSpread) {
        float bonusMod = 1.0f;
        if (barrelItem.getGndData().getString("BarrelBonus", "null").equalsIgnoreCase("BonusSpreadMod")) {
            bonusMod += barrelItem.getGndData().getFloat("BarrelBonusValue", 0.0f) / 100.0f;
        }
        if (bodyItem.getGndData().getString("BodyBonus", "null").equalsIgnoreCase("BonusSpreadMod")) {
            bonusMod += bodyItem.getGndData().getFloat("BodyBonusValue", 0.0f) / 100.0f;
        }
        if (stockItem.getGndData().getString("StockBonus", "null").equalsIgnoreCase("BonusSpreadMod")) {
            bonusMod += stockItem.getGndData().getFloat("StockBonusValue", 0.0f) / 100.0f;
        }
        float mod = bonusMod + barrelItem.getGndData().getFloat("SpreadMod", 0.0f) + bodyItem.getGndData().getFloat("SpreadMod", 0.0f) + stockItem.getGndData().getFloat("SpreadMod", 0.0f);
        return mod * baseSpread;
    }

    public static int getPellets(InventoryItem item, InventoryItem barrelItem, InventoryItem bodyItem, InventoryItem stockItem) {
        int base;
        float bonus = 0.0f;
        if (barrelItem.getGndData().getString("BarrelBonus", "null").equalsIgnoreCase("BonusPellets")) {
            bonus += barrelItem.getGndData().getFloat("BarrelBonusValue", 0.0f);
        }
        if (bodyItem.getGndData().getString("BodyBonus", "null").equalsIgnoreCase("BonusPellets")) {
            bonus += bodyItem.getGndData().getFloat("BodyBonusValue", 0.0f);
        }
        if (stockItem.getGndData().getString("StockBonus", "null").equalsIgnoreCase("BonusPellets")) {
            bonus += stockItem.getGndData().getFloat("StockBonusValue", 0.0f);
        }
        return (base = Math.round(bonus) + (barrelItem.getGndData().getInt("Pellets", 0) + bodyItem.getGndData().getInt("Pellets", 0) + stockItem.getGndData().getInt("Pellets", 0))) > 0 ? base : 4;
    }

    public static int getFlatVelocity(InventoryItem item, InventoryItem barrelItem, InventoryItem bodyItem, InventoryItem stockItem, IntUpgradeValue velocity, ToolItem toolItem) {
        float bonus = 0.0f;
        float bonusMod = 1.0f;
        if (barrelItem.getGndData().getString("BarrelBonus", "null").equalsIgnoreCase("BonusVelocity")) {
            bonus += barrelItem.getGndData().getFloat("BarrelBonusValue", 0.0f);
        }
        if (bodyItem.getGndData().getString("BodyBonus", "null").equalsIgnoreCase("BonusVelocity")) {
            bonus += bodyItem.getGndData().getFloat("BodyBonusValue", 0.0f);
        }
        if (stockItem.getGndData().getString("StockBonus", "null").equalsIgnoreCase("BonusVelocity")) {
            bonus += stockItem.getGndData().getFloat("StockBonusValue", 0.0f);
        }
        if (barrelItem.getGndData().getString("BarrelBonus", "null").equalsIgnoreCase("BonusVelocityMod")) {
            bonusMod += barrelItem.getGndData().getFloat("BarrelBonusValue", 0.0f) / 100.0f;
        }
        if (bodyItem.getGndData().getString("BodyBonus", "null").equalsIgnoreCase("BonusVelocityMod")) {
            bonusMod += bodyItem.getGndData().getFloat("BodyBonusValue", 0.0f) / 100.0f;
        }
        if (stockItem.getGndData().getString("StockBonus", "null").equalsIgnoreCase("BonusVelocityMod")) {
            bonusMod += stockItem.getGndData().getFloat("StockBonusValue", 0.0f) / 100.0f;
        }
        int base = Math.round(bonus) + velocity.getValue(toolItem.getUpgradeTier(item)) + (barrelItem.getGndData().getInt("ProjectileSpeed", 0) + bodyItem.getGndData().getInt("ProjectileSpeed", 0) + stockItem.getGndData().getInt("ProjectileSpeed", 0));
        float baseMod = bonusMod + (barrelItem.getGndData().getFloat("ProjectileSpeedMod", 0.0f) + bodyItem.getGndData().getFloat("ProjectileSpeedMod", 0.0f) + stockItem.getGndData().getFloat("ProjectileSpeedMod", 0.0f));
        return Math.round((float)base * baseMod);
    }
}

