/*
 * Decompiled with CFR 0.152.
 */
package gunsmith.items.parts.stocks.pickaxe;

import gunsmith.gunsmith;
import gunsmith.items.parts.PartMatItem;
import gunsmith.scripts.RGBToHex;
import java.awt.Color;
import necesse.engine.localization.Localization;
import necesse.engine.util.GameBlackboard;
import necesse.entity.mobs.PlayerMob;
import necesse.gfx.gameTexture.MergeFunction;
import necesse.gfx.gameTooltips.ListGameTooltips;
import necesse.inventory.InventoryItem;
import necesse.inventory.item.ItemCategory;

public class ShaftPickaxe
extends PartMatItem {
    public ShaftPickaxe() {
        this.setItemCategory(new String[]{"parts", "pickaxeShaft"});
        this.setItemCategory(ItemCategory.craftingManager, new String[]{"pickaxeShaft"});
    }

    public void drawIcon(InventoryItem item, PlayerMob perspective, int x, int y, int size, Color color) {
        color = color != null ? MergeFunction.MULTIPLY.merge(color, this.getDrawColor(item, perspective)) : this.getDrawColor(item, perspective);
        this.getItemSprite(item, perspective).initDraw().color(color).size(size).draw(x, y);
    }

    @Override
    public ListGameTooltips getTooltips(InventoryItem item, PlayerMob perspective, GameBlackboard blackboard) {
        ListGameTooltips tooltips = super.getTooltips(item, perspective, blackboard);
        tooltips.add(Localization.translate((String)"stocktooltip", (String)"ShaftTip"));
        tooltips.add(Localization.translate((String)"weapontooltip", (String)"DamageToolTip"));
        if (item.getGndData().hasKey("BonusActivate")) {
            tooltips.add(Localization.translate((String)"bonusmodtip", (String)"Random"));
        }
        if (item.getGndData().hasKey("StockBonus")) {
            String color = RGBToHex.RGBToHex(gunsmith.settingsGetter.getColor("bonusColor"));
            StringBuilder stringBuilder = new StringBuilder();
            if (item.getGndData().getFloat("StockBonusValue") >= item.item.getDefaultItem(null, 1).getGndData().getFloat(stringBuilder.append("High").append(item.getGndData().getString("StockBonus")).toString())) {
                color = RGBToHex.RGBToHex(gunsmith.settingsGetter.getColor("bonusMaxColor"));
            }
            if (item.getGndData().getString("StockBonus").equalsIgnoreCase("BonusAttackSpeed")) {
                if (item.getGndData().getFloat("StockBonusValue") > 0.0f) {
                    tooltips.add(Localization.translate((String)"bonusmodtip", (String)item.getGndData().getString("StockBonus"), (Object[])new Object[]{"value", Float.valueOf(item.getGndData().getFloat("StockBonusValue") / 10.0f), "unit", "+", "color", color}));
                } else {
                    tooltips.add(Localization.translate((String)"bonusmodtip", (String)item.getGndData().getString("StockBonus"), (Object[])new Object[]{"value", Float.valueOf(item.getGndData().getFloat("StockBonusValue") / 10.0f), "unit", "", "color", color}));
                }
            } else if (item.getGndData().getFloat("StockBonusValue") > 0.0f) {
                tooltips.add(Localization.translate((String)"bonusmodtip", (String)item.getGndData().getString("StockBonus"), (Object[])new Object[]{"value", Float.valueOf(item.getGndData().getFloat("StockBonusValue")), "unit", "+", "color", color}));
            } else {
                tooltips.add(Localization.translate((String)"bonusmodtip", (String)item.getGndData().getString("StockBonus"), (Object[])new Object[]{"value", Float.valueOf(item.getGndData().getFloat("StockBonusValue")), "unit", "", "color", color}));
            }
        }
        return tooltips;
    }

    @Override
    public InventoryItem getDefaultItem(PlayerMob player, int amount) {
        InventoryItem self = super.getDefaultItem(player, amount);
        self.setGndData(self.getGndData().setInt("LowBonusRange", 1).setInt("HighBonusRange", 2).setFloat("LowBonusPower", 6.0f).setFloat("HighBonusPower", 50.0f).setFloat("LowBonusPowerMod", 3.0f).setFloat("HighBonusPowerMod", 25.0f).setString("Type", "ToolShaft").setString("Part", "Stock"));
        return self;
    }
}

