/*
 * Decompiled with CFR 0.152.
 */
package gunsmith.items.parts.stocks.glaive;

import gunsmith.items.parts.PartMatItem;
import java.awt.Color;
import necesse.engine.localization.Localization;
import necesse.engine.util.GameBlackboard;
import necesse.entity.mobs.PlayerMob;
import necesse.gfx.gameTexture.GameSprite;
import necesse.gfx.gameTexture.GameTexture;
import necesse.gfx.gameTexture.MergeFunction;
import necesse.gfx.gameTooltips.ListGameTooltips;
import necesse.inventory.InventoryItem;
import necesse.inventory.item.ItemCategory;

public class ShaftGlaive
extends PartMatItem {
    public ShaftGlaive() {
        this.setItemCategory(new String[]{"parts", "glaive", "glaiveShaft"});
        this.setItemCategory(ItemCategory.craftingManager, new String[]{"glaiveShaft"});
    }

    public void drawIcon(InventoryItem item, PlayerMob perspective, int x, int y, int size, Color color) {
        color = color != null ? MergeFunction.MULTIPLY.merge(color, this.getDrawColor(item, perspective)) : this.getDrawColor(item, perspective);
        new GameSprite(GameTexture.fromFile((String)"items/GlaiveShaftOutline")).initDraw().color(color).size(size).draw(x, y);
        this.getItemSprite(item, perspective).initDraw().color(color).size(size).draw(x, y);
    }

    @Override
    public ListGameTooltips getTooltips(InventoryItem item, PlayerMob perspective, GameBlackboard blackboard) {
        ListGameTooltips tooltips = super.getTooltips(item, perspective, blackboard);
        tooltips.add(Localization.translate((String)"stocktooltip", (String)"ShaftTip"));
        tooltips.add(Localization.translate((String)"weapontooltip", (String)"GlaiveTip"));
        if (item.getGndData().hasKey("BonusActivate")) {
            tooltips.add(Localization.translate((String)"bonusmodtip", (String)"Random"));
        }
        if (item.getGndData().hasKey("StockBonus")) {
            String color = "\u00a7#07BFE8";
            StringBuilder stringBuilder = new StringBuilder();
            if (item.getGndData().getFloat("StockBonusValue") >= item.item.getDefaultItem(null, 1).getGndData().getFloat(stringBuilder.append("High").append(item.getGndData().getString("StockBonus")).toString())) {
                color = "\u00a7#E655E6";
            }
            if (item.getGndData().getString("StockBonus").equalsIgnoreCase("BonusAttackSpeed")) {
                if (item.getGndData().getFloat("StockBonusValue") > 0.0f) {
                    tooltips.add(Localization.translate((String)"bonusmodtip", (String)item.getGndData().getString("StockBonus"), (Object[])new Object[]{"value", Float.valueOf(item.getGndData().getFloat("StockBonusValue") / 10.0f), "unit", "+", "color", color}));
                } else {
                    tooltips.add(Localization.translate((String)"bonusmodtip", (String)item.getGndData().getString("StockBonus"), (Object[])new Object[]{"value", Float.valueOf(item.getGndData().getFloat("StockBonusValue") / 10.0f), "unit", "", "color", color}));
                }
            } else if (item.getGndData().getFloat("StockBonusValue") > 0.0f) {
                tooltips.add(Localization.translate((String)"bonusmodtip", (String)item.getGndData().getString("StockBonus"), (Object[])new Object[]{"value", Float.valueOf(item.getGndData().getFloat("StockBonusValue")), "unit", "+", "color", color}));
            } else {
                tooltips.add(Localization.translate((String)"bonusmodtip", (String)item.getGndData().getString("StockBonus"), (Object[])new Object[]{"value", Float.valueOf(item.getGndData().getFloat("StockBonusValue")), "unit", "", "color", color}));
            }
        }
        return tooltips;
    }

    @Override
    public InventoryItem getDefaultItem(PlayerMob player, int amount) {
        InventoryItem self = super.getDefaultItem(player, amount);
        self.setGndData(self.getGndData().setString("Type", "ModularGlaive").setString("Part", "Stock"));
        return self;
    }
}

