/*
 * Decompiled with CFR 0.152.
 */
package gunsmith.items.parts.barrels.shotgun;

import gunsmith.gunsmith;
import gunsmith.items.parts.PartMatItem;
import gunsmith.scripts.RGBToHex;
import java.awt.Color;
import necesse.engine.localization.Localization;
import necesse.engine.util.GameBlackboard;
import necesse.entity.mobs.PlayerMob;
import necesse.gfx.gameTexture.GameSprite;
import necesse.gfx.gameTexture.GameTexture;
import necesse.gfx.gameTexture.MergeFunction;
import necesse.gfx.gameTooltips.ListGameTooltips;
import necesse.inventory.InventoryItem;
import necesse.inventory.item.ItemCategory;

public class BarrelShotgun
extends PartMatItem {
    public BarrelShotgun() {
        this.setItemCategory(new String[]{"parts", "shotgun", "shotgunBarrel"});
        this.setItemCategory(ItemCategory.craftingManager, new String[]{"shotgunBarrel"});
    }

    public void drawIcon(InventoryItem item, PlayerMob perspective, int x, int y, int size, Color color) {
        color = color != null ? MergeFunction.MULTIPLY.merge(color, this.getDrawColor(item, perspective)) : this.getDrawColor(item, perspective);
        new GameSprite(GameTexture.fromFile((String)"items/ShotgunBarrelOutline")).initDraw().color(color).size(size).draw(x, y);
        this.getItemSprite(item, perspective).initDraw().color(color).size(size).draw(x, y);
    }

    @Override
    public ListGameTooltips getTooltips(InventoryItem item, PlayerMob perspective, GameBlackboard blackboard) {
        ListGameTooltips tooltips = super.getTooltips(item, perspective, blackboard);
        tooltips.add(Localization.translate((String)"barreltooltip", (String)"BarrelTip"));
        tooltips.add(Localization.translate((String)"weapontooltip", (String)"ShotgunTip"));
        if (item.getGndData().hasKey("BonusActivate")) {
            tooltips.add(Localization.translate((String)"bonusmodtip", (String)"Random"));
        }
        if (item.getGndData().hasKey("BarrelBonus")) {
            String color = RGBToHex.RGBToHex(gunsmith.settingsGetter.getColor("bonusColor"));
            StringBuilder stringBuilder = new StringBuilder();
            if (item.getGndData().getFloat("BarrelBonusValue") >= item.item.getDefaultItem(null, 1).getGndData().getFloat(stringBuilder.append("High").append(item.getGndData().getString("BarrelBonus")).toString())) {
                color = RGBToHex.RGBToHex(gunsmith.settingsGetter.getColor("bonusMaxColor"));
            }
            if (item.getGndData().getString("BodyBonus").equalsIgnoreCase("BonusAttackSpeed")) {
                if (item.getGndData().getFloat("BarrelBonusValue") > 0.0f) {
                    tooltips.add(Localization.translate((String)"bonusmodtip", (String)item.getGndData().getString("BarrelBonus"), (Object[])new Object[]{"value", Float.valueOf(item.getGndData().getFloat("BarrelBonusValue") / 10.0f), "unit", "+", "color", color}));
                } else {
                    tooltips.add(Localization.translate((String)"bonusmodtip", (String)item.getGndData().getString("BarrelBonus"), (Object[])new Object[]{"value", Float.valueOf(item.getGndData().getFloat("BarrelBonusValue") / 10.0f), "unit", "", "color", color}));
                }
            } else if (item.getGndData().getFloat("BarrelBonusValue") > 0.0f) {
                tooltips.add(Localization.translate((String)"bonusmodtip", (String)item.getGndData().getString("BarrelBonus"), (Object[])new Object[]{"value", Float.valueOf(item.getGndData().getFloat("BarrelBonusValue")), "unit", "+", "color", color}));
            } else {
                tooltips.add(Localization.translate((String)"bonusmodtip", (String)item.getGndData().getString("BarrelBonus"), (Object[])new Object[]{"value", Float.valueOf(item.getGndData().getFloat("BarrelBonusValue")), "unit", "", "color", color}));
            }
        }
        return tooltips;
    }

    @Override
    public InventoryItem getDefaultItem(PlayerMob player, int amount) {
        InventoryItem self = super.getDefaultItem(player, amount);
        self.setGndData(self.getGndData().setFloat("LowBonusPellets", 1.0f).setFloat("HighBonusPellets", 2.0f).setFloat("LowBonusVelocityMod", 7.0f).setFloat("HighBonusVelocityMod", 30.0f).setFloat("LowBonusAmmoUseAdd", -5.0f).setFloat("HighBonusAmmoUseAdd", -20.0f).setFloat("LowBonusSpreadMod", -8.0f).setFloat("HighBonusSpreadMod", -33.0f).setString("Type", "ModularShotgun").setString("Part", "Barrel"));
        return self;
    }
}

