/*
 * Decompiled with CFR 0.152.
 */
package gunsmith.items.parts.barrels.glaive;

import java.awt.Color;
import necesse.engine.localization.Localization;
import necesse.engine.util.GameBlackboard;
import necesse.entity.mobs.PlayerMob;
import necesse.gfx.gameTexture.GameSprite;
import necesse.gfx.gameTexture.GameTexture;
import necesse.gfx.gameTexture.MergeFunction;
import necesse.gfx.gameTooltips.ListGameTooltips;
import necesse.inventory.InventoryItem;
import necesse.inventory.item.Item;
import necesse.inventory.item.ItemCategory;
import necesse.inventory.item.matItem.MatItem;

public class HeadGlaive
extends MatItem {
    public HeadGlaive() {
        super(1, Item.Rarity.COMMON, new String[0]);
        this.setItemCategory(new String[]{"parts", "glaive", "glaiveBlade"});
        this.setItemCategory(ItemCategory.craftingManager, new String[]{"glaiveBlade"});
    }

    public void drawIcon(InventoryItem item, PlayerMob perspective, int x, int y, int size, Color color) {
        color = color != null ? MergeFunction.MULTIPLY.merge(color, this.getDrawColor(item, perspective)) : this.getDrawColor(item, perspective);
        new GameSprite(GameTexture.fromFile((String)"items/GlaiveHeadOutline")).initDraw().color(color).size(size).draw(x, y);
        this.getItemSprite(item, perspective).initDraw().color(color).size(size).draw(x, y);
    }

    public ListGameTooltips getTooltips(InventoryItem item, PlayerMob perspective, GameBlackboard blackboard) {
        ListGameTooltips tooltips = super.getTooltips(item, perspective, blackboard);
        tooltips.add(Localization.translate((String)"barreltooltip", (String)"BladeTip"));
        tooltips.add(Localization.translate((String)"weapontooltip", (String)"GlaiveTip"));
        if (item.getGndData().hasKey("BonusActivate")) {
            tooltips.add(Localization.translate((String)"bonusmodtip", (String)"Random"));
        }
        if (item.getGndData().hasKey("BarrelBonus")) {
            if (item.getGndData().getString("BodyBonus").equalsIgnoreCase("BonusAttackSpeed")) {
                if (item.getGndData().getFloat("BarrelBonusValue") > 0.0f) {
                    tooltips.add(Localization.translate((String)"bonusmodtip", (String)item.getGndData().getString("BarrelBonus"), (Object[])new Object[]{"value", Float.valueOf(item.getGndData().getFloat("BarrelBonusValue") / 10.0f), "unit", "+"}));
                } else {
                    tooltips.add(Localization.translate((String)"bonusmodtip", (String)item.getGndData().getString("BarrelBonus"), (Object[])new Object[]{"value", Float.valueOf(item.getGndData().getFloat("BarrelBonusValue") / 10.0f), "unit", ""}));
                }
            } else if (item.getGndData().getFloat("BarrelBonusValue") > 0.0f) {
                tooltips.add(Localization.translate((String)"bonusmodtip", (String)item.getGndData().getString("BarrelBonus"), (Object[])new Object[]{"value", Float.valueOf(item.getGndData().getFloat("BarrelBonusValue")), "unit", "+"}));
            } else {
                tooltips.add(Localization.translate((String)"bonusmodtip", (String)item.getGndData().getString("BarrelBonus"), (Object[])new Object[]{"value", Float.valueOf(item.getGndData().getFloat("BarrelBonusValue")), "unit", ""}));
            }
        }
        return tooltips;
    }

    public InventoryItem getDefaultItem(PlayerMob player, int amount) {
        InventoryItem self = super.getDefaultItem(player, amount);
        self.setGndData(self.getGndData().setString("Type", "ModularGlaive").setString("Part", "Barrel"));
        return self;
    }
}

