/*
 * Decompiled with CFR 0.152.
 */
package gunsmith.items.parts;

import gunsmith.packets.SaveModifierPacket;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import necesse.engine.network.Packet;
import necesse.engine.network.gameNetworkData.GNDItemMap;
import necesse.engine.util.GameBlackboard;
import necesse.engine.util.GameRandom;
import necesse.entity.mobs.PlayerMob;
import necesse.gfx.gameTooltips.ListGameTooltips;
import necesse.inventory.Inventory;
import necesse.inventory.InventoryItem;
import necesse.inventory.InventoryItemsRemoved;
import necesse.inventory.InventorySlot;
import necesse.inventory.PlayerInventorySlot;
import necesse.inventory.item.Item;
import necesse.inventory.item.matItem.MatItem;
import necesse.inventory.recipe.Ingredient;
import necesse.inventory.recipe.IngredientCounter;
import necesse.level.maps.Level;

public class PartMatItem
extends MatItem {
    public PartMatItem() {
        super(1, Item.Rarity.NORMAL, new String[0]);
    }

    public boolean noBonus(InventoryItem item) {
        return !item.getGndData().hasKey("BarrelBonus") && !item.getGndData().hasKey("BodyBonus") && !item.getGndData().hasKey("StockBonus");
    }

    public void countIngredientAmount(Level level, PlayerMob player, Inventory inventory, int inventorySlot, InventoryItem item, String purpose, IngredientCounter handler) {
        if (this.noBonus(item)) {
            super.countIngredientAmount(level, player, inventory, inventorySlot, item, purpose, handler);
        }
    }

    public int removeInventoryAmount(Level level, PlayerMob player, InventoryItem item, Inventory inventory, int inventorySlot, Ingredient ingredient, int amount, Collection<InventoryItemsRemoved> collect) {
        return this.noBonus(item) ? super.removeInventoryAmount(level, player, item, inventory, inventorySlot, ingredient, amount, collect) : 0;
    }

    public ListGameTooltips getTooltips(InventoryItem item, PlayerMob perspective, GameBlackboard blackboard) {
        ListGameTooltips tooltips = super.getTooltips(item, perspective, blackboard);
        if (item.getGndData().getBoolean("BonusActivate") && !item.getGndData().hasKey("BarrelBonus") && !item.getGndData().hasKey("BodyBonus") && !item.getGndData().hasKey("StockBonus") && perspective.getInv().streamInventorySlots(false, false, false, true).anyMatch(inventorySlot -> inventorySlot.getItem() == item)) {
            item.getGndData().addAll(PartMatItem.randomModifier(item.item.getDefaultItem(null, 1).getGndData()));
            if (item.getGndData().getBoolean("isCrafted")) {
                if (item.getGndData().hasKey("BarrelBonus")) {
                    item.getGndData().setFloat("BarrelBonusValue", (float)Math.round(GameRandom.globalRandom.getFloatBetween(item.item.getDefaultItem(null, 1).getGndData().getFloat("Low" + item.getGndData().getString("BarrelBonus")), item.item.getDefaultItem(null, 1).getGndData().getFloat("Low" + item.getGndData().getString("BarrelBonus")) * GameRandom.globalRandom.getFloatBetween(1.2f, 1.4f)) * 10.0f) / 10.0f);
                } else if (item.getGndData().hasKey("BodyBonus")) {
                    item.getGndData().setFloat("BodyBonusValue", (float)Math.round(GameRandom.globalRandom.getFloatBetween(item.item.getDefaultItem(null, 1).getGndData().getFloat("Low" + item.getGndData().getString("BodyBonus")), item.item.getDefaultItem(null, 1).getGndData().getFloat("Low" + item.getGndData().getString("BodyBonus")) * GameRandom.globalRandom.getFloatBetween(1.2f, 1.4f)) * 10.0f) / 10.0f);
                } else if (item.getGndData().hasKey("StockBonus")) {
                    item.getGndData().setFloat("StockBonusValue", (float)Math.round(GameRandom.globalRandom.getFloatBetween(item.item.getDefaultItem(null, 1).getGndData().getFloat("Low" + item.getGndData().getString("StockBonus")), item.item.getDefaultItem(null, 1).getGndData().getFloat("Low" + item.getGndData().getString("StockBonus")) * GameRandom.globalRandom.getFloatBetween(1.2f, 1.4f)) * 10.0f) / 10.0f);
                }
            } else if (item.getGndData().hasKey("BarrelBonus")) {
                item.getGndData().setFloat("BarrelBonusValue", (float)Math.round(GameRandom.globalRandom.getFloatBetween(item.item.getDefaultItem(null, 1).getGndData().getFloat("Low" + item.getGndData().getString("BarrelBonus")) * GameRandom.globalRandom.getFloatBetween(1.2f, 1.35f), item.item.getDefaultItem(null, 1).getGndData().getFloat("High" + item.getGndData().getString("BarrelBonus"))) * 10.0f) / 10.0f);
            } else if (item.getGndData().hasKey("BodyBonus")) {
                item.getGndData().setFloat("BodyBonusValue", (float)Math.round(GameRandom.globalRandom.getFloatBetween(item.item.getDefaultItem(null, 1).getGndData().getFloat("Low" + item.getGndData().getString("BodyBonus")) * GameRandom.globalRandom.getFloatBetween(1.2f, 1.35f), item.item.getDefaultItem(null, 1).getGndData().getFloat("High" + item.getGndData().getString("BodyBonus"))) * 10.0f) / 10.0f);
            } else if (item.getGndData().hasKey("StockBonus")) {
                item.getGndData().setFloat("StockBonusValue", (float)Math.round(GameRandom.globalRandom.getFloatBetween(item.item.getDefaultItem(null, 1).getGndData().getFloat("Low" + item.getGndData().getString("StockBonus")) * GameRandom.globalRandom.getFloatBetween(1.2f, 1.35f), item.item.getDefaultItem(null, 1).getGndData().getFloat("High" + item.getGndData().getString("StockBonus"))) * 10.0f) / 10.0f);
            }
            Iterator slots = perspective.getInv().streamInventorySlots(false, false, false, true).iterator();
            while (slots.hasNext()) {
                InventorySlot slot = (InventorySlot)slots.next();
                if (slot.getItem() != item) continue;
                item.getGndData().clearItem("BonusActivate");
                perspective.getClient().network.sendPacket((Packet)new SaveModifierPacket(slot.slot, perspective, new PlayerInventorySlot(perspective.getInv().main, slot.slot)));
                break;
            }
        }
        return tooltips;
    }

    public static GNDItemMap randomModifier(GNDItemMap GNData) {
        ArrayList<String> bonusKeys = new ArrayList<String>();
        for (String keyName : GNData.getKeyStringSet()) {
            if (!keyName.startsWith("LowBonus")) continue;
            bonusKeys.add(keyName.substring(3));
        }
        if (!bonusKeys.isEmpty()) {
            if (GNData.getString("Part").equalsIgnoreCase("Barrel")) {
                GNData.clearAll();
                GNData.setString("BarrelBonus", (String)bonusKeys.get(GameRandom.globalRandom.getIntBetween(0, bonusKeys.size() - 1)));
            } else if (GNData.getString("Part").equalsIgnoreCase("Body")) {
                GNData.clearAll();
                GNData.setString("BodyBonus", (String)bonusKeys.get(GameRandom.globalRandom.getIntBetween(0, bonusKeys.size() - 1)));
            } else if (GNData.getString("Part").equalsIgnoreCase("Stock")) {
                GNData.clearAll();
                GNData.setString("StockBonus", (String)bonusKeys.get(GameRandom.globalRandom.getIntBetween(0, bonusKeys.size() - 1)));
            }
        }
        return GNData;
    }

    public InventoryItem getDefaultItem(PlayerMob player, int amount) {
        InventoryItem self = new InventoryItem((Item)this, amount);
        self.setGndData(self.getGndData().setFloat("LowBonusDamageMod", 5.0f).setFloat("HighBonusDamageMod", 30.0f).setFloat("LowBonusArmorPen", 1.0f).setFloat("HighBonusArmorPen", 5.0f).setFloat("LowBonusCritChance", 3.0f).setFloat("HighBonusCritChance", 15.0f).setFloat("LowBonusKnockback", 20.0f).setFloat("HighBonusKnockback", 120.0f).setFloat("LowBonusMoveSpeed", 4.0f).setFloat("HighBonusMoveSpeed", 20.0f).setFloat("LowBonusAttackRangeMod", 5.0f).setFloat("HighBonusAttackRangeMod", 28.0f).setFloat("LowBonusAttackSpeedMod", 5.0f).setFloat("HighBonusAttackSpeedMod", 20.0f));
        return self;
    }
}

